/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.commonservices.internal.console;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Locale;

public class ConsoleInputStream {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005, 2016";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.commonservices/src/java/com/ibm/mq/commonservices/internal/console/ConsoleInputStream.java";
    private InputStreamReader inputStreamReader = null;

    public ConsoleInputStream(Trace t, InputStream is) {
        String language = Locale.getDefault().getLanguage();
        if (CommonServices.PLATFORM_ID == 1 && (language.equalsIgnoreCase("fr") || language.equalsIgnoreCase("pt") || language.equalsIgnoreCase("de") || language.equalsIgnoreCase("es"))) {
            try {
                this.inputStreamReader = new InputStreamReader(is, "Cp850");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.inputStreamReader = new InputStreamReader(is);
            }
        } else if (CommonServices.PLATFORM_ID == 1 && language.equalsIgnoreCase("ru")) {
            try {
                this.inputStreamReader = new InputStreamReader(is, "Cp866");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.inputStreamReader = new InputStreamReader(is);
            }
        } else if (CommonServices.PLATFORM_ID == 1 && (language.equalsIgnoreCase("hu") || language.equalsIgnoreCase("pl") || language.equalsIgnoreCase("cs"))) {
            try {
                this.inputStreamReader = new InputStreamReader(is, "Cp852");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.inputStreamReader = new InputStreamReader(is);
            }
        } else {
            this.inputStreamReader = new InputStreamReader(is);
        }
        if (Trace.isTracing) {
            t.data(64, "ConsoleInputStream.ConsoleInputStream", 300, "Using character set " + this.inputStreamReader.getEncoding());
        }
    }

    public InputStreamReader getInputStreamReader() {
        return this.inputStreamReader;
    }
}

