/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.topicstatus.internal.contentproviders;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmObjectListEvent;
import com.ibm.mq.explorer.core.internal.event.DmObjectListListener;
import com.ibm.mq.explorer.core.internal.objects.DmObject;
import com.ibm.mq.explorer.core.internal.objects.IDmObject;
import com.ibm.mq.explorer.qmgradmin.topicstatus.internal.base.TopicStatusPlugin;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.objects.IUiMQObjectFactory;
import com.ibm.mq.explorer.ui.internal.objects.IUiMQObjectLink;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import com.ibm.mq.explorer.ui.internal.splittreetable.ISplitTreeTableContentListener;
import java.util.ArrayList;
import org.eclipse.swt.widgets.Shell;

public class TopicDmListener
implements DmObjectListListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin.topicstatus/src/com/ibm/mq/explorer/qmgradmin/topicstatus/internal/contentproviders/TopicDmListener.java";
    private ISplitTreeTableContentListener splitTreeTableContentListener = null;
    private UiMQObject parentObject = null;
    private UiMQObject owningObject = null;
    private IUiMQObjectFactory uiMQObjectFactory = null;
    private static String nullTreeName = null;
    private boolean isRefreshObjects = false;
    private UiMQObject refreshObject = null;

    public TopicDmListener(Trace t, ISplitTreeTableContentListener listener, IUiMQObjectFactory factory, UiMQObject owningObj, UiMQObject parentObj, boolean isRefresh, UiMQObject refreshObj) {
        this.splitTreeTableContentListener = listener;
        this.uiMQObjectFactory = factory;
        this.owningObject = owningObj;
        this.parentObject = parentObj;
        this.isRefreshObjects = isRefresh;
        this.refreshObject = refreshObj;
        if (nullTreeName == null) {
            nullTreeName = TopicStatusPlugin.getMessages(t).getMessage("TS.General.Null");
        }
    }

    public void dmObjectListDone(DmObjectListEvent event) {
        final Trace t = Trace.getDefault();
        Shell shell = UiPlugin.getShell();
        if (!shell.isDisposed()) {
            final DmCoreException dmCoreException = event.getException();
            if (dmCoreException != null) {
                shell.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (Trace.isTracing) {
                            t.data(66, "TopicDmListener.dmObjectListDone", 900, "DmCoreException received: " + dmCoreException.getLocalizedMessage());
                        }
                        TopicDmListener.this.splitTreeTableContentListener.dmCoreExceptionReceived(t, TopicDmListener.this.parentObject, dmCoreException);
                    }
                });
            } else {
                final ArrayList dmObjects = new ArrayList(event.getList());
                shell.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        TopicDmListener.this.returnObjects(t, dmObjects);
                    }
                });
            }
        }
    }

    protected void returnObjects(Trace t, ArrayList<DmObject> dmObjects) {
        ArrayList<DmObject> objects = new ArrayList<DmObject>(dmObjects);
        this.returnObjectsInArray(t, this.parentObject, objects);
    }

    private void returnObjectsInArray(Trace t, UiMQObject parent, ArrayList<DmObject> objects) {
        ArrayList<UiMQObject> uiMQObjects = new ArrayList<UiMQObject>();
        for (DmObject dmObject : objects) {
            UiMQObject uiMQObject = this.uiMQObjectFactory.create(t, (IDmObject)dmObject, this.owningObject);
            if (uiMQObject != null && uiMQObject instanceof IUiMQObjectLink) {
                IUiMQObjectLink uiMQObjectLink = (IUiMQObjectLink)uiMQObject;
                String treeName = uiMQObject.toString();
                if (parent != null) {
                    String parentName = parent.toString();
                    if (treeName.startsWith(parentName)) {
                        treeName = treeName.substring(parentName.length());
                    }
                    if (treeName.startsWith("/")) {
                        treeName = treeName.substring(1);
                    }
                }
                if (treeName.length() == 0) {
                    treeName = nullTreeName;
                }
                uiMQObjectLink.setTreeName(treeName);
                uiMQObjectLink.setParent(t, parent);
                if (!this.isRefreshObjects && parent != null && parent instanceof IUiMQObjectLink) {
                    IUiMQObjectLink parentObjectLink = (IUiMQObjectLink)parent;
                    parentObjectLink.addChild(t, uiMQObject);
                }
            }
            uiMQObjects.add(uiMQObject);
        }
        if (this.isRefreshObjects) {
            if (parent != null && parent instanceof IUiMQObjectLink) {
                IUiMQObjectLink parentObjectLink = (IUiMQObjectLink)parent;
                int i = 0;
                while (i < uiMQObjects.size()) {
                    parentObjectLink.removeChild(t, ((UiMQObject)uiMQObjects.get(i)).getDmObject().toString(t));
                    ++i;
                }
            }
            this.splitTreeTableContentListener.refreshObjects(t, this.parentObject, this.refreshObject, uiMQObjects);
        } else {
            this.splitTreeTableContentListener.showObjects(t, this.parentObject, uiMQObjects);
        }
    }
}

