/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.explorer.qmgradmin.topicstatus.internal.actions;

import com.ibm.mq.commonservices.internal.trace.Trace;
import com.ibm.mq.commonservices.internal.utils.CommonServices;
import com.ibm.mq.commonservices.internal.utils.Message;
import com.ibm.mq.explorer.core.internal.base.DmCoreException;
import com.ibm.mq.explorer.core.internal.event.DmActionEvent;
import com.ibm.mq.explorer.core.internal.event.DmActionListener;
import com.ibm.mq.explorer.core.internal.objects.DmTopic;
import com.ibm.mq.explorer.core.internal.objects.DmTopicStatus;
import com.ibm.mq.explorer.qmgradmin.internal.topics.UiTopic;
import com.ibm.mq.explorer.qmgradmin.internal.topics.UiTopicStatus;
import com.ibm.mq.explorer.qmgradmin.topicstatus.internal.base.TopicStatusPlugin;
import com.ibm.mq.explorer.ui.extensions.MQExtObject;
import com.ibm.mq.explorer.ui.internal.base.UiPlugin;
import com.ibm.mq.explorer.ui.internal.messagebox.BusyDialog;
import com.ibm.mq.explorer.ui.internal.messagebox.MessageBox;
import com.ibm.mq.explorer.ui.internal.objects.UiMQObject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate;

public class ClearRetainedPublication
implements IActionDelegate,
DmActionListener {
    public static final String COPYRIGHT_NOTICE = "(c) Copyright IBM Corporation 2005.";
    public static final String SCCSID = "@(#) MQMBID sn=p944-L251003 su=5a6d9bbecd43549d3b1be8d12c2bdf86e288a3d6 pn=com.ibm.mq.explorer.qmgradmin.topicstatus/src/com/ibm/mq/explorer/qmgradmin/topicstatus/internal/actions/ClearRetainedPublication.java";
    private static final String AMQ4486 = "AMQ4486";
    private MQExtObject selectedMQExtObject = null;
    private UiMQObject selectedUiMQObject = null;
    private BusyDialog busyDialog = null;
    private DmActionEvent dmActionEvent = null;

    public void run(IAction action) {
        String id = action.getId();
        if ((id.compareTo("com.ibm.mq.explorer.qmgradmin.topicstatus.clearretainedpub_topic_local") == 0 || id.compareTo("com.ibm.mq.explorer.qmgradmin.topicstatus.clearretainedpub_topic_global") == 0 || id.compareTo("com.ibm.mq.explorer.qmgradmin.topicstatus.clearretainedpub_topicstatus_local") == 0 || id.compareTo("com.ibm.mq.explorer.qmgradmin.topicstatus.clearretainedpub_topicstatus_global") == 0) && (this.selectedUiMQObject instanceof UiTopic || this.selectedUiMQObject instanceof UiTopicStatus)) {
            int scope = 1;
            if (id.compareTo("com.ibm.mq.explorer.qmgradmin.topicstatus.clearretainedpub_topic_global") == 0 || id.compareTo("com.ibm.mq.explorer.qmgradmin.topicstatus.clearretainedpub_topicstatus_global") == 0) {
                scope = 2;
            }
            this.clearRetainedPublication(Trace.getDefault(), this.selectedUiMQObject, scope);
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection structuredSelection;
        Object obj;
        if (selection != null && selection instanceof IStructuredSelection && (obj = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) != null && obj instanceof MQExtObject) {
            this.selectedMQExtObject = (MQExtObject)obj;
            this.selectedUiMQObject = (UiMQObject)this.selectedMQExtObject.getInstanceId();
        }
    }

    private void clearRetainedPublication(Trace t, UiMQObject uiMQObject, int scope) {
        Shell shell = UiPlugin.getShell();
        int rc = 1;
        String topicString = "";
        String msg = "";
        String msgNo = "";
        if (uiMQObject instanceof UiTopic) {
            topicString = ((UiTopic)uiMQObject).getTopicString(t);
        } else if (uiMQObject instanceof UiTopicStatus) {
            topicString = ((UiTopicStatus)uiMQObject).getTopicString(t);
        }
        if (scope == 1) {
            msgNo = "AMQ4485";
            msg = Message.format((String)CommonServices.getSystemMessage((Trace)t, (String)msgNo), (String)topicString);
        } else {
            msgNo = "AMQ4498";
            msg = Message.format((String)CommonServices.getSystemMessage((Trace)t, (String)msgNo), (String)topicString);
        }
        rc = MessageBox.showYesNoMessage((Trace)t, (Shell)shell, (String)msg, (int)1, (String)msgNo);
        if (rc == 0) {
            this.busyDialog = new BusyDialog(shell, TopicStatusPlugin.getMessages(t).getMessage("TS.Topic.Clearing.Retained"));
            if (uiMQObject instanceof UiTopic) {
                DmTopic dmTopic = (DmTopic)uiMQObject.getDmObject();
                dmTopic.actionClearTopicString(t, (DmActionListener)this, scope);
            } else if (uiMQObject instanceof UiTopicStatus) {
                DmTopicStatus dmTopicStatus = (DmTopicStatus)uiMQObject.getDmObject();
                dmTopicStatus.actionClearTopicString(t, (DmActionListener)this, scope);
            }
            this.busyDialog.showDialog(t);
            if (this.dmActionEvent != null) {
                rc = this.dmActionEvent.getReasonCode();
                if (rc == 0) {
                    MessageBox.showSystemMessageById((Trace)t, (Shell)UiPlugin.getShell(), (String)AMQ4486, (String[])new String[]{topicString}, (String)AMQ4486);
                } else {
                    DmCoreException exc = this.dmActionEvent.getException();
                    if (exc != null) {
                        MessageBox.showExceptionMessage((Trace)t, (Shell)UiPlugin.getShell(), (DmCoreException)exc);
                    } else {
                        MessageBox.showExceptionMessage((Trace)t, (Shell)UiPlugin.getShell(), (DmCoreException)new DmCoreException("Reason code: " + rc, "Unknown", rc, 0, 1));
                    }
                }
            }
        }
    }

    public void dmActionDone(DmActionEvent event) {
        this.dmActionEvent = event;
        if (this.busyDialog != null) {
            UiPlugin.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ClearRetainedPublication.this.busyDialog.closeDialog(Trace.getDefault());
                    ClearRetainedPublication.this.busyDialog = null;
                }
            });
        }
    }
}

