%{

package com.ibm.etools.cobol.importer;

import java.io.*;
import java.util.*;
import com.ibm.record.*;
import java.math.*;
import java.net.MalformedURLException;


%}

%token FILLER
%token COMP
%token COMP1
%token COMP2
%token COMP3
%token COMP5
%token COMPX
%token INDEX
%token DISPLAY
%token POINTER
%token DISPLAY1
%token NATIONAL
%token PROCPOINTER
%token OCCURS
%token ASCENDING
%token DESCENDING
%token INDEXED
%token DEPENDING
%token REDEFINES
%token TO
%token LEADING
%token TRAILING
%token SEPARATE
%token SYNC
%token RIGHT
%token LEFT
%token JUST
%token BLANK
%token ZERO
%token SPACE
%token QUOTE
%token SQUOTE
%token HIGHVALUE
%token LOWVALUE
%token NULL
%token PERIOD
%token INTEGER
%token ID
%token PICTURE
%token VALUE
%token ALL
%token THROUGH
%token COPY
%token OFIN
%token REPLACING
%token REPLACINGID
%token OPTIONAL
%token LITERAL

%start commarea

%%

commarea:                  records
                       ;

records:                   records record
                       |   /* NIL */
                       ;

record:                    { initInfo(); }
			    descriptor clauses PERIOD
                           { storeInfo(); }
                       |   COPY {bCopyContext = true; /*16494 Keep old semantics for OF/IN in COPY statement*/ }
                           ID ofinClause replacingClause PERIOD
                           {
                           	  bCopyContext = false; /*16494 Turn on OF/IN for ODO qualifiers.*/
                              if ( tokenizerList.size() > 1 && replaceSize > 0 )
                              {
                                 Object[] obj = {cobolFileList.peek().toString(), Integer.toString(((StreamTokenizer)tokenizerList.peek()).lineno())};
                             	  yyerror(CobolResource.getString("_EXC_Invalid_nested_copy_statement", obj), true);
                              }
                              else if ( tokenizerList.size() > 1 && !replaceList.isEmpty() )
                              {
		                  Object[] obj = {cobolFileList.peek().toString(), Integer.toString(((StreamTokenizer)tokenizerList.peek()).lineno())};
                                 yyerror(CobolResource.getString("_EXC_Nested_copy_cannot_contain_replacing_phrase", obj), true);
                              }
                              else
                              {
                                 if ( tokenizerList.size() < 2 )
                                    replaceSize = replaceList.size();
                                 String copybook = buffer.get($3).toString(); /*16494 Adjust order of symbols (was $2 and $3)*/
                                 String filePath = buffer.get($4).toString() + System.getProperty("file.separator");
			          String copybookFullName = filePath + copybook + ".cbl";
   			          if ( !new File(copybookFullName).isFile() )
   				     copybookFullName = filePath + copybook + ".cpy";
   			          if ( !new File(copybookFullName).isFile() )
   				     copybookFullName = filePath + copybook;
			   		try {		     
					 java.net.URL copybookURL = new java.net.URL("file", null, -1, copybookFullName);
					 copybookFullName = copybookURL.toString();
			   		} catch (MalformedURLException ex) {
			   		}
   			
                                 CobolCommareaGenerator f_out = new CobolCommareaGenerator(copybookFullName);
				 f_out.generateToString();
				 cobolFileList.push(copybookFullName);
				 String str = f_out.toString();
				 if ( !replaceList.isEmpty() )
	        		 	str = f_out.replace(str, replaceList, replaceByList);
       			 tokenizerList.push(new StreamTokenizer(new StringReader(str)));
                                 replaceList = new Vector();
                                 replaceByList = new Vector();
                              }
                           }
                       ;

descriptor:                INTEGER
                           { level = $1; }
                           name
                           { name = (String)buffer.get($3); /*Do not mangle the name*/
                             if (level!=88)
                                previousType = new String();
                           }
                       ;

name:                      ID
                           {
                               $$ = buffer.put((String)buffer.get($1));
                               fill = false;
                           }
                       |   FILLER
                           {
                               $$ = buffer.put("fill_" + fillerGen);
                               fillerGen++;
                               fill = true;
                           }
                       |
                           {
                               $$ = buffer.put("fill_" + fillerGen);
                               fillerGen++;
                               fill = true;
                           }
                       ;

clauses:                   clauses clause
                       |   /* NIL */
                       ;

clause:                    usageClause
                       |   synchronizedClause
                           { align = true; }
                       |   justificationClause
                       |   blankClause
                       |   signClause
                       |   occursClause
                       |   valueClause
                       |   redefinesClause
                       |   pictureClause
                       ;

pictureClause:             PICTURE ID
                           {
                              pic((String)buffer.get($2));

                              if ( paddingRequired )
                                 value = " ";

                              if ( usage != CobolRecord.COMP3 )
                              {
                                 if ( !numeric )
                                 {
                                    javaType = "java.lang.String";
                                 }
                                 else
                                 {
                                    if ( decimal )
                                    {
                                       javaType = "java.lang.Double";
                                    }
                                    else
                                    {
                                       if ( numberOfNines < 5 )
                                          javaType = "java.lang.Short";
                                       else if ( numberOfNines > 9 )
                                          javaType = "java.lang.Long";
                                       else
                                          javaType = "java.lang.Integer";
                                    }
                                 }
                              }
                           }
                       |   PICTURE INTEGER
                           {
                              pic(Integer.toString($2));

                              if ( paddingRequired )
                                 value = " ";

                              if ( usage != CobolRecord.COMP3 )
                              {
                                 if ( decimal )
                                 {
                                    javaType = "java.lang.Double";
                                 }
                                 else
                                 {
                                    if ( numberOfNines < 5 )
                                       javaType = "java.lang.Short";
                                    else if ( numberOfNines > 9 )
                                       javaType = "java.lang.Long";
                                    else
                                       javaType = "java.lang.Integer";
                                 }
                             }
                          }
                       ;

blankClause:               BLANK ZERO
                       ;

redefinesClause:           REDEFINES ID
                           { redefinedItem = (String)buffer.get($2); } /*Do not mangle the name*/
                       ;

occursClause:              OCCURS INTEGER dependingClause keyClauses indexClauses
                           {
                           if (isLowBound!=-1)
                              lowBound = $2; /*26260 GIM save this this is ODO */         
			               if ($2 > bound)
		             		   bound = $2;
			               }
                       ;

dependingClause:         TO INTEGER DEPENDING qualifiedIDs /*16494 Correct existing ODO rule*/
                           {
                             isLowBound = $2; /*26260 GIM save this if later item turns to be ODO */ 
						     if ($2 > bound)
        					 bound = $2;
                           }
                       | DEPENDING qualifiedIDs            /*16494*/
                       |   /* NIL */
                       ;

qualifiedIDs:            qualifiedIDs OFIN qualifiedID      /*16494 Correct nonterminal that understands OF/IN*/
					   | qualifiedID                        /*16494 and also understands unqualified items.   */
                       |   /* NIL */                        /*16494*/
					   ;
					
qualifiedID:           ID  /*16494 Separate nonterminal for clarity (could have crammed in IDs above*/
			   {
			     idVector.addElement((String)buffer.get($1)); /*16494*/ /*Do not mangle the name*/
			   }
					   ;					
					    	
keyClauses:                keyClauses keyClause
                       |   /* NIL */
                       ;

keyClause:                 ASCENDING idList
                       |   DESCENDING idList
                       ;

indexClauses:              indexClauses indexClause
                       |   /* NIL */
                       ;

indexClause:               INDEXED idList
                       ;

idList:                    idList ID
                       |   /* NIL */
                       ;

valueClause:               VALUE valueList
                       ;

literal:                   ID LITERAL
                           {
//			       Object[] obj = {cobolFileList.peek().toString(), Integer.toString(((StreamTokenizer)tokenizerList.peek()).lineno())};
//			       yyerror(CobolResource.getString("_EXC_Hexadecimal_value_not_supported", obj), true);
                           }
                       |   ALL ID LITERAL
                       	   {
                       	   }                           
                       |   LITERAL
                           {
                              value = (String)buffer.get($1);
                              lit = value;
                           }
                       |   ALL LITERAL
                           {
                              figConst = buffer.get($2).toString();
			       if ( figConst.equals("\"") )
				  figConst = "\\" + figConst;
                               lit=figConst;
                           }
                       |   ZERO
                           {
                              value = "0";
                              figConst = "0";
                              lit = value;
                           }
                       |   SPACE
                           {  value = " ";
                              lit = value;}
                       |   QUOTE
                           {  figConst = "\\\"";
                              lit = figConst;}
                       |   SQUOTE
                           {  figConst = "\'";
                              lit = figConst;}
                       |   HIGHVALUE
                           {
                           	  /*GIM SVL CMVC: 36900 Handle unsupported types*/ 	
                              //Object[] obj = {cobolFileList.peek().toString(), Integer.toString(((StreamTokenizer)tokenizerList.peek()).lineno())};
                              //unsupportedTypes.add(new String(CobolResource.getString("_EXC_High_value_not_supported", obj)));
                           }
                       |   LOWVALUE
                           {   
                              /*GIM SVL CMVC: 36900 Handle unsupported types*/ 	
                              //Object[] obj = {cobolFileList.peek().toString(), Integer.toString(((StreamTokenizer)tokenizerList.peek()).lineno())};
                              //unsupportedTypes.add(new String(CobolResource.getString("_EXC_Low_value_not_supported", obj)));
                           }
                       |   NULL
                           {   
                              /*GIM SVL CMVC: 36900 Handle unsupported types*/ 	
                              Object[] obj = {cobolFileList.peek().toString(), Integer.toString(((StreamTokenizer)tokenizerList.peek()).lineno())};                              
                              unsupportedTypes.add(new String(CobolResource.getString("_EXC_Null_value_not_supported", obj)));                              
                           }
                       |   ALL ZERO
                           {
                              value = "0";
                              figConst = "0";
                              lit = value;
                           }
                       |   ALL SPACE
                           {  value = " ";
                              lit = value;}
                       |   ALL QUOTE
                           {  figConst = "\\\"";
                              lit = figConst;}
                       |   ALL SQUOTE
                           {  figConst = "\'";
                              lit = figConst;}
                       |   ALL HIGHVALUE
                           {
                              /*GIM SVL CMVC: 36900 Handle unsupported types*/ 	
                             //Object[] obj = {cobolFileList.peek().toString(), Integer.toString(((StreamTokenizer)tokenizerList.peek()).lineno())};
                             //unsupportedTypes.add(new String(CobolResource.getString("_EXC_High_value_not_supported", obj)));                                                           
                           }
                       |   ALL LOWVALUE
                           {
                              /*GIM SVL CMVC: 36900 Handle unsupported types*/ 	
                              //Object[] obj = {cobolFileList.peek().toString(), Integer.toString(((StreamTokenizer)tokenizerList.peek()).lineno())};
							  //unsupportedTypes.add(new String(CobolResource.getString("_EXC_Low_value_not_supported", obj)));                                                                                         
                           }
                       |   ALL NULL
                           {
                              /*GIM SVL CMVC: 36900 Handle unsupported types*/ 	
                              Object[] obj = {cobolFileList.peek().toString(), Integer.toString(((StreamTokenizer)tokenizerList.peek()).lineno())};
                              unsupportedTypes.add(new String(CobolResource.getString("_EXC_Null_value_not_supported", obj)));                                                           
                           }
                       |   INTEGER
                           {
                              value = Integer.toString($1);
                              lit = value;
                           }
                       ;

valueList:                 valueList literal
                           {
                              if ( level == 88 )
                              {
                                 if (previousType.equals(""))
                                 {  possibleValues.addElement((Object) lit); }
                                 else if (previousType.equals("java.lang.String"))
                                 {
                                    possibleValues.addElement(lit);
                                 }
                                 else
                                 {  if (previousType.equals("java.lang.Double"))
                                    {
                                       possibleValues.addElement(new Double(lit));
                                    }
                                    else
                                    {  if (previousType.equals("java.lang.Short"))
                                       {
                                          if (lit.startsWith("+"))
                                             lit = lit.substring(1);
                                          possibleValues.addElement(new Short(lit));
                                       }
                                       else
                                       {  if (previousType.equals("java.lang.Long"))
                                          {
                                             if (lit.startsWith("+"))
                                                lit = lit.substring(1);
                                             possibleValues.addElement(new Long(lit));
                                          }
                                          else
                                          {  if (previousType.equals("java.lang.Integer"))
                                             {
                                                if (lit.startsWith("+"))
                                                   lit = lit.substring(1);
                                                possibleValues.addElement(new Integer(lit));
                                             }
                                             else
                                             {  if (previousType.equals("java.lang.Float"))
                                                {
                                                   possibleValues.addElement(new Float(lit));
                                                }
                                                else
                                                {  if (previousType.equals("java.math.BigDecimal"))
                                                   {
                                                      if (lit.startsWith("+"))
                                                         lit = lit.substring(1);
                                                      possibleValues.addElement(new BigDecimal(lit));
                                                   }
                                                }
                                             }
                                          }
                                       }
                                    }
                                 }
                                 value=null;
                                 figConst=null;
                              }
                           }
                       |   valueList literal
                           {  firstLit=lit;  }
                           THROUGH literal
                           {
                              if ( level == 88 )
                              {
                                 if (previousType.equals("") || previousType.equals("java.lang.String"))
                                 {
                                  try {
                                    if (firstLit.length()==1 && lit.length()==1)
                                    {
                                       if (Character.isLetter(firstLit.charAt(0)) && Character.isLetter(lit.charAt(0)))
                                       {
                                          if ((Character.isLowerCase(firstLit.charAt(0)) && Character.isLowerCase(lit.charAt(0))) ||
                                              (Character.isUpperCase(firstLit.charAt(0)) && Character.isUpperCase(lit.charAt(0))))
                                          {
                                              possibleValues.addElement(new StringRange(firstLit, lit));
                                          }
                                          else
                                          {
                                             if (Character.isLowerCase(firstLit.charAt(0)))
                                             {
                                                possibleValues.addElement(new StringRange(firstLit, "z"));
                                                possibleValues.addElement(new StringRange("A", lit));
                                             }
                                             else
                                             {
                                                possibleValues.addElement(new StringRange(firstLit, "Z"));
                                                possibleValues.addElement(new StringRange("a", lit));
                                             }
                                          }
                                       }
                                       else
                                       {
                                          possibleValues.addElement(new StringRange(firstLit, lit));
                                       }
                                    }
                                    else
                                    {
                                       possibleValues.addElement(new StringRange(firstLit, lit));
                                    }
                                 }
                                 catch(IllegalArgumentException iae) {
										Object[] obj = {lit, firstLit};
										throw new CobolException(CobolResource.getString("_EXC_Invalid_String_Range", obj));                                    	
                                    }
                                 }
                                 else
                                 {  if (previousType.equals("java.lang.Double"))
                                    {
                                       possibleValues.addElement(new DoubleRange (new Double(firstLit).doubleValue(), new Double(lit).doubleValue()));
                                    }
                                    else
                                    {  if (previousType.equals("java.lang.Short"))
                                       {
                                          if (firstLit.startsWith("+"))
                                             firstLit = firstLit.substring(1);
                                          if (lit.startsWith("+"))
                                             lit = lit.substring(1);
                                          possibleValues.addElement(new ShortRange(new Short(firstLit).shortValue(), new Short(lit).shortValue()));
                                       }
                                       else
                                       {  if (previousType.equals("java.lang.Long"))
                                          {
                                             if (firstLit.startsWith("+"))
                                                firstLit = firstLit.substring(1);
                                             if (lit.startsWith("+"))
                                                lit = lit.substring(1);
                                             possibleValues.addElement(new LongRange(new Long(firstLit).longValue(), new Long(lit).longValue()));
                                          }
                                          else
                                          {  if (previousType.equals("java.lang.Integer"))
                                             {
                                                if (firstLit.startsWith("+"))
                                                   firstLit = firstLit.substring(1);
                                                if (lit.startsWith("+"))
                                                   lit = lit.substring(1);
                                                possibleValues.addElement(new IntegerRange(new Integer(firstLit).intValue(), new Integer(lit).intValue()));
                                             }
                                             else
                                             {  if (previousType.equals("java.lang.Float"))
                                                {
                                                   possibleValues.addElement(new FloatRange(new Float(firstLit).floatValue(), new Float(lit).floatValue()));
                                                }
                                                else
                                                {  if (previousType.equals("java.math.BigDecimal"))
                                                   {
                                                      if (firstLit.startsWith("+"))
                                                         firstLit = firstLit.substring(1);
                                                      if (lit.startsWith("+"))
                                                         lit = lit.substring(1);
                                                      possibleValues.addElement(new com.ibm.record.BigDecimalRange(new BigDecimal(firstLit), new BigDecimal(lit)));
                                                   }
                                                }
                                             }
                                          }
                                       }
                                    }
                                 }
                                 value = null;
                                 figConst = null;
                              }
                           }
                       |   /* NIL */
                       ;

usageClause:               COMP
                           { usage = CobolRecord.COMP; }
                       |   COMP1
                           {
                              usage = CobolRecord.COMP1;
                              picString = " ";
                              javaType = "java.lang.Float";
                           }
                       |   COMP2
                           {
                              usage = CobolRecord.COMP2;
                              picString = " ";
                              javaType = "java.lang.Double";
                           }
                       |   COMP3
                           {
                              usage = CobolRecord.COMP3;
                              javaType = "java.math.BigDecimal";
                           }
                       |   COMP5
                           {
                              usage = CobolRecord.COMP5;
//                              Object[] obj = {cobolFileList.peek().toString(), Integer.toString(((StreamTokenizer)tokenizerList.peek()).lineno())};
//                               yyerror(CobolResource.getString("_EXC_Comp5_not_supported_on_mvs", obj), false);
                           }
                       |   DISPLAY
                           { usage = CobolRecord.DISPLAY; }
                       |   COMPX
                           {
                              /*GIM SVL CMVC: 36692 Handle unsupported types*/ 
                              Object[] obj = {cobolFileList.peek().toString(), Integer.toString(((StreamTokenizer)tokenizerList.peek()).lineno())};
                              unsupportedTypes.add(new String(CobolResource.getString("_EXC_Compx_not_supported", obj)));
                           }
                       |   INDEX
                           {
                              Object[] obj = {cobolFileList.peek().toString(), Integer.toString(((StreamTokenizer)tokenizerList.peek()).lineno())};
//                            yyerror(CobolResource.getString("_EXC_Index_not_supported", obj), true);
                              /*GIM SVL CMVC: 36692 Handle unsupported types*/ 
                              unsupportedTypes.add(new String(CobolResource.getString("_EXC_Index_not_supported", obj)));
                           }
                       |   POINTER
                           {
                              /*GIM SVL CMVC: 36692 Handle unsupported types*/ 
                              Object[] obj = {cobolFileList.peek().toString(), Integer.toString(((StreamTokenizer)tokenizerList.peek()).lineno())};
                              unsupportedTypes.add( new String(CobolResource.getString("_EXC_Pointer_not_supported", obj)));
                           }
                       |   DISPLAY1
                           { usage = CobolRecord.DISPLAY1; }
                       |   NATIONAL
                           { usage = CobolRecord.NATIONAL; }
                       |   PROCPOINTER
                           {
                              /*GIM SVL CMVC: 36692 Handle unsupported types*/ 
                              Object[] obj = {cobolFileList.peek().toString(), Integer.toString(((StreamTokenizer)tokenizerList.peek()).lineno())};
                              unsupportedTypes.add(new String(CobolResource.getString("_EXC_Procedure_pointer_not_supported", obj)));
                           }
                       ;

signClause:                LEADING
                           { sign = CobolRecord.LEADING; }
                       |   LEADING SEPARATE
                           { sign = CobolRecord.LEADINGSEPARATE; }
                       |   TRAILING
                           { sign = CobolRecord.TRAILING; }
                       |   TRAILING SEPARATE
                           { sign = CobolRecord.TRAILINGSEPARATE; }
                       ;

synchronizedClause:        SYNC
                       |   SYNC LEFT
                       |   SYNC RIGHT
                       ;

justificationClause:       JUST
                       |   JUST RIGHT
                       ;

ofinClause:                OFIN LITERAL
                           { $$ = buffer.put(buffer.get($2).toString()); }
                       |   /* NIL */
                           { String parent = new File(cobolFileList.firstElement().toString()).getParent();
			     if (parent==null)
				parent = ".";
			     $$ = buffer.put(parent);
			   }
                       ;

replacingClause:           REPLACING replacingList
                       |   /* NIL */
                       ;

replacingList:             replacingList REPLACINGID REPLACINGID
                           {
	String felement = operand1.firstElement().toString();
	String lelement = operand1.lastElement().toString();
	int findex = felement.indexOf("==");
	int lindex = lelement.lastIndexOf("==");
	if ( findex != -1 && lindex != -1 )
	{
		if ( (findex != -1 && lindex == -1) || (findex == -1 && lindex != -1) )
		{
			  Object[] obj = {cobolFileList.peek().toString(), Integer.toString(((StreamTokenizer)tokenizerList.peek()).lineno())};
			  yyerror(CobolResource.getString("_EXC_Syntax_error_in_copy_statement", obj), true);
		}
		else if ( findex == lindex )
		{
			if ( felement.length() == 2 )
				operand1.removeElementAt(0);
			else
				operand1.setElementAt(felement.substring(2), 0);
			if ( lelement.length() == 2 )
				operand1.removeElementAt(operand1.size()-1);
			else
				operand1.setElementAt(lelement.substring(0, lelement.length()-2), operand1.size()-1);
		}
		else
		{
			if ( operand1.size() == 1 )
				operand1.setElementAt(felement.substring(2, lindex), 0);
			else
			{
				operand1.setElementAt(felement.substring(2), 0);
				operand1.setElementAt(lelement.substring(0, lindex), operand1.size()-1);
			}
		}
	}
	if (operand1.isEmpty() || operand1.firstElement().equals("") )
	{
		  Object[] obj = {cobolFileList.peek().toString(), Integer.toString(((StreamTokenizer)tokenizerList.peek()).lineno())};
		  yyerror(CobolResource.getString("_EXC_Syntax_error_in_copy_statement", obj), true);
	}

	felement = operand2.firstElement().toString();
	lelement = operand2.lastElement().toString();
	findex = felement.indexOf("==");
	lindex = lelement.lastIndexOf("==");
	if ( findex != -1 && lindex != -1 )
	{
		if ( (findex != -1 && lindex == -1) || (findex == -1 && lindex != -1) )
		{
			  Object[] obj = {cobolFileList.peek().toString(), Integer.toString(((StreamTokenizer)tokenizerList.peek()).lineno())};
			  yyerror(CobolResource.getString("_EXC_Syntax_error_in_copy_statement", obj), true);
		}
		else if ( findex == lindex )
		{
			if ( felement.length() == 2 )
				operand2.removeElementAt(0);
			else
				operand2.setElementAt(felement.substring(2), 0);
			if ( lelement.length() == 2 )
				operand2.removeElementAt(operand2.size()-1);
			else
				operand2.setElementAt(lelement.substring(0, lelement.length()-2), operand2.size()-1);
		}
		else
		{
			if ( operand2.size() == 1 )
				operand2.setElementAt(felement.substring(2, lindex), 0);
			else
			{
				operand2.setElementAt(felement.substring(2), 0);
				operand2.setElementAt(lelement.substring(0, lindex), operand2.size()-1);
			}
		}
	}
	if ( operand2.isEmpty() )
		operand2.addElement("");
				
							  replaceList.addElement(operand1);
							  replaceByList.addElement(operand2);
	         		  operand1 = new Vector();
        			  operand2 = new Vector();
                           }
                       |   /* NIL */
                       ;

%%


   void initInfo()
   {
      usage = CobolRecord.NOUSAGE;
      sign = CobolRecord.NOSIGN;

      align = false;
      fill = false;
      // 1.0.1 NL changes
      inDBCS = false;
      // 1.0.1 NL end
      isSign = false;
      decimal = false;
      numeric = true;
      paddingRequired = false;

      bound = 1;
      lowBound = -1; /*26260 GIM Save lower bound for ODO */
      isLowBound = -1; /*26260 GIM Save lower bound for ODO */
      numberOfNines = 0;
      decimalPosition = 0;
      scale = 0;
      picFieldLength = 0;

      value = null;
      figConst = null;
      redefinedItem = null;
      picString = new String();
      javaType = new String();

      idVector = new Vector();
      possibleValues = new Vector();
   }

   void storeInfo() throws CobolException
   {
      if (level == 88)
      {
         ((CobolRecord)groupStack.peek()).setPossibleValues(name, possibleValues);
      }
      else
      {
         previousType=javaType;
         while (groupStack.peek() instanceof CobolElementaryRecord)
            groupStack.pop();

         // determine which group record belongs to
         while ( level <= ((CobolRecord)groupStack.peek()).level() )
            groupStack.pop();

         if ( !picString.equals("") )
         {
            countForIMS++;
            pNewRecord =  new CobolElementaryRecord((CobolRecord)groupStack.peek(), name, level);
            if (groupStack.peek() instanceof CobolGroupRecord)
               ((CobolGroupRecord)groupStack.peek()).add(pNewRecord);
            else if (groupStack.peek() instanceof CobolElementaryRecord)
               ((CobolElementaryRecord)groupStack.peek()).add(pNewRecord);
            pNewRecord.setPicString(picString);
 //           pNewRecord.setNewPicClass(com.ibm.ivj.eab.tools.ClassPathUtility.loadClass(CobolImport.workspace, javaType));
            if ( value != null )
               pNewRecord.setValue(value);

            if ( figConst != null )
               pNewRecord.setFigConst(figConst);


            // Add the TranCode Field as the 3rd field for an IMS record
	    if (countForIMS == 2 && !IMSTranCode.equals(""))
            {
		StringTokenizer st = new StringTokenizer(IMSTranCode, ":");
		st.nextToken();
		CobolElementaryRecord tranCodeRec = new CobolElementaryRecord((CobolRecord)groupStack.peek(), st.nextToken(),level);
		if (groupStack.peek() instanceof CobolGroupRecord)
		    ((CobolGroupRecord)groupStack.peek()).add(tranCodeRec);
		else if (groupStack.peek() instanceof CobolElementaryRecord)
			((CobolElementaryRecord)groupStack.peek()).add(tranCodeRec);
	   	if (st.hasMoreTokens())
		   tranCodeRec.setPicString("X("+st.nextToken()+")");
	   	else tranCodeRec.setPicString("X(8)");
//tranCodeRec.setNewPicClass(com.ibm.ivj.eab.tools.ClassPathUtility.loadClass(CobolImport.workspace, javaType));
		if ( st.hasMoreTokens())
	   	   tranCodeRec.setValue(st.nextToken());
				
		groupStack.push(pNewRecord);
			   	
		tranCodeRec.setRedefinedItem(null);
		tranCodeRec.setDependedOnItem(new Vector());
		tranCodeRec.setUsage(CobolRecord.NOUSAGE);
		tranCodeRec.setSign(CobolRecord.NOSIGN);
		tranCodeRec.setAlignment(false);
		tranCodeRec.setFiller(false);
		tranCodeRec.setArrayBound(1);
		groupStack.push(tranCodeRec);
	    }
            else groupStack.push(pNewRecord);
         }
         else
         {
            pNewRecord = new CobolGroupRecord((CobolRecord)groupStack.peek(), name, level);
            if (groupStack.peek() instanceof CobolGroupRecord)
               ((CobolGroupRecord)groupStack.peek()).add(pNewRecord);
            else if (groupStack.peek() instanceof CobolElementaryRecord)
               ((CobolElementaryRecord)groupStack.peek()).add(pNewRecord);
            // create new level
            groupStack.push(pNewRecord);
         }
         pNewRecord.setRedefinedItem(redefinedItem);
         pNewRecord.setDependedOnItem(idVector);
         pNewRecord.setUsage(usage);
         pNewRecord.setSign(sign);
         pNewRecord.setAlignment(align);
         pNewRecord.setFiller(fill);
         pNewRecord.setArrayBound(bound);
         pNewRecord.setArrayLowBound(lowBound); /*26260 GIM Save lower bound for ODO */
      }
   }

public static String hyphenToUnderscore(String str)
{
   // change all hyphens to underscores since COBOL allows hyphens in identifiers
   // ensure name does not begin with a numeric as COBOL allows
   StringTokenizer st = new StringTokenizer(str, "-0123456789", true);
   boolean checkNumber = true;
   StringBuffer strBuff = new StringBuffer();
   while ( st.hasMoreTokens() )
   {
      String token = st.nextToken();
      if ( token.equals("-") )
         strBuff.append("__");
      else
      {
         if ( checkNumber )
         {
            try {
               Integer.parseInt(token);
               strBuff.append("__");
               strBuff.append(token);
            } catch (NumberFormatException e) {
               strBuff.append(token);
            }
         }
         else
            strBuff.append(token);
      }
      checkNumber = false;
   }
   return strBuff.toString();
}

public int yylex() throws CobolException
{
	StreamTokenizer f = (StreamTokenizer)tokenizerList.peek();
	f.ordinaryChars(32, 126);
	f.wordChars(32, 126);
	f.whitespaceChars(' ',' ');
	if ( token != OFIN || (token == OFIN && !bCopyContext))      /*16494 Keep old semantics for OF/IN in COPY statement*/
	{
		f.quoteChar('\'');
		f.quoteChar('"');
	}
	
	int ttype;
	try {
		ttype = f.nextToken();
	} catch (IOException exc) {
		throw new CobolException(CobolResource.getString("_EXC_Import_failed"));
	}
		switch (ttype)
		{
			case java.io.StreamTokenizer.TT_EOF :
				if (tokenizerList.size() > 1)
				{
					tokenizerList.pop();
					cobolFileList.pop();
					return (yylex());
				}
				return 0;
			case java.io.StreamTokenizer.TT_WORD:
				int rc = findSymbol(f.sval);
				if (rc == -1)
				{
					if (f.sval.endsWith(",") || f.sval.endsWith(";"))
					{
					f.sval = f.sval.substring(0, f.sval.length()-1);
					rc = findSymbol(f.sval);
					}
				}

				if ( rc == OPTIONAL )
				{
					if ( f.sval.equalsIgnoreCase("BY") && token == REPLACING )
					{
						token = REPLACINGID;
						/***
						if ( CobolImport.DEBUG )
						{
							String str = operand1.firstElement().toString();
							for (int k=1;k<operand1.size();k++)
								str = str + " " + operand1.elementAt(k);
							System.out.println("REPLACINGID: "+str);
						}
						 ***/
						yylval = buffer.put(operand1);
			   			return REPLACINGID;
					}
					else
						return (yylex());
				}
				else if ( rc == PERIOD )
				{
					if ( token == REPLACINGID )
					{
						f.pushBack();
						token = -1;
							/***
							if ( CobolImport.DEBUG )
							{
								String str = operand2.firstElement().toString();
								for (int k=1;k<operand2.size();k++)
									str = str + " " + operand2.elementAt(k);
								System.out.println("REPLACINGBYID: "+str);
							}
							 ***/
						yylval = buffer.put(operand2);
		   				return REPLACINGID;
					}
					else
					{
						/***
						if ( CobolImport.DEBUG )
							System.out.println("PERIOD");
						 ***/
						token = rc;
						return rc;
					}
				}
				else if ( token == REPLACING )
				{
					operand1.addElement(f.sval);
					return (yylex());
				}
				else if ( token == REPLACINGID )
				{
					if ( operand2.isEmpty() )
					{
						operand2.addElement(f.sval);
						if ( !f.sval.startsWith("==") )
						{
							token = REPLACING;
							/***
							if ( CobolImport.DEBUG )
							{
								String str = operand2.firstElement().toString();
								for (int k=1;k<operand2.size();k++)
									str = str + " " + operand2.elementAt(k);
								System.out.println("REPLACINGBYID1: "+str);
							}
							 ***/
							yylval = buffer.put(operand2);
	   						return REPLACINGID;
						}
						else
							return (yylex());
					}
					else if ( operand2.lastElement().toString().endsWith("==") && operand2.size() > 1 )
					{
						f.pushBack();
						token = REPLACING;
						/***
						if ( CobolImport.DEBUG )
						{
							String str = operand2.firstElement().toString();
							for (int k=1;k<operand2.size();k++)
								str = str + " " + operand2.elementAt(k);
							System.out.println("REPLACINGBYID2: "+str);
						}
						 ***/
						yylval = buffer.put(operand2);
   						return REPLACINGID;
					}
					else if ( operand2.lastElement().toString().endsWith("==") && operand2.firstElement().toString().length() > 2 )
					{
						f.pushBack();
						token = REPLACING;
						/***
						if ( CobolImport.DEBUG )
						{
							String str = operand2.firstElement().toString();
							for (int k=1;k<operand2.size();k++)
								str = str + " " + operand2.elementAt(k);
							System.out.println("REPLACINGBYID3: "+str);
						}
						 ***/
						yylval = buffer.put(operand2);
   						return REPLACINGID;
					}
					else
					{
						operand2.addElement(f.sval);
						return (yylex());
					}
				}
				else if ( token == OFIN && bCopyContext )   /*16494 Keep old semantics for OF/IN in COPY statement*/
				{
					token = -1;
					/***
					if ( CobolImport.DEBUG )
						System.out.println("LITERAL: "+f.sval.substring(1, f.sval.length()-1));
					 ***/
					yylval = buffer.put(f.sval.substring(1, f.sval.length()-1));
					return LITERAL;
				}
				else if ( rc != -1 )
				{
					/***
					if ( CobolImport.DEBUG )
						System.out.println(f.sval.toUpperCase(java.util.Locale.US));
					 ***/
					token = rc;
					return rc;
				}
		
				else
				{
					
					try {
						yylval = Integer.parseInt(f.sval);
						/***
						if ( CobolImport.DEBUG )
							System.out.println("INTEGER: "+f.sval);
						 ***/
						return INTEGER;
					} catch (NumberFormatException exc) {
						try{
							Double doub = Double.valueOf(f.sval);
							yylval = buffer.put(f.sval);
							if (token != PICTURE)
							{
								/***
								if ( CobolImport.DEBUG )
									System.out.println("LITERAL1: "+f.sval);
								 ***/
								return LITERAL;
							}
							else
							{
								/***
								if ( CobolImport.DEBUG )
									System.out.println("ID: "+f.sval);
								 ***/
								return ID;
							}
						}
						catch (NumberFormatException ex) {
							yylval = buffer.put(f.sval);
							/***
							if ( CobolImport.DEBUG )
								System.out.println("ID1: "+f.sval);
							 ***/
							return ID;
						}
					}
				}
			default:
				if ( ttype == '\'' || ttype == '"' )
				{
					/***
					if ( CobolImport.DEBUG )
						System.out.println("LITERAL2: "+f.sval);
					 ***/
					yylval = buffer.put(f.sval);
					return LITERAL;
				}
				else
				{
					/***
					if ( CobolImport.DEBUG )
						System.out.println("ID2: "+new Character((char)ttype).toString());
					 ***/
					yylval = buffer.put(new Character((char)ttype).toString());
					return ID;
				}
		}
}

   void yyerror(String s, boolean isError)
   {
      CobolResource.display(s);
      if ( isError ) {
         errorsOccurred = true;
         errorList.add(s);
      }
   }

   boolean getFlag()
   {
      return errorsOccurred;
   }

   public void addSymbols()
   {
      symbols.addElement("filler");            symbols.addElement(new Integer(FILLER));
      symbols.addElement("binary");            symbols.addElement(new Integer(COMP));
      symbols.addElement("computational");     symbols.addElement(new Integer(COMP));
      symbols.addElement("comp");              symbols.addElement(new Integer(COMP));
      symbols.addElement("computational-1");   symbols.addElement(new Integer(COMP1));
      symbols.addElement("comp-1");            symbols.addElement(new Integer(COMP1));
      symbols.addElement("computational-2");   symbols.addElement(new Integer(COMP2));
      symbols.addElement("comp-2");            symbols.addElement(new Integer(COMP2));
      symbols.addElement("computational-3");   symbols.addElement(new Integer(COMP3));
      symbols.addElement("comp-3");            symbols.addElement(new Integer(COMP3));
      symbols.addElement("computational-4");   symbols.addElement(new Integer(COMP));
      symbols.addElement("comp-4");            symbols.addElement(new Integer(COMP));
      symbols.addElement("computational-5");   symbols.addElement(new Integer(COMP5));
      symbols.addElement("comp-5");            symbols.addElement(new Integer(COMP5));
      symbols.addElement("computational-x");   symbols.addElement(new Integer(COMPX));
      symbols.addElement("comp-x");            symbols.addElement(new Integer(COMPX));
      symbols.addElement("index");             symbols.addElement(new Integer(INDEX));
      symbols.addElement("packed-decimal");    symbols.addElement(new Integer(COMP3));
      symbols.addElement("display");           symbols.addElement(new Integer(DISPLAY));
      symbols.addElement("pointer");           symbols.addElement(new Integer(POINTER));
      symbols.addElement("display-1");         symbols.addElement(new Integer(DISPLAY1));
      symbols.addElement("national");          symbols.addElement(new Integer(NATIONAL));
      symbols.addElement("procedure-pointer"); symbols.addElement(new Integer(PROCPOINTER));
      symbols.addElement("occurs");            symbols.addElement(new Integer(OCCURS));
      symbols.addElement("depending");         symbols.addElement(new Integer(DEPENDING));
      symbols.addElement("to");                symbols.addElement(new Integer(TO));
      symbols.addElement("indexed");           symbols.addElement(new Integer(INDEXED));
      symbols.addElement("ascending");         symbols.addElement(new Integer(ASCENDING));
      symbols.addElement("descending");        symbols.addElement(new Integer(DESCENDING));
      symbols.addElement("trailing");          symbols.addElement(new Integer(TRAILING));
      symbols.addElement("leading");           symbols.addElement(new Integer(LEADING));
      symbols.addElement("separate");          symbols.addElement(new Integer(SEPARATE));
      symbols.addElement("synchronized");      symbols.addElement(new Integer(SYNC));
      symbols.addElement("sync");              symbols.addElement(new Integer(SYNC));
      symbols.addElement("left");              symbols.addElement(new Integer(LEFT));
      symbols.addElement("right");             symbols.addElement(new Integer(RIGHT));
      symbols.addElement("just");              symbols.addElement(new Integer(JUST));
      symbols.addElement("justified");         symbols.addElement(new Integer(JUST));
      symbols.addElement("blank");             symbols.addElement(new Integer(BLANK));
      symbols.addElement("zero");              symbols.addElement(new Integer(ZERO));
      symbols.addElement("zeros");             symbols.addElement(new Integer(ZERO));
      symbols.addElement("zeroes");            symbols.addElement(new Integer(ZERO));
      symbols.addElement("space");             symbols.addElement(new Integer(SPACE));
      symbols.addElement("spaces");            symbols.addElement(new Integer(SPACE));
      symbols.addElement("quote");             symbols.addElement(new Integer(QUOTE));
      symbols.addElement("quotes");            symbols.addElement(new Integer(QUOTE));
      symbols.addElement("squote");            symbols.addElement(new Integer(SQUOTE));
      symbols.addElement("squotes");           symbols.addElement(new Integer(SQUOTE));
      symbols.addElement("high-value");        symbols.addElement(new Integer(HIGHVALUE));
      symbols.addElement("high-values");       symbols.addElement(new Integer(HIGHVALUE));
      symbols.addElement("low-value");         symbols.addElement(new Integer(LOWVALUE));
      symbols.addElement("low-values");        symbols.addElement(new Integer(LOWVALUE));
      symbols.addElement("null");              symbols.addElement(new Integer(NULL));
      symbols.addElement("nulls");             symbols.addElement(new Integer(NULL));
      symbols.addElement(".");                 symbols.addElement(new Integer(PERIOD));
      symbols.addElement("redefines");         symbols.addElement(new Integer(REDEFINES));
      symbols.addElement("through");           symbols.addElement(new Integer(THROUGH));
      symbols.addElement("thru");              symbols.addElement(new Integer(THROUGH));
      symbols.addElement("copy");              symbols.addElement(new Integer(COPY));
      symbols.addElement("of");                symbols.addElement(new Integer(OFIN));
      symbols.addElement("in");                symbols.addElement(new Integer(OFIN));
      symbols.addElement("replacing");         symbols.addElement(new Integer(REPLACING));
      symbols.addElement("picture");           symbols.addElement(new Integer(PICTURE));
      symbols.addElement("pic");               symbols.addElement(new Integer(PICTURE));
      symbols.addElement("value");             symbols.addElement(new Integer(VALUE));
      symbols.addElement("values");            symbols.addElement(new Integer(VALUE));
      symbols.addElement("all");               symbols.addElement(new Integer(ALL));
      symbols.addElement("character");         symbols.addElement(new Integer(OPTIONAL));
      symbols.addElement("is");                symbols.addElement(new Integer(OPTIONAL));
      symbols.addElement("usage");             symbols.addElement(new Integer(OPTIONAL));
      symbols.addElement("times");             symbols.addElement(new Integer(OPTIONAL));
      symbols.addElement("key");               symbols.addElement(new Integer(OPTIONAL));
      symbols.addElement("by");                symbols.addElement(new Integer(OPTIONAL));
      symbols.addElement("on");                symbols.addElement(new Integer(OPTIONAL));
      symbols.addElement("sign");              symbols.addElement(new Integer(OPTIONAL));
      symbols.addElement("when");              symbols.addElement(new Integer(OPTIONAL));
      symbols.addElement("are");               symbols.addElement(new Integer(OPTIONAL));
      symbols.addElement("suppress");          symbols.addElement(new Integer(OPTIONAL));
      symbols.addElement(",");                 symbols.addElement(new Integer(OPTIONAL));
      symbols.addElement(";");                 symbols.addElement(new Integer(OPTIONAL));
   }

   public int findSymbol(String toFind)
   {
      for (int i=0;i<symbols.size();i+=2)
      {
         if (toFind.toLowerCase(java.util.Locale.US).compareTo((String)symbols.elementAt(i)) == 0)
            return ((Integer)(symbols.elementAt(i+1))).intValue();
      }
      return -1;
   }

   public void setIMSTranCode(String str) {
	IMSTranCode=str;
	}

   public CobolParser(CobolGroupRecord group, StreamTokenizer tokenizer, String cobolFile)
   {
	  groupStack.push(group);
	  tokenizerList.push(tokenizer);
	  cobolFileList.push(cobolFile);
	  addSymbols();
   }

/**
 * Initializes the picture table representing the
 * table on page 115 of GC26-4047-6. The
 * representation uses 0x01 if the pairing is
 * valid before the decimal and 0x10 if it is
 * valid after the decimal. The indeces to the
 * table are the integer values of the characters.
 */

 private static void cobolPictureTableInit()
 {

   cobolPictureTable['B']['B'] = 0x11;
   cobolPictureTable['B'][','] = 0x11;
   cobolPictureTable['B']['0'] = 0x11;
   cobolPictureTable['B']['/'] = 0x11;
   cobolPictureTable['B']['.'] = 0x11;
   cobolPictureTable['B']['C'] = 0x11;
   cobolPictureTable['B']['D'] = 0x11;
   cobolPictureTable['B']['E'] = 0x00;
   cobolPictureTable['B']['Z'] = 0x11;
   cobolPictureTable['B']['*'] = 0x11;
   cobolPictureTable['B']['+'] = 0x11;
   cobolPictureTable['B']['-'] = 0x11;
   cobolPictureTable['B']['$'] = 0x11;
   cobolPictureTable['B']['9'] = 0x11;
   cobolPictureTable['B']['A'] = 0x11;
   cobolPictureTable['B']['X'] = 0x11;
   cobolPictureTable['B']['S'] = 0x00;
   cobolPictureTable['B']['V'] = 0x11;
   cobolPictureTable['B']['P'] = 0x01;
   cobolPictureTable['B']['G'] = 0x11;
   cobolPictureTable['B']['N'] = 0x00;

   cobolPictureTable['C']['B'] = 0x00;
   cobolPictureTable['C'][','] = 0x00;
   cobolPictureTable['C']['0'] = 0x00;
   cobolPictureTable['C']['/'] = 0x00;
   cobolPictureTable['C']['.'] = 0x00;
   cobolPictureTable['C']['C'] = 0x00;
   cobolPictureTable['C']['D'] = 0x00;
   cobolPictureTable['C']['E'] = 0x00;
   cobolPictureTable['C']['Z'] = 0x00;
   cobolPictureTable['C']['*'] = 0x00;
   cobolPictureTable['C']['+'] = 0x00;
   cobolPictureTable['C']['-'] = 0x00;
   cobolPictureTable['C']['$'] = 0x00;
   cobolPictureTable['C']['9'] = 0x00;
   cobolPictureTable['C']['A'] = 0x00;
   cobolPictureTable['C']['X'] = 0x00;
   cobolPictureTable['C']['S'] = 0x00;
   cobolPictureTable['C']['V'] = 0x00;
   cobolPictureTable['C']['P'] = 0x00;
   cobolPictureTable['C']['G'] = 0x00;
   cobolPictureTable['C']['N'] = 0x00;

   cobolPictureTable['D']['B'] = 0x00;
   cobolPictureTable['D'][','] = 0x00;
   cobolPictureTable['D']['0'] = 0x00;
   cobolPictureTable['D']['/'] = 0x00;
   cobolPictureTable['D']['.'] = 0x00;
   cobolPictureTable['D']['C'] = 0x00;
   cobolPictureTable['D']['D'] = 0x00;
   cobolPictureTable['D']['E'] = 0x00;
   cobolPictureTable['D']['Z'] = 0x00;
   cobolPictureTable['D']['*'] = 0x00;
   cobolPictureTable['D']['+'] = 0x00;
   cobolPictureTable['D']['-'] = 0x00;
   cobolPictureTable['D']['$'] = 0x00;
   cobolPictureTable['D']['9'] = 0x00;
   cobolPictureTable['D']['A'] = 0x00;
   cobolPictureTable['D']['X'] = 0x00;
   cobolPictureTable['D']['S'] = 0x00;
   cobolPictureTable['D']['V'] = 0x00;
   cobolPictureTable['D']['P'] = 0x00;
   cobolPictureTable['D']['G'] = 0x00;
   cobolPictureTable['D']['N'] = 0x00;

   cobolPictureTable['0']['B'] = 0x11;
   cobolPictureTable['0'][','] = 0x11;
   cobolPictureTable['0']['0'] = 0x11;
   cobolPictureTable['0']['/'] = 0x11;
   cobolPictureTable['0']['.'] = 0x11;
   cobolPictureTable['0']['C'] = 0x11;
   cobolPictureTable['0']['D'] = 0x11;
   cobolPictureTable['0']['E'] = 0x00;
   cobolPictureTable['0']['Z'] = 0x11;
   cobolPictureTable['0']['*'] = 0x11;
   cobolPictureTable['0']['+'] = 0x11;
   cobolPictureTable['0']['-'] = 0x11;
   cobolPictureTable['0']['$'] = 0x11;
   cobolPictureTable['0']['9'] = 0x11;
   cobolPictureTable['0']['A'] = 0x11;
   cobolPictureTable['0']['X'] = 0x11;
   cobolPictureTable['0']['S'] = 0x00;
   cobolPictureTable['0']['V'] = 0x11;
   cobolPictureTable['0']['P'] = 0x01;
   cobolPictureTable['0']['G'] = 0x00;
   cobolPictureTable['0']['N'] = 0x00;

   cobolPictureTable['/']['B'] = 0x11;
   cobolPictureTable['/'][','] = 0x11;
   cobolPictureTable['/']['0'] = 0x11;
   cobolPictureTable['/']['/'] = 0x11;
   cobolPictureTable['/']['.'] = 0x11;
   cobolPictureTable['/']['C'] = 0x11;
   cobolPictureTable['/']['D'] = 0x11;
   cobolPictureTable['/']['E'] = 0x00;
   cobolPictureTable['/']['Z'] = 0x11;
   cobolPictureTable['/']['*'] = 0x11;
   cobolPictureTable['/']['+'] = 0x11;
   cobolPictureTable['/']['-'] = 0x11;
   cobolPictureTable['/']['$'] = 0x11;
   cobolPictureTable['/']['9'] = 0x11;
   cobolPictureTable['/']['A'] = 0x11;
   cobolPictureTable['/']['X'] = 0x11;
   cobolPictureTable['/']['S'] = 0x00;
   cobolPictureTable['/']['V'] = 0x11;
   cobolPictureTable['/']['P'] = 0x01;
   cobolPictureTable['/']['G'] = 0x00;
   cobolPictureTable['/']['N'] = 0x00;

   cobolPictureTable[',']['B'] = 0x11;
   cobolPictureTable[','][','] = 0x11;
   cobolPictureTable[',']['0'] = 0x11;
   cobolPictureTable[',']['/'] = 0x11;
   cobolPictureTable[',']['.'] = 0x11;
   cobolPictureTable[',']['C'] = 0x11;
   cobolPictureTable[',']['D'] = 0x11;
   cobolPictureTable[',']['E'] = 0x11;
   cobolPictureTable[',']['Z'] = 0x11;
   cobolPictureTable[',']['*'] = 0x11;
   cobolPictureTable[',']['+'] = 0x11;
   cobolPictureTable[',']['-'] = 0x11;
   cobolPictureTable[',']['$'] = 0x11;
   cobolPictureTable[',']['9'] = 0x11;
   cobolPictureTable[',']['A'] = 0x00;
   cobolPictureTable[',']['X'] = 0x00;
   cobolPictureTable[',']['S'] = 0x00;
   cobolPictureTable[',']['V'] = 0x11;
   cobolPictureTable[',']['P'] = 0x01;
   cobolPictureTable[',']['G'] = 0x00;
   cobolPictureTable[',']['N'] = 0x00;

   cobolPictureTable['.']['B'] = 0x11;
   cobolPictureTable['.'][','] = 0x11;
   cobolPictureTable['.']['0'] = 0x11;
   cobolPictureTable['.']['/'] = 0x11;
   cobolPictureTable['.']['.'] = 0x00;
   cobolPictureTable['.']['C'] = 0x11;
   cobolPictureTable['.']['D'] = 0x11;
   cobolPictureTable['.']['E'] = 0x11;
   cobolPictureTable['.']['Z'] = 0x10;
   cobolPictureTable['.']['*'] = 0x10;
   cobolPictureTable['.']['+'] = 0x10;
   cobolPictureTable['.']['-'] = 0x10;
   cobolPictureTable['.']['$'] = 0x10;
   cobolPictureTable['.']['9'] = 0x11;
   cobolPictureTable['.']['A'] = 0x00;
   cobolPictureTable['.']['X'] = 0x00;
   cobolPictureTable['.']['S'] = 0x00;
   cobolPictureTable['.']['V'] = 0x00;
   cobolPictureTable['.']['P'] = 0x00;
   cobolPictureTable['.']['G'] = 0x00;
   cobolPictureTable['.']['N'] = 0x00;

   cobolPictureTable['+']['B'] = 0x11;
   cobolPictureTable['+'][','] = 0x11;
   cobolPictureTable['+']['0'] = 0x11;
   cobolPictureTable['+']['/'] = 0x11;
   cobolPictureTable['+']['.'] = 0x11;
   cobolPictureTable['+']['C'] = 0x00;
   cobolPictureTable['+']['D'] = 0x00;
   cobolPictureTable['+']['E'] = 0x00;
   cobolPictureTable['+']['Z'] = 0x11;
   cobolPictureTable['+']['*'] = 0x11;
   cobolPictureTable['+']['+'] = 0x11;
   cobolPictureTable['+']['-'] = 0x00;
   cobolPictureTable['+']['$'] = 0x11;
   cobolPictureTable['+']['9'] = 0x11;
   cobolPictureTable['+']['A'] = 0x00;
   cobolPictureTable['+']['X'] = 0x00;
   cobolPictureTable['+']['S'] = 0x00;
   cobolPictureTable['+']['V'] = 0x11;
   cobolPictureTable['+']['P'] = 0x11;
   cobolPictureTable['+']['G'] = 0x00;
   cobolPictureTable['+']['N'] = 0x00;

   cobolPictureTable['-']['B'] = 0x11;
   cobolPictureTable['-'][','] = 0x11;
   cobolPictureTable['-']['0'] = 0x11;
   cobolPictureTable['-']['/'] = 0x11;
   cobolPictureTable['-']['.'] = 0x11;
   cobolPictureTable['-']['C'] = 0x00;
   cobolPictureTable['-']['D'] = 0x00;
   cobolPictureTable['-']['E'] = 0x00;
   cobolPictureTable['-']['Z'] = 0x11;
   cobolPictureTable['-']['*'] = 0x11;
   cobolPictureTable['-']['+'] = 0x00;
   cobolPictureTable['-']['-'] = 0x11;
   cobolPictureTable['-']['$'] = 0x11;
   cobolPictureTable['-']['9'] = 0x11;
   cobolPictureTable['-']['A'] = 0x00;
   cobolPictureTable['-']['X'] = 0x00;
   cobolPictureTable['-']['S'] = 0x00;
   cobolPictureTable['-']['V'] = 0x11;
   cobolPictureTable['-']['P'] = 0x11;
   cobolPictureTable['-']['G'] = 0x00;
   cobolPictureTable['-']['N'] = 0x00;

   cobolPictureTable['E']['B'] = 0x00;
   cobolPictureTable['E'][','] = 0x00;
   cobolPictureTable['E']['0'] = 0x00;
   cobolPictureTable['E']['/'] = 0x00;
   cobolPictureTable['E']['.'] = 0x00;
   cobolPictureTable['E']['C'] = 0x00;
   cobolPictureTable['E']['D'] = 0x00;
   cobolPictureTable['E']['E'] = 0x00;
   cobolPictureTable['E']['Z'] = 0x00;
   cobolPictureTable['E']['*'] = 0x00;
   cobolPictureTable['E']['+'] = 0x10;
   cobolPictureTable['E']['-'] = 0x10;
   cobolPictureTable['E']['$'] = 0x00;
   cobolPictureTable['E']['9'] = 0x00;
   cobolPictureTable['E']['A'] = 0x00;
   cobolPictureTable['E']['X'] = 0x00;
   cobolPictureTable['E']['S'] = 0x00;
   cobolPictureTable['E']['V'] = 0x00;
   cobolPictureTable['E']['P'] = 0x00;
   cobolPictureTable['E']['G'] = 0x00;
   cobolPictureTable['E']['N'] = 0x00;

   cobolPictureTable['Z']['B'] = 0x11;
   cobolPictureTable['Z'][','] = 0x11;
   cobolPictureTable['Z']['0'] = 0x11;
   cobolPictureTable['Z']['/'] = 0x11;
   cobolPictureTable['Z']['.'] = 0x11;
   cobolPictureTable['Z']['C'] = 0x11;
   cobolPictureTable['Z']['D'] = 0x11;
   cobolPictureTable['Z']['E'] = 0x00;
   cobolPictureTable['Z']['Z'] = 0x11;
   cobolPictureTable['Z']['*'] = 0x00;
   cobolPictureTable['Z']['+'] = 0x11;
   cobolPictureTable['Z']['-'] = 0x11;
   cobolPictureTable['Z']['$'] = 0x00;
   cobolPictureTable['Z']['9'] = 0x11;
   cobolPictureTable['Z']['A'] = 0x00;
   cobolPictureTable['Z']['X'] = 0x00;
   cobolPictureTable['Z']['S'] = 0x00;
   cobolPictureTable['Z']['V'] = 0x11;
   cobolPictureTable['Z']['P'] = 0x01;
   cobolPictureTable['Z']['G'] = 0x00;
   cobolPictureTable['Z']['N'] = 0x00;

   cobolPictureTable['*']['B'] = 0x11;
   cobolPictureTable['*'][','] = 0x11;
   cobolPictureTable['*']['0'] = 0x11;
   cobolPictureTable['*']['/'] = 0x11;
   cobolPictureTable['*']['.'] = 0x11;
   cobolPictureTable['*']['C'] = 0x11;
   cobolPictureTable['*']['D'] = 0x11;
   cobolPictureTable['*']['E'] = 0x00;
   cobolPictureTable['*']['Z'] = 0x00;
   cobolPictureTable['*']['*'] = 0x11;
   cobolPictureTable['*']['+'] = 0x11;
   cobolPictureTable['*']['-'] = 0x11;
   cobolPictureTable['*']['$'] = 0x00;
   cobolPictureTable['*']['9'] = 0x11;
   cobolPictureTable['*']['A'] = 0x00;
   cobolPictureTable['*']['X'] = 0x00;
   cobolPictureTable['*']['S'] = 0x00;
   cobolPictureTable['*']['V'] = 0x11;
   cobolPictureTable['*']['P'] = 0x01;
   cobolPictureTable['*']['G'] = 0x00;
   cobolPictureTable['*']['N'] = 0x00;

   cobolPictureTable['$']['B'] = 0x11;
   cobolPictureTable['$'][','] = 0x11;
   cobolPictureTable['$']['0'] = 0x11;
   cobolPictureTable['$']['/'] = 0x11;
   cobolPictureTable['$']['.'] = 0x11;
   cobolPictureTable['$']['C'] = 0x11;
   cobolPictureTable['$']['D'] = 0x11;
   cobolPictureTable['$']['E'] = 0x00;
   cobolPictureTable['$']['Z'] = 0x11;
   cobolPictureTable['$']['*'] = 0x11;
   cobolPictureTable['$']['+'] = 0x11;
   cobolPictureTable['$']['-'] = 0x11;
   cobolPictureTable['$']['$'] = 0x11;
   cobolPictureTable['$']['9'] = 0x11;
   cobolPictureTable['$']['A'] = 0x00;
   cobolPictureTable['$']['X'] = 0x00;
   cobolPictureTable['$']['S'] = 0x00;
   cobolPictureTable['$']['V'] = 0x11;
   cobolPictureTable['$']['P'] = 0x11;
   cobolPictureTable['$']['G'] = 0x00;
   cobolPictureTable['$']['N'] = 0x00;

   cobolPictureTable['9']['B'] = 0x11;
   cobolPictureTable['9'][','] = 0x11;
   cobolPictureTable['9']['0'] = 0x11;
   cobolPictureTable['9']['/'] = 0x11;
   cobolPictureTable['9']['.'] = 0x11;
   cobolPictureTable['9']['C'] = 0x11;
   cobolPictureTable['9']['D'] = 0x11;
   cobolPictureTable['9']['E'] = 0x11;
   cobolPictureTable['9']['Z'] = 0x00;
   cobolPictureTable['9']['*'] = 0x00;
   cobolPictureTable['9']['+'] = 0x11;
   cobolPictureTable['9']['-'] = 0x11;
   cobolPictureTable['9']['$'] = 0x00;
   cobolPictureTable['9']['9'] = 0x11;
   cobolPictureTable['9']['A'] = 0x11;
   cobolPictureTable['9']['X'] = 0x11;
   cobolPictureTable['9']['S'] = 0x00;
   cobolPictureTable['9']['V'] = 0x11;
   cobolPictureTable['9']['P'] = 0x01;
   cobolPictureTable['9']['G'] = 0x00;
   cobolPictureTable['9']['N'] = 0x00;

   cobolPictureTable['A']['B'] = 0x11;
   cobolPictureTable['A'][','] = 0x11;
   cobolPictureTable['A']['0'] = 0x11;
   cobolPictureTable['A']['/'] = 0x11;
   cobolPictureTable['A']['.'] = 0x00;
   cobolPictureTable['A']['C'] = 0x00;
   cobolPictureTable['A']['D'] = 0x00;
   cobolPictureTable['A']['E'] = 0x00;
   cobolPictureTable['A']['Z'] = 0x00;
   cobolPictureTable['A']['*'] = 0x00;
   cobolPictureTable['A']['+'] = 0x00;
   cobolPictureTable['A']['-'] = 0x00;
   cobolPictureTable['A']['$'] = 0x00;
   cobolPictureTable['A']['9'] = 0x11;
   cobolPictureTable['A']['A'] = 0x11;
   cobolPictureTable['A']['X'] = 0x11;
   cobolPictureTable['A']['S'] = 0x00;
   cobolPictureTable['A']['V'] = 0x00;
   cobolPictureTable['A']['P'] = 0x00;
   cobolPictureTable['A']['G'] = 0x00;
   cobolPictureTable['A']['N'] = 0x00;

   cobolPictureTable['X']['B'] = 0x11;
   cobolPictureTable['X'][','] = 0x11;
   cobolPictureTable['X']['0'] = 0x11;
   cobolPictureTable['X']['/'] = 0x11;
   cobolPictureTable['X']['.'] = 0x00;
   cobolPictureTable['X']['C'] = 0x00;
   cobolPictureTable['X']['D'] = 0x00;
   cobolPictureTable['X']['E'] = 0x00;
   cobolPictureTable['X']['Z'] = 0x00;
   cobolPictureTable['X']['*'] = 0x00;
   cobolPictureTable['X']['+'] = 0x00;
   cobolPictureTable['X']['-'] = 0x00;
   cobolPictureTable['X']['$'] = 0x00;
   cobolPictureTable['X']['9'] = 0x11;
   cobolPictureTable['X']['A'] = 0x11;
   cobolPictureTable['X']['X'] = 0x11;
   cobolPictureTable['X']['S'] = 0x00;
   cobolPictureTable['X']['V'] = 0x00;
   cobolPictureTable['X']['P'] = 0x00;
   cobolPictureTable['X']['G'] = 0x00;
   cobolPictureTable['X']['N'] = 0x00;

   cobolPictureTable['S']['B'] = 0x00;
   cobolPictureTable['S'][','] = 0x00;
   cobolPictureTable['S']['0'] = 0x00;
   cobolPictureTable['S']['/'] = 0x00;
   cobolPictureTable['S']['.'] = 0x00;
   cobolPictureTable['S']['C'] = 0x00;
   cobolPictureTable['S']['D'] = 0x00;
   cobolPictureTable['S']['E'] = 0x00;
   cobolPictureTable['S']['Z'] = 0x00;
   cobolPictureTable['S']['*'] = 0x00;
   cobolPictureTable['S']['+'] = 0x00;
   cobolPictureTable['S']['-'] = 0x00;
   cobolPictureTable['S']['$'] = 0x00;
   cobolPictureTable['S']['9'] = 0x11;
   cobolPictureTable['S']['A'] = 0x00;
   cobolPictureTable['S']['X'] = 0x00;
   cobolPictureTable['S']['S'] = 0x00;
   cobolPictureTable['S']['V'] = 0x11;
   cobolPictureTable['S']['P'] = 0x11;
   cobolPictureTable['S']['G'] = 0x00;
   cobolPictureTable['S']['N'] = 0x00;

   cobolPictureTable['V']['B'] = 0x11;
   cobolPictureTable['V'][','] = 0x11;
   cobolPictureTable['V']['0'] = 0x11;
   cobolPictureTable['V']['/'] = 0x11;
   cobolPictureTable['V']['.'] = 0x00;
   cobolPictureTable['V']['C'] = 0x11;
   cobolPictureTable['V']['D'] = 0x11;
   cobolPictureTable['V']['E'] = 0x11;
   cobolPictureTable['V']['Z'] = 0x10;
   cobolPictureTable['V']['*'] = 0x10;
   cobolPictureTable['V']['+'] = 0x10;
   cobolPictureTable['V']['-'] = 0x10;
   cobolPictureTable['V']['$'] = 0x10;
   cobolPictureTable['V']['9'] = 0x11;
   cobolPictureTable['V']['A'] = 0x00;
   cobolPictureTable['V']['X'] = 0x00;
   cobolPictureTable['V']['S'] = 0x00;
   cobolPictureTable['V']['V'] = 0x00;
   cobolPictureTable['V']['P'] = 0x10;
   cobolPictureTable['V']['G'] = 0x00;
   cobolPictureTable['V']['N'] = 0x00;

   cobolPictureTable['P']['B'] = 0x11;
   cobolPictureTable['P'][','] = 0x11;
   cobolPictureTable['P']['0'] = 0x11;
   cobolPictureTable['P']['/'] = 0x11;
   cobolPictureTable['P']['.'] = 0x00;
   cobolPictureTable['P']['C'] = 0x11;
   cobolPictureTable['P']['D'] = 0x11;
   cobolPictureTable['P']['E'] = 0x00;
   cobolPictureTable['P']['Z'] = 0x10;
   cobolPictureTable['P']['*'] = 0x10;
   cobolPictureTable['P']['+'] = 0x10;
   cobolPictureTable['P']['-'] = 0x10;
   cobolPictureTable['P']['$'] = 0x10;
   cobolPictureTable['P']['9'] = 0x10;
   cobolPictureTable['P']['A'] = 0x00;
   cobolPictureTable['P']['X'] = 0x00;
   cobolPictureTable['P']['S'] = 0x00;
   cobolPictureTable['P']['V'] = 0x11;
   cobolPictureTable['P']['P'] = 0x11;
   cobolPictureTable['P']['G'] = 0x00;
   cobolPictureTable['P']['N'] = 0x00;

   cobolPictureTable['G']['B'] = 0x11;
   cobolPictureTable['G'][','] = 0x00;
   cobolPictureTable['G']['0'] = 0x00;
   cobolPictureTable['G']['/'] = 0x00;
   cobolPictureTable['G']['.'] = 0x00;
   cobolPictureTable['G']['C'] = 0x00;
   cobolPictureTable['G']['D'] = 0x00;
   cobolPictureTable['G']['E'] = 0x00;
   cobolPictureTable['G']['Z'] = 0x00;
   cobolPictureTable['G']['*'] = 0x00;
   cobolPictureTable['G']['+'] = 0x00;
   cobolPictureTable['G']['-'] = 0x00;
   cobolPictureTable['G']['$'] = 0x00;
   cobolPictureTable['G']['9'] = 0x00;
   cobolPictureTable['G']['A'] = 0x00;
   cobolPictureTable['G']['X'] = 0x00;
   cobolPictureTable['G']['S'] = 0x00;
   cobolPictureTable['G']['V'] = 0x00;
   cobolPictureTable['G']['P'] = 0x00;
   cobolPictureTable['G']['G'] = 0x11;
   cobolPictureTable['G']['N'] = 0x00;

   cobolPictureTable['N']['B'] = 0x00;
   cobolPictureTable['N'][','] = 0x00;
   cobolPictureTable['N']['0'] = 0x00;
   cobolPictureTable['N']['/'] = 0x00;
   cobolPictureTable['N']['.'] = 0x00;
   cobolPictureTable['N']['C'] = 0x00;
   cobolPictureTable['N']['D'] = 0x00;
   cobolPictureTable['N']['E'] = 0x00;
   cobolPictureTable['N']['Z'] = 0x00;
   cobolPictureTable['N']['*'] = 0x00;
   cobolPictureTable['N']['+'] = 0x00;
   cobolPictureTable['N']['-'] = 0x00;
   cobolPictureTable['N']['$'] = 0x00;
   cobolPictureTable['N']['9'] = 0x00;
   cobolPictureTable['N']['A'] = 0x00;
   cobolPictureTable['N']['X'] = 0x00;
   cobolPictureTable['N']['S'] = 0x00;
   cobolPictureTable['N']['V'] = 0x00;
   cobolPictureTable['N']['P'] = 0x00;
   cobolPictureTable['N']['G'] = 0x00;
   cobolPictureTable['N']['N'] = 0x11;

  }

/**
 * Get the number of replications of a cobol type (eg. P(99))
 * @param picString String - a string containing a PIC field
 * @param index int - offset into the string
 * @return int - number of replications
 */

private static int getNumberOfReps (String picString, int index )
   {
   int i;

   for (i=index;
           i < picString.length() && Character.isDigit(picString.charAt(i));
           i++);

   i = i - index;

   if ( i == 0 )
   {
        // expected digits - non digits found
        // raise exception
		return -1;
   }

   StringBuffer sb = new StringBuffer(i);
   sb.append(picString.toCharArray(),index,i);
   return ( Integer.parseInt(sb.toString()) );
  }
/**
 * The method parses the pic string.
 * @param inpicString String - a PIC string
 * @exception RecordException
 * The inpicString is an invalid PIC representation
 */

   public void pic(String inpicString)
   {
         if ( inpicString == null )
           return;

         // Check that the picture string is not too long (> 50)
         if ( inpicString.length() > 50 )
         {
            Object[] obj = {inpicString.toUpperCase(java.util.Locale.US), cobolFileList.peek().toString(), Integer.toString(((StreamTokenizer)tokenizerList.peek()).lineno())};
            yyerror(CobolResource.getString("_EXC_Pic_string_length_exceeds_50", obj), true);
            return;
         }

         picString = inpicString.toUpperCase(java.util.Locale.US);

         StringBuffer expandedPicBuf = new StringBuffer(0);
         int[] occurrances = new int[256];
         int decimal_indicator = 0x01;
         int toIndex = 0;

         if (DEBUG)
         {
           System.out.println("picString.length() " + picString.length());
           System.out.println("picString:" + "|" + picString + "|");
         }

         for ( int fromIndex=0; fromIndex < picString.length(); fromIndex++)
         {

           int repetitions = 1;
           if (DEBUG)
                System.out.println("fromIndex " + fromIndex);

           // Increment the number of occurrances of character
           occurrances[ (int) picString.charAt(fromIndex) ]++;

           toIndex = expandedPicBuf.length();
           if (DEBUG)
                System.out.println("toIndex length : " + toIndex);

           // See if the transition to this character is valid
           if (toIndex > 1 )
           {
                if ( (expandedPicBuf.charAt(toIndex -2) == 'C' &&
                         expandedPicBuf.charAt(toIndex -1) == 'R' ) ||
                        (expandedPicBuf.charAt(toIndex -2) == 'D' &&
                         expandedPicBuf.charAt(toIndex -1) == 'B') )
                {
                   if ( (cobolPictureTable[expandedPicBuf.charAt(toIndex-2)][picString.charAt(fromIndex)]
                                        & decimal_indicator) == 0x00 )
// XXJS                    & decimal_indicator) != 0x00 )
                   {
                      Object[] obj = {cobolFileList.peek().toString(), Integer.toString(((StreamTokenizer)tokenizerList.peek()).lineno())};
                      yyerror(CobolResource.getString("_EXC_Pic_string_is_invalid", obj), true);
                      return;
                   }

                }
           }
           if ( toIndex > 0 )
           {
                if ( (cobolPictureTable[expandedPicBuf.charAt(toIndex-1)][picString.charAt(fromIndex)]
                                 & decimal_indicator) == 0x00 )
// XXJS                 & decimal_indicator) != 0x00 )
                   {
                      Object[] obj = {cobolFileList.peek().toString(), Integer.toString(((StreamTokenizer)tokenizerList.peek()).lineno())};
                      yyerror(CobolResource.getString("_EXC_Pic_string_is_invalid", obj), true);
                      return;
                   }

           }

           // Detect numeric string

           if (picString.charAt(fromIndex) != 'S' &&
                  picString.charAt(fromIndex) != 'V' &&
                  picString.charAt(fromIndex) != '9' &&
                  picString.charAt(fromIndex) != 'P' )
           {
                  numeric=false;
           }
           // Check for decimal positions - implied decimal dealt with later

           if ( picString.charAt(fromIndex) == '.' ||
                   picString.charAt(fromIndex) == 'V' )
           {
                decimal = true;
                decimalPosition = toIndex;
                decimal_indicator = 0x10;
           }


           switch ( picString.charAt(fromIndex) )
           {
   // 1.0.1 NL changes
           case 'N':
           case 'G':
                  inDBCS = true;
   // 1.0.1 NL end
           case 'A':
           case 'B':
           case 'P':
           case 'X':
           case 'Z':
           case '9':
           case '0':
           case '/':
           case ',':
           case '+':
           case '-':
           case '*':
           case '$':


                if ( (picString.length() > fromIndex +1) &&
                   (picString.charAt(fromIndex+1) == '('))
                  {
                   // Get the integer number - eg. X(300)
                   repetitions = getNumberOfReps(picString, (fromIndex+2) );
                   if(repetitions == -1) {
						Object[] obj = {picString, cobolFileList.peek().toString(), Integer.toString(((StreamTokenizer)tokenizerList.peek()).lineno())};
						yyerror(CobolResource.getString("_EXC_Pic_string_only_digits", obj), true);
                   		return;
                   }

                   // check for limit (MAX_STRING_LENGTH) - no limit on
                   // A or X

                   int totalLength = expandedPicBuf.length() + repetitions;
                   if ( (totalLength > MAX_STRING_LENGTH) &&
   // 1.0.1 NL changes
                           (picString.charAt(fromIndex) != 'G') &&
                           (picString.charAt(fromIndex) != 'N') &&
   // 1.0.1 NL end
                           (picString.charAt(fromIndex) != 'A') &&
                           (picString.charAt(fromIndex) != 'X') )
                   {
                      Object[] obj = {inpicString, cobolFileList.peek().toString(), Integer.toString(((StreamTokenizer)tokenizerList.peek()).lineno())};
                      yyerror(CobolResource.getString("_EXC_Pic_string_too_long", obj), true);
                      return;
                   }

                   // copy the repetitions to the expanded buffer
                   for (int r=0; r < repetitions; r++)
                   {
                        expandedPicBuf.append(picString.charAt(fromIndex));
                   }
                   toIndex = toIndex + repetitions;


                   // Increment the number of occurrances.  eg X(1), X(100)

                   occurrances[ (int) picString.charAt(fromIndex) ] =
                        occurrances[(int)picString.charAt(fromIndex)] + (repetitions -1);


                   if( picString.charAt(fromIndex) == 'P' )
                   {
                         decimal = true;
                         decimalPosition = expandedPicBuf.length() -1;
                         decimal_indicator = 0x10;
                         // Account for scale for implied decimal
                         scale = scale + repetitions;
                   }
                   else if ( picString.charAt(fromIndex) == '9' )
                   {
                         numberOfNines = numberOfNines + repetitions;
                   }

                  // Go to the bracketed item ")"
                  // fromIndex+1 == "("  fromIndex+2 == digit

                   fromIndex= fromIndex +2;
                   for (; picString.charAt(fromIndex) != ')'; fromIndex++)
                   {
                        if ( !Character.isDigit(picString.charAt(fromIndex)) )
                        {
                           Object[] obj = {inpicString, cobolFileList.peek().toString(), Integer.toString(((StreamTokenizer)tokenizerList.peek()).lineno())};
                           yyerror(CobolResource.getString("_EXC_Pic_string_only_digits", obj), true);
                           return;
                        }
                   }

                } // fromIndex+1 != "("
                else
                {
                   // fromIndex+2 != "(" so only one occurrance of character
                   expandedPicBuf.append(picString.charAt(fromIndex));
                   toIndex++;

                   if( picString.charAt(fromIndex) == 'P' )
                   {
                         decimal = true;
                         decimalPosition = expandedPicBuf.length() -1;
                         decimal_indicator = 0x10;
                         // Account for scale for implied decimal
                         scale++;
                   }
                   else if ( picString.charAt(fromIndex) == '9' )
                   {
                         numberOfNines++;
                   }
                }

                break;

           case '.':       // Characters not replicable
           case 'S':
           case 'V':
           case 'E':


                if ( occurrances[(int) picString.charAt(fromIndex)] > 1 )
                {
                   Object[] obj = {inpicString, cobolFileList.peek().toString(), Integer.toString(((StreamTokenizer)tokenizerList.peek()).lineno())};
                   yyerror(CobolResource.getString("_EXC_Pic_string_one_occurrence", obj), true);
                   return;
                }

                expandedPicBuf.append(picString.charAt(fromIndex));
                toIndex++;
                break;

           case 'C':  // Handle double characters   'CR'

                if ( occurrances[(int) picString.charAt(fromIndex)] > 1 )
                {
                   Object[] obj = {inpicString, cobolFileList.peek().toString(), Integer.toString(((StreamTokenizer)tokenizerList.peek()).lineno())};
                   yyerror(CobolResource.getString("_EXC_Pic_string_only_digits", obj), true);
                   return;
                }

                if ( picString.charAt(fromIndex+1) != 'R' )
                {
                   Object[] obj = {inpicString, cobolFileList.peek().toString(), Integer.toString(((StreamTokenizer)tokenizerList.peek()).lineno())};
                   yyerror(CobolResource.getString("_EXC_Pic_string_r_must_follow_c", obj), true);
                   return;
                }

                expandedPicBuf.append('C');
                expandedPicBuf.append('R');
                fromIndex++;  // handle two char
                toIndex = toIndex +2;
                break;

           case 'D':     //DB

                if ( occurrances[(int) picString.charAt(fromIndex)] > 1 )
                {
                   Object[] obj = {inpicString, cobolFileList.peek().toString(), Integer.toString(((StreamTokenizer)tokenizerList.peek()).lineno())};
                   yyerror(CobolResource.getString("_EXC_Pic_string_only_one_d_allowed", obj), true);
                   return;
                }

                if ( picString.charAt(fromIndex+1) != 'B' )
                {
                   Object[] obj = {inpicString, cobolFileList.peek().toString(), Integer.toString(((StreamTokenizer)tokenizerList.peek()).lineno())};
                   yyerror(CobolResource.getString("_EXC_Pic_string_expected_b_to_follow_d", obj), true);
                   return;
                }

                expandedPicBuf.append('D');
                expandedPicBuf.append('B');
                fromIndex++; // handle two char
                toIndex = toIndex +2;
                break;

           default:
              // not a valid character
              Object[] obj = {inpicString, cobolFileList.peek().toString(), Integer.toString(((StreamTokenizer)tokenizerList.peek()).lineno())};
              yyerror(CobolResource.getString("_EXC_Pic_string_contains_invalid_characters", obj), true);
              return;

           } // END CASE

           // Ensure that number is not exceeding 31 digits or pads

           if ( (scale + numberOfNines) > 31 )
           {
              Object[] obj = {inpicString, cobolFileList.peek().toString(), Integer.toString(((StreamTokenizer)tokenizerList.peek()).lineno())};
              yyerror(CobolResource.getString("_EXC_Pic_string_cannot_exceed_31_digits", obj), true);
              return;
           }

           if (DEBUG)
                System.out.println("expanded pic buf: " + expandedPicBuf);

           if ( (toIndex > MAX_STRING_LENGTH) &&
   // 1.0.1 NL changes
                   (expandedPicBuf.charAt(toIndex - 1) != 'G') &&
                   (expandedPicBuf.charAt(toIndex - 1) != 'N') &&
   // 1.0.1 NL end
                   (expandedPicBuf.charAt(toIndex - 1) != 'A') &&
                   (expandedPicBuf.charAt(toIndex - 1) != 'X') )
           {
              Object[] obj = {inpicString, Integer.toString(CobolParser.MAX_STRING_LENGTH), cobolFileList.peek().toString(), Integer.toString(((StreamTokenizer)tokenizerList.peek()).lineno())};
              yyerror(CobolResource.getString("_EXC_Pic_string_cannot_exceed_characters", obj), true);
              return;
           }

         } // END FOR LOOP

         // Check whether or not picture string is valid

         if ( !( occurrances[(int)'A'] > 0 ||
                   occurrances[(int)'X'] > 0 ||
   // 1.0.1 NL changes
                   occurrances[(int)'G'] > 0 ||
                   occurrances[(int)'N'] > 0 ||
   // 1.0.1 NL end
                   occurrances[(int)'Z'] > 0 ||
                   occurrances[(int)'9'] > 0 ||
                   occurrances[(int)'*'] > 0 ||
                   ( occurrances[(int)'-'] > 1 ||
                   occurrances[(int)'+'] > 1 ||
                   occurrances[(int)'$'] > 1  )) )
         {
              Object[] obj = {cobolFileList.peek().toString(), Integer.toString(((StreamTokenizer)tokenizerList.peek()).lineno())};
              yyerror(CobolResource.getString("_EXC_Pic_string_is_invalid", obj), true);
              return;
         }

         // set the sign field

         if ( expandedPicBuf.charAt(0) == 'S')
           isSign = true;

         if ( occurrances[(int)'V'] == 1)
         {
           // Don't count implied decimal position
           picFieldLength = expandedPicBuf.length() -1;
         }
         else
           picFieldLength = expandedPicBuf.length();

   // 1.0.1 NL changes
   if(inDBCS)
           picFieldLength *= 2;
   // 1.0.1 NL end

         decimalPosition = decimalPosition - expandedPicBuf.length() +1;
         if ( decimalPosition < 0 )
         {
           scale = scale * (-1);
         }

         // See if the field requires padding
         if ( occurrances[(int)'A'] > 0 ||
              occurrances[(int)'G'] > 0 ||
              occurrances[(int)'X'] > 0 ||
              occurrances[(int)'N'] > 0 )
         {
            paddingRequired = true;
         }

         if (DEBUG)
           System.out.println("Exiting updateCicsDataDescriptor");
   }

   private Vector symbols = new Vector();
   private Vector replaceList = new Vector();
   private Vector replaceByList = new Vector();
   private Vector operand1 = new Vector();
   private Vector operand2 = new Vector();
   private Stack cobolFileList = new Stack();
   private Stack tokenizerList = new Stack();
   private Stack groupStack = new Stack();
   private CircularBuffer buffer = new CircularBuffer();
   private CobolRecord pNewRecord = null;
   private boolean errorsOccurred = false;
   private short usage;
   private short sign;
   private int token = -1;
   private int replaceSize = 0;
   private int level;
   private int bound;
   private int lowBound; /*26260 GIM Save lower bound for ODO */
   private int isLowBound; /*26260 GIM Save lower bound for ODO */
   private int fillerGen;
   private int numberOfNines;
   private int decimalPosition;
   private int scale;
   private int picFieldLength;
   private boolean align;
   private boolean fill;
   private boolean paddingRequired;
   // 1.0.1 NL changes
   boolean inDBCS;
   // 1.0.1 NL end
   private boolean isSign;
   private boolean decimal;
   private boolean numeric;
   private String name = new String();
   private String value;
   private String figConst;
   private String lit;
   private String firstLit;
   private Vector possibleValues;
   private String redefinedItem;
   private String picString;
   private String javaType;
   private String previousType;
   private Vector idVector;
   private static final boolean DEBUG = false;
   private static final int MAX_STRING_LENGTH = 249;
   private static int countForIMS=0;
   private String IMSTranCode = new String();
   private static boolean bCopyContext = false;    /*16494 Flag to indicate old semantics for OF/IN in COPY statement*/
   /*-----------------------------------------------------------------*
   * Cobol picture table - describes valid PICTURES                  *
   *-----------------------------------------------------------------*/
   private static char[][] cobolPictureTable = new char[256][256];

   static {cobolPictureTableInit();}

   private static String copyright = "(c) Copyright IBM Corporation 1998, 1999.";

   List errorList = new ArrayList();
   
   /*GIM SVL CMVC: 36692 Handle unsupported types*/ 
   private Vector unsupportedTypes = new Vector();
   public Vector getUnsupportedTypes() {
   	return unsupportedTypes;
   }
   
   public List getErrorList() {
      return errorList;
   }