/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.c.spi.properties;

import com.ibm.adapter.c.spi.properties.CFolderMultiValuedProperty;
import com.ibm.propertygroup.PropertyChangeEvent;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import com.ibm.propertygroup.spi.IVetoableChangeListener;
import com.ibm.propertygroup.spi.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;

public class FolderMultiValuedProperty
extends CFolderMultiValuedProperty {
    public static final String copyright = "Licensed Material - Property of IBM\n com.ibm.adapter.c\n(C) Copyright IBM Corp. 2004 - All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public FolderMultiValuedProperty(String propertyName, String propertyDisplayName, String propertyDescription, BasePropertyGroup parentGroup) throws CoreException {
        super(propertyName, propertyDisplayName, propertyDescription, parentGroup);
    }

    public void addValue(Object value) throws CoreException {
        URI uri = this.convertToUri(value);
        if (uri != null) {
            super.addValue((Object)uri);
        }
    }

    public boolean removeValue(Object value) {
        Object[] objectArray;
        boolean valueRemoved = false;
        URI uri = this.convertToUri(value);
        if (uri != null && (objectArray = this.getValues()) != null) {
            int i = 0;
            while (i < objectArray.length) {
                Object object = objectArray[i];
                if (object instanceof URI && ((URI)object).toFileString().equals(uri.toFileString())) {
                    valueRemoved = super.removeValue(object);
                }
                ++i;
            }
        }
        return valueRemoved;
    }

    private URI convertToUri(Object value) {
        File file = null;
        URI uri = null;
        if (value instanceof URI) {
            uri = (URI)value;
        } else {
            if (value instanceof String) {
                file = new File((String)value);
            } else if (value instanceof File) {
                file = (File)value;
            }
            if (file != null) {
                try {
                    uri = URI.createFileURI((String)file.getCanonicalPath());
                }
                catch (IOException iOException) {}
            }
        }
        return uri;
    }

    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if (evt.getSource() == this) {
            this.validateValue(evt);
        }
    }

    private void validateValue(PropertyChangeEvent evt) throws PropertyVetoException {
        if (evt != null && evt.getNewValue() != null) {
            if (evt.getNewValue() instanceof String) {
                this.validateStringValue(evt);
            } else if (evt.getNewValue() instanceof File) {
                this.validateFileValue(evt);
            } else if (evt.getNewValue() instanceof URI) {
                this.validateFileValue(evt);
            } else {
                throw new PropertyVetoException("Value to be set is not a folder", (java.beans.PropertyChangeEvent)evt);
            }
        }
    }

    private void validateStringValue(PropertyChangeEvent evt) throws PropertyVetoException {
        File file = null;
        String uri = null;
        if (evt != null && evt.getNewValue() != null && evt.getNewValue() instanceof String) {
            uri = (String)evt.getNewValue();
            try {
                file = new File(uri);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new PropertyVetoException("Value to be set is not a folder", (java.beans.PropertyChangeEvent)evt);
            }
            this.validateFile(evt, file);
        }
    }

    private void validateFileValue(PropertyChangeEvent evt) throws PropertyVetoException {
        File file = null;
        if (evt != null && evt.getNewValue() != null) {
            if (evt.getNewValue() instanceof File) {
                file = (File)evt.getNewValue();
            } else if (evt.getNewValue() instanceof URI) {
                String fileName = ((URI)evt.getNewValue()).toFileString();
                file = new File(fileName);
            }
            this.validateFile(evt, file);
        }
    }

    private void validateFile(PropertyChangeEvent evt, File file) throws PropertyVetoException {
        if (file != null && !file.isDirectory()) {
            throw new PropertyVetoException("Value to be set is not a folder", (java.beans.PropertyChangeEvent)evt);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        FolderMultiValuedProperty property = (FolderMultiValuedProperty)((Object)super.clone());
        property.addVetoablePropertyChangeListener((IVetoableChangeListener)property);
        return property;
    }
}

