/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.c.spi.properties;

import com.ibm.adapter.c.messages.Messages;
import com.ibm.icu.util.StringTokenizer;
import com.ibm.propertygroup.PropertyChangeEvent;
import com.ibm.propertygroup.spi.BasePropertyGroup;
import com.ibm.propertygroup.spi.PropertyVetoException;
import com.ibm.propertygroup.spi.common.FileProperty;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jface.text.Document;

public class CFileProperty
extends FileProperty {
    public static final String copyright = "Licensed Material - Property of IBM\n com.ibm.adapter.c\n(C) Copyright IBM Corp. 2004 - All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    boolean languageFound = false;

    public CFileProperty(String propertyName, String displayName, String propertyDescription, BasePropertyGroup parentGroup, String[] validFileExtensions) throws CoreException {
        super(propertyName, displayName, propertyDescription, parentGroup, validFileExtensions);
    }

    public String getValueAsString() {
        String path = null;
        URI uri = (URI)this.value;
        File file = new File(uri.toFileString());
        if (file != null) {
            path = file.getAbsolutePath();
        }
        return path;
    }

    public void setValueAsString(String newValue) throws CoreException {
        super.setValue((Object)URI.createFileURI((String)newValue));
    }

    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        super.vetoableChange(evt);
        if (evt.getSource() == this) {
            if (evt.getNewValue() == null) {
                return;
            }
            URI uri = (URI)evt.getNewValue();
            File aFile = null;
            aFile = new File(uri.toFileString());
            if (aFile == null) {
                String basemsgfmt = Messages.getString("INVALID_JAVA_FILE");
                String fileName = uri.toFileString();
                String formattedString = basemsgfmt;
                try {
                    MessageFormat msgfmt = new MessageFormat(basemsgfmt);
                    formattedString = msgfmt.format(new Object[]{fileName});
                }
                catch (IllegalArgumentException illegalArgumentException) {}
                throw new PropertyVetoException(formattedString, (java.beans.PropertyChangeEvent)evt);
            }
            Path filePath = new Path(aFile.getAbsolutePath());
            if (filePath.getFileExtension().equalsIgnoreCase("java")) {
                Document doc;
                IFile javaFile = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)filePath);
                if (javaFile == null) {
                    String basemsgfmt = Messages.getString("INVALID_JAVA_FILE");
                    String fileName = uri.toFileString();
                    String formattedString = basemsgfmt;
                    try {
                        MessageFormat msgfmt = new MessageFormat(basemsgfmt);
                        formattedString = msgfmt.format(new Object[]{fileName});
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    throw new PropertyVetoException(formattedString, (java.beans.PropertyChangeEvent)evt);
                }
                ICompilationUnit cu = JavaCore.createCompilationUnitFrom((IFile)javaFile);
                try {
                    doc = new Document(cu.getSource());
                }
                catch (JavaModelException javaModelException) {
                    String basemsgfmt = Messages.getString("INVALID_JAVA_FILE");
                    String fileName = javaFile.getName();
                    String formattedString = basemsgfmt;
                    try {
                        MessageFormat msgfmt = new MessageFormat(basemsgfmt);
                        formattedString = msgfmt.format(new Object[]{fileName});
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    throw new PropertyVetoException(formattedString, (java.beans.PropertyChangeEvent)evt);
                }
                ASTParser parser = ASTParser.newParser((int)3);
                parser.setSource(doc.get().toCharArray());
                CompilationUnit astCU = (CompilationUnit)parser.createAST(null);
                this.languageFound = false;
                astCU.accept(new ASTVisitor(true){

                    public boolean visit(TypeDeclaration typeDecl) {
                        String javadocTagName = "@type-descriptor.platform-compiler-info";
                        Javadoc jd = typeDecl.getJavadoc();
                        if (jd == null) {
                            return false;
                        }
                        List tags = jd.tags();
                        Iterator iter = tags.iterator();
                        block0: while (iter.hasNext() && !CFileProperty.this.languageFound) {
                            TagElement te = (TagElement)iter.next();
                            String tagName = te.getTagName();
                            if (!tagName.equals(javadocTagName)) continue;
                            StringBuffer jdBuf = new StringBuffer();
                            for (TextElement element : te.fragments()) {
                                String text = element.getText();
                                text = text.trim();
                                jdBuf.append(" ");
                                jdBuf.append(text);
                            }
                            String jdString = jdBuf.toString().trim();
                            StringTokenizer st = new StringTokenizer(jdString);
                            ArrayList<String> tokenList = new ArrayList<String>();
                            while (st.hasMoreTokens()) {
                                tokenList.add(st.nextToken());
                            }
                            int i = 0;
                            while (i < tokenList.size()) {
                                String token = (String)tokenList.get(i);
                                if ("language=\"C\"".equals(token)) {
                                    CFileProperty.this.languageFound = true;
                                    continue block0;
                                }
                                ++i;
                            }
                        }
                        return false;
                    }
                });
                if (!this.languageFound) {
                    String basemsgfmt = Messages.getString("INVALID_JAVA_FILE");
                    String fileName = javaFile.getName();
                    String formattedString = basemsgfmt;
                    try {
                        MessageFormat msgfmt = new MessageFormat(basemsgfmt);
                        formattedString = msgfmt.format(new Object[]{fileName});
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    throw new PropertyVetoException(formattedString, (java.beans.PropertyChangeEvent)evt);
                }
            }
        }
    }
}

