/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.adapter.c.spi.properties;

import com.ibm.adapter.c.common.CCodepageHelper;
import com.ibm.adapter.c.messages.Messages;
import com.ibm.adapter.c.plugin.CDiscoveryAgentPlugin;
import com.ibm.adapter.c.spi.properties.CBaseSingleValuedProperty;
import com.ibm.adapter.c.spi.properties.CPlatformProperty;
import com.ibm.propertygroup.PropertyChangeEvent;
import com.ibm.propertygroup.spi.IVetoableChangeListener;
import com.ibm.propertygroup.spi.PropertyVetoException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CCodepageProperty
extends CBaseSingleValuedProperty {
    public static final String copyright = "Licensed Material - Property of IBM\n com.ibm.adapter.c\n(C) Copyright IBM Corp. 2004 - All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static String[] validValuesArray = null;

    public CCodepageProperty() throws CoreException {
        super("Codepage", Messages.getString("CODEPAGE_DISPLAY_NAME"), Messages.getString("CODEPAGE_DESCRIPTION"));
        this.initializeProperty();
    }

    private void initializeProperty() {
        try {
            validValuesArray = CCodepageHelper.getInstance().findCCodePages();
            this.cKey = "com.ibm.etools.c.C_CODEPAGE";
            this.setExpert(true);
            if (validValuesArray != null) {
                super.setValidValues((Object[])validValuesArray);
            }
            this.setDefaultValue("8859-1");
            this.setValue();
            this.addVetoablePropertyChangeListener((IVetoableChangeListener)this);
        }
        catch (CoreException ex) {
            this.envStatus = new Status(4, ((Object)((Object)this)).getClass().getName(), 4, ex.getMessage(), (Throwable)new Exception(ex.getMessage()));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ((this.isInitialPropertyChangeEvent() && !this.isPrefStoreValue() || !this.isInitialPropertyChangeEvent()) && evt.getSource() instanceof CPlatformProperty) {
            if (((String)evt.getNewValue()).equalsIgnoreCase(Messages.getString("PLATFORM_OS390_VALUE"))) {
                this.setDefaultValue("ibm-1047");
            } else if (((String)evt.getNewValue()).equalsIgnoreCase(Messages.getString("PLATFORM_WIN_ICC_VALUE")) || ((String)evt.getNewValue()).equalsIgnoreCase(Messages.getString("PLATFORM_WIN_MSVC_VALUE"))) {
                this.setDefaultValue("cp1252");
            } else if (((String)evt.getNewValue()).equalsIgnoreCase(Messages.getString("PLATFORM_AIX_GCC_VALUE")) || ((String)evt.getNewValue()).equalsIgnoreCase(Messages.getString("PLATFORM_AIX_XLC_VALUE"))) {
                this.setDefaultValue("ISO-8859-1");
            } else {
                this.setDefaultValue("8859-1");
            }
            this.unSet();
        }
        this.setInitialPropertyChangeEvent(false);
    }

    @Override
    public void doVetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
    }

    public void setValidValues(Object[] values) throws CoreException {
        Status status = new Status(4, ((Object)((Object)this)).getClass().getName(), 4, Messages.getString("ERROR_METHOD_NOT_IMPLEMENTED"), (Throwable)new Exception(CDiscoveryAgentPlugin.getResourceString("ERROR_METHOD_NOT_IMPLEMENTED")));
        throw new CoreException((IStatus)status);
    }
}

