/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.transaction.wizard.runtimeconsole;

import com.ibm.cics.core.comm.ConnectionConfiguration;
import com.ibm.im.ims.metadata.testcase.InteractionType;
import com.ibm.im.ims.metadata.testcase.Testcase;
import com.ibm.im.ims.metadata.transaction.DatatypeType;
import com.ibm.im.ims.transaction.controller.editor.FieldValueEditorController;
import com.ibm.im.ims.transaction.controller.editor.TestcaseEditorController;
import com.ibm.im.ims.transaction.model.utilities.PasswordMap;
import com.ibm.im.ims.transaction.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.workbench.transaction.Activator;
import com.ibm.im.ims.workbench.transaction.dialog.editfield.EditFieldDialog;
import com.ibm.im.ims.workbench.transaction.editors.MultiPageEditor;
import com.ibm.im.ims.workbench.transaction.editors.TestcaseEditorPage;
import com.ibm.im.ims.workbench.transaction.editors.TestcaseFieldLayoutContentProvider;
import com.ibm.im.ims.workbench.transaction.editors.TestcaseFieldLayoutLabelProvider;
import com.ibm.im.ims.workbench.transaction.preferences.EnWPreferencesPage;
import com.ibm.im.ims.workbench.transaction.resources.utilities.TranMessages;
import com.ibm.im.ims.workbench.transaction.testcase.model.DataStructureNode;
import com.ibm.im.ims.workbench.transaction.testcase.model.FieldNode;
import com.ibm.im.ims.workbench.transaction.testcase.model.IOMessageNode;
import com.ibm.im.ims.workbench.transaction.testcase.model.IOMessagePairNode;
import com.ibm.im.ims.workbench.transaction.testcase.model.SegmentNode;
import com.ibm.im.ims.workbench.transaction.testcase.model.TestCaseNode;
import com.ibm.im.ims.workbench.transaction.utilities.InfoDialog;
import com.ibm.im.ims.workbench.transaction.utilities.RacfInfoDialog;
import com.ibm.im.ims.workbench.transaction.utilities.UIHelper;
import com.ibm.im.ims.workbench.transaction.utilities.Utility;
import com.ibm.im.ims.workbench.transaction.wizard.editmessagepair.EditMessagePairWizard;
import com.ibm.im.ims.workbench.transaction.wizard.newtestcase.NewTestCaseWizard;
import com.ibm.im.ims.workbench.transaction.wizard.runtimeconsole.RuntimeConsoleWizard;
import com.ibm.im.ims.workbench.transaction.wizard.runtimeconsole.SubmitInvocationUnitJob;
import com.ibm.ims.connect.ImsConnectApiException;
import com.ibm.ims.connect.ImsConnectExecutionException;
import com.ibm.ims.dli.types.ConversionException;
import com.ibm.ims.dli.types.UnsupportedTypeConversion;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import com.ibm.ims.transaction.messages.MessagePayloadManager;
import com.ibm.ims.transaction.messages.walkers.MessageWalkerException;
import com.ibm.ims.transaction.util.TraceWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class RuntimeConsoleWizardPage
extends WizardPage
implements ISelectionChangedListener,
SelectionListener,
KeyListener,
MouseListener,
FocusListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private ScrolledForm form;
    private Combo comboTestcaseName;
    private Combo comboOutputViewer;
    private Combo comboRuntimeConfig;
    private Group outputGroup;
    private Group inputGroup;
    private Text textArea;
    private IOMessagePairNode currIomp;
    private Tree inputMsgTree;
    private TreeViewer inputMsgViewer;
    private Button submitButton;
    private Tree outputMsgTree;
    private TreeViewer outputMsgViewer;
    private static Font courierNewFont = null;
    private boolean testcaseEdited = false;
    private int currState = 0;
    public static final int TREE_VIEWER = 0;
    public static final int TEXT_VIEWER = 1;
    private static final String LAST_TEST_CASE = "com.ibm.im.ims.workbench.transaction.wizard.runtimeconsole.LAST_TEST_CASE";
    private static final String STORE_LAST_TESTCASE_ID = "com.ibm.im.ims.workbench.transaction.wizard.runtimeconsole.LAST_TEST_CASE.SECTION_ID";
    private static final int UI_COLUMNS = 4;
    private boolean isPageComplete = false;
    private boolean isTranRunning = false;
    private boolean racfDialogHasBeenDisplayed = false;
    private TestcaseEditorController controller;

    public RuntimeConsoleWizardPage(String pageName, TestcaseEditorController controller) {
        super(pageName);
        this.setTitle(TranMessages.getLabel().getString("RCW_TITLE"));
        this.setImageDescriptor(Utility.getImageDescriptor("testCase_run_40.gif"));
        this.setDescription(TranMessages.getDescription().getString("RCW_DESC"));
        this.controller = controller;
    }

    public void createControl(Composite parent) {
        try {
            if (this.controller.isUnitTest()) {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.im.ims.workbench.transaction.runtime_console");
            } else {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.ims.gw.ui.edit_service_test");
            }
            FormColors formColors = new FormColors(parent.getDisplay());
            formColors.markShared();
            Color bgColor = parent.getBackground();
            FormToolkit toolkit = new FormToolkit(formColors);
            this.form = toolkit.createScrolledForm(parent);
            this.form.setBackground(bgColor);
            this.form.setExpandHorizontal(true);
            this.form.setExpandVertical(true);
            this.form.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    RuntimeConsoleWizardPage.this.resizeColumns();
                }
            });
            GridData gd = new GridData(4, 4, true, true);
            gd.horizontalIndent = 5;
            Composite client = this.form.getBody();
            client.setBackground(bgColor);
            client.setLayout((Layout)new GridLayout(4, false));
            client.setLayoutData((Object)gd);
            gd = new GridData(131072, 128, false, false, 1, 1);
            gd.horizontalIndent = 10;
            Label runtimeLabel = new Label(client, 0);
            runtimeLabel.setBackground(this.form.getBackground());
            runtimeLabel.setText(TranMessages.getLabel().getString("RCW_RUNTIME_CONFIG") + TranMessages.getColon().getString("COLON"));
            runtimeLabel.setLayoutData((Object)gd);
            gd = new GridData(16384, 128, false, false, 1, 1);
            this.comboRuntimeConfig = new Combo(client, 2056);
            this.comboRuntimeConfig.setLayoutData((Object)gd);
            this.comboRuntimeConfig.setBackground(bgColor);
            gd = new GridData(131072, 128, false, false, 1, 1);
            gd.horizontalIndent = 10;
            Label testcaseLabel = new Label(client, 0);
            testcaseLabel.setBackground(this.form.getBackground());
            testcaseLabel.setText(TranMessages.getLabel().getString("RCW_TEST_CASE_NAME") + TranMessages.getColon().getString("COLON"));
            testcaseLabel.setLayoutData((Object)gd);
            gd = new GridData(16384, 128, false, false, 1, 1);
            this.comboTestcaseName = new Combo(client, 2056);
            this.comboTestcaseName.setLayoutData((Object)gd);
            this.comboTestcaseName.setBackground(bgColor);
            gd = new GridData(4, 4, true, true);
            gd.horizontalSpan = 4;
            this.inputGroup = new Group(client, 0);
            this.inputGroup.setText(TranMessages.getLabel().getString("RCW_INPUT_MSG_GROUP"));
            this.inputGroup.setLayout((Layout)new GridLayout());
            this.inputGroup.setLayoutData((Object)gd);
            this.inputGroup.setBackground(bgColor);
            gd = new GridData(4, 4, true, true);
            gd.horizontalSpan = 4;
            this.inputMsgTree = new Tree((Composite)this.inputGroup, 68352);
            this.inputMsgTree.setHeaderVisible(true);
            this.inputMsgTree.setLinesVisible(true);
            this.inputMsgTree.setLayoutData((Object)gd);
            int i = 0;
            while (i < TestcaseEditorPage.COLUMN_NAMES.length) {
                TreeColumn column = new TreeColumn(this.inputMsgTree, 16384);
                column.setResizable(true);
                column.setAlignment(16384);
                column.setText(TestcaseEditorPage.COLUMN_NAMES[i]);
                ++i;
            }
            this.inputMsgTree.addFocusListener((FocusListener)this);
            this.inputMsgViewer = new TreeViewer(this.inputMsgTree);
            this.inputMsgViewer.setColumnProperties(TestcaseEditorPage.COLUMN_NAMES);
            this.inputMsgViewer.setContentProvider((IContentProvider)new TestcaseFieldLayoutContentProvider(true, true));
            this.inputMsgViewer.setLabelProvider((IBaseLabelProvider)new TestcaseFieldLayoutLabelProvider());
            gd = new GridData(68);
            gd.widthHint = 30;
            gd.horizontalSpan = 4;
            this.submitButton = new Button(client, 8);
            this.submitButton.setImage(Utility.getImage("run.gif"));
            this.submitButton.setToolTipText(TranMessages.getDescription().getString("RCW_RUN_BUTTON_TOOLTIP"));
            this.submitButton.setLayoutData((Object)gd);
            this.submitButton.setEnabled(false);
            this.submitButton.setToolTipText(TranMessages.getLabel().getString("RCW_RUN_HOVER"));
            this.submitButton.addFocusListener((FocusListener)this);
            gd = new GridData(4, 4, true, true);
            gd.horizontalSpan = 4;
            this.outputGroup = new Group(client, 0);
            this.outputGroup.setText(TranMessages.getLabel().getString("RCW_OUTPUT_MSG_GROUP"));
            this.outputGroup.setLayout((Layout)new GridLayout(4, false));
            this.outputGroup.setLayoutData((Object)gd);
            this.outputGroup.setBackground(bgColor);
            Label viewerLabel = new Label((Composite)this.outputGroup, 0);
            viewerLabel.setBackground(this.form.getBackground());
            viewerLabel.setText(TranMessages.getLabel().getString("RTC_VIEWER_COMBO_LABEL") + TranMessages.getColon().getString("COLON"));
            gd = new GridData(16384, 128, false, false, 1, 1);
            this.comboOutputViewer = new Combo((Composite)this.outputGroup, 2056);
            this.comboOutputViewer.setLayoutData((Object)gd);
            this.comboOutputViewer.setBackground(bgColor);
            gd = new GridData(4, 4, true, true);
            gd.horizontalSpan = 4;
            this.outputMsgTree = new Tree((Composite)this.outputGroup, 68352);
            this.outputMsgTree.setHeaderVisible(true);
            this.outputMsgTree.setLinesVisible(true);
            this.outputMsgTree.setLayoutData((Object)gd);
            int i2 = 0;
            while (i2 < TestcaseEditorPage.COLUMN_NAMES.length) {
                TreeColumn column = new TreeColumn(this.outputMsgTree, 16384);
                column.setResizable(true);
                column.setAlignment(16384);
                column.setText(TestcaseEditorPage.COLUMN_NAMES[i2]);
                ++i2;
            }
            this.outputMsgTree.addFocusListener((FocusListener)this);
            this.outputMsgViewer = new TreeViewer(this.outputMsgTree);
            this.outputMsgViewer.setColumnProperties(TestcaseEditorPage.COLUMN_NAMES);
            this.outputMsgViewer.setContentProvider((IContentProvider)new TestcaseFieldLayoutContentProvider(true, false));
            this.outputMsgViewer.setLabelProvider((IBaseLabelProvider)new TestcaseFieldLayoutLabelProvider());
            String projectName = ((RuntimeConsoleWizard)this.getWizard()).getProjectName();
            this.populateRuntimeCombo();
            this.populateTestcaseCombo(projectName);
            Rectangle screenSize = PlatformUI.getWorkbench().getDisplay().getBounds();
            this.getShell().setSize(screenSize.width, screenSize.height);
            this.addListeners();
            this.restoreWidgetValues();
            try {
                this.doNewTestCaseSelected();
            }
            catch (Exception e) {
                UIHelper.displayErrorDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), TranMessages.getLabel().getString("PPW_EDIT_ERROR"), e);
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "", e);
            logger.error(e);
        }
    }

    private synchronized boolean testAndSetIsTranRunning(boolean isTranRunning) {
        boolean retVal = this.isTranRunning;
        this.isTranRunning = isTranRunning;
        return retVal;
    }

    public void saveWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put(LAST_TEST_CASE, this.comboTestcaseName.getText());
        }
    }

    private void restoreWidgetValues() {
        String testcaseName;
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null && (testcaseName = settings.get(LAST_TEST_CASE)) != null) {
            this.comboTestcaseName.setText(testcaseName);
        }
    }

    public IDialogSettings getDialogSettings() {
        return Utility.getDialogSettings(STORE_LAST_TESTCASE_ID);
    }

    private void addListeners() {
        this.comboRuntimeConfig.addSelectionListener((SelectionListener)this);
        this.comboTestcaseName.addSelectionListener((SelectionListener)this);
        this.inputMsgTree.addKeyListener((KeyListener)this);
        this.outputMsgViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.comboOutputViewer.addSelectionListener((SelectionListener)this);
        this.submitButton.addSelectionListener((SelectionListener)this);
        this.inputMsgViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.inputMsgTree.addMouseListener((MouseListener)this);
    }

    public Control getControl() {
        return this.form;
    }

    public void setVisible(boolean isVisible) {
        this.form.setVisible(isVisible);
    }

    public boolean isPageComplete() {
        return this.isPageComplete;
    }

    private void editFieldValue(FieldNode fieldNode) throws NumberFormatException, JAXBException, CoreException, UnsupportedTypeConversion, IOException, ConversionException {
        DatatypeType adt = fieldNode.getFieldType().getApplicationDatatype().getDatatype();
        if (adt == DatatypeType.ARRAY || adt == DatatypeType.STRUCT) {
            return;
        }
        IOMessagePairNode ioMessagePairNode = (IOMessagePairNode)fieldNode.getParentNode().getParentNode().getParentNode().getParentNode();
        String encoding = ioMessagePairNode.getMessagePair().getInteraction().getImsConnectCodepage();
        FieldValueEditorController fveController = new FieldValueEditorController(fieldNode.getFieldType(), fieldNode.getFieldValue().getFieldValue(), encoding);
        EditFieldDialog dialog = new EditFieldDialog(this.getPage().getShell(), TranMessages.getLabel().getString("EFVD_DIALOG_TITLE", (Object[])new String[]{fieldNode.getName()}), fveController);
        dialog.open();
        int rc = dialog.getReturnCode();
        if (rc == 0) {
            this.testcaseEdited = true;
            Object[] expandedElements = this.inputMsgViewer.getExpandedElements();
            this.controller.editFieldValue(fieldNode, fveController.getNewFieldValue());
            this.inputMsgViewer.refresh();
            this.expandTree(expandedElements);
            TestCaseNode tcNode = fieldNode.getParentNode();
            List peerNodes = tcNode.getChildren();
            int i = 0;
            while (i < peerNodes.size()) {
                TestCaseNode currNode = (TestCaseNode)peerNodes.get(i);
                if (currNode == fieldNode && i < peerNodes.size() - 1) {
                    this.inputMsgViewer.setSelection((ISelection)new StructuredSelection(peerNodes.get(i + 1)), true);
                    break;
                }
                ++i;
            }
        }
    }

    private void resizeColumns() {
        String colLabel;
        Rectangle area = this.form.getClientArea();
        this.form.setMinSize(area.width, area.height);
        int width = area.width - this.inputMsgViewer.getTree().getBorderWidth() - this.inputMsgViewer.getTree().getHeaderHeight();
        TreeColumn[] tableColumns = this.inputMsgViewer.getTree().getColumns();
        int i = 0;
        while (i < tableColumns.length) {
            colLabel = TestcaseEditorPage.COLUMN_NAMES[i];
            if (colLabel == TestcaseEditorPage.IOMP_NODES) {
                tableColumns[i].setWidth(width / 5 * 2);
            } else if (colLabel == TestcaseEditorPage.DATA_TYPE) {
                tableColumns[i].setWidth(width / 5);
            } else if (colLabel == TestcaseEditorPage.FIELD_VALUE) {
                tableColumns[i].setWidth(width / 5 * 2);
            } else if (colLabel == TestcaseEditorPage.START_BYTE) {
                tableColumns[i].setWidth(width / 5);
            } else if (colLabel == TestcaseEditorPage.FIELD_LENGTH) {
                tableColumns[i].setWidth(width / 5);
            }
            ++i;
        }
        if (!this.outputMsgTree.isDisposed()) {
            tableColumns = this.outputMsgViewer.getTree().getColumns();
            i = 0;
            while (i < tableColumns.length) {
                colLabel = TestcaseEditorPage.COLUMN_NAMES[i];
                if (colLabel == TestcaseEditorPage.IOMP_NODES) {
                    tableColumns[i].setWidth(width / 5 * 2);
                } else if (colLabel == TestcaseEditorPage.DATA_TYPE) {
                    tableColumns[i].setWidth(width / 5);
                } else if (colLabel == TestcaseEditorPage.FIELD_VALUE) {
                    tableColumns[i].setWidth(width / 5 * 2);
                } else if (colLabel == TestcaseEditorPage.START_BYTE) {
                    tableColumns[i].setWidth(width / 5);
                } else if (colLabel == TestcaseEditorPage.FIELD_LENGTH) {
                    tableColumns[i].setWidth(width / 5);
                }
                ++i;
            }
        }
        int height = area.height / 2;
        GridData gd = (GridData)this.inputGroup.getLayoutData();
        gd.heightHint = height;
        GridData outputgd = (GridData)this.outputGroup.getLayoutData();
        outputgd.heightHint = height;
    }

    private void populateTestcaseCombo(String projectName) throws UnsupportedTypeConversion, IOException, CoreException, JAXBException {
        this.comboTestcaseName.removeAll();
        String[] items = this.controller.isUnitTest() ? ProjectTreeFileHelper.getTestCaseFileNames((String)projectName, (boolean)false) : ProjectTreeFileHelper.getServiceTestCaseFileNames((String)projectName, (boolean)false);
        this.comboTestcaseName.setItems(items);
        this.comboTestcaseName.setSize(this.comboTestcaseName.computeSize(-1, -1));
    }

    private void populateRuntimeCombo() throws UnsupportedTypeConversion, IOException, CoreException, JAXBException {
        String selectedRunConfigName = this.controller.getRunConfigName();
        ILaunchConfiguration[] configurations = this.getConfigurations();
        String[] members = new String[configurations.length];
        if (configurations.length > 0) {
            int i = 0;
            while (i < configurations.length) {
                String currentRunConfigName;
                members[i] = currentRunConfigName = configurations[i].getName();
                ++i;
            }
        } else {
            this.comboRuntimeConfig.removeAll();
            return;
        }
        this.comboRuntimeConfig.setItems(members);
        this.comboRuntimeConfig.setText(selectedRunConfigName);
        this.comboRuntimeConfig.setSize(this.comboRuntimeConfig.computeSize(-1, -1));
    }

    private ILaunchConfiguration[] getConfigurations() throws CoreException {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfigurationType type = launchManager.getLaunchConfigurationType("com.ibm.im.ims.workbench.debug.launchConfigType");
        ILaunchConfiguration[] configurations = launchManager.getLaunchConfigurations(type);
        return configurations;
    }

    private void populateOutputViewerCombo(List<String> outMsgNames, String currentActiveOutMsg) {
        String[] members = new String[2 + outMsgNames.size()];
        int selectionIx = -1;
        members[0] = TranMessages.getLabel().getString("RTC_TEXT_VIEW");
        members[1] = TranMessages.getLabel().getString("RTC_TRACE_VIEW");
        if (currentActiveOutMsg.equals(members[0])) {
            selectionIx = 0;
        }
        if (currentActiveOutMsg.equals(members[1])) {
            selectionIx = 1;
        }
        int i = 2;
        while (i < members.length) {
            members[i] = outMsgNames.get(i - 2);
            if (currentActiveOutMsg.equals(members[i])) {
                selectionIx = i;
            }
            ++i;
        }
        this.comboOutputViewer.setItems(members);
        this.comboOutputViewer.select(selectionIx);
        this.comboOutputViewer.setSize(this.comboOutputViewer.computeSize(-1, -1));
    }

    private void doNewTestCaseSelected() throws JAXBException, CoreException, UnsupportedTypeConversion, IOException, ConversionException, MessageWalkerException {
        this.testcaseEdited = false;
        String tcName = this.comboTestcaseName.getText().trim();
        if (tcName != null && tcName.length() > 0) {
            this.controller.setTestcase(tcName);
            this.inputMsgViewer.setInput((Object)this.controller.getInvisibleRoot());
            this.outputMsgViewer.setInput((Object)this.controller.getInvisibleRoot());
            this.updateTableViewers();
            this.inputMsgViewer.refresh();
            IOMessagePairNode firstIomp = (IOMessagePairNode)((TestCaseNode)this.controller.getInvisibleRoot().getChildren().get(0)).getChildren().get(0);
            Object[] selectedNode = new Object[]{firstIomp};
            this.inputMsgViewer.setSelection((ISelection)new StructuredSelection(selectedNode), true);
        }
        this.handleButtonEnablement();
    }

    private void doNewRuntimeSelected() throws CoreException, UnsupportedTypeConversion, IOException, JAXBException {
        ILaunchConfiguration configuration = this.getConfiguration();
        if (configuration != null) {
            String serverName = configuration.getAttribute("server", "");
            this.controller.setServerName(serverName);
            String projectName = configuration.getAttribute("TestProjectName", "");
            this.controller.setProjectName(projectName);
            this.populateTestcaseCombo(projectName);
            this.inputMsgViewer.setInput((Object)new TestCaseNode("", null));
            this.outputMsgViewer.setInput((Object)new TestCaseNode("", null));
            this.inputMsgViewer.refresh();
            this.outputMsgViewer.refresh();
        }
    }

    private ILaunchConfiguration getConfiguration() throws CoreException {
        ILaunchConfiguration retVal = null;
        String runtimeName = this.comboRuntimeConfig.getText().trim();
        if (runtimeName != null && runtimeName.length() > 0) {
            ILaunchConfiguration[] configurations = this.getConfigurations();
            int i = 0;
            while (i < configurations.length) {
                ILaunchConfiguration configuration = configurations[i];
                if (configuration.getName().equals(runtimeName)) {
                    retVal = configuration;
                    break;
                }
                ++i;
            }
        }
        return retVal;
    }

    public void handleSaveOrSaveAs() throws JAXBException, CoreException, UnsupportedTypeConversion, IOException, ConversionException {
        if (this.testcaseEdited) {
            Object[] inserts = new Object[]{this.controller.getTestcaseFilename()};
            String message = TranMessages.getLabel().getString("RTC_SAVE_DIALOG_MSG", inserts);
            MessageDialog dialog = new MessageDialog(this.getShell(), TranMessages.getLabel().getString("RTC_SAVE_DIALOG_TITLE"), null, message, 3, new String[]{TranMessages.getLabel().getString("RTC_SAVE"), TranMessages.getLabel().getString("RTC_SAVEAS"), TranMessages.getLabel().getString("RTC_DONT_SAVE")}, 0);
            int result = dialog.open();
            if (result == 0) {
                this.controller.doSave(((RuntimeConsoleWizard)this.getWizard()).getProjectName());
                IEditorReference[] openEditorRefs = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
                int j = 0;
                while (j < openEditorRefs.length) {
                    String tcFileName;
                    IEditorPart currEditor = openEditorRefs[j].getEditor(false);
                    if (currEditor instanceof MultiPageEditor && (tcFileName = ((MultiPageEditor)currEditor).getTestCaseFileName()) != null && !tcFileName.isEmpty() && tcFileName.equals(this.controller.getTestcaseFilename())) {
                        ((MultiPageEditor)currEditor).refreshTestcaseEditor();
                    }
                    ++j;
                }
            } else if (result == 1) {
                this.controller.updateJaxbFromMessagePayloadManager();
                Testcase existingTcForDup = this.controller.getTestCase();
                NewTestCaseWizard newTcWiz = new NewTestCaseWizard();
                newTcWiz.setProjectName(((RuntimeConsoleWizard)this.getWizard()).getProjectName());
                newTcWiz.setExistingTCForDup(existingTcForDup);
                newTcWiz.setExistingTCForDupName(this.controller.getTestcaseFilename());
                WizardDialog newTcDialog = new WizardDialog(this.getShell(), (IWizard)newTcWiz);
                int retCode = newTcDialog.open();
                if (retCode == 0) {
                    this.comboTestcaseName.removeSelectionListener((SelectionListener)this);
                    String currTcName = this.comboTestcaseName.getText();
                    this.populateTestcaseCombo(this.controller.getProjectName());
                    this.comboTestcaseName.setText(currTcName);
                    this.comboTestcaseName.addSelectionListener((SelectionListener)this);
                }
            }
        }
    }

    public Composite getPage() {
        return this.form;
    }

    public void expandTree(Object[] expandElements) {
        int i = 0;
        while (i < expandElements.length) {
            TestCaseNode currNode = (TestCaseNode)expandElements[i];
            boolean shouldExpand = true;
            TestCaseNode ancestorNode = currNode.getParentNode();
            while (ancestorNode != this.controller.getInvisibleRoot()) {
                boolean isExpanded = this.inputMsgViewer.getExpandedState((Object)ancestorNode);
                if (!isExpanded) {
                    shouldExpand = false;
                    break;
                }
                ancestorNode = ancestorNode.getParentNode();
            }
            if (shouldExpand) {
                this.inputMsgViewer.expandToLevel(expandElements[i], 1);
            }
            ++i;
        }
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        try {
            if (selectionEvent.widget.equals(this.submitButton)) {
                boolean isTranAlreadyRunning = this.testAndSetIsTranRunning(true);
                if (!isTranAlreadyRunning) {
                    this.handleSubmit();
                } else {
                    logger.finest("Submit click ignored, because tran is already running.");
                }
            } else if (selectionEvent.widget.equals(this.comboTestcaseName)) {
                this.handleSaveOrSaveAs();
                this.doNewTestCaseSelected();
            } else if (selectionEvent.widget.equals(this.comboRuntimeConfig)) {
                this.doNewRuntimeSelected();
            } else if (selectionEvent.widget.equals(this.comboOutputViewer)) {
                this.doOutputViewerSelected();
            }
        }
        catch (Throwable t) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "widgetSelected(SelectionEvent e)", t);
            logger.error(t);
        }
    }

    private void handleSubmit() throws CoreException {
        if (this.controller.isUnitTest()) {
            this.invokeUnitTest();
        } else {
            this.invokeMobileService();
        }
    }

    private void invokeMobileService() throws CoreException {
        PasswordMap passwordMap;
        String racfPassword;
        String racfId = "";
        String mapKey = this.getPasswordKey("");
        if (!(mapKey == null || (racfPassword = (String)(passwordMap = PasswordMap.getSingletonInstance()).getPasswordValues().get(mapKey)) != null && !racfPassword.isEmpty() || racfId == null || racfId.isEmpty() || this.racfDialogHasBeenDisplayed)) {
            this.racfDialogHasBeenDisplayed = true;
            RacfInfoDialog infoDialog = new RacfInfoDialog(this.getShell(), TranMessages.getLabel().getString("IPC_RACF_INFORMATION"), null, TranMessages.getDescription().getString("IPC_RACF"), 2, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0, "", racfPassword, "", "", 0);
            int retCode = infoDialog.open();
            if (retCode == 0) {
                this.testcaseEdited = true;
                passwordMap.getPasswordValues().put(mapKey, infoDialog.getPassword());
            }
        }
        SubmitInvocationUnitJob connectJob = new SubmitInvocationUnitJob(null, this.controller, this);
        connectJob.setUser(true);
        connectJob.schedule();
    }

    private void invokeUnitTest() throws CoreException {
        TestCaseNode tcNode = (TestCaseNode)((TreeSelection)this.inputMsgViewer.getSelection()).getFirstElement();
        IOMessagePairNode iomp = this.controller.getIompNode(tcNode);
        InteractionType interaction = iomp.getMessagePair().getInteraction();
        String racfId = interaction.getRacfUserId();
        String mapKey = "";
        if (mapKey != null) {
            PasswordMap passwordMap = PasswordMap.getSingletonInstance();
            String racfPassword = "ims4ever";
            if (!(racfPassword != null && !racfPassword.isEmpty() || racfId == null || racfId.isEmpty() || this.racfDialogHasBeenDisplayed)) {
                this.racfDialogHasBeenDisplayed = true;
                RacfInfoDialog infoDialog = new RacfInfoDialog(this.getShell(), TranMessages.getLabel().getString("IPC_RACF_INFORMATION"), null, TranMessages.getDescription().getString("IPC_RACF"), 2, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0, interaction.getRacfUserId(), racfPassword, interaction.getRacfGroupName(), interaction.getRacfApplName(), 0);
                int retCode = infoDialog.open();
                if (retCode == 0) {
                    this.testcaseEdited = true;
                    interaction.setRacfUserId(infoDialog.getUserId());
                    interaction.setRacfGroupName(infoDialog.getGroupName());
                    interaction.setRacfApplName(infoDialog.getApplName());
                    passwordMap.getPasswordValues().put(mapKey, infoDialog.getPassword());
                }
            }
        }
        boolean runTran = true;
        String fieldMissingValue = this.findFirstFieldMissingValue(iomp);
        if (fieldMissingValue != null) {
            runTran = this.runDespiteEmptyField();
        }
        if (runTran) {
            SubmitInvocationUnitJob connectJob = new SubmitInvocationUnitJob(iomp, this.controller, this);
            connectJob.setUser(true);
            connectJob.schedule();
        }
    }

    private String getPasswordKey(String racfId) throws CoreException {
        String retVal = null;
        ConnectionConfiguration connectionConfiguration = this.controller.getConnectionProfile().getConnectionConfiguration();
        String hostName = connectionConfiguration.getHost();
        String portNumber = String.valueOf(connectionConfiguration.getPort());
        retVal = hostName + "_" + portNumber + "_" + racfId;
        return retVal;
    }

    public void processOutputReceived(long start, long end, IOMessagePairNode iomp) throws CoreException, UnsupportedTypeConversion, IOException {
        ImsConnectExecutionException connectApiExecutionException;
        if (this.inputMsgTree.isDisposed()) {
            return;
        }
        this.updateWizardDescription(start, end, iomp.getName());
        this.updateTableViewers();
        ImsConnectApiException connectApiException = this.controller.getConnectApiException();
        if (connectApiException != null) {
            logger.error((Throwable)connectApiException);
            MessageDialog.openError((Shell)this.getShell(), (String)TranMessages.getLabel().getString("IDSW_ERR"), (String)connectApiException.getMessage());
        }
        if ((connectApiExecutionException = this.controller.getConnectApiExecutionException()) != null) {
            logger.error((Throwable)connectApiExecutionException);
            String racfMessage = connectApiExecutionException.getracfReturnCodeString();
            int racfReturnCode = connectApiExecutionException.getracfReturnCode();
            if ((racfMessage == null || racfMessage.isEmpty()) && (racfMessage = connectApiExecutionException.getErrorMessage()) != null && racfMessage.indexOf("HWS0043E") >= 0) {
                racfReturnCode = connectApiExecutionException.getReturnCode();
            }
            if (racfMessage != null && !racfMessage.isEmpty() && racfReturnCode >= 4) {
                this.testAndSetIsTranRunning(false);
                IStatus status = logger.createMultiStatus(4, TranMessages.getError().getString("TCMLE_VIEW_DETAILS"), (Throwable)connectApiExecutionException);
                ErrorDialog.openError((Shell)this.getShell(), (String)TranMessages.getError().getString("TCMLE_ERRDLG_TITLE"), (String)TranMessages.getError().getString("TCMLE_RACF_ERROR"), (IStatus)status);
                if (this.controller.getConnectionProfile().getCredentials() == null) {
                    RacfInfoDialog infoDialog;
                    int retCode;
                    InteractionType interaction = iomp.getMessagePair().getInteraction();
                    String racfId = interaction.getRacfUserId();
                    String mapKey = this.getPasswordKey(racfId);
                    PasswordMap passwordMap = PasswordMap.getSingletonInstance();
                    String racfPassword = (String)passwordMap.getPasswordValues().get(mapKey);
                    if (racfPassword == null) {
                        racfPassword = "";
                    }
                    if ((retCode = (infoDialog = new RacfInfoDialog(this.getShell(), TranMessages.getLabel().getString("IDSW_ERR"), null, racfMessage, 1, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0, interaction.getRacfUserId(), racfPassword, interaction.getRacfGroupName(), interaction.getRacfApplName(), racfReturnCode)).open()) == 0) {
                        this.testcaseEdited = true;
                        passwordMap.getPasswordValues().remove(mapKey);
                        racfId = infoDialog.getUserId();
                        mapKey = this.getPasswordKey(racfId);
                        passwordMap.getPasswordValues().put(mapKey, infoDialog.getPassword());
                        interaction.setRacfUserId(racfId);
                        interaction.setRacfGroupName(infoDialog.getGroupName());
                        interaction.setRacfApplName(infoDialog.getApplName());
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    RuntimeConsoleWizardPage.this.handleSubmit();
                                }
                                catch (Throwable e) {
                                    logger.error(e);
                                }
                            }
                        });
                    }
                }
            } else {
                this.testAndSetIsTranRunning(false);
                MessageDialog.openError((Shell)this.getShell(), (String)TranMessages.getLabel().getString("IDSW_ERR"), (String)connectApiExecutionException.getErrorMessage());
            }
        } else {
            this.testAndSetIsTranRunning(false);
            MessagePayloadManager mpm = iomp.getOutputMessageNode().getMessagePayloadManager();
            int numSegments = mpm.getNumSegments();
            int numIoAreas = mpm.getNumIoAreas();
            if (numIoAreas - numSegments > 1) {
                Object[] inserts = new Object[]{TranMessages.getLabel().getString("RTC_VIEWER_COMBO_LABEL"), TranMessages.getLabel().getString("RTC_TEXT_VIEW"), TranMessages.getLabel().getString("RTC_TRACE_VIEW")};
                MessageDialog.openInformation((Shell)this.getShell(), (String)TranMessages.getLabel().getString("IPC_RACF_INFORMATION"), (String)TranMessages.getError().getString("TCMLE_EXTRA_OUTPUT_IOAREAS", inserts));
            }
        }
    }

    private void doOutputViewerSelected() throws JAXBException, CoreException, UnsupportedTypeConversion, IOException, ConversionException {
        IOMessagePairNode iomp = (IOMessagePairNode)((TreeSelection)this.outputMsgViewer.getSelection()).getFirstElement();
        String newOutMsgName = this.comboOutputViewer.getText();
        if (newOutMsgName.equals(TranMessages.getLabel().getString("RTC_TEXT_VIEW")) || newOutMsgName.equals(TranMessages.getLabel().getString("RTC_TRACE_VIEW"))) {
            if (this.currState == 0) {
                this.currState = 1;
                this.currIomp = iomp;
                this.outputMsgTree.dispose();
                this.textArea = new Text((Composite)this.outputGroup, 2826);
                GridData gd = new GridData(16384, 128, true, true);
                gd.horizontalSpan = 4;
                Rectangle currSize = this.outputGroup.getBounds();
                gd.widthHint = currSize.width;
                gd.heightHint = currSize.height;
                this.textArea.setLayoutData((Object)gd);
                if (courierNewFont == null) {
                    FontData[] fontData = this.outputGroup.getFont().getFontData();
                    fontData[0].setName("Courier New");
                    fontData[0].setHeight(12);
                    courierNewFont = new Font((Device)PlatformUI.getWorkbench().getDisplay(), fontData[0]);
                }
                this.textArea.setFont(courierNewFont);
                this.outputGroup.layout();
            }
            this.refreshTextArea();
        } else {
            if (this.currState == 1) {
                this.currState = 0;
                iomp = this.currIomp;
                this.textArea.dispose();
                GridData gd = new GridData(4, 4, true, true);
                gd.horizontalSpan = 4;
                this.outputMsgTree = new Tree((Composite)this.outputGroup, 68352);
                this.outputMsgTree.setHeaderVisible(true);
                this.outputMsgTree.setLinesVisible(true);
                this.outputMsgTree.setLayoutData((Object)gd);
                int i = 0;
                while (i < TestcaseEditorPage.COLUMN_NAMES.length) {
                    TreeColumn column = new TreeColumn(this.outputMsgTree, 16384);
                    column.setResizable(true);
                    column.setAlignment(16384);
                    column.setText(TestcaseEditorPage.COLUMN_NAMES[i]);
                    column.pack();
                    ++i;
                }
                this.outputMsgViewer = new TreeViewer(this.outputMsgTree);
                this.outputMsgViewer.setColumnProperties(TestcaseEditorPage.COLUMN_NAMES);
                this.outputMsgViewer.setContentProvider((IContentProvider)new TestcaseFieldLayoutContentProvider(true, false));
                this.outputMsgViewer.setLabelProvider((IBaseLabelProvider)new TestcaseFieldLayoutLabelProvider());
                this.outputMsgViewer.setInput((Object)this.controller.getInvisibleRoot());
                this.outputMsgTree.layout();
                this.outputGroup.layout();
                this.resizeColumns();
                if (iomp != null) {
                    iomp.setCurrentActiveOutputMsg(newOutMsgName);
                    this.outputMsgViewer.addSelectionChangedListener((ISelectionChangedListener)this);
                    Object[] selectedNode = new Object[]{iomp};
                    this.outputMsgViewer.setSelection((ISelection)new StructuredSelection(selectedNode), true);
                }
            }
            if (iomp != null) {
                iomp.setCurrentActiveOutputMsg(newOutMsgName);
                this.controller.populateIoMessageNodes(iomp);
                this.outputMsgViewer.refresh();
                this.expandEntireSubTree(this.outputMsgViewer, (TestCaseNode)iomp);
            }
        }
    }

    private void refreshTextArea() throws UnsupportedTypeConversion, IOException {
        String outputViewerName = this.comboOutputViewer.getText();
        MessagePayloadManager mpm = this.currIomp.getOutputMessageNode().getMessagePayloadManager();
        String lineSep = System.getProperty("line.separator");
        if (outputViewerName.equals(TranMessages.getLabel().getString("RTC_TEXT_VIEW"))) {
            if (mpm.getNumIoAreas() > 0) {
                StringBuffer sb = new StringBuffer();
                int numSegments = mpm.getNumSegments();
                int i = 0;
                while (i < numSegments) {
                    sb.append("Segment ").append(i + 1).append(":").append(lineSep);
                    String currPayloadStr = mpm.getPayloadAsSingleString(i);
                    sb.append(currPayloadStr).append(lineSep).append(lineSep);
                    ++i;
                }
                int numIoAreas = mpm.getNumIoAreas();
                int i2 = numSegments;
                while (i2 < numIoAreas) {
                    byte[] currIoArea = mpm.getIoArea(i2);
                    String currPayloadStr = mpm.getPayloadAsSingleString(currIoArea);
                    sb.append("[**EXTRA**]Segment ").append(numSegments + i2 - 1).append(":").append(lineSep);
                    sb.append(currPayloadStr).append(lineSep).append(lineSep);
                    ++i2;
                }
                this.textArea.setText(sb.toString());
            }
        } else {
            StringBuffer sb = new StringBuffer();
            int numSegments = mpm.getNumSegments();
            byte[][] outputBytes = this.currIomp.getOutputBytes();
            if (outputBytes != null) {
                TraceWriter tw = new TraceWriter();
                int i = 0;
                while (i < outputBytes.length) {
                    if (i >= numSegments) {
                        sb.append("[**EXTRA**]");
                    }
                    sb.append("Segment ").append(i + 1).append(":");
                    String currTraceStr = tw.traceBuffer(outputBytes[i], 0, outputBytes[i].length, 2);
                    sb.append(currTraceStr).append(lineSep).append(lineSep);
                    ++i;
                }
                this.textArea.setText(sb.toString());
            }
        }
    }

    private String findFirstFieldMissingValue(IOMessagePairNode iomp) {
        IOMessageNode msgNode = iomp.getInputMessageNode();
        List segments = msgNode.getChildren();
        String retVal = null;
        int i = 0;
        while (i < segments.size()) {
            SegmentNode segment = (SegmentNode)segments.get(i);
            List dsNodes = segment.getChildren();
            int j = 0;
            while (j < dsNodes.size()) {
                DataStructureNode ds = (DataStructureNode)dsNodes.get(j);
                List fields = ds.getChildren();
                int k = 0;
                while (k < fields.size()) {
                    FieldNode field = (FieldNode)fields.get(k);
                    if (field.getFieldValue().getFieldValue() == null || field.getFieldValue().getFieldValue().isEmpty()) {
                        retVal = field.getName();
                        break;
                    }
                    ++k;
                }
                if (retVal != null) break;
                ++j;
            }
            if (retVal != null) break;
            ++i;
        }
        return retVal;
    }

    private boolean runDespiteEmptyField() {
        boolean retVal = true;
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        if (!store.getBoolean(EnWPreferencesPage.messageTypes[0])) {
            String fullDialogWarningMsg = EnWPreferencesPage.errorCodes[0] + " - " + TranMessages.getError().getString("PPEW_" + EnWPreferencesPage.messageTypes[0]);
            InfoDialog infoDialog = new InfoDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), TranMessages.getLabel().getString("WRND_DIALOG_TITLE"), null, fullDialogWarningMsg, 2, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
            infoDialog.setWarningType(0);
            int retCode = infoDialog.open();
            if (retCode == 1) {
                retVal = false;
            }
        }
        return retVal;
    }

    private void updateTableViewers() throws UnsupportedTypeConversion, IOException {
        List iompList = ((TestCaseNode)this.controller.getInvisibleRoot().getChildren().get(0)).getChildren();
        this.inputMsgViewer.refresh();
        if (this.currState == 0) {
            this.outputMsgViewer.refresh();
        } else {
            this.refreshTextArea();
        }
        IOMessagePairNode nextToRunIomp = null;
        IOMessagePairNode lastRunOutputIomp = (IOMessagePairNode)iompList.get(0);
        if (iompList != null && iompList.size() > 0) {
            int i = 0;
            while (i < iompList.size()) {
                IOMessagePairNode currIompNode = (IOMessagePairNode)iompList.get(i);
                if (currIompNode.getState() == 1) {
                    nextToRunIomp = currIompNode;
                }
                if (currIompNode.isInputMsgExpanded()) {
                    this.expandEntireSubTree(this.inputMsgViewer, (TestCaseNode)currIompNode);
                } else {
                    this.inputMsgViewer.setExpandedState((Object)currIompNode, false);
                }
                if (currIompNode.isOutputMsgExpanded()) {
                    this.expandEntireSubTree(this.outputMsgViewer, (TestCaseNode)currIompNode);
                    lastRunOutputIomp = currIompNode;
                } else {
                    this.outputMsgViewer.setExpandedState((Object)currIompNode, false);
                }
                ++i;
            }
        }
        if (lastRunOutputIomp != null) {
            Object[] selectedNode = new Object[]{lastRunOutputIomp};
            this.outputMsgViewer.setSelection((ISelection)new StructuredSelection(selectedNode), true);
        }
        if (nextToRunIomp != null) {
            Object[] selectedNode = new Object[]{nextToRunIomp};
            this.inputMsgViewer.setSelection((ISelection)new StructuredSelection(selectedNode), true);
        }
    }

    private void expandEntireSubTree(TreeViewer viewer, TestCaseNode node) {
        viewer.setExpandedState((Object)node, true);
        List children = node.getChildren();
        if (children != null) {
            int i = 0;
            while (i < children.size()) {
                TestCaseNode currChildNode = (TestCaseNode)children.get(i);
                if (currChildNode != null) {
                    this.expandEntireSubTree(viewer, currChildNode);
                }
                ++i;
            }
        }
    }

    private void updateWizardDescription(long start, long end, String invocableName) {
        DecimalFormat formatter = new DecimalFormat("#0.00000");
        this.setDescription(TranMessages.getDescription().getString("RCW_ELAPSED_TIME", (Object[])new String[]{formatter.format((double)(end - start) / 1000.0), invocableName}));
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object selectedObject = ((TreeSelection)event.getSelection()).getFirstElement();
        if (event.getSource().equals(this.inputMsgViewer)) {
            this.handleButtonEnablement();
        } else if (event.getSource().equals(this.outputMsgViewer)) {
            if (selectedObject instanceof IOMessagePairNode) {
                IOMessagePairNode outMsgPairNode = (IOMessagePairNode)selectedObject;
                String currentMsg = outMsgPairNode.getCurrentActiveOutputMsg();
                this.comboOutputViewer.setEnabled(true);
                if (currentMsg != null && !currentMsg.isEmpty()) {
                    List outMsgNameList = outMsgPairNode.getOutputMsgNames();
                    this.populateOutputViewerCombo(outMsgNameList, currentMsg);
                }
            } else {
                this.comboOutputViewer.setEnabled(false);
            }
        }
    }

    private void handleButtonEnablement() {
        if (this.controller.isUnitTest()) {
            TreeItem[] selection = this.inputMsgViewer.getTree().getSelection();
            if (selection.length > 0) {
                this.submitButton.setEnabled(true);
            } else {
                this.submitButton.setEnabled(false);
            }
        } else {
            String tcName = this.controller.getTestcaseFilename();
            this.submitButton.setEnabled(tcName != null && !tcName.isEmpty());
        }
    }

    public void keyPressed(KeyEvent event) {
    }

    public void keyReleased(KeyEvent event) {
        try {
            Object sourceObj;
            int kc = event.keyCode;
            if (kc == 13 && (sourceObj = event.getSource()) == this.inputMsgTree) {
                IStructuredSelection selection = (IStructuredSelection)this.inputMsgViewer.getSelection();
                TestCaseNode node = (TestCaseNode)selection.getFirstElement();
                if (node instanceof IOMessagePairNode) {
                    Object[] expandedElements = this.inputMsgViewer.getExpandedElements();
                    IOMessagePairNode msgPairNode = (IOMessagePairNode)node;
                    EditMessagePairWizard editMessagePairWizard = new EditMessagePairWizard(msgPairNode, this.controller);
                    WizardDialog dialog = new WizardDialog(this.getPage().getShell(), (IWizard)editMessagePairWizard);
                    dialog.create();
                    int rc = dialog.open();
                    if (rc == 0) {
                        this.testcaseEdited = true;
                        this.controller.editMessagePair(msgPairNode, editMessagePairWizard.getMessagePairName());
                        this.inputMsgViewer.refresh();
                        this.expandTree(expandedElements);
                    }
                } else if (node instanceof FieldNode) {
                    FieldNode fieldNode = (FieldNode)node;
                    DatatypeType dataType = fieldNode.getFieldType().getApplicationDatatype().getDatatype();
                    if (dataType == DatatypeType.ARRAY || dataType == DatatypeType.STRUCT) {
                        Object[] inserts = new Object[]{dataType.toString()};
                        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)TranMessages.getLabel().getString("IDSW_ERR"), (String)TranMessages.getError().getString("TCMLE_INVALID_FIELD_FOR_EDIT", inserts));
                    } else {
                        DataStructureNode dsNode = (DataStructureNode)fieldNode.getParentNode();
                        SegmentNode segNode = (SegmentNode)dsNode.getParentNode();
                        IOMessageNode msgNode = (IOMessageNode)segNode.getParentNode();
                        int msgType = msgNode.getType();
                        if (msgType == 0) {
                            this.editFieldValue(fieldNode);
                        }
                    }
                }
            }
        }
        catch (Throwable ex) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "widgetSelected()", ex);
            logger.error(ex);
        }
    }

    public void mouseDoubleClick(MouseEvent event) {
        try {
            Object sourceObj = event.getSource();
            if (sourceObj == this.inputMsgTree) {
                IStructuredSelection selection = (IStructuredSelection)this.inputMsgViewer.getSelection();
                TestCaseNode node = (TestCaseNode)selection.getFirstElement();
                if (node instanceof IOMessagePairNode) {
                    Object[] expandedElements = this.inputMsgViewer.getExpandedElements();
                    IOMessagePairNode msgPairNode = (IOMessagePairNode)node;
                    EditMessagePairWizard editMessagePairWizard = new EditMessagePairWizard(msgPairNode, this.controller);
                    WizardDialog dialog = new WizardDialog(this.getPage().getShell(), (IWizard)editMessagePairWizard);
                    dialog.create();
                    int rc = dialog.open();
                    if (rc == 0) {
                        this.testcaseEdited = true;
                        this.controller.editMessagePair(msgPairNode, editMessagePairWizard.getMessagePairName());
                        this.inputMsgViewer.refresh();
                        this.expandTree(expandedElements);
                    }
                } else if (node instanceof FieldNode) {
                    FieldNode fieldNode = (FieldNode)node;
                    DatatypeType dataType = fieldNode.getFieldType().getApplicationDatatype().getDatatype();
                    if (dataType == DatatypeType.ARRAY || dataType == DatatypeType.STRUCT) {
                        Object[] inserts = new Object[]{dataType.toString()};
                        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)TranMessages.getLabel().getString("IDSW_ERR"), (String)TranMessages.getError().getString("TCMLE_INVALID_FIELD_FOR_EDIT", inserts));
                    } else {
                        DataStructureNode dsNode = (DataStructureNode)fieldNode.getParentNode();
                        SegmentNode segNode = (SegmentNode)dsNode.getParentNode();
                        IOMessageNode msgNode = (IOMessageNode)segNode.getParentNode();
                        int msgType = msgNode.getType();
                        if (msgType == 0) {
                            this.editFieldValue(fieldNode);
                        }
                    }
                }
            }
        }
        catch (Throwable ex) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "widgetSelected()", ex);
            logger.error(ex);
        }
    }

    public void mouseDown(MouseEvent arg0) {
    }

    public void mouseUp(MouseEvent arg0) {
    }

    public void focusGained(FocusEvent arg0) {
        try {
            if (this.controller.isTestcaseUpdated()) {
                Object[] inserts = new Object[]{this.controller.getTestcaseFilename()};
                String message = TranMessages.getLabel().getString("RTC_REFRESH_TESTCASE", inserts);
                boolean refreshTest = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)TranMessages.getLabel().getString("RTC_WARNING"), (String)message);
                if (refreshTest) {
                    this.doNewTestCaseSelected();
                }
                this.controller.setTestcaseUpdated(false);
            }
        }
        catch (Exception e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "", (Throwable)e);
            logger.error((Throwable)e);
        }
    }

    public void focusLost(FocusEvent arg0) {
    }
}

