/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.transaction.wizard.runtimeconsole;

import com.ibm.im.ims.transaction.controller.editor.TestcaseEditorController;
import com.ibm.im.ims.workbench.transaction.Activator;
import com.ibm.im.ims.workbench.transaction.resources.utilities.TranMessages;
import com.ibm.im.ims.workbench.transaction.wizard.runtimeconsole.RuntimeConsoleManager;
import com.ibm.im.ims.workbench.transaction.wizard.runtimeconsole.RuntimeConsoleWizardPage;
import com.ibm.ims.dli.types.ConversionException;
import com.ibm.ims.dli.types.UnsupportedTypeConversion;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.io.IOException;
import javax.xml.bind.JAXBException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class RuntimeConsoleWizard
extends Wizard {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private RuntimeConsoleWizardPage page;
    private String projectName;
    private TestcaseEditorController controller;
    private RuntimeConsoleManager rcManager = RuntimeConsoleManager.getSingletonInstance();

    public RuntimeConsoleWizard(String projectName, String serverName, String serverId, String runConfigName) throws JAXBException, CoreException, UnsupportedTypeConversion, IOException, ConversionException {
        this.setWindowTitle(TranMessages.getLabel().getString("RCW_WINDOW_TITLE"));
        this.setNeedsProgressMonitor(false);
        this.projectName = projectName;
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        String traceFile = store.getString("IPC_IMS_CONNECT_TRACEFILE");
        this.controller = new TestcaseEditorController(projectName, traceFile);
        this.controller.setServerName(serverName);
        this.controller.setServerId(serverId);
        this.controller.setRunConfigName(runConfigName);
        this.rcManager.addController(this.controller);
    }

    public boolean canFinish() {
        return this.page.isPageComplete();
    }

    public void addPages() {
        try {
            this.page = new RuntimeConsoleWizardPage(TranMessages.getLabel().getString("RCW_WINDOW_TITLE"), this.controller);
            this.addPage((IWizardPage)this.page);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "addPages()", e);
            logger.error(e);
        }
    }

    public boolean performFinish() {
        return true;
    }

    public boolean performCancel() {
        try {
            this.page.saveWidgetValues();
            this.page.handleSaveOrSaveAs();
            this.rcManager.removeController(this.controller);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "", e);
            logger.error(e);
        }
        return true;
    }

    public String getProjectName() {
        return this.projectName;
    }
}

