/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.transaction.wizard.newtran;

import com.ibm.im.ims.transaction.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.workbench.transaction.resources.utilities.TranMessages;
import com.ibm.im.ims.workbench.transaction.utilities.UIHelper;
import com.ibm.im.ims.workbench.transaction.utilities.Utility;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.common.util.PosixPortablePathValidator;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class NewTransactionWizardPage
extends WizardPage
implements VerifyListener,
ModifyListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private IStructuredSelection selection;
    private Combo comboProjectName;
    private Text textTranNameField;
    private Text textTranCode;
    private UIHelper uih;

    public NewTransactionWizardPage(String pageName, IStructuredSelection selection) {
        super(pageName);
        this.selection = selection;
        this.setTitle(pageName);
        this.setImageDescriptor(Utility.getImageDescriptor("transaction_new_wizard_64.gif"));
        this.uih = new UIHelper();
    }

    public void createControl(Composite parent) {
        try {
            Composite composite = new Composite(parent, 0);
            Display display = parent.getDisplay();
            this.uih.setDisplay(display);
            FormLayout layout = new FormLayout();
            layout.marginHeight = 5;
            layout.marginWidth = 5;
            composite.setLayout((Layout)layout);
            composite.setFont(parent.getFont());
            IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
            int[] labelSizes = new int[]{Utility.getTextWidth(composite, 0, TranMessages.getLabel().getString("NPNT_PROJ_NAME")), Utility.getTextWidth(composite, 0, TranMessages.getLabel().getString("NPNT_TRAN_CODE")), Utility.getTextWidth(composite, 0, TranMessages.getLabel().getString("NPNT_TRAN_NAME"))};
            int requiredLabelWidth = Utility.getTextWidth(parent, 0, "*");
            int colonWidth = Utility.getTextWidth(parent, 0, TranMessages.getColon().getString("COLON"));
            int labelWidth = Utility.getMaxSize(labelSizes) + requiredLabelWidth + colonWidth;
            FormData fd1 = this.uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment(0, 0), null);
            this.uih.genRequiredLabel(composite, 16384, TranMessages.getLabel().getString("NPNT_PROJ_NAME") + TranMessages.getColon().getString("COLON"), this.uih.black, fd1);
            FormData fd2 = this.uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment(0, labelWidth), new FormAttachment(100, 0));
            this.comboProjectName = new Combo(composite, 2056);
            this.comboProjectName.setLayoutData((Object)fd2);
            fd1 = this.uih.genFormData(new FormAttachment((Control)this.comboProjectName, 10), null, new FormAttachment(0, 0), null);
            this.uih.genRequiredLabel(composite, 16384, TranMessages.getLabel().getString("NPNT_TRAN_CODE") + TranMessages.getColon().getString("COLON"), this.uih.black, fd1);
            fd2 = this.uih.genFormData(new FormAttachment((Control)this.comboProjectName, 10), null, new FormAttachment(0, labelWidth), new FormAttachment(100, 0));
            this.textTranCode = new Text(composite, 2048);
            this.textTranCode.setLayoutData((Object)fd2);
            this.textTranCode.setTextLimit(8);
            this.textTranCode.addVerifyListener((VerifyListener)this);
            this.textTranCode.addModifyListener((ModifyListener)this);
            fd1 = this.uih.genFormData(new FormAttachment((Control)this.textTranCode, 10), null, new FormAttachment(0, requiredLabelWidth / 2), null);
            this.uih.genLabel(composite, 16384, TranMessages.getLabel().getString("NPNT_TRAN_NAME") + TranMessages.getColon().getString("COLON"), this.uih.black, fd1);
            fd2 = this.uih.genFormData(new FormAttachment((Control)this.textTranCode, 10), null, new FormAttachment(0, labelWidth), new FormAttachment(100, 0));
            this.textTranNameField = new Text(composite, 2048);
            this.textTranNameField.setLayoutData((Object)fd2);
            helpSystem.setHelp((Control)composite, "com.ibm.im.ims.workbench.NewProjectWizard");
            this.initialize();
            this.setControl((Control)composite);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", e);
            logger.error(e);
        }
    }

    private void initialize() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject[] projects = root.getProjects();
        Vector<String> projectNames = new Vector<String>();
        String selectedName = this.getSelectedProjectName();
        int i = 0;
        while (i < projects.length) {
            IProjectNature nature;
            IProject currentProject = projects[i];
            if (currentProject.isOpen() && (nature = projects[i].getNature("com.ibm.im.ims.workbench.transaction.nature")) != null) {
                projectNames.add(projects[i].getName());
            }
            ++i;
        }
        String[] strArray = new String[projectNames.size()];
        projectNames.toArray(strArray);
        this.comboProjectName.setItems(strArray);
        this.comboProjectName.setText(selectedName);
        this.comboProjectName.addModifyListener((ModifyListener)this);
        this.textTranCode.addModifyListener((ModifyListener)this);
        this.textTranNameField.addModifyListener((ModifyListener)this);
        if (selectedName != null && selectedName.length() > 0) {
            this.textTranCode.setFocus();
        }
    }

    private String getSelectedProjectName() {
        String selectedProject = "";
        if (this.selection == null || this.selection.isEmpty()) {
            return selectedProject;
        }
        if (this.selection.getFirstElement() instanceof IProject) {
            selectedProject = ((IProject)this.selection.getFirstElement()).getName();
        } else if (this.selection.getFirstElement() instanceof IResource) {
            selectedProject = ((IResource)this.selection.getFirstElement()).getProject().getName();
        } else if (this.selection.getFirstElement() instanceof IFile) {
            selectedProject = ((IFile)this.selection.getFirstElement()).getProject().getName();
        }
        return selectedProject;
    }

    private boolean validatePage() throws CoreException {
        boolean retVal = true;
        this.setErrorMessage(null);
        this.setMessage(null);
        String projectName = this.getProjectName();
        String tranCode = this.textTranCode.getText().trim();
        String tranName = this.textTranNameField.getText().trim();
        String[] tranNames = null;
        if (projectName == null || projectName.equals("")) {
            this.setErrorMessage(null);
            this.setMessage(TranMessages.getError().getString("NT_PROJNAME"));
            retVal = false;
        } else {
            tranNames = ProjectTreeFileHelper.getTransactionFileNames((String)projectName);
        }
        if (tranCode == null || tranCode.isEmpty()) {
            retVal = false;
        } else if (!Utility.isValidName(tranCode)) {
            retVal = false;
            String errorMessage = TranMessages.getError().getString("IPC_NAME_ERROR", (Object[])new String[]{TranMessages.getLabel().getString("NPNT_TRAN_CODE")});
            this.setErrorMessage(errorMessage);
        }
        if (retVal) {
            if (tranName == null || tranName.isEmpty()) {
                tranName = tranCode;
            }
            if (tranNames != null && this.isTranNameDuplicated(tranNames, tranName)) {
                this.setErrorMessage(TranMessages.getError().getString("GWEM_ALREADY_EXISTS", (Object[])new String[]{TranMessages.getLabel().getString("NPNT_TRAN_NAME"), tranName}));
                retVal = false;
            }
        }
        if (retVal && tranName != null && !tranName.isEmpty() && !PosixPortablePathValidator.isPortableName((String)tranName)) {
            this.setErrorMessage(TranMessages.getError().getString("INVALID_TRAN_NAME", new Object[]{tranName}));
            this.setMessage(null);
            retVal = false;
        }
        return retVal;
    }

    public String getSelectedProjectName(IStructuredSelection selection) {
        String selectedProject = "";
        if (selection == null || selection.isEmpty()) {
            return selectedProject;
        }
        if (selection.getFirstElement() instanceof IProject) {
            selectedProject = ((IProject)selection.getFirstElement()).getName();
        } else if (selection.getFirstElement() instanceof IResource) {
            selectedProject = ((IResource)selection.getFirstElement()).getProject().getName();
        } else if (selection.getFirstElement() instanceof IFile) {
            selectedProject = ((IFile)selection.getFirstElement()).getProject().getName();
        }
        return selectedProject;
    }

    private boolean isTranNameDuplicated(String[] tranNames, String tranName) {
        boolean retVal = false;
        int i = 0;
        while (i < tranNames.length) {
            if (tranNames[i].equals(tranName)) {
                retVal = true;
                break;
            }
            ++i;
        }
        return retVal;
    }

    public String getProjectName() {
        return this.comboProjectName.getText().trim();
    }

    public String getTranName() {
        String tranName = this.textTranNameField.getText().trim();
        if (tranName == null || tranName.isEmpty()) {
            tranName = this.getTranCode();
        }
        return tranName;
    }

    public String getTranCode() {
        return this.textTranCode.getText().trim();
    }

    public IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
    }

    public void verifyText(VerifyEvent event) {
        try {
            if (event.character >= 'a' && event.character <= 'z') {
                event.text = event.text.toUpperCase();
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "verifyText(VerifyEvent event)", e);
            logger.error(e);
        }
    }

    public void modifyText(ModifyEvent arg0) {
        try {
            this.setPageComplete(this.validatePage());
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "modifyText(ModifyEvent arg0)", e);
            logger.error(e);
        }
    }
}

