/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.transaction.wizard.newtran;

import com.ibm.im.ims.metadata.transaction.Transaction;
import com.ibm.im.ims.transaction.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.workbench.transaction.resources.utilities.TranMessages;
import com.ibm.im.ims.workbench.transaction.utilities.NewTranHelper;
import com.ibm.im.ims.workbench.transaction.wizard.newtran.NewTransactionWizardPage;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewTransactionWizard
extends Wizard
implements INewWizard {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private NewTransactionWizardPage newTranPage;
    private IStructuredSelection selection;
    private String projectName;
    private String tranCode;
    private String tranName;

    public NewTransactionWizard() {
        this.setWindowTitle(TranMessages.getLabel().getString("NPNT_TITLE2"));
    }

    public void addPages() {
        try {
            this.newTranPage = new NewTransactionWizardPage(TranMessages.getLabel().getString("NPNT_PAGE_TITLE2"), this.selection);
            this.addPage((IWizardPage)this.newTranPage);
            this.newTranPage.setPageComplete(false);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "addPages()", e);
            logger.error(e);
        }
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getTranCode() {
        return this.tranCode;
    }

    public String getTransactionName() {
        return this.tranName;
    }

    public boolean performFinish() {
        try {
            this.projectName = this.newTranPage.getProjectName();
            this.tranName = this.newTranPage.getTranName();
            this.tranCode = this.newTranPage.getTranCode();
            Transaction newTran = NewTranHelper.createNewTran(this.projectName, this.tranCode);
            IFile tranFile = ProjectTreeFileHelper.marshallNewTran((String)this.projectName, (Transaction)newTran, (String)this.tranName);
            ProjectTreeFileHelper.revealTranInProjectTree((IFile)tranFile);
            ProjectTreeFileHelper.launchTranEditor((IFile)tranFile);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "performFinish()", e);
            logger.error(e);
        }
        return true;
    }

    public static String getProjectName(IStructuredSelection selection) {
        String retValue = null;
        if (selection != null && !selection.isEmpty()) {
            if (selection.size() > 1) {
                return null;
            }
            Object obj = selection.getFirstElement();
            if (obj instanceof IResource) {
                Object container = obj instanceof IProject ? (IContainer)obj : ((IResource)obj).getProject();
                retValue = container.getName();
            } else if (obj instanceof IJavaProject) {
                retValue = ((IJavaProject)obj).getProject().getName();
            }
        }
        return retValue;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        try {
            this.selection = selection;
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "init(IWorkbench workbench, IStructuredSelection selection)", e);
            logger.error(e);
        }
    }
}

