/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.transaction.wizard.newtestcase;

import com.ibm.im.ims.metadata.testcase.Testcase;
import com.ibm.im.ims.transaction.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.workbench.transaction.resources.utilities.TranMessages;
import com.ibm.im.ims.workbench.transaction.utilities.UIHelper;
import com.ibm.im.ims.workbench.transaction.utilities.Utility;
import com.ibm.im.ims.workbench.transaction.wizard.newtestcase.NewTestCaseWizard;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.common.util.PosixPortablePathValidator;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class NewTestCaseWizardPage
extends WizardPage
implements ModifyListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private IStructuredSelection selection;
    private static final int margin = 5;
    private static final int rightPercentage = 65;
    private static final String COLON = TranMessages.getColon().getString("COLON");
    private Combo projectNameCombo;
    private Text tcNameField;
    private Combo copyFromTcCombo;

    public NewTestCaseWizardPage(String pageName, IStructuredSelection selection) {
        super(pageName);
        this.setImageDescriptor(Utility.getImageDescriptor("testCase_new_wizard_64.gif"));
        this.selection = selection;
    }

    public void createControl(Composite parent) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", new Object[0]);
        try {
            Composite composite = new Composite(parent, 0);
            Font font = parent.getFont();
            FormLayout layout = new FormLayout();
            layout.marginHeight = 5;
            layout.marginWidth = 5;
            composite.setLayout((Layout)layout);
            composite.setFont(font);
            UIHelper uih = new UIHelper();
            Display display = parent.getDisplay();
            uih.setDisplay(display);
            int[] labelSizes = new int[]{Utility.getTextWidth(parent, 0, TranMessages.getLabel().getString("NTC_PROJ_NAME")), Utility.getTextWidth(parent, 0, TranMessages.getLabel().getString("NTC_TEST_CASE_NAME")), Utility.getTextWidth(parent, 0, TranMessages.getLabel().getString("NTC_CLONED_TEST_CASE"))};
            int requiredLabelWidth = Utility.getTextWidth(parent, 0, "*");
            int colonWidth = Utility.getTextWidth(parent, 0, COLON);
            int labelWidth = Utility.getMaxSize(labelSizes) + requiredLabelWidth + colonWidth;
            FormData fd = uih.genFormData(new FormAttachment(0, 7), null, new FormAttachment(0, 0), null);
            Label projectReq = uih.genRequiredSymbol(composite, 0, fd, parent.getDisplay().getSystemColor(3));
            projectReq.setFont(font);
            fd = uih.genFormData(new FormAttachment(0, 5), null, new FormAttachment((Control)projectReq, 5), null);
            Label projectLabel = new Label(composite, 0);
            projectLabel.setText(TranMessages.getLabel().getString("NTC_PROJ_NAME") + COLON);
            projectLabel.setLayoutData((Object)fd);
            projectLabel.setFont(font);
            fd = uih.genFormData(new FormAttachment(0, 3), null, new FormAttachment(0, labelWidth), new FormAttachment(65, 5));
            this.projectNameCombo = new Combo(composite, 2056);
            this.projectNameCombo.setLayoutData((Object)fd);
            this.projectNameCombo.setFont(font);
            this.projectNameCombo.setFocus();
            fd = uih.genFormData(new FormAttachment((Control)this.projectNameCombo, 19), null, new FormAttachment(0, 0), null);
            Label psbReq = uih.genRequiredSymbol(composite, 0, fd, parent.getDisplay().getSystemColor(3));
            psbReq.setFont(font);
            fd = uih.genFormData(new FormAttachment((Control)this.projectNameCombo, 17), null, new FormAttachment((Control)psbReq, 5), null);
            Label tcLabel = new Label(composite, 0);
            tcLabel.setText(TranMessages.getLabel().getString("NTC_TEST_CASE_NAME") + COLON);
            tcLabel.setLayoutData((Object)fd);
            tcLabel.setFont(font);
            fd = uih.genFormData(new FormAttachment((Control)this.projectNameCombo, 15), null, new FormAttachment(0, labelWidth), new FormAttachment(65, 5));
            this.tcNameField = new Text(composite, 2048);
            this.tcNameField.setLayoutData((Object)fd);
            this.tcNameField.setFont(font);
            fd = uih.genFormData(new FormAttachment((Control)tcLabel, 27), null, new FormAttachment((Control)psbReq, 5), null);
            Label copyFromTcLbl = new Label(composite, 0);
            copyFromTcLbl.setText(TranMessages.getLabel().getString("NTC_CLONED_TEST_CASE") + COLON);
            copyFromTcLbl.setLayoutData((Object)fd);
            copyFromTcLbl.setFont(font);
            fd = uih.genFormData(new FormAttachment((Control)this.tcNameField, 19), null, new FormAttachment(0, labelWidth), new FormAttachment(65, 5));
            this.copyFromTcCombo = new Combo(composite, 2056);
            this.copyFromTcCombo.setLayoutData((Object)fd);
            this.copyFromTcCombo.setFont(font);
            this.copyFromTcCombo.setFocus();
            this.copyFromTcCombo.setToolTipText(TranMessages.getLabel().getString("NTC_CLONED_TEST_CASE"));
            this.setTitle(TranMessages.getLabel().getString("NTC_WIZ_PAGE_TITLE"));
            this.setDescription(TranMessages.getDescription().getString("NTC_PAGE_DESCRIPTION"));
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.im.ims.workbench.ies1_wb_createpsb");
            this.setControl((Control)composite);
            this.initialize();
            this.getContainer().getShell().setMinimumSize(550, 400);
            this.setPageComplete(false);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", e);
            logger.error(e);
        }
    }

    private void initialize() throws CoreException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject[] projects = root.getProjects();
        Vector<String> projectNames = new Vector<String>();
        String selectedName = this.getSelectedProjectName();
        int i = 0;
        while (i < projects.length) {
            IProjectNature nature;
            IProject currentProject = projects[i];
            if (currentProject.isOpen() && (nature = projects[i].getNature("com.ibm.im.ims.workbench.transaction.nature")) != null) {
                projectNames.add(projects[i].getName());
            }
            ++i;
        }
        String[] strArray = new String[projectNames.size()];
        projectNames.toArray(strArray);
        this.projectNameCombo.setItems(strArray);
        this.projectNameCombo.setText(selectedName);
        this.projectNameCombo.addModifyListener((ModifyListener)this);
        this.tcNameField.addModifyListener((ModifyListener)this);
        if (selectedName != null && selectedName.length() > 0) {
            this.tcNameField.setFocus();
        }
        if (selectedName != null && !selectedName.isEmpty()) {
            String[] tcNames = ProjectTreeFileHelper.getTestCaseFileNames((String)selectedName);
            this.copyFromTcCombo.setItems(tcNames);
        }
        Testcase existingTcForDup = this.getWiz().getExistingTCForDup();
        String existingTcForDupName = this.getWiz().getExistingTCForDupName();
        if (existingTcForDup != null && existingTcForDupName != null) {
            this.copyFromTcCombo.setText(existingTcForDupName);
            this.projectNameCombo.setEnabled(false);
            this.copyFromTcCombo.setEnabled(false);
        }
        this.copyFromTcCombo.addModifyListener((ModifyListener)this);
    }

    private String getSelectedProjectName() {
        String selectedProject = "";
        String overrideProjectName = this.getWiz().getProjectName();
        if (overrideProjectName != null && !overrideProjectName.isEmpty()) {
            selectedProject = overrideProjectName;
        } else if (this.selection != null && !this.selection.isEmpty()) {
            if (this.selection.getFirstElement() instanceof IProject) {
                selectedProject = ((IProject)this.selection.getFirstElement()).getName();
            } else if (this.selection.getFirstElement() instanceof IResource) {
                selectedProject = ((IResource)this.selection.getFirstElement()).getProject().getName();
            } else if (this.selection.getFirstElement() instanceof IFile) {
                selectedProject = ((IFile)this.selection.getFirstElement()).getProject().getName();
            }
        }
        return selectedProject;
    }

    private boolean validatePage() throws CoreException {
        boolean retVal = true;
        this.setErrorMessage(null);
        this.setMessage(null);
        String projectName = this.getProjectName();
        String tcName = this.tcNameField.getText().trim();
        String[] tcNames = null;
        if (projectName == null || projectName.equals("")) {
            this.setErrorMessage(null);
            this.setMessage(TranMessages.getError().getString("NT_PROJNAME"));
            retVal = false;
        } else {
            tcNames = ProjectTreeFileHelper.getTestCaseFileNames((String)projectName);
        }
        if (tcName == null || tcName.isEmpty()) {
            retVal = false;
        } else if (tcNames != null && this.isTcNameDuplicated(tcNames, tcName)) {
            this.setErrorMessage(TranMessages.getError().getString("GWEM_ALREADY_EXISTS", (Object[])new String[]{TranMessages.getLabel().getString("NTC_TEST_CASE_NAME"), tcName}));
            retVal = false;
        }
        if (retVal && tcName != null && !tcName.isEmpty() && !PosixPortablePathValidator.isPortableName((String)tcName)) {
            this.setErrorMessage(TranMessages.getError().getString("INVALID_TRAN_TEST_CASE_NAME", new Object[]{tcName}));
            this.setMessage(null);
            retVal = false;
        }
        return retVal;
    }

    private boolean isTcNameDuplicated(String[] tcNames, String tcName) {
        boolean retVal = false;
        int i = 0;
        while (i < tcNames.length) {
            if (tcNames[i].equals(tcName)) {
                retVal = true;
                break;
            }
            ++i;
        }
        return retVal;
    }

    public IStructuredSelection getSelection() {
        return this.selection;
    }

    public String getProjectName() {
        return this.projectNameCombo.getText().trim();
    }

    public String getTestcaseName() {
        return this.tcNameField.getText().trim();
    }

    public String getTcForDupName() {
        return this.copyFromTcCombo.getText().trim();
    }

    private NewTestCaseWizard getWiz() {
        return (NewTestCaseWizard)this.getWizard();
    }

    public void modifyText(ModifyEvent event) {
        try {
            if (event.widget == this.projectNameCombo) {
                this.updateCopyFromTcComboItems();
            }
            this.setPageComplete(this.validatePage());
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "modifyText(ModifyEvent arg0)", e);
            logger.error(e);
        }
    }

    private void updateCopyFromTcComboItems() throws CoreException {
        String projectName = this.projectNameCombo.getText();
        String[] tcNames = ProjectTreeFileHelper.getTestCaseFileNames((String)projectName);
        this.copyFromTcCombo.setItems(tcNames);
    }
}

