/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.transaction.wizard.newtestcase;

import com.ibm.im.ims.metadata.testcase.InteractionType;
import com.ibm.im.ims.metadata.testcase.IoMessagePairType;
import com.ibm.im.ims.metadata.testcase.Testcase;
import com.ibm.im.ims.transaction.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.workbench.transaction.Activator;
import com.ibm.im.ims.workbench.transaction.resources.utilities.TranMessages;
import com.ibm.im.ims.workbench.transaction.wizard.newtestcase.NewTestCaseWizardPage;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewTestCaseWizard
extends Wizard
implements INewWizard {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private NewTestCaseWizardPage page;
    private IStructuredSelection selection;
    private String projectName;
    private String tcName;
    private Testcase existingTCForDup;
    private String existingTCForDupName;
    private IFile newDupFile;

    public NewTestCaseWizard() {
        this.setWindowTitle(TranMessages.getLabel().getString("NTC_WIZ_TITLE"));
    }

    public boolean canFinish() {
        try {
            return this.page.isPageComplete();
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "canFinish()", e);
            logger.error(e);
            return true;
        }
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public String getTestCaseName() {
        return this.tcName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void addPages() {
        try {
            this.page = new NewTestCaseWizardPage("", this.selection);
            this.addPage((IWizardPage)this.page);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "addPages()", e);
            logger.error(e);
        }
    }

    public static IFile createDupTC(String projectName, Testcase existingTCForDup, String existingTCForDupName, String tcName) throws JAXBException, CoreException {
        if (existingTCForDup == null) {
            existingTCForDup = ProjectTreeFileHelper.unmarshallTestcase((String)projectName, (String)existingTCForDupName);
        }
        return ProjectTreeFileHelper.marshallTestcase((String)projectName, (Testcase)existingTCForDup, (String)tcName);
    }

    public static void createTC(String projectName, String tcName) throws CoreException, IOException, JAXBException {
        Testcase testcase = new Testcase();
        List iompList = testcase.getIoMessagePair();
        IoMessagePairType newIomp = new IoMessagePairType();
        newIomp.setName("Rename this Input and Output pair");
        InteractionType interaction = new InteractionType();
        NewTestCaseWizard.initializeInteraction(interaction);
        newIomp.setInteraction(interaction);
        iompList.add(newIomp);
        ProjectTreeFileHelper.marshallTestcase((String)projectName, (Testcase)testcase, (String)tcName);
    }

    private static void initializeInteraction(InteractionType interaction) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        if (interaction != null) {
            String dsName = store.getString("IPC_IMS_DATASTORE_NAME");
            interaction.setImsDatastoreName(dsName);
            String userExit = store.getString("IPC_IMS_CONNECT_USER_EXIT");
            interaction.setImsConnectUserMessageExitIdentifier(userExit);
            Boolean llzzIncluded = store.getBoolean("IPC_INPUT_MSG_INCLUDE_LLZZ");
            interaction.setInputMessageDataSegmentsIncludeLlzzAndTrancode(llzzIncluded);
            Boolean outputllzzIncluded = store.getBoolean("IPC_OUTPUT_MSG_INCLUDE_LLZZ");
            interaction.setOutputMessageDataSegmentsIncludeLlzz(outputllzzIncluded);
            Boolean llllIncluded = store.getBoolean("IPC_REROUTE_UNDELIVERABLE_OUTPUT");
            interaction.setResponseIncludesLlll(llllIncluded);
            Byte ackProvider = (byte)store.getInt("IPC_ACK_PROVIDER");
            interaction.setAckNakProvider(ackProvider);
            BigInteger type = BigInteger.valueOf(store.getInt("IPC_RESUME_TPIPE_PROCESSING"));
            interaction.setResumeTpipeProcessing(type);
            Boolean returnMfs = store.getBoolean("IPC_RETURN_MFS_MOD_NAME");
            interaction.setReturnMfsModname(returnMfs);
            Byte commMode = (byte)store.getInt("IPC_COMMIT_MODE");
            interaction.setCommitMode(commMode);
            Byte syncLvl = (byte)store.getInt("IPC_SYNC_LEVEL");
            interaction.setSyncLevel(syncLvl);
            String description = store.getString("IPC_INTERACTION_TYPE_DESC");
            interaction.setInteractionTypeDescription(description);
            String overrideName = store.getString("IPC_LTERM_OVERRIDE_NAME");
            interaction.setLtermOverrideName(overrideName);
            Boolean isReroute = store.getBoolean("IPC_REROUTE_UNDELIVERABLE_OUTPUT");
            interaction.setRerouteUndeliverableOutput(isReroute);
            String rerouteNm = store.getString("IPC_REROUTE_NAME");
            interaction.setRerouteName(rerouteNm);
            Boolean isPurge = store.getBoolean("IPC_PURGE_UNDELIVERABLE_OUTPUT");
            interaction.setPurgeUndeliverableOutput(isPurge);
            String clientId = store.getString("IPC_RESUMETPIPE_ALTERNATE_CLIENTID");
            interaction.setResumeTpipeAlternateClientId(clientId);
            BigInteger cTimeout = BigInteger.valueOf(store.getInt("IPC_IMS_CONNECT_TIMEOUT"));
            interaction.setImsConnectTimeout(cTimeout);
            BigInteger iTimeout = BigInteger.valueOf(store.getInt("IPC_INTERACTION_TIMEOUT"));
            interaction.setInteractionTimeout(iTimeout);
            String codePage = store.getString("IPC_IMS_CONNECT_CODEPAGE");
            interaction.setImsConnectCodepage(codePage);
            String racfId = store.getString("IPC_RACF_USERID");
            interaction.setRacfUserId(racfId);
            String racfGrpName = store.getString("IPC_RACF_GROUP_NAME");
            interaction.setRacfGroupName(racfGrpName);
            String racfAppl = store.getString("IPC_RACF_APPL_NAME");
            interaction.setRacfApplName(racfAppl);
        }
    }

    public boolean performFinish() {
        try {
            this.projectName = this.page.getProjectName();
            this.tcName = this.page.getTestcaseName();
            if (this.existingTCForDupName == null || this.existingTCForDupName.isEmpty()) {
                this.existingTCForDupName = this.page.getTcForDupName();
            }
            if (this.existingTCForDupName != null && !this.existingTCForDupName.isEmpty()) {
                this.newDupFile = NewTestCaseWizard.createDupTC(this.projectName, this.existingTCForDup, this.existingTCForDupName, this.tcName);
            } else {
                NewTestCaseWizard.createTC(this.projectName, this.tcName);
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "performFinish()", e);
            logger.error(e);
        }
        return true;
    }

    public void setExistingTCForDup(Testcase existingTCForDup) {
        this.existingTCForDup = existingTCForDup;
    }

    public Testcase getExistingTCForDup() {
        return this.existingTCForDup;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getExistingTCForDupName() {
        return this.existingTCForDupName;
    }

    public void setExistingTCForDupName(String existingTCForDupName) {
        this.existingTCForDupName = existingTCForDupName;
    }

    public IFile getNewDupFile() {
        return this.newDupFile;
    }
}

