/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.transaction.wizard.newproject;

import com.ibm.im.ims.transaction.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.workbench.transaction.resources.utilities.TranMessages;
import com.ibm.im.ims.workbench.transaction.utilities.UIHelper;
import com.ibm.im.ims.workbench.transaction.utilities.Utility;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.common.util.PosixPortablePathValidator;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class NewIMSTransactionProjectWizardPage
extends WizardPage
implements VerifyListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private Text projectNameField;
    private Text tranNameField;
    private Text textTranCode;
    private UIHelper uih = new UIHelper();
    private HashMap<String, String> projHash = null;
    public static final int IMPORT = 0;
    public static final int EXPORT = 1;
    public static final int NEW_PROJECT = 2;
    private Listener nameModifyListener = new Listener(){

        public void handleEvent(Event e) {
            boolean pageComplete = NewIMSTransactionProjectWizardPage.this.validatePage();
            NewIMSTransactionProjectWizardPage.this.setPageComplete(pageComplete);
            if (pageComplete) {
                NewIMSTransactionProjectWizardPage.this.getWizard().canFinish();
            }
        }
    };

    public NewIMSTransactionProjectWizardPage(String pageName, IStructuredSelection selection) {
        super(pageName);
        this.setTitle(pageName);
        this.setDescription(TranMessages.getDescription().getString("NTP_PAGE_DESCRIPTION"));
        this.setImageDescriptor(Utility.getImageDescriptor("projects_new_transactions_wizard_64.gif"));
    }

    public void createControl(Composite parent) {
        try {
            Composite composite = new Composite(parent, 0);
            Display display = parent.getDisplay();
            this.uih.setDisplay(display);
            FormLayout layout = new FormLayout();
            layout.marginHeight = 5;
            layout.marginWidth = 5;
            composite.setLayout((Layout)layout);
            composite.setFont(parent.getFont());
            this.projHash = ProjectTreeFileHelper.getAllProjectFromOS();
            IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
            helpSystem.setHelp((Control)composite, "com.ibm.im.ims.workbench.transaction.new_ims_transaction_project");
            int[] labelSizes = new int[]{Utility.getTextWidth(composite, 0, TranMessages.getLabel().getString("NPNT_PROJ_NAME")), Utility.getTextWidth(composite, 0, TranMessages.getLabel().getString("NPNT_TRAN_CODE")), Utility.getTextWidth(composite, 0, TranMessages.getLabel().getString("NPNT_TRAN_NAME"))};
            int requiredLabelWidth = Utility.getTextWidth(parent, 0, "*");
            int colonWidth = Utility.getTextWidth(parent, 0, TranMessages.getColon().getString("COLON"));
            int labelWidth = Utility.getMaxSize(labelSizes) + requiredLabelWidth + colonWidth;
            FormData fd = this.uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment(0, 0), null);
            this.uih.genRequiredLabel(composite, 16384, TranMessages.getLabel().getString("NPNT_PROJ_NAME") + TranMessages.getColon().getString("COLON"), this.uih.black, fd);
            fd = this.uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment(0, labelWidth), new FormAttachment(100, 0));
            this.projectNameField = this.uih.genTextField(composite, 2048, "", 100, fd, this.nameModifyListener, 24);
            this.projectNameField.setFocus();
            fd = this.uih.genFormData(new FormAttachment((Control)this.projectNameField, 10), null, new FormAttachment(0, 0), null);
            this.uih.genRequiredLabel(composite, 16384, TranMessages.getLabel().getString("NPNT_TRAN_CODE") + TranMessages.getColon().getString("COLON"), this.uih.black, fd);
            fd = this.uih.genFormData(new FormAttachment((Control)this.projectNameField, 10), null, new FormAttachment(0, labelWidth), new FormAttachment(100, 0));
            this.textTranCode = this.uih.genTextField(composite, 2048, "", 100, fd, this.nameModifyListener, 24);
            this.textTranCode.setTextLimit(8);
            this.textTranCode.addVerifyListener((VerifyListener)this);
            fd = this.uih.genFormData(new FormAttachment((Control)this.textTranCode, 10), null, new FormAttachment(0, requiredLabelWidth / 2), null);
            this.uih.genLabel(composite, 16384, TranMessages.getLabel().getString("NPNT_TRAN_NAME") + TranMessages.getColon().getString("COLON"), this.uih.black, fd);
            fd = this.uih.genFormData(new FormAttachment((Control)this.textTranCode, 10), null, new FormAttachment(0, labelWidth), new FormAttachment(100, 0));
            this.tranNameField = this.uih.genTextField(composite, 2048, "", 100, fd, this.nameModifyListener, 24);
            this.setPageComplete(this.validatePage());
            this.setControl((Control)composite);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", e);
            logger.error(e);
        }
    }

    private boolean validatePage() {
        boolean retVal = true;
        this.setErrorMessage(null);
        this.setMessage(null);
        String projectName = this.getProjectName();
        String tranCode = this.textTranCode.getText().trim();
        String tranName = this.tranNameField.getText().trim();
        if (projectName == null || projectName.equals("")) {
            this.setErrorMessage(null);
            this.setMessage(TranMessages.getError().getString("NT_PROJNAME"));
            retVal = false;
        } else if (!PosixPortablePathValidator.isPortableName((String)projectName)) {
            this.setErrorMessage(TranMessages.getError().getString("INVALID_PROJECT_NAME", new Object[]{projectName}));
            this.setMessage(null);
            retVal = false;
        } else if (this.projHash.get(projectName.toUpperCase()) != null) {
            this.setErrorMessage(TranMessages.getError().getString("NT_PROJNAME_EXISTSIN", (Object[])new String[]{Platform.getLocation().toOSString()}));
            retVal = false;
        }
        if (retVal) {
            if (tranCode == null || tranCode.isEmpty()) {
                retVal = false;
            } else if (!Utility.isValidName(tranCode)) {
                String errorMessage = TranMessages.getError().getString("IPC_NAME_ERROR", (Object[])new String[]{TranMessages.getLabel().getString("NPNT_TRAN_CODE")});
                this.setErrorMessage(errorMessage);
                retVal = false;
            }
        }
        if (retVal && tranName != null && !tranName.isEmpty() && !PosixPortablePathValidator.isPortableName((String)tranName)) {
            this.setErrorMessage(TranMessages.getError().getString("INVALID_TRAN_NAME", new Object[]{tranName}));
            this.setMessage(null);
            retVal = false;
        }
        return retVal;
    }

    public String getProjectName() {
        return this.projectNameField.getText().trim();
    }

    public String getTranCode() {
        return this.textTranCode.getText().trim();
    }

    public String getTranName() {
        return this.tranNameField.getText().trim();
    }

    public IProject getProjectHandle() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.getProjectName());
    }

    public void verifyText(VerifyEvent event) {
        try {
            if (event.character >= 'a' && event.character <= 'z') {
                event.text = event.text.toUpperCase();
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "verifyText(VerifyEvent event)", e);
            logger.error(e);
        }
    }
}

