/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.transaction.wizard.newproject;

import com.ibm.im.ims.metadata.transaction.Transaction;
import com.ibm.im.ims.metadata.trantoc.Trantoc;
import com.ibm.im.ims.transaction.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.transaction.model.utilities.TrantocMap;
import com.ibm.im.ims.transaction.model.utilities.TrantocMapManager;
import com.ibm.im.ims.workbench.transaction.resources.utilities.TranMessages;
import com.ibm.im.ims.workbench.transaction.utilities.NewTranHelper;
import com.ibm.im.ims.workbench.transaction.wizard.newproject.NewIMSTransactionProjectWizardPage;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.xml.bind.JAXBException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class NewIMSTransactionProjectWizard
extends Wizard
implements INewWizard,
IExecutableExtension {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private NewIMSTransactionProjectWizardPage newProjectPage;
    private IStructuredSelection selection;
    private IConfigurationElement config;
    private boolean projectAlreadyCreated = false;

    public NewIMSTransactionProjectWizard() {
        this.setWindowTitle(TranMessages.getLabel().getString("NPNT_TITLE"));
    }

    public void addPages() {
        try {
            this.newProjectPage = new NewIMSTransactionProjectWizardPage(TranMessages.getLabel().getString("NPNT_PAGE_TITLE"), this.selection);
            this.addPage((IWizardPage)this.newProjectPage);
            this.newProjectPage.setPageComplete(false);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "addPages()", e);
            logger.error(e);
        }
    }

    public String getProjectName() {
        return this.newProjectPage.getProjectName();
    }

    public boolean performFinish() {
        try {
            this.doFinish(this.getProjectName());
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.config);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "performFinish()", e);
            logger.error(e);
        }
        return true;
    }

    private void doFinish(String containerName) throws InvocationTargetException, InterruptedException, CoreException, IOException, JAXBException {
        String selectedProject = NewIMSTransactionProjectWizard.getProjectName(this.selection);
        if (selectedProject == null || !selectedProject.equals(containerName)) {
            this.createNewProject(containerName);
        }
    }

    public static String getProjectName(IStructuredSelection selection) {
        String retValue = null;
        if (selection != null && !selection.isEmpty()) {
            if (selection.size() > 1) {
                return null;
            }
            Object obj = selection.getFirstElement();
            if (obj instanceof IResource) {
                Object container = obj instanceof IProject ? (IContainer)obj : ((IResource)obj).getProject();
                retValue = container.getName();
            } else if (obj instanceof IJavaProject) {
                retValue = ((IJavaProject)obj).getProject().getName();
            }
        }
        return retValue;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        try {
            this.selection = selection;
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "init(IWorkbench workbench, IStructuredSelection selection)", e);
            logger.error(e);
        }
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        try {
            this.config = config;
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "setInitializationData(IConfigurationElement config, String propertyName,Object data)", e);
            logger.error(e);
        }
    }

    private void createNewProject(String containerName) throws CoreException, IOException, JAXBException {
        logger.entering(((Object)((Object)this)).getClass().getName(), "createNewProject(String containerName)", new Object[0]);
        if (!this.projectAlreadyCreated) {
            Trantoc trantoc = ProjectTreeFileHelper.createNewTranProject((String)containerName);
            this.projectAlreadyCreated = true;
            TrantocMap newMap = new TrantocMap(trantoc);
            TrantocMapManager.getSingletonInstance().putTrantocMap(containerName, newMap);
            String tranCode = this.newProjectPage.getTranCode();
            String tranName = this.newProjectPage.getTranName();
            if (tranName == null || tranName.isEmpty()) {
                tranName = tranCode;
            }
            Transaction newTran = NewTranHelper.createNewTran(containerName, tranCode);
            IFile tranFile = ProjectTreeFileHelper.marshallNewTran((String)containerName, (Transaction)newTran, (String)tranName);
            ProjectTreeFileHelper.revealTranInProjectTree((IFile)tranFile);
            ProjectTreeFileHelper.launchTranEditor((IFile)tranFile);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "createNewProject(String containerName)", new Object[0]);
    }
}

