/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.transaction.wizard.importmsg;

import com.ibm.im.ims.metadata.transaction.MessageType;
import com.ibm.im.ims.metadata.transaction.Transaction;
import com.ibm.im.ims.transaction.controller.importmessage.TestcaseTransactionMessageController;
import com.ibm.im.ims.transaction.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.workbench.transaction.resources.utilities.TranMessages;
import com.ibm.im.ims.workbench.transaction.utilities.UIHelper;
import com.ibm.im.ims.workbench.transaction.utilities.Utility;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.math.BigInteger;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class ImportTranMessageWizardPage
extends WizardPage
implements ModifyListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private Text ioMessagePairText;
    private Combo transactionName;
    private Combo inputMessageName;
    private Combo outputMessageName;
    private UIHelper uih;
    private TestcaseTransactionMessageController controller;

    public ImportTranMessageWizardPage(String pageName, TestcaseTransactionMessageController controller) {
        super(pageName);
        this.setTitle(pageName);
        this.setDescription(TranMessages.getDescription().getString("ITMW_DESC"));
        this.setImageDescriptor(Utility.getImageDescriptor("import_messages_wizard_64.gif"));
        this.uih = new UIHelper();
        this.controller = controller;
    }

    public void createControl(Composite parent) {
        try {
            Composite composite = new Composite(parent, 0);
            Display display = parent.getDisplay();
            this.uih.setDisplay(display);
            FormLayout layout = new FormLayout();
            layout.marginHeight = 5;
            layout.marginWidth = 5;
            composite.setLayout((Layout)layout);
            composite.setFont(parent.getFont());
            IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
            helpSystem.setHelp((Control)composite, "com.ibm.im.ims.workbench.transaction.import_tranmessage");
            int[] labelSizes = new int[]{Utility.getTextWidth(composite, 0, TranMessages.getLabel().getString("ITMW_IO_MSG_PAIR_NAME")), Utility.getTextWidth(composite, 0, TranMessages.getLabel().getString("ITMW_TRANSACTION_NAMES")), Utility.getTextWidth(composite, 0, TranMessages.getLabel().getString("ITMW_INPUT_MESSAGES")), Utility.getTextWidth(composite, 0, TranMessages.getLabel().getString("ITMW_OUTPUT_MESSAGES"))};
            int requiredLabelWidth = Utility.getTextWidth(parent, 0, "*");
            int colonWidth = Utility.getTextWidth(parent, 0, TranMessages.getColon().getString("COLON"));
            int labelWidth = Utility.getMaxSize(labelSizes) + requiredLabelWidth + colonWidth;
            FormData fd = this.uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment(0, requiredLabelWidth / 2), null);
            this.uih.genLabel(composite, 16384, TranMessages.getLabel().getString("ITMW_IO_MSG_PAIR_NAME") + TranMessages.getColon().getString("COLON"), this.uih.black, fd);
            fd = this.uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment(0, labelWidth), new FormAttachment(100, 0));
            this.ioMessagePairText = new Text(composite, 2048);
            this.ioMessagePairText.setLayoutData((Object)fd);
            this.ioMessagePairText.setEnabled(false);
            fd = this.uih.genFormData(new FormAttachment((Control)this.ioMessagePairText, 10), null, new FormAttachment(0, 0), null);
            this.uih.genRequiredLabel(composite, 16384, TranMessages.getLabel().getString("ITMW_TRANSACTION_NAMES") + TranMessages.getColon().getString("COLON"), this.uih.black, fd);
            fd = this.uih.genFormData(new FormAttachment((Control)this.ioMessagePairText, 10), null, new FormAttachment(0, labelWidth), new FormAttachment(100, 0));
            this.transactionName = new Combo(composite, 2056);
            this.transactionName.setLayoutData((Object)fd);
            fd = this.uih.genFormData(new FormAttachment((Control)this.transactionName, 10), null, new FormAttachment(0, 0), null);
            this.uih.genRequiredLabel(composite, 16384, TranMessages.getLabel().getString("ITMW_INPUT_MESSAGES") + TranMessages.getColon().getString("COLON"), this.uih.black, fd);
            fd = this.uih.genFormData(new FormAttachment((Control)this.transactionName, 10), null, new FormAttachment(0, labelWidth), new FormAttachment(100, 0));
            this.inputMessageName = new Combo(composite, 2056);
            this.inputMessageName.setLayoutData((Object)fd);
            fd = this.uih.genFormData(new FormAttachment((Control)this.inputMessageName, 10), null, new FormAttachment(0, 0), null);
            this.uih.genRequiredLabel(composite, 16384, TranMessages.getLabel().getString("ITMW_OUTPUT_MESSAGES") + TranMessages.getColon().getString("COLON"), this.uih.black, fd);
            fd = this.uih.genFormData(new FormAttachment((Control)this.inputMessageName, 10), null, new FormAttachment(0, labelWidth), new FormAttachment(100, 0));
            this.outputMessageName = new Combo(composite, 2056);
            this.outputMessageName.setLayoutData((Object)fd);
            this.setPageComplete(false);
            this.initialize();
            this.addListeners();
            this.setControl((Control)composite);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", e);
            logger.error(e);
        }
    }

    private void addListeners() {
        this.transactionName.addModifyListener((ModifyListener)this);
        this.inputMessageName.addModifyListener((ModifyListener)this);
        this.outputMessageName.addModifyListener((ModifyListener)this);
    }

    private void initialize() throws CoreException, JAXBException {
        this.ioMessagePairText.setText(this.controller.getIoMessagePairName());
        this.initializeTransactionList();
    }

    private void initializeTransactionList() throws CoreException, JAXBException {
        String projectName = this.controller.getProjectName();
        String[] transactionNames = ProjectTreeFileHelper.getTransactionFileNames((String)projectName);
        this.transactionName.setItems(transactionNames);
        Transaction transaction = this.controller.retrieveTransaction();
        String tranName = this.controller.retrieveTransactionFileName();
        if (transaction != null) {
            this.transactionName.setText(tranName);
            this.initializeIOMessageList(projectName, transaction);
        }
    }

    private void initializeIOMessageList(String projectName, Transaction transaction) throws CoreException, JAXBException {
        List inputMessages = transaction.getInputMessage();
        int size = inputMessages.size();
        if (inputMessages != null && inputMessages.size() > 0) {
            String[] inputMsgNames = new String[size + 1];
            inputMsgNames[0] = "";
            String inputMsgName = "";
            BigInteger inputMsgId = this.controller.getInputMessageId();
            int i = 0;
            while (i < size) {
                String currentMessageName;
                MessageType currentMessage = (MessageType)inputMessages.get(i);
                inputMsgNames[i + 1] = currentMessageName = currentMessage.getName();
                if (inputMsgId != null && inputMsgId.equals(currentMessage.getId())) {
                    inputMsgName = currentMessageName;
                }
                ++i;
            }
            this.inputMessageName.setItems(inputMsgNames);
            this.inputMessageName.setText(inputMsgName);
        }
        List outputMessages = transaction.getOutputMessage();
        size = outputMessages.size();
        if (outputMessages != null && outputMessages.size() > 0) {
            String[] outputMsgNames = new String[size + 1];
            outputMsgNames[0] = "";
            String outputMsgName = "";
            BigInteger outputMsgId = this.controller.getOutputMessageId();
            int i = 0;
            while (i < size) {
                String currentMessageName;
                MessageType currentMessage = (MessageType)outputMessages.get(i);
                outputMsgNames[i + 1] = currentMessageName = currentMessage.getName();
                if (outputMsgId != null && outputMsgId.equals(currentMessage.getId())) {
                    outputMsgName = currentMessageName;
                }
                ++i;
            }
            this.outputMessageName.setItems(outputMsgNames);
            this.outputMessageName.setText(outputMsgName);
        }
    }

    private boolean validatePage() {
        boolean retVal = true;
        this.setErrorMessage(null);
        String tranName = this.transactionName.getText().trim();
        if (tranName == null || tranName.isEmpty()) {
            this.setErrorMessage(TranMessages.getError().getString("ITMW_ERR_TRANSACTION_REQUIRED"));
            retVal = false;
        } else {
            String inputMsg = this.inputMessageName.getText();
            String outputMsg = this.outputMessageName.getText();
            if (inputMsg == null || inputMsg.isEmpty() || outputMsg == null || outputMsg.isEmpty()) {
                this.setErrorMessage(TranMessages.getError().getString("ITMW_ERR_INPUT_OR_OUTPUT_REQUIRED"));
                retVal = false;
            }
        }
        return retVal;
    }

    public String getTransactionName() {
        return this.transactionName.getText().trim();
    }

    public String getInputMessageName() {
        return this.inputMessageName.getText().trim();
    }

    public String getOutputMessageName() {
        return this.outputMessageName.getText().trim();
    }

    public void modifyText(ModifyEvent arg0) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "modifyText(ModifyEvent e)", new Object[0]);
        try {
            if (arg0.widget == this.transactionName) {
                String projectName = this.controller.getProjectName();
                Transaction tran = ProjectTreeFileHelper.unmarshallTran((String)projectName, (String)this.transactionName.getText());
                this.initializeIOMessageList(projectName, tran);
            }
            this.setPageComplete(this.validatePage());
        }
        catch (Throwable ex) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "modifyText(ModifyEvent e)", ex);
            logger.error(ex);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "modifyText(ModifyEvent e)", new Object[0]);
    }
}

