/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.transaction.wizard.importds;

import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.IConnectionService;
import com.ibm.cics.zos.model.DataSet;
import com.ibm.cics.zos.model.IZOSConnectable;
import com.ibm.cics.zos.model.Member;
import com.ibm.cics.zos.model.PartitionedDataSet;
import com.ibm.cics.zos.model.PermissionDeniedException;
import com.ibm.im.ims.metadata.transaction.FieldType;
import com.ibm.im.ims.metadata.transaction.MessageType;
import com.ibm.im.ims.transaction.controller.datastructure.DataStructureSegmentAssociation;
import com.ibm.im.ims.transaction.controller.datastructure.ImportParseException;
import com.ibm.im.ims.transaction.controller.datastructure.InformationException;
import com.ibm.im.ims.transaction.controller.datastructure.TranDataStructureController;
import com.ibm.im.ims.transaction.model.utilities.ParseException;
import com.ibm.im.ims.workbench.transaction.resources.utilities.TranMessages;
import com.ibm.im.ims.workbench.transaction.utilities.UIHelper;
import com.ibm.im.ims.workbench.transaction.utilities.Utility;
import com.ibm.im.ims.workbench.transaction.utilities.Warnings;
import com.ibm.im.ims.workbench.transaction.wizard.importds.ImportDSExceptionDialog;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import com.ibm.ims.explorer.wizard.importdataset.ImportDataSetWizard;
import java.io.File;
import java.io.FileNotFoundException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class ImportDSTranMessageMetadataWizardPage
extends WizardPage
implements Listener,
ModifyListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private TranDataStructureController controller;
    private UIHelper uih;
    private Group associationGroup;
    private Group tableGroup;
    private Label fileLabel;
    private Label folderLabel;
    private Combo importFromField;
    private Combo sourceTypeField;
    private Combo folderNameField;
    private Button sourceBrowseButton;
    private Combo fileNameField;
    private Combo dataStructureField;
    private Combo segmentNameField;
    private Combo messageNameField;
    private Button associateButton;
    private Button removeButton;
    private Table associationTable;
    private static final int margin = 5;
    private static final int adjust = -4;
    private int col2LabelWidth;
    private int buttonWidth;
    private boolean entryChanged = false;
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private String sourceFolderStr;
    private String sourceFileStr;
    private String sourceFileTypeStr;
    public Vector<InformationException> parsingInformationExceptionList;
    private static final String STORE_LOCAL_SOURCE_NAMES_ID = "ImportDSTranMessageMetadataWizardPage.STORE_LOCAL_SOURCE_NAMES_ID";
    private static final String STORE_HOST_SOURCE_NAMES_ID = "ImportDSTranMessageMetadataWizardPage.STORE_HOST_SOURCE_NAMES_ID";
    private static final String[] sourceTypes = new String[]{TranMessages.getLabel().getString("IDSW_LOCAL_FILE"), TranMessages.getLabel().getString("IDSW_ZOS")};

    public ImportDSTranMessageMetadataWizardPage(String pageName, TranDataStructureController controller) {
        super(pageName);
        this.controller = controller;
        this.setTitle(pageName);
        this.setDescription(TranMessages.getDescription().getString("IDSW_DESC"));
        this.setImageDescriptor(Utility.getImageDescriptor("data_structure_imprt_wizard_64.gif"));
        this.uih = new UIHelper();
        this.setPageComplete(false);
    }

    public void createControl(Composite composite) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", new Object[0]);
        try {
            String segmentName;
            Composite parent = new Composite(composite, 0);
            FormLayout formLayout = new FormLayout();
            formLayout.marginWidth = 5;
            parent.setLayout((Layout)formLayout);
            Display display = parent.getDisplay();
            this.uih.setDisplay(display);
            Color reqColor = parent.getDisplay().getSystemColor(3);
            IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
            helpSystem.setHelp((Control)composite, "com.ibm.im.ims.workbench.transaction.transaction_importds");
            int comboWidth = Utility.getTextWidth(composite, 0, TranMessages.getLabel().getString("IDSW_LOCAL_FILE"));
            int requiredLabelWidth = Utility.getTextWidth(composite, 0, "*");
            int[] labelSizes = new int[]{Utility.getTextWidth(parent, 0, TranMessages.getLabel().getString("IDSW_BROWSE_BUTTON")), Utility.getTextWidth(parent, 0, TranMessages.getLabel().getString("IDSW_ADD_IPLIST_BUTTON")), Utility.getTextWidth(parent, 0, TranMessages.getLabel().getString("IDSW_REMOVE_BUTTON"))};
            this.buttonWidth = Utility.getMaxSize(labelSizes) + 10;
            int[] col1LabelSizes = new int[]{Utility.getTextWidth(parent, 0, TranMessages.getLabel().getString("IDSW_IMPORT_LBL")), Utility.getTextWidth(parent, 0, TranMessages.getLabel().getString("IDSW_SOURCE_FLD_LBL")), Utility.getTextWidth(parent, 0, TranMessages.getLabel().getString("IDSW_SOURCE_PDS_LBL")), Utility.getTextWidth(parent, 0, TranMessages.getLabel().getString("IDSW_DS_FILE_LBL")), Utility.getTextWidth(parent, 0, TranMessages.getLabel().getString("IDSW_DS_MEM_LBL")), Utility.getTextWidth(parent, 0, TranMessages.getLabel().getString("IDSW_DS_NAME_LBL"))};
            int col1LabelWidth = Utility.getMaxSize(col1LabelSizes) + requiredLabelWidth;
            int[] col2LabelSizes = new int[]{Utility.getTextWidth(parent, 0, TranMessages.getLabel().getString("IDSW_FILE_TYPE_LBL")), Utility.getTextWidth(parent, 0, TranMessages.getLabel().getString("IDSW_SEGNAME_LBL")), Utility.getTextWidth(parent, 0, TranMessages.getLabel().getString("IDSW_MSG_NAME_LBL") + ":")};
            this.col2LabelWidth = Utility.getMaxSize(col2LabelSizes) + requiredLabelWidth;
            FormAttachment leftColumnLabelStart = new FormAttachment(0, requiredLabelWidth - 5);
            FormAttachment leftColumnLabelStart1 = new FormAttachment(0, requiredLabelWidth - 5 - -2);
            FormAttachment leftColumnComboStart = new FormAttachment(0, col1LabelWidth - 5);
            FormAttachment leftColumnComboStart1 = new FormAttachment(0, col1LabelWidth - 5 - -2);
            FormAttachment leftColumnComboEnd = new FormAttachment(50, -this.buttonWidth / 2 - 5);
            FormAttachment leftColumnComboEnd1 = new FormAttachment(50, -this.buttonWidth / 2 - 5 - -2);
            FormAttachment rightColumnLabelStart = new FormAttachment(50, -this.buttonWidth / 2 + requiredLabelWidth - 5);
            FormAttachment rightColumnLabelStart1 = new FormAttachment(50, -this.buttonWidth / 2 + requiredLabelWidth - 5 - -2);
            FormAttachment rightColumnComboStart = new FormAttachment(50, -this.buttonWidth / 2 + this.col2LabelWidth - 5);
            FormAttachment rightColumnComboStart1 = new FormAttachment(50, -this.buttonWidth / 2 + this.col2LabelWidth - 5 - -2);
            FormAttachment rightColumnComboEnd = new FormAttachment(100, -this.buttonWidth - 5);
            FormAttachment rightColumnComboEnd1 = new FormAttachment(100, -this.buttonWidth - 5 - -2);
            FormAttachment buttonEnd = new FormAttachment(100, -3);
            FormData fd = this.uih.genFormData(new FormAttachment(0, 7), null, new FormAttachment(0, 0), null);
            this.uih.genRequiredSymbol(parent, 0, fd, reqColor);
            fd = this.uih.genFormData(new FormAttachment(0, 5), null, leftColumnLabelStart, null);
            Label importFromLabel = new Label(parent, 0);
            importFromLabel.setText(TranMessages.getLabel().getString("IDSW_IMPORT_LBL"));
            importFromLabel.setLayoutData((Object)fd);
            fd = this.uih.genFormData(new FormAttachment(0, 3), null, leftColumnComboStart, leftColumnComboEnd);
            this.importFromField = new Combo(parent, 2056);
            this.importFromField.setLayoutData((Object)fd);
            this.importFromField.setItems(sourceTypes);
            if (this.controller.isLocalImport()) {
                this.importFromField.setText(sourceTypes[0]);
            } else {
                this.importFromField.setText(sourceTypes[1]);
            }
            fd = this.uih.genFormData(new FormAttachment(0, 7), null, new FormAttachment(50, -this.buttonWidth / 2), null);
            this.uih.genRequiredSymbol(parent, 0, fd, reqColor);
            fd = this.uih.genFormData(new FormAttachment(0, 5), null, rightColumnLabelStart, null);
            Label sourceTypeLabel = new Label(parent, 0);
            sourceTypeLabel.setText(TranMessages.getLabel().getString("IDSW_FILE_TYPE_LBL"));
            sourceTypeLabel.setLayoutData((Object)fd);
            fd = this.uih.genFormData(new FormAttachment(0, 3), null, rightColumnComboStart, rightColumnComboEnd);
            this.sourceTypeField = new Combo(parent, 2056);
            this.sourceTypeField.setLayoutData((Object)fd);
            this.sourceTypeField.setItems(TranDataStructureController.sourceLanguages);
            String importLanguage = this.controller.getImportLanguage();
            if (importLanguage != null) {
                this.sourceTypeField.setText(importLanguage);
            } else {
                this.sourceTypeField.setText(TranDataStructureController.sourceLanguages[0]);
            }
            fd = this.uih.genFormData(new FormAttachment((Control)this.importFromField, 19), null, new FormAttachment(0, 0), null);
            this.uih.genRequiredSymbol(parent, 0, fd, reqColor);
            fd = this.uih.genFormData(new FormAttachment((Control)this.importFromField, 17), null, leftColumnLabelStart, null);
            this.folderLabel = new Label(parent, 0);
            if (this.controller.isLocalImport()) {
                this.folderLabel.setText(TranMessages.getLabel().getString("IDSW_SOURCE_FLD_LBL"));
            } else {
                this.folderLabel.setText(TranMessages.getLabel().getString("IDSW_SOURCE_PDS_LBL"));
            }
            this.folderLabel.setLayoutData((Object)fd);
            fd = this.uih.genFormData(new FormAttachment((Control)this.importFromField, 15), null, leftColumnComboStart, rightColumnComboEnd);
            this.folderNameField = new Combo(parent, 2056);
            this.folderNameField.setLayoutData((Object)fd);
            this.folderNameField.setText(this.restoreFolderValues());
            fd = this.uih.genFormData(new FormAttachment((Control)this.folderNameField, 19), null, new FormAttachment(0, 0), null);
            this.uih.genRequiredSymbol(parent, 0, fd, reqColor);
            fd = this.uih.genFormData(new FormAttachment((Control)this.folderNameField, 17), null, leftColumnLabelStart, null);
            this.fileLabel = new Label(parent, 0);
            if (this.controller.isLocalImport()) {
                this.fileLabel.setText(TranMessages.getLabel().getString("IDSW_DS_FILE_LBL"));
            } else {
                this.fileLabel.setText(TranMessages.getLabel().getString("IDSW_DS_MEM_LBL"));
            }
            this.fileLabel.setLayoutData((Object)fd);
            this.fileLabel.setToolTipText(TranMessages.getDescription().getString("IDSW_DESC_DSFILE"));
            fd = this.uih.genFormData(new FormAttachment((Control)this.folderNameField, 15), null, leftColumnComboStart, rightColumnComboEnd);
            this.fileNameField = new Combo(parent, 2056);
            this.fileNameField.setLayoutData((Object)fd);
            if (this.controller.isLocalImport() && !this.folderNameField.getText().isEmpty()) {
                this.populateFileCombo(this.folderNameField.getText());
            } else {
                this.fileNameField.setEnabled(false);
            }
            fd = this.uih.genFormData(new FormAttachment((Control)this.folderNameField, 13), null, new FormAttachment((Control)this.fileNameField, 5), new FormAttachment(100, -5));
            fd.width = this.buttonWidth;
            this.sourceBrowseButton = new Button(parent, 8);
            this.sourceBrowseButton.setText(TranMessages.getLabel().getString("IDSW_BROWSE_BUTTON"));
            this.sourceBrowseButton.setLayoutData((Object)fd);
            FormLayout formLayout1 = new FormLayout();
            formLayout1.marginBottom = 5;
            fd = this.uih.genFormData(new FormAttachment((Control)this.fileNameField, 5), null, new FormAttachment(0, -4), new FormAttachment(100));
            this.associationGroup = new Group(parent, 0);
            this.associationGroup.setText(TranMessages.getLabel().getString("IDSW_DS_ASSOCIATIONS"));
            this.associationGroup.setLayout((Layout)formLayout1);
            this.associationGroup.setLayoutData((Object)fd);
            fd = this.uih.genFormData(new FormAttachment(0, 7), null, new FormAttachment(0, 2), null);
            this.uih.genRequiredSymbol((Composite)this.associationGroup, 0, fd, reqColor);
            fd = this.uih.genFormData(new FormAttachment(0, 5), null, leftColumnLabelStart1, null);
            Label dataStructureLabel = new Label((Composite)this.associationGroup, 0);
            dataStructureLabel.setText(TranMessages.getLabel().getString("IDSW_DS_NAME_LBL"));
            dataStructureLabel.setLayoutData((Object)fd);
            dataStructureLabel.setToolTipText(TranMessages.getDescription().getString("IDSW_DESC_DSNAME"));
            fd = this.uih.genFormData(new FormAttachment(0, 3), null, leftColumnComboStart1, leftColumnComboEnd1);
            this.dataStructureField = new Combo((Composite)this.associationGroup, 2056);
            this.dataStructureField.setLayoutData((Object)fd);
            this.dataStructureField.setEnabled(!this.fileNameField.getText().isEmpty());
            fd = this.uih.genFormData(new FormAttachment(0, 7), null, new FormAttachment(50, -this.buttonWidth / 2 - -2), null);
            this.uih.genRequiredSymbol((Composite)this.associationGroup, 0, fd, reqColor);
            fd = this.uih.genFormData(new FormAttachment(0, 5), null, rightColumnLabelStart1, null);
            Label messageLabel = new Label((Composite)this.associationGroup, 0);
            messageLabel.setText(TranMessages.getLabel().getString("IDSW_MSG_NAME_LBL"));
            messageLabel.setLayoutData((Object)fd);
            messageLabel.setToolTipText(TranMessages.getLabel().getString("IDSW_MSG_NAME_COLUMN"));
            fd = this.uih.genFormData(new FormAttachment(0, 3), null, rightColumnComboStart1, rightColumnComboEnd1);
            fd.width = comboWidth;
            this.messageNameField = new Combo((Composite)this.associationGroup, 2056);
            this.messageNameField.setLayoutData((Object)fd);
            this.messageNameField.setEnabled(false);
            fd = this.uih.genFormData(new FormAttachment(0, 2), null, new FormAttachment((Control)this.messageNameField, 5), buttonEnd);
            fd.width = this.buttonWidth;
            this.associateButton = new Button((Composite)this.associationGroup, 8);
            this.associateButton.setText(TranMessages.getLabel().getString("IDSW_ADD_IPLIST_BUTTON"));
            this.associateButton.setLayoutData((Object)fd);
            this.associateButton.setEnabled(false);
            this.associateButton.addListener(13, (Listener)this);
            fd = this.uih.genFormData(new FormAttachment((Control)this.messageNameField, 7), null, new FormAttachment(50, -this.buttonWidth / 2 - -2), null);
            this.uih.genRequiredSymbol((Composite)this.associationGroup, 0, fd, reqColor);
            fd = this.uih.genFormData(new FormAttachment((Control)this.messageNameField, 5), null, rightColumnLabelStart1, null);
            Label segmentLabel = new Label((Composite)this.associationGroup, 0);
            segmentLabel.setText(TranMessages.getLabel().getString("IDSW_SEGNAME_LBL"));
            segmentLabel.setLayoutData((Object)fd);
            segmentLabel.setToolTipText(TranMessages.getDescription().getString("IDSW_DESC_SEGNAME"));
            fd = this.uih.genFormData(new FormAttachment((Control)this.messageNameField, 3), null, rightColumnComboStart1, rightColumnComboEnd1);
            fd.width = comboWidth;
            this.segmentNameField = new Combo((Composite)this.associationGroup, 2056);
            this.segmentNameField.setLayoutData((Object)fd);
            this.segmentNameField.setEnabled(false);
            FormLayout formLayout2 = new FormLayout();
            formLayout2.marginLeft = 5;
            formLayout2.marginBottom = 5;
            fd = this.uih.genFormData(new FormAttachment((Control)this.associationGroup, 5), new FormAttachment(100, -5), new FormAttachment(0, -4), new FormAttachment(100));
            fd.height = 350;
            this.tableGroup = new Group(parent, 0);
            this.tableGroup.setText(TranMessages.getLabel().getString("IDSW_IMPORT_LIST_GROUP"));
            this.tableGroup.setLayout((Layout)formLayout2);
            this.tableGroup.setLayoutData((Object)fd);
            fd = this.uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment(0, -2), new FormAttachment(100));
            Label tableLabel = new Label((Composite)this.tableGroup, 64);
            tableLabel.setText(TranMessages.getLabel().getString("IDSW_DSCR_IPLIST"));
            tableLabel.setLayoutData((Object)fd);
            fd = this.uih.genFormData(new FormAttachment((Control)tableLabel, 5), new FormAttachment(100), new FormAttachment(0, -2), rightColumnComboEnd1);
            this.associationTable = new Table((Composite)this.tableGroup, 67586);
            this.associationTable.addListener(13, (Listener)this);
            this.associationTable.setHeaderVisible(true);
            this.associationTable.setLinesVisible(true);
            this.associationTable.setLayoutData((Object)fd);
            this.associationTable.setEnabled(false);
            this.setColumns();
            fd = this.uih.genFormData(new FormAttachment((Control)tableLabel, this.associationTable.getHeaderHeight() + 5), null, new FormAttachment((Control)this.associationTable, 5), buttonEnd);
            fd.width = this.buttonWidth;
            this.removeButton = new Button((Composite)this.tableGroup, 8);
            this.removeButton.setText(TranMessages.getLabel().getString("IDSW_REMOVE_BUTTON"));
            this.removeButton.setLayoutData((Object)fd);
            this.removeButton.setEnabled(false);
            String messageName = this.controller.getSelectedMessageName();
            if (messageName != null && !messageName.isEmpty()) {
                this.populateMessageCombo();
                this.setMessageName(messageName);
            }
            if ((segmentName = this.controller.getSelectedSegmentName()) != null && !segmentName.isEmpty()) {
                this.setSegmentName(segmentName);
            }
            this.addListeners();
            this.getContainer().getShell().setMinimumSize((col1LabelWidth > this.col2LabelWidth ? col1LabelWidth * 2 : this.col2LabelWidth * 2) + comboWidth * 2 + this.buttonWidth + 50, 700);
            this.setControl((Control)parent);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", e);
            logger.error(e);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", new Object[0]);
    }

    private void addListeners() {
        this.fileNameField.addModifyListener((ModifyListener)this);
        this.sourceBrowseButton.addListener(13, (Listener)this);
        this.sourceTypeField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportDSTranMessageMetadataWizardPage.this.updateSourceTypeField();
            }
        });
        this.importFromField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportDSTranMessageMetadataWizardPage.this.updateImportFromField();
            }
        });
        this.folderNameField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                try {
                    ImportDSTranMessageMetadataWizardPage.this.updateFromFolderField();
                }
                catch (Throwable e) {
                    logger.throwing(((Object)((Object)this)).getClass().getName(), "handleEvent(Event event)", e);
                    logger.error(e);
                }
            }
        });
        this.folderNameField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent event) {
                try {
                    if (ImportDSTranMessageMetadataWizardPage.this.entryChanged) {
                        ImportDSTranMessageMetadataWizardPage.this.entryChanged = false;
                        ImportDSTranMessageMetadataWizardPage.this.updateFromFolderField();
                    } else if (ImportDSTranMessageMetadataWizardPage.this.getMessageType() == 2) {
                        ImportDSTranMessageMetadataWizardPage.this.setMessage(null, 4);
                    }
                }
                catch (Throwable e) {
                    logger.throwing(this.getClass().getName(), "handleEvent(Event event)", e);
                    logger.error(e);
                }
            }
        });
        this.segmentNameField.addModifyListener((ModifyListener)this);
        this.segmentNameField.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportDSTranMessageMetadataWizardPage.this.updateFromSegmentField();
            }
        });
        this.segmentNameField.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                ImportDSTranMessageMetadataWizardPage.this.entryChanged = true;
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.segmentNameField.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                if (ImportDSTranMessageMetadataWizardPage.this.entryChanged) {
                    ImportDSTranMessageMetadataWizardPage.this.entryChanged = false;
                    ImportDSTranMessageMetadataWizardPage.this.updateFromSegmentField();
                } else if (ImportDSTranMessageMetadataWizardPage.this.getMessageType() == 2) {
                    ImportDSTranMessageMetadataWizardPage.this.setMessage(null, 4);
                }
            }
        });
        this.tableGroup.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                ImportDSTranMessageMetadataWizardPage.this.resizeColumns();
            }
        });
        this.removeButton.addListener(13, (Listener)this);
        this.dataStructureField.addModifyListener((ModifyListener)this);
        this.messageNameField.addModifyListener((ModifyListener)this);
    }

    private void resizeColumns() {
        Rectangle area = this.tableGroup.getClientArea();
        int width = area.width - 2 * this.associationTable.getBorderWidth() - this.buttonWidth - 5;
        TableColumn[] tableColumns = this.associationTable.getColumns();
        this.associationTable.setSize(area.width, area.height);
        int i = 0;
        while (i < tableColumns.length) {
            tableColumns[i].setWidth(width / tableColumns.length);
            ++i;
        }
    }

    private void setColumns() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "setColumns()", new Object[0]);
        String[] columnLabels = new String[]{TranMessages.getLabel().getString("IDSW_MSG_NAME_COLUMN"), TranMessages.getLabel().getString("IDSW_DS_NAME_COLUMN"), TranMessages.getLabel().getString("IDSW_SEGNAME_COLUMN"), TranMessages.getLabel().getString("IDSW_DS_FILE_COLUMN")};
        String[] stringArray = new String[4];
        stringArray[1] = TranMessages.getDescription().getString("IDSW_DESC_SEGNAME");
        stringArray[3] = TranMessages.getDescription().getString("IDSW_DESC_DSNAME");
        String[] columnTooltips = stringArray;
        int i = 0;
        while (i < columnLabels.length) {
            this.setColumn(columnLabels[i], columnTooltips[i]);
            ++i;
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "setColumns()", new Object[0]);
    }

    private void setColumn(String columnLabel, String columnTooltip) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "setColumn(String label)", new Object[0]);
        TableColumn tableColumn = new TableColumn(this.associationTable, 0);
        tableColumn.setMoveable(true);
        tableColumn.setResizable(true);
        tableColumn.setText(columnLabel);
        logger.exiting(((Object)((Object)this)).getClass().getName(), "setColumn(String label)", new Object[0]);
    }

    public void handleEvent(Event event) {
        try {
            this.setMessage(null, 2);
            if (event.widget == this.sourceBrowseButton) {
                this.handleSourceBrowseButtonPressed();
            } else if (event.widget == this.associateButton) {
                this.handleAssociateButtonPressed();
            } else if (event.widget == this.associationTable) {
                this.removeButton.setEnabled(this.associationTable.getSelectionCount() > 0);
                this.setMessage(null, 2);
            } else if (event.widget == this.removeButton) {
                this.handleRemoveButtonPressed();
            }
            this.setPageComplete(this.associationTable.getItemCount() > 0);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "handleEvent(Event event)", e);
            logger.error(e);
        }
    }

    public void modifyText(ModifyEvent event) {
        try {
            String segName;
            this.setMessage(null, 2);
            if (event.widget == this.fileNameField) {
                String fileName = this.fileNameField.getText();
                if (fileName != null && !fileName.isEmpty()) {
                    this.setFileName(fileName);
                    this.updateWidgetEnablements();
                }
            } else if (event.widget == this.dataStructureField) {
                String dsName = this.dataStructureField.getText();
                if (dsName != null && !dsName.isEmpty()) {
                    this.setDataStructureName(dsName);
                    this.updateWidgetEnablements();
                }
            } else if (event.widget == this.messageNameField) {
                String msgName = this.messageNameField.getText();
                if (msgName != null && !msgName.isEmpty()) {
                    this.setMessageName(msgName);
                    this.updateWidgetEnablements();
                }
            } else if (event.widget == this.segmentNameField && (segName = this.segmentNameField.getText()) != null && !segName.isEmpty()) {
                this.setSegmentName(segName);
                this.updateWidgetEnablements();
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "handleEvent(Event event)", e);
            logger.error(e);
        }
    }

    private void parseApplicationSourceFile() throws InvocationTargetException, InterruptedException {
        this.sourceFolderStr = this.folderNameField.getText();
        this.sourceFileStr = this.fileNameField.getText();
        this.sourceFileTypeStr = this.sourceTypeField.getText();
        final ImportDSTranMessageMetadataWizardPage wizPage = this;
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                monitor.beginTask(TranMessages.getLabel().getString("IDSW_PARSING") + "...", -1);
                try {
                    ImportDSTranMessageMetadataWizardPage.this.controller.parseApplicationSourceFile(ImportDSTranMessageMetadataWizardPage.this.sourceFolderStr, ImportDSTranMessageMetadataWizardPage.this.sourceFileStr, ImportDSTranMessageMetadataWizardPage.this.sourceFileTypeStr);
                }
                catch (ParseException e) {
                    final String errMsg = e.getMessage();
                    wizPage.getControl().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            String fullPath = (this).ImportDSTranMessageMetadataWizardPage.this.controller.getTempFileName();
                            ImportDSExceptionDialog errorDialog = new ImportDSExceptionDialog(ImportDSTranMessageMetadataWizardPage.this.getShell(), TranMessages.getLabel().getString("IDSW_ERR"), (this).ImportDSTranMessageMetadataWizardPage.this.controller.getImportLanguage(), fullPath, wizPage, (this).ImportDSTranMessageMetadataWizardPage.this.controller.getProjectName());
                            errorDialog.create();
                            errorDialog.setParseErrorMessage(errMsg);
                            errorDialog.setFileContent((this).ImportDSTranMessageMetadataWizardPage.this.controller.readFileToString(new File(fullPath)));
                            errorDialog.getShell().setSize(700, 570);
                            errorDialog.open();
                            ArrayList<FieldType> segModels = errorDialog.getSegmentModels();
                            if (segModels != null && segModels.size() > 0) {
                                String newFileType = errorDialog.getFileType();
                                (this).ImportDSTranMessageMetadataWizardPage.this.controller.setImportLanguage(newFileType);
                                (this).ImportDSTranMessageMetadataWizardPage.this.controller.updateFileNameToSegmentModelsTable(segModels);
                                (this).ImportDSTranMessageMetadataWizardPage.this.sourceTypeField.setText(newFileType);
                                (this).ImportDSTranMessageMetadataWizardPage.this.dataStructureField.setItems((this).ImportDSTranMessageMetadataWizardPage.this.controller.getDataStructureNames());
                                (this).ImportDSTranMessageMetadataWizardPage.this.parsingInformationExceptionList = errorDialog.getInformationExceptionList();
                                ImportDSTranMessageMetadataWizardPage.this.setMessage(null, 2);
                            } else {
                                (this).ImportDSTranMessageMetadataWizardPage.this.dataStructureField.setItems(new String[0]);
                                (this).ImportDSTranMessageMetadataWizardPage.this.dataStructureField.setEnabled(false);
                                (this).ImportDSTranMessageMetadataWizardPage.this.segmentNameField.setEnabled(false);
                                (this).ImportDSTranMessageMetadataWizardPage.this.associateButton.setEnabled(false);
                                ImportDSTranMessageMetadataWizardPage.this.setMessage(ImportDSTranMessageMetadataWizardPage.this.getParseErrorMessage(), 2);
                                (this).ImportDSTranMessageMetadataWizardPage.this.fileNameField.setFocus();
                            }
                        }
                    });
                }
                catch (Throwable e) {
                    logger.error(e);
                }
                monitor.done();
            }
        };
        new ProgressMonitorDialog(this.getShell()).run(true, true, op);
        this.controller.deleteTempFile();
        this.sourceTypeField.setText(this.controller.getImportLanguage());
        ImportParseException e = this.controller.getImportParseException();
        if (e != null) {
            MessageDialog.openError((Shell)this.getShell(), (String)TranMessages.getLabel().getString("IDSW_ERR"), (String)e.getMessage());
        }
    }

    protected final File getSourceDirectory(String path) {
        return new File(this.getSourceDirectoryName(path));
    }

    private String getSourceDirectoryName(String sourceName) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "getSourceDirectoryName(String sourceName)", new Object[0]);
        Path result = new Path(sourceName.trim());
        result = result.getDevice() != null && result.segmentCount() == 0 ? result.addTrailingSeparator() : result.removeTrailingSeparator();
        logger.exiting(((Object)((Object)this)).getClass().getName(), "getSourceDirectoryName(String sourceName)", new Object[0]);
        return result.toOSString();
    }

    private void setFolderName(String path, boolean isFolder) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "setFolderName(String path)", new Object[0]);
        if (path != null && !path.isEmpty()) {
            String folderName = path;
            if (!isFolder) {
                folderName = path.substring(0, path.lastIndexOf(File.separator));
            }
            String[] currentItems = this.folderNameField.getItems();
            int selectionIndex = -1;
            int i = 0;
            while (i < currentItems.length) {
                if (currentItems[i].equals(folderName)) {
                    selectionIndex = i;
                }
                ++i;
            }
            if (selectionIndex < 0) {
                this.folderNameField.add(folderName);
                this.folderNameField.setText(folderName);
                this.saveFolderValues();
            } else {
                this.restoreFolderValues();
                this.folderNameField.select(selectionIndex);
            }
            this.populateFileCombo(path);
        } else {
            this.fileNameField.removeAll();
        }
        if (isFolder) {
            this.dataStructureField.removeAll();
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "setFolderName(String path)", new Object[0]);
    }

    private void updateWidgetEnablements() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "updateWidgetEnablements()", new Object[0]);
        this.fileNameField.setEnabled(!this.folderNameField.getText().isEmpty());
        if (this.dataStructureField.getItemCount() == 0) {
            return;
        }
        if (this.dataStructureField.getItemCount() == 1) {
            this.dataStructureField.select(0);
        }
        this.dataStructureField.setEnabled(!this.fileNameField.getText().isEmpty() && this.getSourceDirectory() != null);
        this.messageNameField.setEnabled(this.dataStructureField.isEnabled() && !this.dataStructureField.getText().isEmpty());
        this.segmentNameField.setEnabled(this.messageNameField.isEnabled() && !this.messageNameField.getText().isEmpty());
        this.associateButton.setEnabled(this.segmentNameField.isEnabled() && !this.segmentNameField.getText().isEmpty() && this.dataStructureField.isEnabled() && !this.dataStructureField.getText().isEmpty() && this.messageNameField.isEnabled() && !this.messageNameField.getText().isEmpty());
        this.associationTable.setEnabled(this.associationTable.getItemCount() > 0);
        this.removeButton.setEnabled(this.associationTable.getSelectionCount() > 0);
        logger.exiting(((Object)((Object)this)).getClass().getName(), "updateWidgetEnablements()", new Object[0]);
    }

    private void saveFolderValues() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "saveFolderValues()", new Object[0]);
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] sourceNames = settings.getArray(STORE_LOCAL_SOURCE_NAMES_ID);
            if (!this.controller.isLocalImport()) {
                sourceNames = settings.getArray(STORE_HOST_SOURCE_NAMES_ID);
            }
            if (sourceNames == null) {
                sourceNames = new String[]{};
            }
            sourceNames = Utility.addToHistory(sourceNames, this.getSourceDirectoryName());
            if (!this.controller.isLocalImport()) {
                settings.put(STORE_HOST_SOURCE_NAMES_ID, sourceNames);
            } else {
                settings.put(STORE_LOCAL_SOURCE_NAMES_ID, sourceNames);
            }
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "saveFolderValues()", new Object[0]);
    }

    private String restoreFolderValues() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "restoreFolderValues()", new Object[0]);
        this.folderNameField.removeAll();
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            String[] sourceNames = settings.getArray(STORE_LOCAL_SOURCE_NAMES_ID);
            if (!this.controller.isLocalImport()) {
                sourceNames = settings.getArray(STORE_HOST_SOURCE_NAMES_ID);
            }
            if (sourceNames == null) {
                return "";
            }
            int i = 0;
            while (i < sourceNames.length) {
                if (!sourceNames[i].isEmpty()) {
                    this.folderNameField.add(sourceNames[i]);
                }
                ++i;
            }
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "restoreFolderValues()", new Object[0]);
        return this.controller.getLastDirectory();
    }

    protected final File getSourceDirectory() {
        return this.getSourceDirectory(this.folderNameField.getText());
    }

    protected String getSourceDirectoryName() {
        if (this.controller.isLocalImport()) {
            return this.getSourceDirectoryName(this.folderNameField.getText());
        }
        return this.folderNameField.getText();
    }

    private void populateFileCombo(String selectedFileFullPath) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "populateFileCombo(String)", new Object[0]);
        String selectedFileName = selectedFileFullPath.substring(selectedFileFullPath.lastIndexOf(File.separator) + 1, selectedFileFullPath.length());
        File folder = this.getSourceDirectory();
        if (folder != null) {
            File[] allFiles = folder.listFiles();
            if (allFiles != null) {
                Vector<String> fileNames = new Vector<String>();
                int i = 0;
                while (i < allFiles.length) {
                    if (allFiles[i].isFile()) {
                        String currentFileName = allFiles[i].getName();
                        fileNames.add(currentFileName);
                    }
                    ++i;
                }
                this.fileNameField.removeModifyListener((ModifyListener)this);
                this.fileNameField.setItems(fileNames.toArray(new String[fileNames.size()]));
                this.fileNameField.addModifyListener((ModifyListener)this);
                if (this.fileNameField.getItems().length == 0) {
                    this.setMessage("", 2);
                } else {
                    this.setMessage(null, 2);
                    this.fileNameField.setText(selectedFileName);
                }
            } else {
                this.setMessage("", 2);
            }
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "populateFileCombo(String)", new Object[0]);
    }

    private void updateImportFromField() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "updateImportFromField()", new Object[0]);
        this.setImportFrom();
        this.updateWidgetEnablements();
        logger.exiting(((Object)((Object)this)).getClass().getName(), "updateImportFromField()", new Object[0]);
    }

    private void setImportFrom() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "setImportFrom()", new Object[0]);
        boolean importFromLocal = true;
        if (this.importFromField.getText().equals(sourceTypes[1])) {
            importFromLocal = false;
        }
        if (this.controller.isLocalImport() != importFromLocal) {
            this.controller.setLocalImport(importFromLocal);
            if (this.controller.isLocalImport()) {
                this.folderLabel.setText(TranMessages.getLabel().getString("IDSW_SOURCE_FLD_LBL"));
                this.fileLabel.setText(TranMessages.getLabel().getString("IDSW_DS_FILE_LBL"));
            } else {
                this.folderLabel.setText(TranMessages.getLabel().getString("IDSW_SOURCE_PDS_LBL"));
                this.fileLabel.setText(TranMessages.getLabel().getString("IDSW_DS_MEM_LBL"));
            }
            this.fileLabel.getParent().layout();
            this.restoreFolderValues();
            this.setFolderName(null, true);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "setImportFrom()", new Object[0]);
    }

    private void updateSourceTypeField() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "updateSourceTypeField()", new Object[0]);
        this.setSourceType();
        this.updateWidgetEnablements();
        logger.exiting(((Object)((Object)this)).getClass().getName(), "updateSourceTypeField()", new Object[0]);
    }

    private void setSourceType() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "setSourceType()", new Object[0]);
        String importLanguage = this.controller.getImportLanguage();
        if (importLanguage == null || !importLanguage.equals(this.sourceTypeField.getText())) {
            importLanguage = this.sourceTypeField.getText();
            String wizardMessage = this.getMessage();
            if (!this.fileNameField.getText().isEmpty() && wizardMessage != null && (wizardMessage.equals(TranMessages.getError().getString("IDSW_ERR_01")) || wizardMessage.equals(this.getParseErrorMessage()) || wizardMessage.equals(TranMessages.getError().getString("IDSW_ERR_03")))) {
                this.updateFromFileField();
            }
            this.controller.setImportLanguage(importLanguage);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "setSourceType()", new Object[0]);
    }

    private String getParseErrorMessage() {
        MessageFormat formatter = new MessageFormat(TranMessages.getError().getString("IDSW_ERR_04"), Locale.getDefault());
        Object[] messageArguments = new Object[]{this.controller.isCOBOLLanguage() ? "COBOL" : "PL/I", this.fileNameField.getText()};
        return formatter.format(messageArguments);
    }

    private void updateFromFileField() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "updateFromFileField()", new Object[0]);
        this.setFileName(this.fileNameField.getText());
        this.updateWidgetEnablements();
        logger.exiting(((Object)((Object)this)).getClass().getName(), "updateFromFileField()", new Object[0]);
    }

    private void setFileName(String fileName) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "setMemberName(String mName)", new Object[0]);
        if (fileName != null && !fileName.isEmpty()) {
            String[] currentItems = this.fileNameField.getItems();
            int selectionIndex = -1;
            int i = 0;
            while (i < currentItems.length) {
                if (currentItems[i].equals(fileName)) {
                    selectionIndex = i;
                }
                ++i;
            }
            if (selectionIndex < 0) {
                int oldLength = currentItems.length;
                String[] newItems = new String[oldLength + 1];
                System.arraycopy(currentItems, 0, newItems, 0, oldLength);
                newItems[oldLength] = fileName;
                this.fileNameField.setItems(newItems);
                selectionIndex = oldLength;
            }
            this.fileNameField.select(selectionIndex);
            this.populateDataStructureComboModel();
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "setMemberName(String mName)", new Object[0]);
    }

    private void updateFromFolderField() throws PermissionDeniedException, FileNotFoundException, ConnectionException {
        logger.entering(((Object)((Object)this)).getClass().getName(), "updateFromFolderField()", new Object[0]);
        if (this.controller.isLocalImport()) {
            this.setFolderName(this.folderNameField.getText(), true);
            this.updateWidgetEnablements();
        } else {
            this.handlePdsSelected();
            this.updateWidgetEnablements();
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "updateFromFolderField()", new Object[0]);
    }

    private void handlePdsSelected() throws PermissionDeniedException, ConnectionException, FileNotFoundException {
        DataSet dataSet;
        IConnectionService connService;
        IZOSConnectable zosConn;
        this.fileNameField.removeAll();
        String folderPath = this.folderNameField.getText();
        if (folderPath != null) {
            folderPath = folderPath.trim();
        }
        if ((zosConn = (IZOSConnectable)(connService = ConnectionsPlugin.getDefault().getConnectionService()).getConnectable("com.ibm.cics.zos.comm.connection")) != null && zosConn.isConnected() && folderPath != null && !folderPath.isEmpty() && (dataSet = zosConn.getDataSet(folderPath)) instanceof PartitionedDataSet) {
            PartitionedDataSet pds = (PartitionedDataSet)dataSet;
            Vector<Member> memberVector = null;
            if (!this.controller.pdsAlreadyInList(pds)) {
                this.controller.addPds(pds);
                memberVector = new Vector<Member>();
            }
            List memberList = zosConn.getMembers(pds);
            String[] memberNameList = new String[memberList.size()];
            int i = 0;
            while (i < memberList.size()) {
                Member currMember = (Member)memberList.get(i);
                memberNameList[i] = currMember.getName();
                if (memberVector != null) {
                    memberVector.add(currMember);
                }
                ++i;
            }
            this.fileNameField.setItems(memberNameList);
            if (memberVector != null) {
                this.controller.addToAllPdsMembers(pds, memberVector);
            }
        }
    }

    private void populateDataStructureComboModel() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "populateDataStructureComboModel()", new Object[0]);
        try {
            this.parseApplicationSourceFile();
        }
        catch (InvocationTargetException e) {
            logger.error((Throwable)e);
            Warnings warnings = new Warnings(this.getShell(), "ERROR", null, "Parsing source file errors", 1, new String[]{IDialogConstants.OK_LABEL}, 0);
            warnings.setWarnings(e.getMessage() != null ? e.getMessage() : "");
            warnings.open();
            this.dataStructureField.setItems(new String[0]);
            this.dataStructureField.setEnabled(false);
            this.segmentNameField.setEnabled(false);
            this.associateButton.setEnabled(false);
            this.setMessage(this.getParseErrorMessage(), 2);
            this.fileNameField.setFocus();
        }
        catch (InterruptedException e) {
            logger.error((Throwable)e);
            Warnings warnings = new Warnings(this.getShell(), "ERROR", null, "Parsing source file errors", 1, new String[]{IDialogConstants.OK_LABEL}, 0);
            warnings.setWarnings(e.getMessage() != null ? e.getMessage() : "");
            warnings.open();
            this.dataStructureField.setItems(new String[0]);
            this.dataStructureField.setEnabled(false);
            this.segmentNameField.setEnabled(false);
            this.associateButton.setEnabled(false);
            this.setMessage(this.getParseErrorMessage(), 2);
            this.fileNameField.setFocus();
        }
        String[] dsNames = this.controller.getDataStructureNames();
        this.dataStructureField.setItems(dsNames);
        if (dsNames.length > 0) {
            if (dsNames.length == 1) {
                this.dataStructureField.select(0);
            }
            this.setMessage(null, 4);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "populateDataStructureComboModel()", new Object[0]);
    }

    private void populateMessageCombo() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "populateMessageCombo()", new Object[0]);
        ArrayList<String> allMessageNamesList = new ArrayList<String>();
        List messageNames = this.controller.getInputMessageNames();
        for (String messageName : messageNames) {
            allMessageNamesList.add(messageName);
        }
        messageNames = this.controller.getOutputMessageNames();
        for (String messageName : messageNames) {
            allMessageNamesList.add(messageName);
        }
        String[] allMessageNames = allMessageNamesList.toArray(new String[0]);
        this.messageNameField.setItems(allMessageNames);
        if (allMessageNames.length == 1) {
            this.messageNameField.select(0);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "populateMessageCombo()", new Object[0]);
    }

    private void populateSegmentCombo() {
        List segmentNames;
        MessageType mtObject;
        String msgName = this.messageNameField.getText();
        if (msgName != null && !msgName.isEmpty() && (mtObject = this.controller.getMessageType(msgName)) != null && (segmentNames = this.controller.getSegmentNames(mtObject)) != null && segmentNames.size() > 0) {
            this.segmentNameField.setItems(segmentNames.toArray(new String[segmentNames.size()]));
            if (segmentNames.size() == 1) {
                this.segmentNameField.select(0);
            }
            return;
        }
        this.segmentNameField.setItems(new String[]{""});
    }

    private void populateMemberCombo(Vector<Member> selectedMembers) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "populateMemberCombo()", new Object[0]);
        if (selectedMembers != null) {
            String[] memberNames = new String[selectedMembers.size()];
            int i = 0;
            while (i < selectedMembers.size()) {
                memberNames[i] = selectedMembers.get(i).getName();
                ++i;
            }
            this.fileNameField.setItems(memberNames);
            if (this.fileNameField.getItems().length == 0) {
                this.setMessage(TranMessages.getError().getString("IDSW_ERR_02"), 2);
            } else {
                this.setMessage(null, 2);
                this.folderNameField.setEnabled(true);
            }
            this.controller.setLastDirectory(this.folderNameField.getText());
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "populateMemberCombo()", new Object[0]);
    }

    private void handleSourceBrowseButtonPressed() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "handleSourceBrowseButtonPressed()", new Object[0]);
        if (this.controller.isLocalImport()) {
            FileDialog dialog = new FileDialog(new Shell(), 4096);
            dialog.setFilterPath(this.folderNameField.getText() + File.separator);
            dialog.setText(TranMessages.getLabel().getString("IDSW_SELECT_FILE"));
            String selectedFile = dialog.open();
            if (selectedFile != null && this.getSourceDirectory(selectedFile) != null) {
                this.setFolderName(selectedFile, false);
                this.updateWidgetEnablements();
            }
        } else {
            ImportDataSetWizard importDataSetWizard = new ImportDataSetWizard(1, false);
            importDataSetWizard.setCallingWizard(this.getWizard());
            WizardDialog dialog = new WizardDialog(this.getContainer().getShell(), (IWizard)importDataSetWizard);
            dialog.open();
            Vector impliedPdsList = importDataSetWizard.getImpliedPdsList();
            if (impliedPdsList != null && impliedPdsList.size() == 1) {
                Vector selectedMember;
                PartitionedDataSet pds = (PartitionedDataSet)impliedPdsList.get(0);
                if (!this.controller.pdsAlreadyInList(pds)) {
                    this.controller.addPds(pds);
                    HashMap impliedPdsMembers = importDataSetWizard.getImpliedPdsMembers();
                    Vector pds_members = (Vector)impliedPdsMembers.get(pds);
                    this.controller.addToAllPdsMembers(pds, pds_members);
                    this.setDataEntryName(pds.getPath());
                    this.populateMemberCombo(pds_members);
                }
                if ((selectedMember = importDataSetWizard.getSelectedMembers()).size() > 0) {
                    this.fileNameField.setText(((Member)selectedMember.elementAt(0)).getName());
                } else {
                    this.fileNameField.setText("");
                }
                this.updateWidgetEnablements();
            }
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "handleSourceBrowseButtonPressed()", new Object[0]);
    }

    private void handleAssociateButtonPressed() {
        String errorMessage;
        logger.entering(((Object)((Object)this)).getClass().getName(), "handleAssociateButtonPressed()", new Object[0]);
        String dsName = this.dataStructureField.getText();
        String msgName = this.messageNameField.getText();
        String segName = this.segmentNameField.getText();
        String fullPath = this.folderNameField.getText() + File.separator + this.fileNameField.getText();
        if (!this.controller.isLocalImport()) {
            fullPath = this.folderNameField.getText() + "(" + this.fileNameField.getText() + ")";
        }
        if ((errorMessage = this.controller.addAssociation(dsName, msgName, segName, fullPath)) == null) {
            this.refreshTable();
        }
        this.setMessage(errorMessage, 2);
        this.updateWidgetEnablements();
        this.associateButton.setEnabled(false);
        logger.exiting(((Object)((Object)this)).getClass().getName(), "handleAssociateButtonPressed()", new Object[0]);
    }

    private void refreshTable() {
        this.associationTable.removeAll();
        Vector associations = this.controller.getAssociations();
        int i = 0;
        while (i < associations.size()) {
            DataStructureSegmentAssociation currAssoc = (DataStructureSegmentAssociation)associations.get(i);
            TableItem item = new TableItem(this.associationTable, 0);
            item.setText(0, currAssoc.messageName);
            item.setText(1, currAssoc.dataStructure.getName());
            item.setText(2, currAssoc.segmentName);
            item.setText(3, currAssoc.importFile);
            ++i;
        }
    }

    private void handleRemoveButtonPressed() {
        int[] selIdx;
        logger.entering(((Object)((Object)this)).getClass().getName(), "handleRemoveButtonPressed()", new Object[0]);
        int[] nArray = selIdx = this.associationTable.getSelectionIndices();
        int n = selIdx.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            TableItem ti = this.associationTable.getItem(i);
            this.controller.removeAssociation(ti.getText(1), ti.getText(0), ti.getText(2), ti.getText(3));
            ++n2;
        }
        this.associationTable.remove(selIdx);
        this.updateWidgetEnablements();
        this.setMessage(null, 2);
        logger.exiting(((Object)((Object)this)).getClass().getName(), "handleRemoveButtonPressed()", new Object[0]);
    }

    private void setDataStructureName(String path) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "setDataStructureName(String path)", new Object[0]);
        if (path != null && !path.isEmpty()) {
            String[] currentItems = this.dataStructureField.getItems();
            int selectionIndex = -1;
            int i = 0;
            while (i < currentItems.length) {
                if (currentItems[i].equals(path)) {
                    selectionIndex = i;
                }
                ++i;
            }
            if (selectionIndex < 0) {
                int oldLength = currentItems.length;
                String[] newItems = new String[oldLength + 1];
                System.arraycopy(currentItems, 0, newItems, 0, oldLength);
                newItems[oldLength] = path;
                this.dataStructureField.setItems(newItems);
                selectionIndex = oldLength;
            }
            this.dataStructureField.select(selectionIndex);
            if (this.messageNameField.getItemCount() == 0) {
                this.populateMessageCombo();
            }
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "setDataStructureName(String path)", new Object[0]);
    }

    private void updateFromSegmentField() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "updateFromSegmentField()", new Object[0]);
        this.setSegmentName(this.segmentNameField.getText());
        this.updateWidgetEnablements();
        logger.exiting(((Object)((Object)this)).getClass().getName(), "updateFromSegmentField()", new Object[0]);
    }

    private void setSegmentName(String segmentName) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "setSegmentName(String segmentName)", new Object[0]);
        if (segmentName.length() > 0) {
            String[] currentItems = this.segmentNameField.getItems();
            int selectionIndex = -1;
            int i = 0;
            while (i < currentItems.length) {
                if (currentItems[i].equals(segmentName)) {
                    selectionIndex = i;
                }
                ++i;
            }
            if (selectionIndex < 0) {
                int oldLength = currentItems.length;
                String[] newItems = new String[oldLength + 1];
                System.arraycopy(currentItems, 0, newItems, 0, oldLength);
                newItems[oldLength] = segmentName;
                this.segmentNameField.setItems(newItems);
                selectionIndex = oldLength;
            }
            this.segmentNameField.select(selectionIndex);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "setSegmentName(String segmentName)", new Object[0]);
    }

    private void setMessageName(String messageName) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "setMessagetName(String messageName)", new Object[0]);
        if (messageName.length() > 0) {
            String[] currentItems = this.messageNameField.getItems();
            int selectionIndex = -1;
            int i = 0;
            while (i < currentItems.length) {
                if (currentItems[i].equals(messageName)) {
                    selectionIndex = i;
                    break;
                }
                ++i;
            }
            if (selectionIndex < 0) {
                int oldLength = currentItems.length;
                String[] newItems = new String[oldLength + 1];
                System.arraycopy(currentItems, 0, newItems, 0, oldLength);
                newItems[oldLength] = messageName;
                this.messageNameField.setItems(newItems);
                selectionIndex = oldLength;
            }
            this.messageNameField.select(selectionIndex);
            this.populateSegmentCombo();
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "setMessagetName(String messageName)", new Object[0]);
    }

    public Table getAssociationTable() {
        return this.associationTable;
    }

    private void setDataEntryName(String dePath) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "setDataEntryName(String path)", new Object[0]);
        if (dePath != null && !dePath.isEmpty()) {
            String[] currentItems = this.folderNameField.getItems();
            int selectionIndex = -1;
            int i = 0;
            while (i < currentItems.length) {
                if (currentItems[i].equals(dePath)) {
                    selectionIndex = i;
                    break;
                }
                ++i;
            }
            if (selectionIndex < 0) {
                this.folderNameField.add(dePath);
                this.folderNameField.setText(dePath);
                this.saveFolderValues();
            } else {
                this.restoreFolderValues();
                this.folderNameField.select(selectionIndex);
            }
        } else {
            this.fileNameField.removeAll();
        }
        this.dataStructureField.removeAll();
        logger.exiting(((Object)((Object)this)).getClass().getName(), "setDataEntryName(String path)", new Object[0]);
    }

    public TranDataStructureController getController() {
        return this.controller;
    }
}

