/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.transaction.wizard.importds;

import com.ibm.im.ims.transaction.controller.datastructure.DataStructureSegmentAssociation;
import com.ibm.im.ims.transaction.controller.datastructure.TranDataStructureController;
import com.ibm.im.ims.workbench.transaction.Activator;
import com.ibm.im.ims.workbench.transaction.editors.TransactionEditorPage;
import com.ibm.im.ims.workbench.transaction.resources.utilities.TranMessages;
import com.ibm.im.ims.workbench.transaction.wizard.importds.ImportDSTranMessageMetadataWizardPage;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.Vector;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;

public class ImportDSTranMessageMetadataWizard
extends Wizard {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    protected static final String STORE_IMPORT_DATA_STRUCTURE_ID = "ImportDSTranMessageMetadataWizard.STORE_IMPORT_DATA_STRUCTURE_ID";
    private static final String STORE_LAST_FOLDER_ID = "ImportDSTranMessageMetadataWizard.STORE_LAST_FOLDER_ID";
    private static final String STORE_LAST_SOURCE_TYPE_ID = "ImportDSTranMessageMetadataWizard.STORE_LAST_SOURCE_TYPE_ID";
    private static final String STORE_LAST_SOURCE_LANGUAGE_ID = "ImportDSTranMessageMetadataWizard.STORE_LAST_SOURCE_LANGUAGE_ID";
    private ImportDSTranMessageMetadataWizardPage page;
    private TranDataStructureController controller;
    private Vector<DataStructureSegmentAssociation> importResult;
    private boolean isLocalSource;
    private String importLanguage;
    private String lastDirectory;

    public Vector<DataStructureSegmentAssociation> getImportResult() {
        return this.importResult;
    }

    public ImportDSTranMessageMetadataWizard(TransactionEditorPage parentEditor, String selectedMessageName, String selectedSegmentName) {
        this.setWindowTitle(TranMessages.getLabel().getString("IDSW_WINDOW_TITLE"));
        this.restoreWidgetValues();
        this.controller = new TranDataStructureController(parentEditor.getController().getTran(), parentEditor.getParent().getProjectName(), this.isLocalSource, this.importLanguage, this.lastDirectory, selectedMessageName, selectedSegmentName);
    }

    public void addPages() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "addPages()", new Object[0]);
        try {
            this.page = new ImportDSTranMessageMetadataWizardPage(TranMessages.getLabel().getString("IDSW_TITLE"), this.controller);
            this.addPage((IWizardPage)this.page);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "addPages()", e);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "addPages()", new Object[0]);
    }

    public boolean performFinish() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "performFinish()", new Object[0]);
        this.saveWidgetValues();
        Vector dssaList = this.controller.getAssociations();
        int i = 0;
        while (i < dssaList.size()) {
            DataStructureSegmentAssociation currDssa = (DataStructureSegmentAssociation)dssaList.get(i);
            String collideName = currDssa.dataStructure.getName();
            if (currDssa.nameCollision) {
                Object[] inserts = new Object[]{collideName};
                if (MessageDialog.openQuestion((Shell)this.getShell(), (String)TranMessages.getLabel().getString("TNT_REPLACE_DIALOG_TITLE"), (String)TranMessages.getDescription().getString("ITMW_CONFIRM", inserts))) {
                    currDssa.replace = true;
                }
            }
            ++i;
        }
        this.controller.doFinishModel();
        this.importResult = this.controller.getAssociations();
        logger.exiting(((Object)((Object)this)).getClass().getName(), "performFinish()", new Object[0]);
        return true;
    }

    private void restoreWidgetValues() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            this.isLocalSource = settings.getBoolean(STORE_LAST_SOURCE_TYPE_ID);
            this.importLanguage = settings.get(STORE_LAST_SOURCE_LANGUAGE_ID);
            this.lastDirectory = settings.get(STORE_LAST_FOLDER_ID);
        }
        if (this.importLanguage == null) {
            this.isLocalSource = true;
            this.importLanguage = TranDataStructureController.sourceLanguages[0];
            this.lastDirectory = "";
        }
    }

    private void saveWidgetValues() {
        this.isLocalSource = this.controller.isLocalImport();
        this.importLanguage = this.controller.getImportLanguage();
        this.lastDirectory = this.controller.getLastDirectory();
        IDialogSettings settings = this.getDialogSettings();
        if (settings != null) {
            settings.put(STORE_LAST_SOURCE_TYPE_ID, this.isLocalSource);
            settings.put(STORE_LAST_SOURCE_LANGUAGE_ID, this.importLanguage);
            settings.put(STORE_LAST_FOLDER_ID, this.lastDirectory);
        }
    }

    public IDialogSettings getDialogSettings() {
        return ImportDSTranMessageMetadataWizard.getDialogSettings(STORE_IMPORT_DATA_STRUCTURE_ID);
    }

    public static IDialogSettings getDialogSettings(String sectionID) {
        Activator plugin = Activator.getDefault();
        IDialogSettings settings = plugin.getDialogSettings();
        if (settings == null) {
            settings = plugin.getDialogSettings().addNewSection(sectionID);
        } else {
            settings = plugin.getDialogSettings().getSection(sectionID);
            if (settings == null) {
                settings = plugin.getDialogSettings().addNewSection(sectionID);
            }
        }
        return settings;
    }
}

