/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.transaction.wizard.importds;

import com.ibm.im.ims.metadata.transaction.FieldType;
import com.ibm.im.ims.transaction.controller.datastructure.InformationException;
import com.ibm.im.ims.transaction.controller.datastructure.TranDataStructureController;
import com.ibm.im.ims.transaction.controller.datastructure.TranDataStructureParser;
import com.ibm.im.ims.transaction.model.utilities.ParseException;
import com.ibm.im.ims.transaction.model.utilities.Utility;
import com.ibm.im.ims.workbench.transaction.resources.utilities.TranMessages;
import com.ibm.im.ims.workbench.transaction.utilities.UIHelper;
import com.ibm.im.ims.workbench.transaction.wizard.importds.ImportDSTranMessageMetadataWizardPage;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ImportDSExceptionDialog
extends Dialog
implements Listener,
ModifyListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    String dialogTitle;
    String[] dialogButtonLabels;
    int defaultIndex;
    private ImportDSTranMessageMetadataWizardPage impDSWizPage;
    private static final int margin = 5;
    private Exception currentException;
    private Label messageLbl;
    private Label fileTypeLbl;
    private Label requireFileLabel;
    private Label imageLbl;
    private Combo fileTypeCombo;
    private Button reParse;
    private Text sourceFile;
    private Text parseError;
    private UIHelper uih;
    private String fileType;
    private String projectName;
    private ArrayList<FieldType> segModels;
    private Vector<InformationException> parsingInformationExceptionList;
    private static final String SUCCESS_MSG = TranMessages.getLabel().getString("IDSW_SUCCESSFUL");
    private static final String REPARSE_BUTTON = TranMessages.getLabel().getString("IDSW_REPARSE_BUTTON");
    private String fileName;

    public ImportDSExceptionDialog(Shell parentShell, String dialogTitle, String fileType, String fileName, ImportDSTranMessageMetadataWizardPage impDSWizPage, String projectName) {
        super(parentShell);
        this.dialogTitle = dialogTitle;
        this.fileType = fileType;
        this.fileName = fileName;
        this.impDSWizPage = impDSWizPage;
        this.projectName = projectName;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.dialogTitle);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Control createDialogArea(Composite dialogParent) {
        Composite parent = (Composite)super.createDialogArea(dialogParent);
        GridData gd = new GridData(4, 4, true, true, 1, 1);
        parent.setLayoutData((Object)gd);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        parent.setLayout((Layout)formLayout);
        this.uih = new UIHelper();
        Display display = parent.getDisplay();
        this.uih.setDisplay(display);
        FormData fd_img = this.uih.genFormData(new FormAttachment(0, 10), null, new FormAttachment(0, 10), null);
        this.imageLbl = new Label(parent, 64);
        this.imageLbl.setImage(display.getSystemImage(1));
        this.imageLbl.setLayoutData((Object)fd_img);
        FormData fd_msg = this.uih.genFormData(new FormAttachment(0, 10), null, new FormAttachment((Control)this.imageLbl, 10), new FormAttachment(100, -5));
        this.messageLbl = new Label(parent, 64);
        String newFileName = this.fileName.substring(this.fileName.lastIndexOf(File.separator) + 1);
        Object[] inserts = new Object[]{newFileName.lastIndexOf(".") >= 0 ? newFileName.substring(0, newFileName.lastIndexOf(".")) : newFileName};
        if (this.impDSWizPage.getController().isLocalImport()) {
            FALSE_MSG = TranMessages.getError().getString("IDSW_ERR_FILE", inserts);
            this.setMessageLbl(FALSE_MSG, true);
        } else {
            FALSE_MSG = TranMessages.getError().getString("IDSW_ERR_MEM", inserts);
            this.setMessageLbl(FALSE_MSG, true);
        }
        this.imageLbl.setLayoutData((Object)fd_img);
        this.messageLbl.setLayoutData((Object)fd_msg);
        FormData fd0 = this.uih.genFormData(new FormAttachment((Control)this.messageLbl, 30), null, new FormAttachment(0, 0), null);
        this.requireFileLabel = this.uih.genRequiredSymbol(parent, 0, fd0, parent.getDisplay().getSystemColor(3));
        FormData fd1 = this.uih.genFormData(new FormAttachment((Control)this.messageLbl, 30), null, new FormAttachment((Control)this.requireFileLabel, 5), null);
        this.fileTypeLbl = new Label(parent, 0);
        this.fileTypeLbl.setText(TranMessages.getLabel().getString("IDSW_FILE_TYPE_LBL"));
        this.fileTypeLbl.setToolTipText(TranMessages.getLabel().getString("IDSW_FILE_TYPE_LBL"));
        this.fileTypeLbl.setLayoutData((Object)fd1);
        FormData fd2 = this.uih.genFormData(new FormAttachment((Control)this.messageLbl, 30), null, new FormAttachment((Control)this.fileTypeLbl, 20), null);
        this.fileTypeCombo = new Combo(parent, 2056);
        this.fileTypeCombo.setLayoutData((Object)fd2);
        this.fileTypeCombo.setItems(TranDataStructureController.sourceLanguages);
        this.fileTypeCombo.setText(this.fileType);
        this.fileTypeCombo.setToolTipText(this.fileType);
        this.fileTypeCombo.addModifyListener((ModifyListener)this);
        FormData fd3 = this.uih.genFormData(new FormAttachment((Control)this.messageLbl, 30), null, new FormAttachment((Control)this.fileTypeCombo, 20), null);
        this.reParse = new Button(parent, 8);
        this.reParse.setText(REPARSE_BUTTON);
        this.reParse.setToolTipText(REPARSE_BUTTON);
        this.reParse.setLayoutData((Object)fd3);
        this.reParse.setEnabled(true);
        this.reParse.addListener(13, (Listener)this);
        FormData fd4 = this.uih.genFormData(new FormAttachment((Control)this.fileTypeCombo, 25), new FormAttachment((Control)this.fileTypeCombo, 200), new FormAttachment(0, 0), new FormAttachment(100, -5));
        Group srcGroup = new Group(parent, 0);
        srcGroup.setText(TranMessages.getLabel().getString("IDSW_SOURCE_CONTENT"));
        srcGroup.setToolTipText(TranMessages.getLabel().getString("IDSW_SOURCE_CONTENT"));
        srcGroup.setLayoutData((Object)fd4);
        srcGroup.setLayout((Layout)new FillLayout());
        this.sourceFile = new Text((Composite)srcGroup, 2890);
        this.sourceFile.setBackground(this.getShell().getDisplay().getSystemColor(1));
        this.sourceFile.setText("");
        FormData fd5 = this.uih.genFormData(new FormAttachment((Control)srcGroup, 25), new FormAttachment((Control)srcGroup, 320), new FormAttachment(0, 0), new FormAttachment(100, -5));
        Group errGroup = new Group(parent, 0);
        errGroup.setText(TranMessages.getLabel().getString("IDSW_PARSE_ERROR"));
        errGroup.setToolTipText(TranMessages.getLabel().getString("IDSW_PARSE_ERROR"));
        errGroup.setLayoutData((Object)fd5);
        errGroup.setLayout((Layout)new FillLayout());
        this.parseError = new Text((Composite)errGroup, 2890);
        this.parseError.setBackground(this.getShell().getDisplay().getSystemColor(1));
        this.parseError.setText("");
        parent.pack();
        return parent;
    }

    public void modifyText(ModifyEvent e) {
        if (e.widget == this.fileTypeCombo) {
            this.fileTypeCombo.setToolTipText(this.fileTypeCombo.getText());
            this.updateFileType();
        }
    }

    public void handleEvent(Event event) {
        if (event.widget == this.reParse) {
            this.handleReParse();
        }
    }

    private void handleReParse() {
        block8: {
            logger.entering(((Object)((Object)this)).getClass().getName(), "handleReParse()", new Object[0]);
            IFile newFile = null;
            try {
                this.currentException = null;
                IRunnableWithProgress op = new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        monitor.beginTask("Reparsing the source.", -1);
                        try {
                            ImportDSExceptionDialog.this.changeFileExt();
                            TranDataStructureParser parser = new TranDataStructureParser(ImportDSExceptionDialog.this.impDSWizPage.getController());
                            ImportDSExceptionDialog.this.segModels = TranDataStructureController.isCOBOLFile((String)ImportDSExceptionDialog.this.fileName) ? TranDataStructureController.handleCOBOLFile((String)ImportDSExceptionDialog.this.fileName, (TranDataStructureParser)parser, (String)ImportDSExceptionDialog.this.projectName) : TranDataStructureController.handlePLIFile((String)ImportDSExceptionDialog.this.fileName, (TranDataStructureParser)parser, (String)ImportDSExceptionDialog.this.projectName);
                            ImportDSExceptionDialog.this.parsingInformationExceptionList = parser.getInformationExceptionList();
                        }
                        catch (Exception e) {
                            ImportDSExceptionDialog.this.currentException = e;
                        }
                        monitor.done();
                    }
                };
                new ProgressMonitorDialog(this.getShell()).run(true, true, op);
                if (this.currentException != null) {
                    throw this.currentException;
                }
                this.setMessageLbl(SUCCESS_MSG, false);
                this.fileTypeCombo.setEnabled(false);
                Utility.deleteTempFile(newFile);
            }
            catch (ParseException e) {
                String errorMessage = e.getMessage();
                this.setParseErrorMessage(errorMessage);
                Utility.deleteTempFile(newFile);
                break block8;
            }
            catch (Throwable e) {
                try {
                    logger.throwing(((Object)((Object)this)).getClass().getName(), "handleReParse()", e);
                    logger.error(e);
                    break block8;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    Utility.deleteTempFile(newFile);
                }
            }
            Utility.deleteTempFile(newFile);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "handleReParse()", new Object[0]);
    }

    private void changeFileExt() throws CoreException, IOException {
        String currFileType = null;
        String lowerCaseFileName = this.fileName.toLowerCase();
        if (lowerCaseFileName.indexOf(".cbl") > 0) {
            currFileType = TranDataStructureController.COBOL_PROG;
        } else if (lowerCaseFileName.indexOf(".cpy") > 0) {
            currFileType = TranDataStructureController.COBOL_DS;
        } else if (lowerCaseFileName.indexOf(".pli") > 0) {
            currFileType = TranDataStructureController.PLI_PROG;
        } else if (lowerCaseFileName.indexOf(".inc") > 0) {
            currFileType = TranDataStructureController.PLI_DS;
        }
        if (!currFileType.equals(this.fileType)) {
            String shortFileName = TranDataStructureController.getShortFileName((String)this.fileName);
            if (TranDataStructureController.isFileInProjectDir((String)this.projectName, (String)shortFileName)) {
                IWorkspaceRoot wsRoot = ResourcesPlugin.getWorkspace().getRoot();
                IProject project = wsRoot.getProject(this.projectName);
                IFile origFile = project.getFile(shortFileName);
                IFile targetTempFile = TranDataStructureController.getTempFile((String)this.projectName, (String)TranDataStructureController.getTempFileName((String)this.fileType, (String)TranDataStructureController.massageFileName((String)shortFileName)));
                if (targetTempFile.exists()) {
                    targetTempFile.delete(true, null);
                }
                TranDataStructureController.moveFile((String)this.projectName, (IFile)origFile, (IFile)targetTempFile);
                this.fileName = targetTempFile.getRawLocation().toOSString();
                logger.info("Temp file for import: " + targetTempFile.getFullPath().toOSString(), new Object[0]);
            } else {
                IFile tempFile = TranDataStructureController.createTempFile((String)this.projectName, (String)this.fileType, (String)this.fileName, (String)shortFileName);
                this.fileName = tempFile.getRawLocation().toOSString();
                logger.info("Temp file for import: " + tempFile.getLocation().toOSString(), new Object[0]);
            }
        }
    }

    protected Vector<InformationException> getInformationExceptionList() {
        return this.parsingInformationExceptionList;
    }

    public void setFileContent(String fileContent) {
        this.sourceFile.setText(fileContent);
    }

    public void setParseErrorMessage(String parseErrorMessage) {
        this.parseError.setText(parseErrorMessage);
    }

    private void updateFileType() {
        this.fileType = this.fileTypeCombo.getText();
        this.parseError.setText("");
    }

    private void setMessageLbl(String message, boolean isError) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "setMessageLbl(String message, boolean isError)", new Object[0]);
        this.messageLbl.setText(message);
        if (isError) {
            this.imageLbl.setImage(this.imageLbl.getParent().getDisplay().getSystemImage(1));
        } else {
            this.imageLbl.setImage(this.imageLbl.getParent().getDisplay().getSystemImage(2));
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "updateFileType()", new Object[0]);
    }

    public boolean isSuccessful() {
        return this.parseError.getText() != null && this.parseError.getText().length() == 0;
    }

    public ArrayList<FieldType> getSegmentModels() {
        return this.segModels;
    }

    public String getFileType() {
        return this.fileType;
    }

    protected void okPressed() {
        try {
            this.deleteTempFile();
        }
        catch (CoreException e) {
            logger.error((Throwable)e);
        }
        super.okPressed();
    }

    public boolean close() {
        try {
            this.deleteTempFile();
        }
        catch (CoreException e) {
            logger.error((Throwable)e);
        }
        return super.close();
    }

    private void deleteTempFile() throws CoreException {
        String shortFileName = TranDataStructureController.getShortFileName((String)this.fileName);
        IFile iFile = TranDataStructureController.getTempFile((String)this.projectName, (String)shortFileName);
        Utility.deleteTempFile((IFile)iFile);
    }
}

