/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.transaction.wizard.editmessagepair;

import com.ibm.im.ims.metadata.testcase.InteractionType;
import com.ibm.im.ims.transaction.controller.editor.TestcaseEditorController;
import com.ibm.im.ims.workbench.transaction.common.ui.InteractionSpecComposite;
import com.ibm.im.ims.workbench.transaction.resources.utilities.TranMessages;
import com.ibm.im.ims.workbench.transaction.testcase.model.IOMessagePairNode;
import com.ibm.im.ims.workbench.transaction.utilities.UIHelper;
import com.ibm.im.ims.workbench.transaction.utilities.Utility;
import com.ibm.im.ims.workbench.transaction.wizard.editmessagepair.EditMessagePairWizard;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class EditMessagePairWizardPage
extends WizardPage
implements VerifyListener,
ModifyListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private Text textMessageName;
    private UIHelper uih;
    private IOMessagePairNode msgPairNode;
    private boolean addNewMessage;
    private InteractionType interaction = new InteractionType();
    private InteractionSpecComposite interactionComposite;

    public EditMessagePairWizardPage(String pageName, IOMessagePairNode msgPairNode) {
        super(pageName);
        this.setTitle(pageName);
        this.setImageDescriptor(Utility.getImageDescriptor("message_unit_wizard_64.gif"));
        this.uih = new UIHelper();
        this.msgPairNode = msgPairNode;
        this.addNewMessage = msgPairNode == null;
    }

    public void createControl(Composite parent) {
        try {
            Display display = parent.getDisplay();
            this.uih.setDisplay(display);
            IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
            helpSystem.setHelp((Control)parent, "com.ibm.im.ims.workbench.transaction.edit_messagepair_wizard");
            int[] labelSizes = new int[]{Utility.getTextWidth(parent, 0, TranMessages.getLabel().getString("EMP_MESSAGE_NAME")), Utility.getTextWidth(parent, 0, TranMessages.getLabel().getString("EMP_REMARKS"))};
            int colonWidth = Utility.getTextWidth(parent, 0, TranMessages.getColon().getString("COLON"));
            int labelWidth1 = Utility.getMaxSize(labelSizes) + colonWidth;
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)new GridLayout(3, false));
            composite.setFont(parent.getFont());
            Label requiredLabel = new Label(composite, 0);
            requiredLabel.setText("*");
            requiredLabel.setForeground(this.uih.red);
            GridData gd = new GridData(36);
            requiredLabel.setLayoutData((Object)gd);
            Label labelMessageName = new Label(composite, 0);
            labelMessageName.setText(TranMessages.getLabel().getString("EMP_MESSAGE_NAME") + TranMessages.getColon().getString("COLON"));
            gd = new GridData(36);
            gd.widthHint = labelWidth1;
            gd.horizontalIndent = -5;
            labelMessageName.setLayoutData((Object)gd);
            this.textMessageName = new Text(composite, 2048);
            gd = new GridData(768);
            gd.horizontalIndent = -10;
            this.textMessageName.setLayoutData((Object)gd);
            this.textMessageName.addVerifyListener((VerifyListener)this);
            this.cloneInteractionType();
            Composite tempComposite = new Composite(composite, 0);
            tempComposite.setLayout((Layout)new GridLayout(1, true));
            tempComposite.setFont(composite.getFont());
            gd = new GridData(1808);
            gd.verticalIndent = -20;
            gd.horizontalSpan = 3;
            tempComposite.setLayoutData((Object)gd);
            this.interactionComposite = new InteractionSpecComposite(tempComposite, false, this.interaction);
            ModifyListener modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent arg0) {
                    EditMessagePairWizardPage.this.setPageComplete(EditMessagePairWizardPage.this.validatePage());
                }
            };
            this.interactionComposite.addChildListener((Control)tempComposite, modifyListener);
            if (!this.addNewMessage) {
                this.textMessageName.setText(this.msgPairNode.getName());
            }
            this.setPageComplete(false);
            this.initialize();
            this.setControl((Control)composite);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", e);
            logger.error(e);
        }
    }

    public InteractionType getInteractionType() {
        return this.interaction;
    }

    private void cloneInteractionType() {
        if (!this.addNewMessage) {
            InteractionType oldInteraction = this.msgPairNode.getMessagePair().getInteraction();
            this.interaction.setAckNakProvider(oldInteraction.getAckNakProvider());
            this.interaction.setCommitMode(oldInteraction.getCommitMode());
            this.interaction.setImsConnectCodepage(oldInteraction.getImsConnectCodepage());
            this.interaction.setImsConnectTimeout(oldInteraction.getImsConnectTimeout());
            this.interaction.setImsConnectUserMessageExitIdentifier(oldInteraction.getImsConnectUserMessageExitIdentifier());
            this.interaction.setImsDatastoreName(oldInteraction.getImsDatastoreName());
            this.interaction.setInputMessageDataSegmentsIncludeLlzzAndTrancode(oldInteraction.isInputMessageDataSegmentsIncludeLlzzAndTrancode());
            this.interaction.setOutputMessageDataSegmentsIncludeLlzz(oldInteraction.isOutputMessageDataSegmentsIncludeLlzz());
            this.interaction.setInputMessageOptions(oldInteraction.getInputMessageOptions());
            this.interaction.setInteractionTimeout(oldInteraction.getInteractionTimeout());
            this.interaction.setInteractionTypeDescription(oldInteraction.getInteractionTypeDescription());
            this.interaction.setLtermOverrideName(oldInteraction.getLtermOverrideName());
            this.interaction.setName(oldInteraction.getName());
            this.interaction.setPurgeUndeliverableOutput(oldInteraction.isPurgeUndeliverableOutput());
            this.interaction.setRacfApplName(oldInteraction.getRacfApplName());
            this.interaction.setRacfGroupName(oldInteraction.getRacfGroupName());
            this.interaction.setRacfUserId(oldInteraction.getRacfUserId());
            this.interaction.setRerouteName(oldInteraction.getRerouteName());
            this.interaction.setRerouteUndeliverableOutput(oldInteraction.isRerouteUndeliverableOutput());
            this.interaction.setResponseIncludesLlll(oldInteraction.isResponseIncludesLlll());
            this.interaction.setResumeTpipeAlternateClientId(oldInteraction.getResumeTpipeAlternateClientId());
            this.interaction.setResumeTpipeProcessing(oldInteraction.getResumeTpipeProcessing());
            this.interaction.setReturnMfsModname(oldInteraction.isReturnMfsModname());
            this.interaction.setSyncLevel(oldInteraction.getSyncLevel());
        }
    }

    private EditMessagePairWizard getWiz() {
        return (EditMessagePairWizard)this.getWizard();
    }

    private void initialize() throws CoreException {
        this.textMessageName.addModifyListener((ModifyListener)this);
    }

    public String getMessagePairName() {
        return this.textMessageName.getText();
    }

    public String getTraceFilePath() {
        return this.interactionComposite.getTraceFilePath();
    }

    private boolean validatePage() {
        boolean retVal = true;
        this.setErrorMessage(null);
        this.setMessage(null);
        TestcaseEditorController controller = this.getWiz().getEditorController();
        String msgPairName = this.textMessageName.getText().trim();
        String originalName = null;
        if (!this.addNewMessage) {
            originalName = this.msgPairNode.getName();
        }
        if (msgPairName == null || msgPairName.isEmpty()) {
            this.setMessage(TranMessages.getDescription().getString("TW_DESCRIPTION"));
            retVal = false;
        } else {
            Vector existingMpNames = controller.getIOMPNames();
            if (existingMpNames != null) {
                for (String currName : existingMpNames) {
                    if (originalName != null && originalName.equals(currName) || !msgPairName.equals(currName)) continue;
                    Object[] inserts = new Object[]{TranMessages.getLabel().getString("EMP_MESSAGE_NAME"), msgPairName};
                    this.setErrorMessage(TranMessages.getError().getString("GWEM_ALREADY_EXISTS", inserts));
                    retVal = false;
                    break;
                }
            }
        }
        if (retVal) {
            String errorMessage = this.interactionComposite.getErrorMessage();
            retVal = errorMessage == null || errorMessage.isEmpty();
            this.setErrorMessage(errorMessage);
            if (retVal) {
                controller.setTraceFile(this.interactionComposite.getTraceFilePath());
            }
        }
        return retVal;
    }

    public void verifyText(VerifyEvent e) {
    }

    public void modifyText(ModifyEvent arg0) {
        this.setPageComplete(this.validatePage());
    }
}

