/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.transaction.wizard.editmessagepair;

import com.ibm.im.ims.metadata.testcase.InteractionType;
import com.ibm.im.ims.transaction.controller.editor.TestcaseEditorController;
import com.ibm.im.ims.workbench.transaction.Activator;
import com.ibm.im.ims.workbench.transaction.resources.utilities.TranMessages;
import com.ibm.im.ims.workbench.transaction.testcase.model.IOMessagePairNode;
import com.ibm.im.ims.workbench.transaction.wizard.editmessagepair.EditMessagePairWizardPage;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class EditMessagePairWizard
extends Wizard
implements INewWizard {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private EditMessagePairWizardPage msgPairPage;
    private String msgPairName;
    private boolean addNewMessagePair;
    private IOMessagePairNode msgPairNode;
    private TestcaseEditorController editorController;
    private InteractionType interaction;

    public EditMessagePairWizard(IOMessagePairNode msgPairNode, TestcaseEditorController editorController) {
        this.addNewMessagePair = msgPairNode == null;
        this.setWindowTitle(this.addNewMessagePair ? TranMessages.getDescription().getString("EMP_TITLE_ADD") : TranMessages.getDescription().getString("EMP_TITLE_EDIT"));
        this.editorController = editorController;
        this.msgPairNode = msgPairNode;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        try {
            if (this.addNewMessagePair) {
                String pageTitle = TranMessages.getDescription().getString("EMP_TITLE_ADD");
                this.msgPairPage = new EditMessagePairWizardPage(pageTitle, null);
            } else {
                String pageTitle = TranMessages.getDescription().getString("EMP_TITLE_EDIT");
                this.msgPairPage = new EditMessagePairWizardPage(pageTitle, this.msgPairNode);
            }
            this.addPage((IWizardPage)this.msgPairPage);
            this.msgPairPage.setPageComplete(false);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "addPages()", e);
            logger.error(e);
        }
    }

    public String getMessagePairName() {
        return this.msgPairName;
    }

    public boolean performFinish() {
        try {
            this.msgPairName = this.msgPairPage.getMessagePairName();
            this.interaction = this.msgPairPage.getInteractionType();
            if (!this.addNewMessagePair) {
                this.msgPairNode.getMessagePair().setInteraction(this.interaction);
            }
            IPreferenceStore store = Activator.getDefault().getPreferenceStore();
            store.setValue("IPC_IMS_CONNECT_TRACEFILE", this.msgPairPage.getTraceFilePath());
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "performFinish()", e);
            logger.error(e);
        }
        return true;
    }

    public InteractionType getInteractionType() {
        return this.interaction;
    }

    public TestcaseEditorController getEditorController() {
        return this.editorController;
    }
}

