/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.transaction.wizard.editmessage;

import com.ibm.im.ims.metadata.transaction.MessageType;
import com.ibm.im.ims.metadata.transaction.Transaction;
import com.ibm.im.ims.workbench.transaction.model.TranMessageModel;
import com.ibm.im.ims.workbench.transaction.resources.utilities.TranMessages;
import com.ibm.im.ims.workbench.transaction.utilities.UIHelper;
import com.ibm.im.ims.workbench.transaction.utilities.Utility;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;

public class EditMessageWizardPage
extends WizardPage
implements VerifyListener,
ModifyListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private Label labelRemarks;
    private Label labelMessageName;
    private Text textRemarks;
    private Text textMessageName;
    private static final int margin = 5;
    private UIHelper uih;
    private TranMessageModel msgNode;
    private Transaction tran;
    private int messageType;

    public EditMessageWizardPage(String pageName, Transaction tran, TranMessageModel msgNode, int messageType) {
        super(pageName);
        this.setTitle(pageName);
        this.setDescription(TranMessages.getLabel().getString("EM_TITLE"));
        if (messageType == 0) {
            this.setImageDescriptor(Utility.getImageDescriptor("message_input_wizard_64.gif"));
        } else {
            this.setImageDescriptor(Utility.getImageDescriptor("message_output_wizard_64.gif"));
        }
        this.uih = new UIHelper();
        this.msgNode = msgNode;
        this.tran = tran;
        this.messageType = messageType;
    }

    public void createControl(Composite parent) {
        try {
            Composite composite = new Composite(parent, 0);
            Display display = parent.getDisplay();
            this.uih.setDisplay(display);
            FormLayout layout = new FormLayout();
            layout.marginHeight = 5;
            layout.marginWidth = 5;
            composite.setLayout((Layout)layout);
            composite.setFont(parent.getFont());
            IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
            int[] labelSizes = new int[]{Utility.getTextWidth(composite, 0, TranMessages.getLabel().getString("EM_MESSAGE_NAME")), Utility.getTextWidth(composite, 0, TranMessages.getLabel().getString("EM_REMARKS"))};
            int requiredLabelWidth = Utility.getTextWidth(parent, 0, "*");
            int colonWidth = Utility.getTextWidth(parent, 0, TranMessages.getColon().getString("COLON"));
            int labelWidth = Utility.getMaxSize(labelSizes) + requiredLabelWidth + colonWidth;
            FormData fd1 = this.uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment(0, 0), null);
            this.labelMessageName = this.uih.genRequiredLabel(composite, 16384, TranMessages.getLabel().getString("EM_MESSAGE_NAME") + TranMessages.getColon().getString("COLON"), this.uih.black, fd1);
            FormData fd2 = this.uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment(0, labelWidth), new FormAttachment(100, 0));
            this.textMessageName = new Text(composite, 2048);
            this.textMessageName.setLayoutData((Object)fd2);
            this.textMessageName.addVerifyListener((VerifyListener)this);
            fd1 = this.uih.genFormData(new FormAttachment((Control)this.labelMessageName, 20), null, new FormAttachment(0, 0), null);
            this.labelRemarks = new Label(composite, 0);
            this.labelRemarks.setText(TranMessages.getLabel().getString("EM_REMARKS") + TranMessages.getColon().getString("COLON"));
            this.labelRemarks.pack();
            this.labelRemarks.setLayoutData((Object)fd1);
            fd2 = this.uih.genFormData(new FormAttachment((Control)this.labelMessageName, 20), new FormAttachment(100), new FormAttachment(0, labelWidth), new FormAttachment(100, 0));
            this.textRemarks = new Text(composite, 2114);
            this.textRemarks.setTextLimit(256);
            this.textRemarks.setLayoutData((Object)fd2);
            this.textRemarks.addVerifyListener((VerifyListener)this);
            if (this.msgNode != null) {
                this.textMessageName.setText(this.msgNode.getMessageName());
                String remarks = this.msgNode.getMessageRemarks();
                if (remarks != null && !remarks.isEmpty()) {
                    this.textRemarks.setText(this.msgNode.getMessageRemarks());
                }
            }
            this.setPageComplete(this.validatePage());
            helpSystem.setHelp((Control)composite, "com.ibm.im.ims.workbench.transaction.edit_message_wizard");
            this.initialize();
            this.setControl((Control)composite);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", e);
            logger.error(e);
        }
    }

    private void initialize() throws CoreException {
        this.textMessageName.addModifyListener((ModifyListener)this);
    }

    public String getMessageName() {
        return this.textMessageName.getText();
    }

    public String getRemarks() {
        return this.textRemarks.getText();
    }

    private boolean validatePage() {
        boolean retVal = true;
        this.setErrorMessage(null);
        this.setMessage(null);
        String msgName = this.textMessageName.getText().trim();
        if (msgName == null || msgName.isEmpty()) {
            this.setMessage(TranMessages.getDescription().getString("TW_DESCRIPTION"));
            retVal = false;
        }
        if (retVal) {
            String origMsgName = null;
            if (this.msgNode != null) {
                origMsgName = this.msgNode.getMessageName();
            }
            List msgTypes = null;
            msgTypes = this.messageType == 0 ? this.tran.getInputMessage() : this.tran.getOutputMessage();
            int i = 0;
            while (i < msgTypes.size()) {
                MessageType currMsgType = (MessageType)msgTypes.get(i);
                String currExistingMsgName = currMsgType.getName();
                if (currExistingMsgName.equals(msgName) && !currExistingMsgName.equals(origMsgName)) {
                    Object[] inserts = new Object[]{TranMessages.getLabel().getString("EM_MESSAGE_NAME"), msgName};
                    this.setErrorMessage(TranMessages.getError().getString("GWEM_ALREADY_EXISTS", inserts));
                    retVal = false;
                    break;
                }
                ++i;
            }
        }
        return retVal;
    }

    public void verifyText(VerifyEvent e) {
        try {
            if (e.widget == this.textRemarks) {
                if (e.character == '\t') {
                    e.text = null;
                    this.textRemarks.traverse(16);
                } else if (e.character == '\r') {
                    e.text = null;
                    this.textRemarks.traverse(4, (KeyEvent)e);
                }
            }
        }
        catch (Throwable err) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "verifyText(VerifyEvent event)", err);
            logger.error(err);
        }
    }

    public void modifyText(ModifyEvent arg0) {
        this.setPageComplete(this.validatePage());
    }
}

