/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.transaction.wizard.editdatastructure;

import com.ibm.im.ims.workbench.transaction.model.FieldModel;
import com.ibm.im.ims.workbench.transaction.model.TranDataStructureModel;
import com.ibm.im.ims.workbench.transaction.model.TranTreeObject;
import com.ibm.im.ims.workbench.transaction.resources.utilities.TranMessages;
import com.ibm.im.ims.workbench.transaction.utilities.UIHelper;
import com.ibm.im.ims.workbench.transaction.utilities.Utility;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class EditDataStructureAndFieldWizardPage
extends WizardPage
implements VerifyListener,
ModifyListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private Label labelRemarks;
    private Label labelFieldName;
    private Label labelOriginalName;
    private Text textRemarks;
    private Text textFieldName;
    private Text textOriginalName;
    private static final int margin = 5;
    private UIHelper uih;
    private TranTreeObject field;
    private Vector<String> existingDsNames;
    private static String SOURCE_TYPE;

    public EditDataStructureAndFieldWizardPage(String pageName, TranTreeObject field, Vector<String> existingDsNames) {
        super(pageName);
        this.setTitle(pageName);
        if (field instanceof TranDataStructureModel) {
            this.setDescription(TranMessages.getDescription().getString("EDS_DESC_EDIT"));
            SOURCE_TYPE = TranMessages.getError().getString("EDS_DS_LABEL");
        } else {
            this.setDescription(TranMessages.getDescription().getString("EF_DESC_EDIT"));
            SOURCE_TYPE = TranMessages.getError().getString("EDS_FLD_LABEL");
        }
        this.setImageDescriptor(Utility.getImageDescriptor("transaction_new_wizard_64.gif"));
        this.uih = new UIHelper();
        this.field = field;
        this.existingDsNames = existingDsNames;
        if (existingDsNames != null && field instanceof TranDataStructureModel) {
            TranDataStructureModel dsNode = (TranDataStructureModel)field;
            this.existingDsNames.remove(dsNode.getName());
        }
    }

    public void createControl(Composite parent) {
        try {
            String originalName;
            String remarks;
            String fieldName;
            if (this.field instanceof TranDataStructureModel) {
                TranDataStructureModel dsNode = (TranDataStructureModel)this.field;
                fieldName = dsNode.getField().getName();
                remarks = dsNode.getField().getRemarks();
                originalName = dsNode.getField().getOriginalName();
            } else {
                FieldModel fieldNode = (FieldModel)this.field;
                fieldName = fieldNode.getFieldType().getName();
                remarks = fieldNode.getFieldType().getRemarks();
                originalName = fieldNode.getFieldType().getOriginalName();
            }
            if (originalName == null) {
                originalName = fieldName;
            }
            Composite composite = new Composite(parent, 0);
            Display display = parent.getDisplay();
            this.uih.setDisplay(display);
            FormLayout layout = new FormLayout();
            layout.marginHeight = 5;
            layout.marginWidth = 5;
            composite.setLayout((Layout)layout);
            composite.setFont(parent.getFont());
            int[] labelSizes = new int[]{Utility.getTextWidth(composite, 0, TranMessages.getLabel().getString("EDS_NAME")), Utility.getTextWidth(composite, 0, TranMessages.getLabel().getString("EDS_ORIGINAL_NAME")), Utility.getTextWidth(composite, 0, TranMessages.getLabel().getString("EM_REMARKS"))};
            int requiredLabelWidth = Utility.getTextWidth(parent, 0, "*");
            int colonWidth = Utility.getTextWidth(parent, 0, TranMessages.getColon().getString("COLON"));
            int labelWidth = Utility.getMaxSize(labelSizes) + requiredLabelWidth + colonWidth;
            FormData fd1 = this.uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment(0, 0), null);
            this.labelFieldName = this.uih.genRequiredLabel(composite, 16384, TranMessages.getLabel().getString("EDS_NAME") + TranMessages.getColon().getString("COLON"), this.uih.black, fd1);
            FormData fd2 = this.uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment(0, labelWidth), new FormAttachment(100, 0));
            this.textFieldName = new Text(composite, 2048);
            this.textFieldName.setLayoutData((Object)fd2);
            this.textFieldName.setText(fieldName == null ? "" : fieldName);
            this.textFieldName.addVerifyListener((VerifyListener)this);
            fd1 = this.uih.genFormData(new FormAttachment((Control)this.labelFieldName, 20), null, new FormAttachment(0, 0), null);
            this.labelOriginalName = new Label(composite, 0);
            this.labelOriginalName.setText(TranMessages.getLabel().getString("EDS_ORIGINAL_NAME") + TranMessages.getColon().getString("COLON"));
            this.labelOriginalName.pack();
            this.labelOriginalName.setLayoutData((Object)fd1);
            fd2 = this.uih.genFormData(new FormAttachment((Control)this.labelFieldName, 20), null, new FormAttachment(0, labelWidth), new FormAttachment(100, 0));
            this.textOriginalName = new Text(composite, 2048);
            this.textOriginalName.setLayoutData((Object)fd2);
            this.textOriginalName.setText(originalName);
            this.textOriginalName.setEnabled(false);
            fd1 = this.uih.genFormData(new FormAttachment((Control)this.labelOriginalName, 20), null, new FormAttachment(0, 0), null);
            this.labelRemarks = new Label(composite, 0);
            this.labelRemarks.setText(TranMessages.getLabel().getString("EM_REMARKS") + TranMessages.getColon().getString("COLON"));
            this.labelRemarks.pack();
            this.labelRemarks.setLayoutData((Object)fd1);
            fd2 = this.uih.genFormData(new FormAttachment((Control)this.labelOriginalName, 20), new FormAttachment(100), new FormAttachment(0, labelWidth), new FormAttachment(100, 0));
            this.textRemarks = new Text(composite, 2114);
            this.textRemarks.setTextLimit(256);
            this.textRemarks.setText(remarks == null ? "" : remarks);
            this.textRemarks.setLayoutData((Object)fd2);
            this.textRemarks.addVerifyListener((VerifyListener)this);
            this.setPageComplete(this.validatePage());
            this.initialize();
            this.setControl((Control)composite);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", e);
            logger.error(e);
        }
    }

    private void initialize() throws CoreException {
        this.textFieldName.addModifyListener((ModifyListener)this);
    }

    public String getFieldName() {
        return this.textFieldName.getText();
    }

    public String getRemarks() {
        return this.textRemarks.getText();
    }

    private boolean nameCollision(String name) {
        boolean retVal = false;
        Iterator<String> iter = this.existingDsNames.iterator();
        while (iter.hasNext()) {
            if (!name.equalsIgnoreCase(iter.next())) continue;
            retVal = true;
            break;
        }
        return retVal;
    }

    private boolean validatePage() {
        Object[] inserts;
        boolean retVal = true;
        this.setErrorMessage(null);
        String dsName = this.textFieldName.getText().trim();
        if (dsName == null || dsName.isEmpty()) {
            inserts = new String[]{SOURCE_TYPE};
            this.setErrorMessage(TranMessages.getError().getString("EDS_MISSING_NAME", inserts));
            retVal = false;
        }
        if (retVal && this.existingDsNames != null && this.nameCollision(dsName)) {
            inserts = new String[]{dsName, SOURCE_TYPE};
            this.setErrorMessage(TranMessages.getError().getString("EDS_COLLIDED_NAME", inserts));
            retVal = false;
        }
        return retVal;
    }

    public void verifyText(VerifyEvent e) {
        try {
            if (e.widget == this.textRemarks) {
                if (e.character == '\t') {
                    e.text = null;
                    this.textRemarks.traverse(16);
                } else if (e.character == '\r') {
                    e.text = null;
                    this.textRemarks.traverse(4, (KeyEvent)e);
                }
            }
        }
        catch (Throwable err) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "verifyText(VerifyEvent event)", err);
            logger.error(err);
        }
    }

    public void modifyText(ModifyEvent arg0) {
        this.setPageComplete(this.validatePage());
    }
}

