/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.transaction.utilities;

import com.ibm.im.ims.workbench.transaction.resources.utilities.TranMessages;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class UIHelper {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    public Color gray;
    public Color black;
    public Color red;
    public Color green;
    public final char[] specialChar = new char[]{'<', '>', '&', '/', '\\', '!', '%', '(', ')', '*', '|', '+', '-', ',', '.', ':', ';', '=', '?', '[', ']', '{', '}', '^', '_', '`', '~', ' ', '\"', '\''};
    public final char[] numChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    public final String[] numString = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};

    public void setDisplay(Display display) {
        this.gray = display.getSystemColor(15);
        this.black = display.getSystemColor(2);
        this.red = display.getSystemColor(3);
        this.green = display.getSystemColor(5);
    }

    public Label genLabel(Composite composite, int style, String text, Color color, GridData gridData) {
        Label lbl = new Label(composite, style);
        lbl.setText(text);
        lbl.setForeground(color);
        lbl.setLayoutData((Object)gridData);
        return lbl;
    }

    public Label genLabel(Composite composite, int style, String text, Color color, FormData fd) {
        Label lbl = new Label(composite, style);
        lbl.setText(text);
        lbl.setForeground(color);
        lbl.setLayoutData((Object)fd);
        return lbl;
    }

    public Text genTextField(Composite composite, int style, String text, int limit, GridData gridData, Listener listener, int eventType) {
        Text txt = new Text(composite, style);
        txt.setText(text);
        txt.setTextLimit(limit);
        txt.setLayoutData((Object)gridData);
        txt.addListener(eventType, listener);
        return txt;
    }

    public void enableGroupInput(Group group, boolean enabled) {
        if (group != null) {
            Control[] controlArray = group.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control c = controlArray[n2];
                c.setEnabled(enabled);
                ++n2;
            }
        }
    }

    public Label genRequiredSymbol(Composite composite, int style, FormData fd, Color color) {
        Label req = new Label(composite, style);
        req.setText("*");
        req.setForeground(color);
        req.setLayoutData((Object)fd);
        return req;
    }

    public Label genRequiredLabel(Composite composite, int style, String text, Color color, FormData formData) {
        Label lbl = new Label(composite, style);
        FormData fd = new FormData();
        fd.left = formData.left;
        fd.top = formData.top;
        Label req = new Label(composite, style);
        req.setText("*");
        req.setForeground(this.red);
        req.setLayoutData((Object)fd);
        lbl.setText(text);
        lbl.setForeground(color);
        formData.left = new FormAttachment((Control)req, 1);
        lbl.setLayoutData((Object)formData);
        return lbl;
    }

    public Label genLabel(Composite composite, int style, String text, Color color, FormData formData, boolean isRequired) {
        FormData fd = new FormData();
        fd.top = new FormAttachment(formData.top.control, 10);
        Label req = new Label(composite, style);
        req.setText("*");
        req.setForeground(this.red);
        req.setLayoutData((Object)fd);
        req.setVisible(isRequired);
        Label lbl = new Label(composite, style);
        lbl.setText(text);
        lbl.setForeground(color);
        formData.left = new FormAttachment((Control)req, 1);
        lbl.setLayoutData((Object)formData);
        return lbl;
    }

    public Label genRequiredLabel(Composite composite, int style, String text, Color color, Color bgColor, FormData formData) {
        Label lbl = new Label(composite, style);
        FormData fd = new FormData();
        fd.left = formData.left;
        fd.top = formData.top;
        Label req = new Label(composite, style);
        req.setText("*");
        req.setForeground(this.red);
        req.setBackground(bgColor);
        req.setLayoutData((Object)fd);
        lbl.setText(text);
        lbl.setForeground(color);
        formData.left = new FormAttachment((Control)req, 1);
        lbl.setLayoutData((Object)formData);
        return lbl;
    }

    public Text genTextField(Composite composite, int style, String text, int limit, FormData fd, Listener listener, int eventType) {
        Text txt = new Text(composite, style);
        txt.setText(text);
        txt.setTextLimit(limit);
        txt.setLayoutData((Object)fd);
        txt.addListener(eventType, listener);
        return txt;
    }

    public FormData genFormData(FormAttachment top, FormAttachment bottom, FormAttachment left, FormAttachment right) {
        FormData fd = new FormData();
        if (top != null) {
            fd.top = top;
        }
        if (bottom != null) {
            fd.bottom = bottom;
        }
        if (left != null) {
            fd.left = left;
        }
        if (right != null) {
            fd.right = right;
        }
        return fd;
    }

    public Button getCheckButton(Composite composite, int style, boolean selected, FormData fd) {
        Button button = new Button(composite, style);
        button.setSelection(selected);
        button.setLayoutData((Object)fd);
        return button;
    }

    public Button genButton(Composite composite, int style, boolean selection, String text, int x, int y, int width, int height, FormData formdata) {
        Button button = new Button(composite, style);
        button.setText(text);
        button.setSelection(selection);
        button.setBounds(x, y, width, height);
        button.setLayoutData((Object)formdata);
        return button;
    }

    public void moveUp(Table table, Listener listener) {
        TableItem[] items = table.getItems();
        int numItems = items.length;
        int selected = table.getSelectionIndex();
        logger.info(this.getClass().getName() + ".subseqMoveUp() - selected: " + selected + " - numItems: " + numItems, new Object[0]);
        if (selected < 0 || numItems < 2 || selected == 0) {
            return;
        }
        TableItemInfo[] tiis = new TableItemInfo[items.length];
        int i = 0;
        while (i < items.length) {
            tiis[i] = new TableItemInfo();
            tiis[i].text = items[i].getText();
            tiis[i].checked = items[i].getChecked();
            ++i;
        }
        TableItemInfo temp = tiis[selected - 1];
        tiis[selected - 1] = tiis[selected];
        tiis[selected] = temp;
        table.removeAll();
        int i2 = 0;
        while (i2 < tiis.length) {
            TableItem subSeqTableItem = new TableItem(table, 0);
            subSeqTableItem.setText(tiis[i2].text);
            subSeqTableItem.setChecked(tiis[i2].checked);
            subSeqTableItem.addListener(13, listener);
            ++i2;
        }
        table.setSelection(selected - 1);
    }

    public void moveDown(Table table, Listener listener) {
        TableItem[] items = table.getItems();
        int numItems = items.length;
        int selected = table.getSelectionIndex();
        logger.info(this.getClass().getName() + ".subseqMoveDown() - selected: " + selected + " - numItems: " + numItems, new Object[0]);
        if (selected < 0 || numItems < 2 || selected == numItems - 1) {
            return;
        }
        TableItemInfo[] tiis = new TableItemInfo[items.length];
        int i = 0;
        while (i < items.length) {
            tiis[i] = new TableItemInfo();
            tiis[i].text = items[i].getText();
            tiis[i].checked = items[i].getChecked();
            ++i;
        }
        TableItemInfo temp = tiis[selected];
        tiis[selected] = tiis[selected + 1];
        tiis[selected + 1] = temp;
        table.removeAll();
        int i2 = 0;
        while (i2 < tiis.length) {
            TableItem subSeqTableItem = new TableItem(table, 0);
            subSeqTableItem.setText(tiis[i2].text);
            subSeqTableItem.setChecked(tiis[i2].checked);
            subSeqTableItem.addListener(13, listener);
            ++i2;
        }
        table.setSelection(selected + 1);
    }

    public int getAverageLabelWidth(Label label) {
        Text text = new Text(label.getParent(), label.getStyle());
        text.setText(label.getText());
        text.setFont(label.getFont());
        int retVal = text.computeSize((int)-1, (int)-1).x;
        text.dispose();
        return retVal;
    }

    public int getAverageLabelWidth(Label[] labels) {
        int[] sizes = new int[labels.length];
        int i = 0;
        while (i < labels.length) {
            sizes[i] = this.getAverageLabelWidth(labels[i]);
            ++i;
        }
        return this.getMaxSize(sizes);
    }

    public int getMaxSize(int[] sizes) {
        Arrays.sort(sizes);
        return sizes[sizes.length - 1];
    }

    public Vector<String> getCheckedTableValues(Table table) {
        TableItem[] items = table.getItems();
        Vector<String> retVal = null;
        if (items.length > 0) {
            retVal = new Vector<String>();
            int i = 0;
            while (i < items.length) {
                if (items[i].getChecked()) {
                    retVal.addElement(items[i].getText());
                }
                ++i;
            }
        }
        return retVal;
    }

    public static void displayErrorDialog(Shell shell, String title, Throwable e) {
        Throwable userException = e;
        ArrayList<Status> childStatus = new ArrayList<Status>();
        if (userException == null) {
            userException = new Exception();
        }
        StackTraceElement[] stackTraceElementArray = userException.getStackTrace();
        int n = stackTraceElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            StackTraceElement ele = stackTraceElementArray[n2];
            childStatus.add(new Status(4, "com.ibm.im.ims.workbench.transaction", ele.toString()));
            ++n2;
        }
        MultiStatus status = new MultiStatus("com.ibm.im.ims.workbench.transaction", 4, childStatus.toArray(new IStatus[0]), userException.getMessage(), e);
        String message = TranMessages.getError().getString("UNEXPECTED_ERROR");
        ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
        logger.error(message, e, new Object[0]);
    }

    class TableItemInfo {
        public String text;
        public boolean checked;

        TableItemInfo() {
        }
    }
}

