/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.transaction.utilities;

import com.ibm.im.ims.metadata.transaction.Transaction;
import com.ibm.im.ims.metadata.trantoc.Trantoc;
import com.ibm.im.ims.transaction.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.transaction.model.utilities.TrantocMap;
import com.ibm.im.ims.transaction.model.utilities.TrantocMapManager;
import com.ibm.im.ims.workbench.transaction.editors.MultiPageEditor;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.Vector;
import javax.xml.bind.JAXBException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.PlatformUI;

public class TrantocMapUpdater
implements Runnable {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private Vector<IPath> changedTranFiles;

    public TrantocMapUpdater(Vector<IPath> changedTranFiles) {
        this.changedTranFiles = changedTranFiles;
    }

    @Override
    public void run() {
        try {
            int i = 0;
            while (i < this.changedTranFiles.size()) {
                String tranName;
                IFile file;
                IPath currChangedFile = this.changedTranFiles.get(i);
                String[] segments = currChangedFile.segments();
                String projectName = segments[0];
                String newFileName = segments[2];
                TrantocMap map = TrantocMapManager.getSingletonInstance().getTrantocMap(projectName);
                if (map == null) {
                    map = TrantocMapManager.addTrantocMap((String)projectName);
                }
                if ((file = ProjectTreeFileHelper.getTransactionMetadataFile((String)projectName, (String)(tranName = newFileName.substring(0, newFileName.indexOf(".trn"))))).exists()) {
                    Transaction tran = ProjectTreeFileHelper.unmarshallTran((String)projectName, (String)tranName);
                    map.newTranFileAdded(projectName, tran.getId(), newFileName);
                    IEditorReference[] openEditorRefs = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
                    int j = 0;
                    while (j < openEditorRefs.length) {
                        IEditorPart currEditor = openEditorRefs[j].getEditor(false);
                        if (currEditor instanceof MultiPageEditor) {
                            ((MultiPageEditor)currEditor).transactionFileChanged(tran.getId().intValue());
                        }
                        ++j;
                    }
                } else {
                    map.tranFileRemoved(projectName, newFileName);
                }
                ++i;
            }
        }
        catch (Throwable e) {
            logger.error(e);
        }
    }

    public static void refreshTrantocMapManager() throws CoreException, JAXBException {
        TrantocMapManager mapMgr = TrantocMapManager.getSingletonInstance();
        mapMgr.clearAllMaps();
        TrantocMapUpdater.populateTrantocMapManager();
    }

    public static void populateTrantocMapManager() throws CoreException, JAXBException {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot root = workspace.getRoot();
        IProject[] projects = root.getProjects();
        Vector<String> projectNames = new Vector<String>();
        int i = 0;
        while (i < projects.length) {
            IProjectNature nature;
            IProject project = projects[i];
            if (project.isOpen() && (nature = projects[i].getNature("com.ibm.im.ims.workbench.transaction.nature")) != null) {
                String projName = projects[i].getName();
                projectNames.add(projName);
            }
            ++i;
        }
        TrantocMapManager mapMgr = TrantocMapManager.getSingletonInstance();
        int i2 = 0;
        while (i2 < projectNames.size()) {
            String currProjectName = (String)projectNames.get(i2);
            Trantoc trantoc = ProjectTreeFileHelper.unmarshallTrantoc((String)currProjectName);
            TrantocMap map = new TrantocMap(trantoc);
            mapMgr.putTrantocMap(currProjectName, map);
            ++i2;
        }
    }
}

