/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.transaction.utilities;

import com.ibm.im.ims.transaction.model.utilities.Utility;
import com.ibm.im.ims.workbench.transaction.common.ui.EAMessageControl;
import com.ibm.im.ims.workbench.transaction.resources.utilities.TranMessages;
import com.ibm.im.ims.workbench.transaction.utilities.UIHelper;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RacfInfoDialog
extends MessageDialog
implements VerifyListener,
ModifyListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final int MARGIN = 5;
    private static final int SPACING = 4;
    private static final String IPC_RACF_USERID = TranMessages.getLabel().getString("IPC_RACF_USERID") + TranMessages.getColon().getString("COLON");
    private static final String IPC_RACF_USERID_HOVER = Utility.formatMessage((String)TranMessages.getDescription().getString("IPC_RACF_USERID_HOVER"));
    private static final String IPC_RACF_PASSWORD = TranMessages.getLabel().getString("IPC_RACF_PASSWORD") + TranMessages.getColon().getString("COLON");
    private static final String IPC_RACF_PASSWORD_HOVER = Utility.formatMessage((String)TranMessages.getDescription().getString("IPC_RACF_PASSWORD_HOVER"));
    private static final String IPC_RACF_GROUP_NAME = TranMessages.getLabel().getString("IPC_RACF_GROUP_NAME") + TranMessages.getColon().getString("COLON");
    private static final String IPC_RACF_GROUP_NAME_HOVER = Utility.formatMessage((String)TranMessages.getDescription().getString("IPC_RACF_GROUP_NAME_HOVER"));
    private static final String IPC_RACF_APPL_NAME = TranMessages.getLabel().getString("IPC_RACF_APPL_NAME") + TranMessages.getColon().getString("COLON");
    private static final String IPC_RACF_APPL_NAME_HOVER = Utility.formatMessage((String)TranMessages.getDescription().getString("IPC_RACF_APPL_NAME_HOVER"));
    private static final String IPC_RACF_APPL_NAME_LABEL_HOVER = Utility.formatMessage((String)TranMessages.getDescription().getString("IPC_RACF_APPL_NAME_LABEL_HOVER"));
    private Text racfUserId;
    private Text racfPassword;
    private Text racfGroupName;
    private Text racfApplName;
    private int racfReturnCode;
    private String userId;
    private String password;
    private String groupName;
    private String applName;
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private EAMessageControl msgControl = new EAMessageControl();

    public RacfInfoDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex, String userId, String password, String groupName, String applName, int racfReturnCode) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
        this.setShellStyle(67616);
        this.userId = userId;
        this.groupName = groupName;
        this.applName = applName;
        this.password = password;
        this.racfReturnCode = racfReturnCode;
    }

    public Control createCustomArea(Composite parent) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "createCustomArea(Composite parent)", new Object[0]);
        int[] labelSizes = new int[]{Utility.getTextWidth((Composite)parent, (int)0, (String)IPC_RACF_USERID), Utility.getTextWidth((Composite)parent, (int)0, (String)IPC_RACF_PASSWORD), Utility.getTextWidth((Composite)parent, (int)0, (String)IPC_RACF_GROUP_NAME), Utility.getTextWidth((Composite)parent, (int)0, (String)IPC_RACF_APPL_NAME)};
        int requiredLabelWidth = Utility.getTextWidth((Composite)parent, (int)0, (String)"*");
        int labelWidth = Utility.getMaxSize((int[])labelSizes) + requiredLabelWidth;
        int style = 0;
        UIHelper uih = new UIHelper();
        Display display = parent.getDisplay();
        Font font = parent.getFont();
        Color color = parent.getForeground();
        uih.setDisplay(display);
        Composite composite = new Composite(parent, style);
        composite.setLayout((Layout)new FormLayout());
        FormData fd = uih.genFormData(new FormAttachment(0, 9), null, new FormAttachment(0, 0), null);
        Label userIdLabel = uih.genLabel(composite, style, IPC_RACF_USERID, color, fd, true);
        fd = uih.genFormData(new FormAttachment(0, 9), null, new FormAttachment(0, labelWidth), new FormAttachment(100, -15));
        fd.width = 400;
        this.racfUserId = new Text(composite, 2048);
        this.racfUserId.setTextLimit(8);
        this.racfUserId.setToolTipText(IPC_RACF_USERID_HOVER);
        this.racfUserId.setLayoutData((Object)fd);
        this.racfUserId.setFont(font);
        if (this.userId != null) {
            this.racfUserId.setText(this.userId);
        }
        this.msgControl.addControl((Control)this.racfUserId);
        if (this.racfReturnCode == 4) {
            this.racfUserId.setFocus();
        }
        fd = uih.genFormData(new FormAttachment((Control)userIdLabel, 9), null, new FormAttachment(0, 0), null);
        Label passwordLabel = uih.genLabel(composite, style, IPC_RACF_PASSWORD, color, fd, true);
        fd = uih.genFormData(new FormAttachment((Control)userIdLabel, 9), null, new FormAttachment(0, labelWidth), new FormAttachment(100, -15));
        this.racfPassword = new Text(composite, 0x400800);
        this.racfPassword.setTextLimit(101);
        this.racfPassword.setToolTipText(IPC_RACF_PASSWORD_HOVER);
        this.racfPassword.setLayoutData((Object)fd);
        this.racfPassword.setFont(font);
        if (this.password != null) {
            this.racfPassword.setText(this.password);
        }
        if (this.racfReturnCode == 8) {
            this.racfPassword.setFocus();
        }
        this.msgControl.addControl((Control)this.racfPassword);
        fd = uih.genFormData(new FormAttachment((Control)passwordLabel, 9), null, new FormAttachment(0, 0), null);
        Label groupNameLabel = uih.genLabel(composite, style, IPC_RACF_GROUP_NAME, color, fd, false);
        fd = uih.genFormData(new FormAttachment((Control)passwordLabel, 9), null, new FormAttachment(0, labelWidth), new FormAttachment(100, -15));
        this.racfGroupName = new Text(composite, 2048);
        this.racfGroupName.setTextLimit(8);
        this.racfGroupName.setToolTipText(IPC_RACF_GROUP_NAME_HOVER);
        this.racfGroupName.setLayoutData((Object)fd);
        this.racfGroupName.setFont(font);
        if (this.groupName != null) {
            this.racfGroupName.setText(this.groupName);
        }
        if (this.racfReturnCode == 20) {
            this.racfGroupName.setFocus();
        }
        this.msgControl.addControl((Control)this.racfGroupName);
        fd = uih.genFormData(new FormAttachment((Control)groupNameLabel, 9), null, new FormAttachment(0, 0), null);
        Label appNameLabel = uih.genLabel(composite, style, IPC_RACF_APPL_NAME, color, fd, false);
        appNameLabel.setToolTipText(IPC_RACF_APPL_NAME_LABEL_HOVER);
        fd = uih.genFormData(new FormAttachment((Control)groupNameLabel, 9), null, new FormAttachment(0, labelWidth), new FormAttachment(100, -15));
        this.racfApplName = new Text(composite, 2048);
        this.racfApplName.setTextLimit(8);
        this.racfApplName.setToolTipText(IPC_RACF_APPL_NAME_HOVER);
        this.racfApplName.setLayoutData((Object)fd);
        this.racfApplName.setFont(font);
        if (this.applName != null) {
            this.racfApplName.setText(this.applName);
        }
        this.msgControl.addControl((Control)this.racfApplName);
        parent.setSize(parent.computeSize(-1, -1));
        this.addListeners();
        logger.exiting(((Object)((Object)this)).getClass().getName(), "createCustomArea(Composite parent)", new Object[0]);
        return parent;
    }

    private void addListeners() {
        this.racfUserId.addVerifyListener((VerifyListener)this);
        this.racfPassword.addVerifyListener((VerifyListener)this);
        this.racfGroupName.addVerifyListener((VerifyListener)this);
        this.racfApplName.addVerifyListener((VerifyListener)this);
        this.racfUserId.addModifyListener((ModifyListener)this);
        this.racfPassword.addModifyListener((ModifyListener)this);
        this.racfGroupName.addModifyListener((ModifyListener)this);
        this.racfApplName.addModifyListener((ModifyListener)this);
    }

    private void removeListeners() {
        this.racfUserId.removeVerifyListener((VerifyListener)this);
        this.racfPassword.removeVerifyListener((VerifyListener)this);
        this.racfGroupName.removeVerifyListener((VerifyListener)this);
        this.racfApplName.removeVerifyListener((VerifyListener)this);
        this.racfUserId.removeModifyListener((ModifyListener)this);
        this.racfPassword.removeModifyListener((ModifyListener)this);
        this.racfGroupName.removeModifyListener((ModifyListener)this);
        this.racfApplName.removeModifyListener((ModifyListener)this);
    }

    private void disposeWidgets() {
        this.racfUserId.dispose();
        this.racfPassword.dispose();
        this.racfGroupName.dispose();
        this.racfApplName.dispose();
    }

    public void verifyText(VerifyEvent event) {
        try {
            if (event.character >= 'a' && event.character <= 'z') {
                event.text = event.text.toUpperCase();
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "verifyText(VerifyEvent event)", e);
            logger.error(e);
        }
    }

    public void modifyText(ModifyEvent event) {
        String errorMessage = null;
        Control control = (Control)event.widget;
        this.msgControl.clearValidationMessage((Control)event.widget);
        if (control == this.racfUserId) {
            String userId = this.racfUserId.getText().trim();
            if (!userId.isEmpty() && !Utility.isValidName((String)userId)) {
                errorMessage = TranMessages.getError().getString("IPC_NAME_ERROR", (Object[])new String[]{IPC_RACF_USERID});
            } else {
                this.userId = userId;
            }
        } else if (control == this.racfPassword) {
            String password = this.racfPassword.getText().trim();
            if (!password.isEmpty() && !Utility.isValidPassphrase((String)password)) {
                errorMessage = TranMessages.getError().getString("IPC_PASSPHRASE_ERROR");
            } else {
                this.password = password;
            }
        } else if (control == this.racfGroupName) {
            String groupName = this.racfGroupName.getText().trim();
            if (!groupName.isEmpty() && !Utility.isValidName((String)groupName)) {
                errorMessage = TranMessages.getError().getString("IPC_NAME_ERROR", (Object[])new String[]{IPC_RACF_GROUP_NAME});
            } else {
                this.groupName = groupName;
            }
        } else if (control == this.racfApplName) {
            String applName = this.racfApplName.getText().trim();
            if (!applName.isEmpty() && !Utility.isValidName((String)applName)) {
                errorMessage = TranMessages.getError().getString("IPC_NAME_ERROR", (Object[])new String[]{IPC_RACF_APPL_NAME});
            } else {
                this.applName = applName;
            }
        }
        if (errorMessage != null) {
            this.msgControl.setValidationMessage(control, errorMessage, 1);
        }
    }

    public String getUserId() {
        return this.userId;
    }

    public String getPassword() {
        return this.password;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getApplName() {
        return this.applName;
    }

    public boolean close() {
        this.removeListeners();
        this.disposeWidgets();
        return super.close();
    }
}

