/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.transaction.utilities;

import com.ibm.im.ims.workbench.transaction.resources.utilities.TranMessages;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FontFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class NodePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String DBD_LABEL_COLOR = "explorer_dbd_label_color";
    public static final String DBD_BACKGROUND_COLOR = "explorer_dbd_background_color";
    public static final String SEGMENT_LABEL_COLOR = "explorer_segment_color";
    public static final String FIELD_LABEL_COLOR = "explorer_field_color";
    public static final String FIELD_SELECTED_COLOR = "explorer_field_selected_color";
    public static final String CONNECTION_PHYSICAL_COLOR = "explorer_connection_physical_color";
    public static final String CONNECTION_LOGICAL_COLOR = "explorer_connection_logical_color";
    public static final String CONNECTION_SELECTED_LOGICAL_COLOR = "explorer_selected_connection_logical_color";
    public static final String DBD_LABEL_FONT = "explorer_dbd_font";
    public static final String SEGMENT_LABEL_FONT = "explorer_segment_font";
    public static final String FIELD_FONT = "explorer_field_font";
    public static final String SEGMENT_EXPAND_ALL_FLAG = "explorer_segment_expand_all_flag";
    public static final String ENABLE_IMS_JDBC = "explorer_enable_ims_jdbc";
    public static final String ENABLE_IMS_CATALOG = "explorer_enable_ims_catalog";
    public static final String WIZARD_SKIP_WARNING_FLAG = "explorer_wizard_skip_warning_flag";
    public static final String DBD_ENCODING_SELECTION = "explorer_dbd_encoding_selection";
    public static final String COBOL = "COBOL";
    public static final String PLI = "PL/I";
    public static final String DEFAULT_ENCODING = "Cp1047";
    private IPreferenceStore store = TranMessages.getDefault().getPreferenceStore();
    private ColorFieldEditor dbdLabelColor;
    private ColorFieldEditor dbdBackgroundColor;
    private ColorFieldEditor segmentLabelColor;
    private ColorFieldEditor fieldBackgroundColor;
    private ColorFieldEditor fieldSelectedColor;
    private ColorFieldEditor connectionPhysicalColor;
    private ColorFieldEditor connectionLogicalColor;
    private ColorFieldEditor connectionSelectedLogicalColor;
    private FontFieldEditor dbdFont;
    private FontFieldEditor segmentFont;
    private FontFieldEditor fieldFont;
    private BooleanFieldEditor isExpand;
    private BooleanFieldEditor enableIMSJDBC;
    private StringFieldEditor dbdEncodingSelection;
    private String encoding = TranMessages.getDefault().getPreferenceStore().getString("explorer_dbd_encoding_selection");

    public NodePreferencePage() {
        this.setPreferenceStore(this.store);
    }

    protected Control createContents(Composite parent) {
        Composite top = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 5;
        top.setLayout((Layout)layout);
        top.setLayoutData((Object)new GridData(768));
        Group imsFeatureGroup = new Group(top, 0);
        imsFeatureGroup.setLayout((Layout)layout);
        imsFeatureGroup.setLayoutData((Object)new GridData(768));
        imsFeatureGroup.setText(TranMessages.getLabel().getString("IMS_PREF"));
        Composite jdbcPanel = new Composite((Composite)imsFeatureGroup, 0);
        this.enableIMSJDBC = new BooleanFieldEditor(ENABLE_IMS_JDBC, TranMessages.getLabel().getString("IMS_UNI_META"), jdbcPanel);
        this.enableIMSJDBC.setPage((DialogPage)this);
        this.enableIMSJDBC.setPreferenceStore(this.store);
        this.enableIMSJDBC.load();
        Composite encodingPanel = new Composite((Composite)imsFeatureGroup, 0);
        this.dbdEncodingSelection = new StringFieldEditor(DBD_ENCODING_SELECTION, TranMessages.getLabel().getString("IMS_ENCODING") + TranMessages.getColon().getString("COLON"), 25, encodingPanel);
        this.dbdEncodingSelection.setPage((DialogPage)this);
        this.dbdEncodingSelection.setPreferenceStore(this.store);
        this.dbdEncodingSelection.load();
        this.dbdEncodingSelection.setEmptyStringAllowed(false);
        this.dbdEncodingSelection.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                NodePreferencePage.this.setErrorMessage(NodePreferencePage.this.getEncodingErrorMessage());
            }
        });
        if (this.encoding.isEmpty()) {
            this.dbdEncodingSelection.setStringValue(DEFAULT_ENCODING);
        }
        Group diagramGroup = new Group(top, 0);
        diagramGroup.setText(TranMessages.getLabel().getString("IMS_EDITOR"));
        diagramGroup.setLayout((Layout)layout);
        diagramGroup.setLayoutData((Object)new GridData(768));
        Composite colorPanel = new Composite((Composite)diagramGroup, 0);
        this.dbdLabelColor = new ColorFieldEditor(DBD_LABEL_COLOR, TranMessages.getLabel().getString("IMS_DBD_PCB"), colorPanel);
        this.dbdLabelColor.setPage((DialogPage)this);
        this.dbdLabelColor.setPreferenceStore(this.store);
        this.dbdLabelColor.load();
        this.dbdBackgroundColor = new ColorFieldEditor(DBD_BACKGROUND_COLOR, TranMessages.getLabel().getString("IMS_DBD_PCB_COLOR"), colorPanel);
        this.dbdBackgroundColor.setPage((DialogPage)this);
        this.dbdBackgroundColor.setPreferenceStore(this.store);
        this.dbdBackgroundColor.load();
        this.segmentLabelColor = new ColorFieldEditor(SEGMENT_LABEL_COLOR, TranMessages.getLabel().getString("IMS_SEG_COLOR"), colorPanel);
        this.segmentLabelColor.setPage((DialogPage)this);
        this.segmentLabelColor.setPreferenceStore(this.store);
        this.segmentLabelColor.load();
        this.fieldBackgroundColor = new ColorFieldEditor(FIELD_LABEL_COLOR, TranMessages.getLabel().getString("IMS_FLD_COLOR"), colorPanel);
        this.fieldBackgroundColor.setPage((DialogPage)this);
        this.fieldBackgroundColor.setPreferenceStore(this.store);
        this.fieldBackgroundColor.load();
        this.fieldSelectedColor = new ColorFieldEditor(FIELD_SELECTED_COLOR, TranMessages.getLabel().getString("IMS_FLD_SELECT"), colorPanel);
        this.fieldSelectedColor.setPage((DialogPage)this);
        this.fieldSelectedColor.setPreferenceStore(this.store);
        this.fieldSelectedColor.load();
        this.connectionPhysicalColor = new ColorFieldEditor(CONNECTION_PHYSICAL_COLOR, TranMessages.getLabel().getString("IMS_PHY_CONNECTOR"), colorPanel);
        this.connectionPhysicalColor.setPage((DialogPage)this);
        this.connectionPhysicalColor.setPreferenceStore(this.store);
        this.connectionPhysicalColor.load();
        this.connectionLogicalColor = new ColorFieldEditor(CONNECTION_LOGICAL_COLOR, TranMessages.getLabel().getString("IMS_LOGICAL"), colorPanel);
        this.connectionLogicalColor.setPage((DialogPage)this);
        this.connectionLogicalColor.setPreferenceStore(this.store);
        this.connectionLogicalColor.load();
        this.connectionSelectedLogicalColor = new ColorFieldEditor(CONNECTION_SELECTED_LOGICAL_COLOR, TranMessages.getLabel().getString("IMS_SELECT_LOGICAL"), colorPanel);
        this.connectionSelectedLogicalColor.setPage((DialogPage)this);
        this.connectionSelectedLogicalColor.setPreferenceStore(this.store);
        this.connectionSelectedLogicalColor.load();
        Composite fontPanel = new Composite((Composite)diagramGroup, 0);
        this.dbdFont = new FontFieldEditor(DBD_LABEL_FONT, TranMessages.getLabel().getString("IMS_DBD_PCB_FONT"), fontPanel);
        this.dbdFont.setPage((DialogPage)this);
        this.dbdFont.setChangeButtonText(TranMessages.getLabel().getString("IMS_EDIT"));
        this.dbdFont.setPreferenceStore(this.store);
        this.dbdFont.load();
        this.segmentFont = new FontFieldEditor(SEGMENT_LABEL_FONT, TranMessages.getLabel().getString("IMS_SEG_FONT"), fontPanel);
        this.segmentFont.setPage((DialogPage)this);
        this.segmentFont.setChangeButtonText(TranMessages.getLabel().getString("IMS_EDIT"));
        this.segmentFont.setPreferenceStore(this.store);
        this.segmentFont.load();
        this.fieldFont = new FontFieldEditor(FIELD_FONT, TranMessages.getLabel().getString("IMS_FLD_FONT"), fontPanel);
        this.fieldFont.setPage((DialogPage)this);
        this.fieldFont.setChangeButtonText(TranMessages.getLabel().getString("IMS_EDIT"));
        this.fieldFont.setPreferenceStore(this.store);
        this.fieldFont.load();
        Composite expandPanel = new Composite((Composite)diagramGroup, 0);
        this.isExpand = new BooleanFieldEditor(SEGMENT_EXPAND_ALL_FLAG, TranMessages.getLabel().getString("IMS_SHOWALL_FLD"), expandPanel);
        this.isExpand.setPage((DialogPage)this);
        this.isExpand.setPreferenceStore(this.store);
        this.isExpand.load();
        return top;
    }

    protected void performDefaults() {
        this.dbdLabelColor.loadDefault();
        this.dbdBackgroundColor.loadDefault();
        this.segmentLabelColor.loadDefault();
        this.fieldBackgroundColor.loadDefault();
        this.fieldSelectedColor.loadDefault();
        this.connectionPhysicalColor.loadDefault();
        this.connectionLogicalColor.loadDefault();
        this.connectionSelectedLogicalColor.loadDefault();
        this.dbdFont.loadDefault();
        this.segmentFont.loadDefault();
        this.fieldFont.loadDefault();
        this.isExpand.loadDefault();
        this.enableIMSJDBC.loadDefault();
        this.dbdEncodingSelection.loadDefault();
        super.performDefaults();
    }

    public boolean performOk() {
        this.dbdLabelColor.store();
        this.dbdBackgroundColor.store();
        this.segmentLabelColor.store();
        this.fieldBackgroundColor.store();
        this.fieldSelectedColor.store();
        this.connectionPhysicalColor.store();
        this.connectionLogicalColor.store();
        this.connectionSelectedLogicalColor.store();
        this.dbdFont.store();
        this.segmentFont.store();
        this.fieldFont.store();
        this.isExpand.store();
        this.enableIMSJDBC.store();
        this.dbdEncodingSelection.store();
        if (!this.encoding.equals(this.dbdEncodingSelection.getStringValue())) {
            this.encoding = this.dbdEncodingSelection.getStringValue();
            if (MessageDialog.openQuestion((Shell)this.getShell(), (String)TranMessages.getLabel().getString("IMS_CONFIRM"), (String)TranMessages.getLabel().getString("IMS_NEW_ENCODE"))) {
                IProject[] projects;
                IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject project = iProjectArray[n2];
                    project.getName();
                    ++n2;
                }
            }
        }
        return super.performOk();
    }

    public void dispose() {
        this.dbdLabelColor.dispose();
        this.dbdBackgroundColor.dispose();
        this.segmentLabelColor.dispose();
        this.fieldBackgroundColor.dispose();
        this.fieldSelectedColor.dispose();
        this.connectionPhysicalColor.dispose();
        this.connectionLogicalColor.dispose();
        this.connectionSelectedLogicalColor.dispose();
        this.dbdFont.dispose();
        this.segmentFont.dispose();
        this.fieldFont.dispose();
        this.isExpand.dispose();
        this.enableIMSJDBC.dispose();
        this.dbdEncodingSelection.dispose();
    }

    private String getEncodingErrorMessage() {
        if (this.dbdEncodingSelection != null) {
            String encodingText = this.dbdEncodingSelection.getStringValue().trim();
            try {
                encodingText.getBytes(encodingText);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.setValid(false);
                return TranMessages.getError().getString("ENCODING_INVALID");
            }
        }
        this.setValid(true);
        return null;
    }

    public void init(IWorkbench arg0) {
    }
}

