/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.transaction.utilities;

import com.ibm.im.ims.metadata.transaction.MessageType;
import com.ibm.im.ims.metadata.transaction.SegmentType;
import com.ibm.im.ims.metadata.transaction.Transaction;
import com.ibm.im.ims.transaction.model.utilities.TrantocMap;
import com.ibm.im.ims.transaction.model.utilities.TrantocMapManager;
import java.math.BigInteger;

public class NewTranHelper {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static Transaction createNewTran(String projectName, String tranCode) {
        Transaction newTran = new Transaction();
        TrantocMap map = TrantocMapManager.getSingletonInstance().getTrantocMap(projectName);
        long lastUsedTranId = map.getTrantoc().getLastUsedTranId().longValue();
        newTran.setId(BigInteger.valueOf(lastUsedTranId + 1L));
        newTran.setTranCode(tranCode);
        MessageType newMsg = new MessageType();
        newMsg.setName(tranCode + " - INPUT");
        newMsg.setId(BigInteger.valueOf(1L));
        SegmentType newSeg = new SegmentType();
        newSeg.setId(BigInteger.valueOf(1L));
        newMsg.getSegment().add(newSeg);
        newTran.getInputMessage().add(newMsg);
        MessageType newOutMsg = new MessageType();
        newOutMsg.setName(tranCode + " - OUTPUT");
        newOutMsg.setId(BigInteger.valueOf(2L));
        SegmentType newOutSeg = new SegmentType();
        newOutSeg.setId(BigInteger.valueOf(1L));
        newOutMsg.getSegment().add(newOutSeg);
        newTran.getOutputMessage().add(newOutMsg);
        return newTran;
    }
}

