/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.transaction.preferences;

import com.ibm.im.ims.metadata.testcase.InteractionType;
import com.ibm.im.ims.workbench.transaction.Activator;
import com.ibm.im.ims.workbench.transaction.common.ui.InteractionSpecComposite;
import com.ibm.im.ims.workbench.transaction.utilities.UIHelper;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.preferences.ImsTmPreferenceConstants;
import java.math.BigInteger;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class IConApiInteractionPreferencesPage
extends PreferencePage
implements IWorkbenchPreferencePage,
ImsTmPreferenceConstants {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private IPreferenceStore store = Activator.getDefault().getPreferenceStore();
    private InteractionType interaction = new InteractionType();
    private InteractionSpecComposite top;
    private UIHelper uih;

    public IConApiInteractionPreferencesPage() {
        this.setPreferenceStore(this.store);
        this.uih = new UIHelper();
    }

    public void setPreferenceStore(IPreferenceStore store) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "setPreferenceStore(IPreferenceStore store)", new Object[0]);
        this.interaction.setImsDatastoreName(store.getString("IPC_IMS_DATASTORE_NAME"));
        this.interaction.setImsConnectUserMessageExitIdentifier(store.getString("IPC_IMS_CONNECT_USER_EXIT"));
        this.interaction.setInputMessageDataSegmentsIncludeLlzzAndTrancode(Boolean.valueOf(store.getBoolean("IPC_INPUT_MSG_INCLUDE_LLZZ")));
        this.interaction.setOutputMessageDataSegmentsIncludeLlzz(Boolean.valueOf(store.getBoolean("IPC_OUTPUT_MSG_INCLUDE_LLZZ")));
        this.interaction.setResponseIncludesLlll(Boolean.valueOf(store.getBoolean("IPC_RESPONSE_INCLUDE_LLLL")));
        this.interaction.setAckNakProvider(Byte.valueOf((byte)store.getInt("IPC_ACK_PROVIDER")));
        this.interaction.setInputMessageOptions(BigInteger.valueOf(store.getInt("IPC_INPUT_MESSAGE_OPTIONS")));
        this.interaction.setResumeTpipeProcessing(BigInteger.valueOf(store.getInt("IPC_RESUME_TPIPE_PROCESSING")));
        this.interaction.setReturnMfsModname(Boolean.valueOf(store.getBoolean("IPC_RETURN_MFS_MOD_NAME")));
        this.interaction.setCommitMode(Byte.valueOf((byte)store.getInt("IPC_COMMIT_MODE")));
        this.interaction.setSyncLevel(Byte.valueOf((byte)store.getInt("IPC_SYNC_LEVEL")));
        this.interaction.setInteractionTypeDescription(store.getString("IPC_INTERACTION_TYPE_DESC"));
        this.interaction.setLtermOverrideName(store.getString("IPC_LTERM_OVERRIDE_NAME"));
        this.interaction.setPurgeUndeliverableOutput(Boolean.valueOf(store.getBoolean("IPC_PURGE_UNDELIVERABLE_OUTPUT")));
        this.interaction.setRerouteName(store.getString("IPC_REROUTE_NAME"));
        this.interaction.setRerouteUndeliverableOutput(Boolean.valueOf(store.getBoolean("IPC_REROUTE_UNDELIVERABLE_OUTPUT")));
        this.interaction.setResumeTpipeAlternateClientId(store.getString("IPC_RESUMETPIPE_ALTERNATE_CLIENTID"));
        this.interaction.setImsConnectTimeout(BigInteger.valueOf(store.getInt("IPC_IMS_CONNECT_TIMEOUT")));
        this.interaction.setInteractionTimeout(BigInteger.valueOf(store.getInt("IPC_INTERACTION_TIMEOUT")));
        this.interaction.setImsConnectCodepage(store.getString("IPC_IMS_CONNECT_CODEPAGE"));
        this.interaction.setRacfUserId(store.getString("IPC_RACF_USERID"));
        this.interaction.setRacfGroupName(store.getString("IPC_RACF_GROUP_NAME"));
        this.interaction.setRacfApplName(store.getString("IPC_RACF_APPL_NAME"));
        logger.exiting(((Object)((Object)this)).getClass().getName(), "setPreferenceStore(IPreferenceStore store)", new Object[0]);
    }

    protected Control createContents(Composite parent) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "createContents(Composite parent)", new Object[0]);
        try {
            Display display = parent.getDisplay();
            this.uih.setDisplay(display);
            Composite composite = new Composite(parent, 16);
            composite.setLayout((Layout)new GridLayout(1, true));
            GridData gd = new GridData(1808);
            gd.verticalIndent = -30;
            composite.setLayoutData((Object)gd);
            this.top = new InteractionSpecComposite(composite, false, this.interaction);
            ModifyListener modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent arg0) {
                    IConApiInteractionPreferencesPage.this.validatePage();
                }
            };
            this.top.addChildListener((Control)composite, modifyListener);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "createContents(Composite parent)", e);
            logger.error(e);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "createContents(Composite parent)", new Object[0]);
        return this.top;
    }

    private void validatePage() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "validatePage()", new Object[0]);
        String errorMessage = this.top.getErrorMessage();
        boolean isValid = errorMessage == null || errorMessage.isEmpty();
        this.setValid(isValid);
        if (!isValid) {
            this.setErrorMessage(errorMessage);
        } else {
            this.setErrorMessage(null);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "validatePage()", new Object[0]);
    }

    public boolean performOk() {
        this.savePreferences();
        return super.performOk();
    }

    public void performApply() {
        this.savePreferences();
    }

    protected void performDefaults() {
        this.restoreDefaultPreferences();
        this.top.initialize();
    }

    private void restoreDefaultPreferences() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "restorePreferences(", new Object[0]);
        this.interaction.setImsDatastoreName("MYDSTRNM");
        this.interaction.setImsConnectUserMessageExitIdentifier("*SAMPL1*");
        this.interaction.setInputMessageDataSegmentsIncludeLlzzAndTrancode(Boolean.valueOf(true));
        this.interaction.setOutputMessageDataSegmentsIncludeLlzz(Boolean.valueOf(true));
        this.interaction.setResponseIncludesLlll(Boolean.valueOf(true));
        this.interaction.setAckNakProvider(Byte.valueOf((byte)0));
        this.interaction.setInputMessageOptions(BigInteger.valueOf(0L));
        this.interaction.setResumeTpipeProcessing(BigInteger.valueOf(16L));
        this.interaction.setReturnMfsModname(Boolean.valueOf(false));
        this.interaction.setCommitMode(Byte.valueOf((byte)64));
        this.interaction.setSyncLevel(Byte.valueOf((byte)1));
        this.interaction.setInteractionTypeDescription("SENDRECV");
        this.interaction.setLtermOverrideName("        ");
        this.interaction.setPurgeUndeliverableOutput(Boolean.valueOf(false));
        this.interaction.setRerouteName("        ");
        this.interaction.setRerouteUndeliverableOutput(Boolean.valueOf(false));
        this.interaction.setResumeTpipeAlternateClientId("        ");
        this.interaction.setImsConnectTimeout(BigInteger.valueOf(0L));
        this.interaction.setInteractionTimeout(BigInteger.valueOf(-1L));
        this.interaction.setImsConnectCodepage("CP037");
        this.interaction.setRacfUserId("");
        this.interaction.setRacfGroupName("");
        this.interaction.setRacfApplName("");
        this.store.setValue("IPC_IMS_CONNECT_TRACEFILE", this.store.getDefaultString("IPC_IMS_CONNECT_TRACEFILE"));
        logger.exiting(((Object)((Object)this)).getClass().getName(), "restorePreferences())", new Object[0]);
    }

    private void savePreferences() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "savePreferences()", new Object[0]);
        this.store.setValue("IPC_IMS_DATASTORE_NAME", this.interaction.getImsDatastoreName());
        this.store.setValue("IPC_IMS_CONNECT_USER_EXIT", this.interaction.getImsConnectUserMessageExitIdentifier());
        this.store.setValue("IPC_INPUT_MSG_INCLUDE_LLZZ", this.interaction.isInputMessageDataSegmentsIncludeLlzzAndTrancode().booleanValue());
        this.store.setValue("IPC_OUTPUT_MSG_INCLUDE_LLZZ", this.interaction.isOutputMessageDataSegmentsIncludeLlzz().booleanValue());
        this.store.setValue("IPC_RESPONSE_INCLUDE_LLLL", this.interaction.isResponseIncludesLlll().booleanValue());
        this.store.setValue("IPC_ACK_PROVIDER", (int)this.interaction.getAckNakProvider().byteValue());
        this.store.setValue("IPC_INPUT_MESSAGE_OPTIONS", this.interaction.getInputMessageOptions().intValue());
        this.store.setValue("IPC_RESUME_TPIPE_PROCESSING", this.interaction.getResumeTpipeProcessing().intValue());
        this.store.setValue("IPC_RETURN_MFS_MOD_NAME", this.interaction.isReturnMfsModname().booleanValue());
        this.store.setValue("IPC_COMMIT_MODE", (int)this.interaction.getCommitMode().byteValue());
        this.store.setValue("IPC_SYNC_LEVEL", (int)this.interaction.getSyncLevel().byteValue());
        this.store.setValue("IPC_INTERACTION_TYPE_DESC", this.interaction.getInteractionTypeDescription());
        this.store.setValue("IPC_LTERM_OVERRIDE_NAME", this.interaction.getLtermOverrideName());
        this.store.setValue("IPC_PURGE_UNDELIVERABLE_OUTPUT", this.interaction.isPurgeUndeliverableOutput().booleanValue());
        this.store.setValue("IPC_REROUTE_NAME", this.interaction.getRerouteName());
        this.store.setValue("IPC_REROUTE_UNDELIVERABLE_OUTPUT", this.interaction.isRerouteUndeliverableOutput().booleanValue());
        this.store.setValue("IPC_RESUMETPIPE_ALTERNATE_CLIENTID", this.interaction.getResumeTpipeAlternateClientId());
        this.store.setValue("IPC_IMS_CONNECT_TIMEOUT", this.interaction.getImsConnectTimeout().intValue());
        this.store.setValue("IPC_INTERACTION_TIMEOUT", this.interaction.getInteractionTimeout().intValue());
        this.store.setValue("IPC_IMS_CONNECT_CODEPAGE", this.interaction.getImsConnectCodepage());
        this.store.setValue("IPC_IMS_CONNECT_TRACEFILE", this.top.getTraceFilePath());
        this.store.setValue("IPC_RACF_USERID", this.interaction.getRacfUserId());
        this.store.setValue("IPC_RACF_GROUP_NAME", this.interaction.getRacfGroupName());
        this.store.setValue("IPC_RACF_APPL_NAME", this.interaction.getRacfApplName());
        logger.exiting(((Object)((Object)this)).getClass().getName(), "savePreferences()", new Object[0]);
    }

    public void dispose() {
        this.top.dispose();
        super.dispose();
    }

    public void init(IWorkbench arg0) {
    }
}

