/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.transaction.handlers;

import com.ibm.im.ims.transaction.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.workbench.transaction.model.TestCase;
import com.ibm.im.ims.workbench.transaction.nav.CurrentTestcaseNodes;
import com.ibm.im.ims.workbench.transaction.wizard.newtestcase.NewTestCaseWizard;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandlerListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;

public class CreateNewTestCase
implements IHandler {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();

    public void addHandlerListener(IHandlerListener arg0) {
    }

    public void dispose() {
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            NewTestCaseWizard tcWizard = new NewTestCaseWizard();
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
            ISelection selection = workbenchWindow.getSelectionService().getSelection();
            tcWizard.init(workbench, (IStructuredSelection)selection);
            WizardDialog dialog = new WizardDialog(workbenchWindow.getShell(), (IWizard)tcWizard);
            int rc = dialog.open();
            if (rc == 0) {
                String tcFileName = tcWizard.getTestCaseName();
                String projectName = tcWizard.getProjectName();
                IFile tcFile = ProjectTreeFileHelper.getTestCaseMetadataFile((String)projectName, (String)tcFileName);
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IWorkbenchPage page = window.getActivePage();
                if (page != null) {
                    TestCase tc;
                    IViewPart part = page.findView("org.eclipse.ui.navigator.ProjectExplorer");
                    if (part instanceof CommonNavigator) {
                        CommonViewer viewer = ((CommonNavigator)part).getCommonViewer();
                        viewer.refresh();
                    }
                    if (part != null && part instanceof ISetSelectionTarget && (tc = CurrentTestcaseNodes.getTestcaseForFile(tcFileName)) != null) {
                        StructuredSelection tcSelection = new StructuredSelection((Object)tc);
                        ((ISetSelectionTarget)part).selectReveal((ISelection)tcSelection);
                    }
                }
                page.openEditor((IEditorInput)new FileEditorInput(tcFile), "com.ibm.im.ims.workbench.transaction.editors.TestCaseEditor");
            }
        }
        catch (Throwable e) {
            logger.error(e);
        }
        return null;
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean isHandled() {
        return true;
    }

    public void removeHandlerListener(IHandlerListener arg0) {
    }
}

