/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.transaction.fieldEditor;

import com.ibm.im.ims.transaction.controller.datastructure.DBDConstants;
import com.ibm.im.ims.transaction.controller.editor.EditFieldController;
import com.ibm.im.ims.transaction.controller.editor.InvalidInputException;
import com.ibm.im.ims.transaction.controller.editor.ManageFieldsController;
import com.ibm.im.ims.transaction.model.utilities.ModelException;
import com.ibm.im.ims.transaction.model.utilities.Utility;
import com.ibm.im.ims.workbench.transaction.fieldEditor.EditFieldWizard;
import com.ibm.im.ims.workbench.transaction.fieldEditor.FieldSearchDialog;
import com.ibm.im.ims.workbench.transaction.model.FieldModel;
import com.ibm.im.ims.workbench.transaction.model.TranDataStructureModel;
import com.ibm.im.ims.workbench.transaction.model.TranDataStructuresFolder;
import com.ibm.im.ims.workbench.transaction.model.TranMessageModel;
import com.ibm.im.ims.workbench.transaction.model.TranMessagesFolder;
import com.ibm.im.ims.workbench.transaction.model.TranSegmentModel;
import com.ibm.im.ims.workbench.transaction.model.TranSegmentsFolder;
import com.ibm.im.ims.workbench.transaction.model.TranTreeParent;
import com.ibm.im.ims.workbench.transaction.resources.utilities.TranMessages;
import com.ibm.im.ims.workbench.transaction.utilities.UIHelper;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;

public class ManageFieldWizardPage1
extends WizardPage
implements SelectionListener,
MouseListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String MESSAGE_LABEL = TranMessages.getLabel().getString("EDIT_FIELD_WIZARD_LOCATION_MESSAGE") + TranMessages.getColon().getString("COLON");
    private static final String SEGMENT_LABEL = TranMessages.getLabel().getString("EDIT_FIELD_WIZARD_LOCATION_SEGMENT") + TranMessages.getColon().getString("COLON");
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private Composite composite;
    private Display display;
    private UIHelper uih;
    private IStructuredSelection selection;
    private Label messageLabel;
    private Label segmentLabel;
    private Combo messageCombo;
    private Combo segmentCombo;
    private Composite fieldGrp;
    private Table fieldTab;
    private boolean fieldWasAddedRemovedOrEdited = false;
    boolean isFieldEditorOpened = false;
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private Button findButton;
    private ManageFieldsController mfController;
    private boolean isFindDialogOpen = false;
    private TranMessageModel tranMessage;
    private int segmentNumber;
    private TranSegmentModel tranSegmentModel;
    private ArrayList<FieldModel> fieldModelList;
    private static int margin = 5;

    public ManageFieldWizardPage1(String pageName, boolean genSchema, ManageFieldsController mfController, IStructuredSelection selection) {
        super("Add or Edit Field");
        this.mfController = mfController;
        this.selection = selection;
        this.setTitle(TranMessages.getLabel().getString("WB038A"));
        this.setDescription(TranMessages.getLabel().getString("WB203"));
        this.setImageDescriptor(ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"/icons/EFWEdit.gif"));
    }

    public void createControl(Composite parent) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", new Object[0]);
        try {
            this.uih = new UIHelper();
            this.composite = new Composite(parent, 0);
            this.display = parent.getDisplay();
            this.uih.setDisplay(this.display);
            FormLayout layout = new FormLayout();
            layout.marginHeight = margin;
            layout.marginWidth = margin;
            this.composite.setLayout((Layout)layout);
            FormData fd = new FormData();
            this.composite.setLayoutData((Object)fd);
            this.messageLabel = new Label(this.composite, 0);
            this.messageCombo = new Combo(this.composite, 780);
            this.segmentLabel = new Label(this.composite, 0);
            this.segmentCombo = new Combo(this.composite, 780);
            this.createListenerForMessageCombo();
            this.createListenerForSegmentCombo();
            this.populateMessageCombo(this.messageCombo);
            this.populateSegmentCombo(this.messageCombo.getText(), this.segmentCombo);
            FormLayout fldFL = new FormLayout();
            fldFL.marginHeight = margin;
            fldFL.marginWidth = margin;
            this.messageLabel.setText(MESSAGE_LABEL);
            FormData lblMap = this.uih.genFormData(new FormAttachment(0, margin), null, new FormAttachment(0, 0), null);
            this.messageLabel.setToolTipText(TranMessages.getDescription().getString("WB455"));
            this.messageLabel.setLayoutData((Object)lblMap);
            FormData cmbFD1 = this.uih.genFormData(new FormAttachment(0, margin), null, new FormAttachment((Control)this.messageLabel, margin), new FormAttachment(50, 0));
            this.messageCombo.setLayoutData((Object)cmbFD1);
            this.segmentLabel.setText(SEGMENT_LABEL);
            FormData lblCase = this.uih.genFormData(new FormAttachment(0, margin), null, new FormAttachment((Control)this.messageCombo, margin * 5), null);
            this.segmentLabel.setToolTipText(TranMessages.getDescription().getString("WB456"));
            this.segmentLabel.setLayoutData((Object)lblCase);
            FormData cmbFD2 = this.uih.genFormData(new FormAttachment(0, margin), null, new FormAttachment((Control)this.segmentLabel, margin), new FormAttachment(100, 0));
            this.segmentCombo.setLayoutData((Object)cmbFD2);
            FormData fldFD = this.uih.genFormData(new FormAttachment((Control)this.messageCombo, 10), new FormAttachment(100, 0), new FormAttachment(0, 0), new FormAttachment(100, 0));
            this.fieldGrp = new Composite(this.composite, 0);
            this.fieldGrp.setLayout((Layout)fldFL);
            this.fieldGrp.setLayoutData((Object)fldFD);
            fldFD = this.uih.genFormData(new FormAttachment((Control)this.fieldGrp, 0), null, new FormAttachment(0, 0), new FormAttachment(100, 0));
            fldFD.width = this.fieldGrp.getClientArea().width;
            Link fldHelpLink = new Link(this.fieldGrp, 16384);
            String textLink = TranMessages.getDescription().getString("WB078") + "  <a>" + TranMessages.getDescription().getString("WB070") + "</a>";
            fldHelpLink.setText(textLink);
            fldHelpLink.setLayoutData((Object)fldFD);
            fldHelpLink.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    PlatformUI.getWorkbench().getHelpSystem().displayHelp("com.ibm.im.ims.workbench.transaction.manage_field_wizard");
                }
            });
            int[] labelSizes = new int[]{Utility.getTextWidth((Composite)this.fieldGrp, (int)0, (String)TranMessages.getLabel().getString("WB008A")), Utility.getTextWidth((Composite)this.fieldGrp, (int)0, (String)TranMessages.getLabel().getString("WB042A")), Utility.getTextWidth((Composite)this.fieldGrp, (int)0, (String)TranMessages.getLabel().getString("WB009A")), Utility.getTextWidth((Composite)this.fieldGrp, (int)0, (String)TranMessages.getLabel().getString("WB009B")), Utility.getTextWidth((Composite)this.fieldGrp, (int)0, (String)TranMessages.getLabel().getString("WB085A"))};
            int buttonWidth = Utility.getMaxSize((int[])labelSizes) + margin;
            fldFD = this.uih.genFormData(new FormAttachment((Control)fldHelpLink, 10), null, null, new FormAttachment(100, 0));
            fldFD.width = buttonWidth;
            this.addButton = new Button(this.fieldGrp, 0x1000000);
            this.addButton.setText(TranMessages.getLabel().getString("WB008A"));
            this.addButton.setLayoutData((Object)fldFD);
            this.addButton.addSelectionListener((SelectionListener)this);
            this.addButton.setEnabled(true);
            fldFD = this.uih.genFormData(new FormAttachment((Control)this.addButton, 10), null, null, new FormAttachment(100, 0));
            fldFD.width = buttonWidth;
            this.editButton = new Button(this.fieldGrp, 0x1000000);
            this.editButton.setText(TranMessages.getLabel().getString("WB042A"));
            this.editButton.setLayoutData((Object)fldFD);
            this.editButton.addSelectionListener((SelectionListener)this);
            this.editButton.setEnabled(false);
            fldFD = this.uih.genFormData(new FormAttachment((Control)this.editButton, 10), null, null, new FormAttachment(100, 0));
            fldFD.width = buttonWidth;
            this.removeButton = new Button(this.fieldGrp, 0x1000000);
            this.removeButton.setText(TranMessages.getLabel().getString("WB009A"));
            this.removeButton.setLayoutData((Object)fldFD);
            this.removeButton.addSelectionListener((SelectionListener)this);
            this.removeButton.setEnabled(false);
            fldFD = this.uih.genFormData(new FormAttachment((Control)this.removeButton, 10), null, null, new FormAttachment(100, 0));
            fldFD.width = buttonWidth;
            this.findButton = new Button(this.fieldGrp, 0x1000000);
            this.findButton.setText(TranMessages.getLabel().getString("WB085A"));
            this.findButton.setLayoutData((Object)fldFD);
            this.findButton.addSelectionListener((SelectionListener)this);
            this.findButton.setEnabled(true);
            fldFD = this.uih.genFormData(new FormAttachment((Control)fldHelpLink, 10), new FormAttachment(100, 0), new FormAttachment(0, 0), new FormAttachment((Control)this.addButton, -margin * 2));
            this.fieldTab = new Table(this.fieldGrp, 268503042);
            this.fieldTab.addSelectionListener((SelectionListener)this);
            this.fieldTab.addMouseListener((MouseListener)this);
            String[] columnLabels = new String[]{TranMessages.getLabel().getString("EDS_ORIGINAL_NAME"), TranMessages.getLabel().getString("WB211"), TranMessages.getLabel().getString("WB485"), TranMessages.getLabel().getString("WB012A"), TranMessages.getLabel().getString("WB013A"), TranMessages.getLabel().getString("WB212"), TranMessages.getLabel().getString("WB018A"), TranMessages.getLabel().getString("EDIT_FIELD_WIZARD_REDEFINES"), TranMessages.getLabel().getString("EDIT_FIELD_WIZARD_DEPENDS_ON")};
            this.fieldTab.setLinesVisible(true);
            this.fieldTab.setHeaderVisible(true);
            this.fieldTab.setLayoutData((Object)fldFD);
            this.setColumns(this.fieldTab, columnLabels);
            this.fieldGrp.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    Rectangle area = ManageFieldWizardPage1.this.fieldGrp.getClientArea();
                    int width = area.width - 2 * ManageFieldWizardPage1.this.fieldTab.getBorderWidth();
                    TableColumn[] tableColumns = ManageFieldWizardPage1.this.fieldTab.getColumns();
                    ManageFieldWizardPage1.this.fieldTab.setSize(area.width, area.height);
                    int i = 0;
                    while (i < tableColumns.length) {
                        tableColumns[i].setWidth(width / tableColumns.length);
                        ++i;
                    }
                }
            });
            Control[] fieldGrpTabList = new Control[]{fldHelpLink, this.fieldTab, this.addButton, this.editButton, this.removeButton, this.findButton};
            this.fieldGrp.setTabList(fieldGrpTabList);
            this.selectInitialMessageSegmentCombo();
            this.populateTableFromFields(this.fieldModelList);
            this.getContainer().getShell().setMinimumSize(this.composite.computeSize(-1, 800));
            this.setControl((Control)this.composite);
            this.setPageComplete(false);
            this.setErrorMessage(null);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.composite, "com.ibm.im.ims.workbench.transaction.manage_field_wizard");
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", e);
            logger.error(e);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", new Object[0]);
    }

    private void selectInitialMessageSegmentCombo() throws ModelException {
        if (this.selection.isEmpty()) {
            String messageName = this.messageCombo.getText();
            this.tranMessage = this.mfController.getMsgNodeByName(messageName);
            String segmentName = this.segmentCombo.getText();
            this.segmentNumber = Integer.parseInt(segmentName.substring(segmentName.indexOf(32) + 1));
            this.tranSegmentModel = this.mfController.getSegmentNode(this.tranMessage, this.segmentNumber);
            this.fieldModelList = this.mfController.getFreshFieldList(this.tranSegmentModel);
        } else {
            TranDataStructuresFolder dsFolder;
            TranTreeParent initialParent;
            Object initialSelection = this.selection.getFirstElement();
            String messageName = this.messageCombo.getText();
            String segmentName = this.segmentCombo.getText();
            if (initialSelection instanceof TranMessagesFolder || initialSelection instanceof TranMessageModel || initialSelection instanceof TranSegmentsFolder) {
                initialParent = (TranTreeParent)initialSelection;
                if (initialSelection instanceof TranMessagesFolder) {
                    messageName = initialParent.getChildren()[0].getName();
                } else if (initialSelection instanceof TranMessageModel) {
                    messageName = initialParent.getName();
                } else if (initialSelection instanceof TranSegmentsFolder) {
                    messageName = initialParent.getParent().toString();
                }
                segmentName = this.segmentCombo.getText();
            }
            if (initialSelection instanceof TranSegmentModel || initialSelection instanceof TranDataStructuresFolder || initialSelection instanceof TranDataStructureModel) {
                initialParent = (TranTreeParent)initialSelection;
                TranSegmentModel segModel = null;
                if (initialSelection instanceof TranSegmentModel) {
                    segModel = (TranSegmentModel)initialParent;
                } else if (initialSelection instanceof TranDataStructuresFolder) {
                    segModel = (TranSegmentModel)initialParent.getParent();
                } else if (initialSelection instanceof TranDataStructureModel) {
                    dsFolder = (TranDataStructuresFolder)initialParent.getParent();
                    segModel = (TranSegmentModel)dsFolder.getParent();
                }
                TranSegmentsFolder segFolder = (TranSegmentsFolder)segModel.getParent();
                messageName = segFolder.getParent().toString();
                segmentName = segModel.getName();
            }
            if (initialSelection instanceof FieldModel) {
                FieldModel fieldModel = (FieldModel)initialSelection;
                TranDataStructureModel dsModel = (TranDataStructureModel)fieldModel.getParent();
                dsFolder = (TranDataStructuresFolder)dsModel.getParent();
                TranSegmentModel segModel = (TranSegmentModel)dsFolder.getParent();
                TranSegmentsFolder segFolder = (TranSegmentsFolder)segModel.getParent();
                messageName = segFolder.getParent().toString();
                segmentName = segModel.getName();
            }
            this.messageCombo.select(this.messageCombo.indexOf(messageName));
            this.segmentCombo.select(this.segmentCombo.indexOf(segmentName));
            this.tranMessage = this.mfController.getMsgNodeByName(messageName);
            this.segmentNumber = Integer.parseInt(segmentName.substring(segmentName.indexOf(32) + 1));
            this.tranSegmentModel = this.mfController.getSegmentNode(this.tranMessage, this.segmentNumber);
            this.fieldModelList = this.mfController.getFreshFieldList(this.tranSegmentModel);
        }
    }

    private void populateTableFromFields(List<FieldModel> fields) {
        int i = 0;
        while (i < fields.size()) {
            FieldModel currField = fields.get(i);
            TableItem newTableItem = new TableItem(this.fieldTab, 0);
            this.populateTableItemFromField(newTableItem, currField);
            ++i;
        }
        TableColumn[] cols = this.fieldTab.getColumns();
        int i2 = 0;
        while (i2 < cols.length) {
            cols[i2].pack();
            ++i2;
        }
    }

    public void setColumn(Table table, String columnLabel) {
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setMoveable(true);
        tableColumn.setResizable(true);
        tableColumn.setText(columnLabel);
    }

    public void setColumns(Table table, String[] columnsLabels) {
        int i = 0;
        while (i < columnsLabels.length) {
            this.setColumn(table, columnsLabels[i]);
            ++i;
        }
    }

    private void populateTableItemFromField(TableItem currentTableItem, FieldModel fieldModel) {
        String fieldNameStr = null;
        fieldNameStr = fieldModel.getOriginalName() != null ? fieldModel.getOriginalName() : "NO_ORIG_NAME";
        currentTableItem.setText(0, fieldNameStr);
        String aliasStr = null;
        aliasStr = fieldModel.getName() != null ? fieldModel.getName() : "";
        currentTableItem.setText(1, aliasStr);
        FieldModel parentField = fieldModel.getParentField();
        if (parentField != null) {
            currentTableItem.setText(2, parentField.getName());
        } else {
            currentTableItem.setText(2, "");
        }
        int start = fieldModel.getStartPos();
        if (fieldModel.getAppDatatype() != null && fieldModel.getAppDatatype().equals((Object)DBDConstants.XML) && start == 0) {
            currentTableItem.setText(3, "S=0");
        } else if (start == 0) {
            start = fieldModel.getRelativeStart();
            if (start == 0) {
                String startAfter = fieldModel.getStartAfter();
                if (startAfter != null && !startAfter.isEmpty()) {
                    currentTableItem.setText(3, "A=" + startAfter);
                } else {
                    currentTableItem.setText(3, "");
                }
            } else {
                currentTableItem.setText(3, "R=" + Integer.toString(start));
            }
        } else {
            currentTableItem.setText(3, "S=" + Integer.toString(start));
        }
        int bytes = fieldModel.getBytes();
        if (fieldModel.getAppDatatype() != null && fieldModel.getAppDatatype().equals((Object)DBDConstants.XML) && bytes == 0) {
            currentTableItem.setText(4, "0");
        } else if (bytes > 0) {
            currentTableItem.setText(4, Integer.toString(bytes));
        } else {
            currentTableItem.setText(4, "M=" + Integer.toString(fieldModel.getMaxBytes()));
        }
        DBDConstants appDatatype = fieldModel.getAppDatatype();
        if (appDatatype != null) {
            currentTableItem.setText(5, appDatatype.toString());
        } else {
            currentTableItem.setText(5, "");
        }
        DBDConstants physDatatype = fieldModel.getPhysicalDataType();
        String physDatatypeStr = null;
        if (physDatatype != null) {
            physDatatypeStr = physDatatype.toString();
            currentTableItem.setText(6, physDatatypeStr);
        } else {
            String userTypeConv = fieldModel.getUserTypeConverter();
            if (userTypeConv != null && !userTypeConv.isEmpty()) {
                currentTableItem.setText(6, DBDConstants.USER.toString());
            } else {
                currentTableItem.setText(6, "");
            }
        }
        String redefineField = fieldModel.getRedefines();
        if (redefineField != null) {
            currentTableItem.setText(7, redefineField);
        } else {
            currentTableItem.setText(7, "");
        }
        String dependOnField = fieldModel.getDependsOn();
        if (dependOnField != null) {
            currentTableItem.setText(8, dependOnField);
        } else {
            currentTableItem.setText(8, "");
        }
        currentTableItem.setData(DBDConstants.SEQ.toString(), (Object)"NO_SEQ_TYPE");
        currentTableItem.setData(DBDConstants.TYPE.toString(), (Object)"NO_IMS_DATATYPE");
        currentTableItem.setData(DBDConstants.PATTERN.toString(), (Object)"NO_PATTERN");
        String commentStr = fieldModel.getRemarks();
        if (commentStr != null) {
            currentTableItem.setData(DBDConstants.REMARK.toString(), (Object)commentStr);
        } else {
            currentTableItem.setData(DBDConstants.REMARK.toString(), (Object)"");
        }
        currentTableItem.setData(DBDConstants.ENCODING.toString(), (Object)"NO_ENCODING");
        currentTableItem.setData(DBDConstants.XML.toString(), (Object)"NO_URL");
        currentTableItem.setData(DBDConstants.OVERFLOW.toString(), (Object)"NO_OVERFLOW");
        currentTableItem.setData(DBDConstants.PRECISION.toString(), (Object)"NO_PRECISION");
        currentTableItem.setData(DBDConstants.SCALE.toString(), (Object)"NO_SCALE");
        currentTableItem.setData(DBDConstants.ISSIGNED.toString(), (Object)"NO_SIGNED");
        currentTableItem.setData(DBDConstants.USERCLASS.toString(), (Object)"NO_CONVERTER_CLASS");
    }

    public Table getFieldTab() {
        return this.fieldTab;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "widgetSelected(SelectionEvent e)", new Object[0]);
        try {
            if (e.widget == this.addButton) {
                logger.finest("Add button was clicked");
                this.handleAdd();
            } else if (e.widget == this.editButton) {
                logger.finest("Edit button was clicked");
                this.handleEdit();
            } else if (e.widget == this.removeButton) {
                logger.finest("Remove button was clicked.");
                this.handleRemove();
            } else if (e.widget == this.findButton) {
                logger.finest("find button was clicked.");
                this.handleFind();
            } else if (e.widget == this.fieldTab) {
                this.enableButtons();
            } else if (e.widget == this.messageCombo) {
                String userSelection = this.messageCombo.getText();
                this.populateSegmentCombo(userSelection, this.segmentCombo);
                this.refreshFieldTable();
            } else if (e.widget == this.segmentCombo) {
                this.refreshFieldTable();
            }
            this.setPageComplete(this.fieldWasAddedRemovedOrEdited);
        }
        catch (ModelException iie) {
            if (iie.getErrorCode() == 12) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)TranMessages.getError().getString("EISRC25"), (String)iie.getMessage());
                this.setPageComplete(false);
            } else if (iie.getErrorCode() == 4) {
                this.setMessage(iie.getMessage(), 2);
                this.setPageComplete(true);
            } else {
                this.setErrorMessage(iie.getMessage());
                this.setPageComplete(false);
            }
        }
        catch (Throwable err) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "widgetSelected(SelectionEvent e)", err);
            logger.error(err);
        }
        this.messageCombo.setEnabled(this.getErrorMessage() == null);
        this.segmentCombo.setEnabled(this.getErrorMessage() == null);
        logger.exiting(((Object)((Object)this)).getClass().getName(), "widgetSelected(SelectionEvent e)", new Object[0]);
    }

    private void enableButtons() {
        int numSelected = this.fieldTab.getSelectionCount();
        if (numSelected == 0) {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        } else if (numSelected == 1) {
            TableItem selectedItem = this.fieldTab.getSelection()[0];
            if (selectedItem.getText(2).isEmpty()) {
                this.editButton.setEnabled(false);
                this.removeButton.setEnabled(true);
            } else {
                this.editButton.setEnabled(true);
                this.removeButton.setEnabled(true);
            }
        } else if (numSelected > 1) {
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(true);
        }
    }

    public void setVisible(boolean visible) {
        try {
            super.setVisible(visible);
            if (visible) {
                Object initialSelection;
                this.refreshFieldTable();
                if (!this.selection.isEmpty() && (initialSelection = this.selection.getFirstElement()) instanceof FieldModel) {
                    FieldModel fieldModel = (FieldModel)initialSelection;
                    this.selectFields(new String[]{fieldModel.getName()});
                }
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "widgetSelected(SelectionEvent e)", e);
            logger.error(e);
        }
    }

    private void handleRemove() throws ModelException {
        if (MessageDialog.openQuestion((Shell)this.getContainer().getShell(), (String)TranMessages.getError().getString("ITMW_ERR_CONFIRMATION"), (String)TranMessages.getDescription().getString("WB64"))) {
            TableItem[] selectedItems = this.fieldTab.getSelection();
            String fieldName = this.fieldTab.getItem(0).getText(1);
            int index = this.fieldTab.getSelectionIndices()[0];
            if (index > 0) {
                fieldName = this.fieldTab.getItem(index - 1).getText(1);
            }
            String[] selectedFields = new String[selectedItems.length];
            int i = 0;
            while (i < selectedItems.length) {
                String fieldAlias;
                selectedFields[i] = fieldAlias = selectedItems[i].getText(1);
                ++i;
            }
            String error = this.mfController.validateAndRemove(selectedFields, this.messageCombo.getText(), this.segmentCombo.getSelectionIndex() + 1);
            if (error == null) {
                this.refreshFieldTable();
                if (index == 0 && this.fieldTab.getItemCount() > 0) {
                    fieldName = this.fieldTab.getItem(0).getText(0);
                }
                this.selectFields(new String[]{fieldName});
                this.enableButtons();
                if (!this.fieldWasAddedRemovedOrEdited) {
                    this.fieldWasAddedRemovedOrEdited = true;
                }
            } else {
                Object[] inserts = new Object[]{error, TranMessages.getError().getString("MNG_FIELD_WIZ_REMOVED"), TranMessages.getError().getString("MNG_FIELD_WIZ_REMOVING")};
                String errorMessage = TranMessages.getError().getString("MNG_FIELD_WIZ_2", inserts);
                MessageDialog.openInformation((Shell)this.getShell(), (String)TranMessages.getError().getString("EISRC25"), (String)errorMessage);
            }
        }
    }

    private void handleAdd() throws ModelException {
        String messageName = this.messageCombo.getText();
        String segmentName = this.segmentCombo.getText();
        String fieldName = null;
        int selectionIndex = 0;
        if (this.fieldTab.getSelectionCount() == 1) {
            selectionIndex = this.fieldTab.getSelectionIndex();
            TableItem selectedItem = this.fieldTab.getSelection()[0];
            fieldName = selectedItem.getText(1);
        } else {
            fieldName = "";
        }
        EditFieldController efController = new EditFieldController(fieldName, selectionIndex, messageName, segmentName, this.mfController, "ADD");
        EditFieldWizard editFieldWizard = new EditFieldWizard(efController);
        WizardDialog dialog = new WizardDialog(this.getContainer().getShell(), (IWizard)editFieldWizard);
        dialog.create();
        dialog.getShell().setSize(editFieldWizard.getShell().getMinimumSize());
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            this.refreshFieldTable();
            this.enableButtons();
            this.selectFields(new String[]{fieldName});
            if (!this.fieldWasAddedRemovedOrEdited) {
                this.fieldWasAddedRemovedOrEdited = true;
            }
        }
    }

    private void handleEdit() throws ModelException {
        TableItem selectedItem = this.fieldTab.getSelection()[0];
        int selectionIndex = this.fieldTab.getSelectionIndex();
        String fieldName = selectedItem.getText(0);
        String messageName = this.messageCombo.getText();
        String segmentName = this.segmentCombo.getText();
        EditFieldController efController = new EditFieldController(fieldName, selectionIndex, messageName, segmentName, this.mfController, "EDIT");
        EditFieldWizard editFieldWizard = new EditFieldWizard(efController);
        WizardDialog dialog = new WizardDialog(this.getContainer().getShell(), (IWizard)editFieldWizard);
        dialog.create();
        dialog.getShell().setSize(editFieldWizard.getShell().getMinimumSize());
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            this.refreshFieldTable();
            this.enableButtons();
            this.selectFields(new String[]{fieldName});
            if (!this.fieldWasAddedRemovedOrEdited) {
                this.fieldWasAddedRemovedOrEdited = true;
            }
        }
    }

    private void selectFields(String[] fieldNames) {
        int[] indices = new int[fieldNames.length];
        int i = 0;
        while (i < fieldNames.length) {
            int index = this.getTableItemIndex(fieldNames[i]);
            if (index >= 0) {
                indices[i] = index;
            }
            ++i;
        }
        this.fieldTab.setSelection(indices);
    }

    private int getTableItemIndex(String fieldName) {
        int retVal = -1;
        int i = 0;
        while (i < this.fieldTab.getItems().length) {
            String fldName = this.fieldTab.getItem(i).getText(0);
            if (fldName.equals(fieldName)) {
                retVal = i;
                break;
            }
            ++i;
        }
        return retVal;
    }

    private synchronized boolean testAndSetFindDialogOpen() {
        boolean retVal = this.isFindDialogOpen;
        this.isFindDialogOpen = true;
        return retVal;
    }

    private void handleFind() {
        boolean findDialogOpenAlreadyOpen = this.testAndSetFindDialogOpen();
        if (!findDialogOpenAlreadyOpen) {
            FieldSearchDialog dialog = new FieldSearchDialog(this.getContainer().getShell(), TranMessages.getLabel().getString("WB086A"), this);
            dialog.open();
        }
    }

    private void populateMessageCombo(Combo messageCombo) {
        List inputMessages = this.mfController.getMessageNodes(0);
        List outputMessages = this.mfController.getMessageNodes(1);
        messageCombo.removeAll();
        int i = 0;
        while (i < inputMessages.size()) {
            messageCombo.add(((TranMessageModel)inputMessages.get(i)).getName());
            ++i;
        }
        i = 0;
        while (i < outputMessages.size()) {
            messageCombo.add(((TranMessageModel)outputMessages.get(i)).getName());
            ++i;
        }
        messageCombo.select(0);
    }

    private void populateSegmentCombo(String messageName, Combo segmentCombo) {
        List segments = this.mfController.getSegmentNodes(this.mfController.getMsgNodeByName(messageName));
        segmentCombo.removeAll();
        int i = 0;
        while (i < segments.size()) {
            segmentCombo.add(((TranSegmentModel)segments.get(i)).getName());
            ++i;
        }
        if (segmentCombo.getItemCount() > 0) {
            segmentCombo.select(0);
        }
    }

    public void createListenerForMessageCombo() {
        this.messageCombo.addSelectionListener((SelectionListener)this);
    }

    public void createListenerForSegmentCombo() {
        this.segmentCombo.addSelectionListener((SelectionListener)this);
    }

    private void refreshFieldTable() throws ModelException {
        try {
            String messageName = this.messageCombo.getText();
            this.tranMessage = this.mfController.getMsgNodeByName(messageName);
            String segmentName = this.segmentCombo.getText();
            this.segmentNumber = Integer.parseInt(segmentName.substring(segmentName.indexOf(32) + 1));
            this.tranSegmentModel = this.mfController.getSegmentNode(this.tranMessage, this.segmentNumber);
            this.fieldModelList = this.mfController.getFreshFieldList(this.tranSegmentModel);
            this.fieldTab.removeAll();
            this.populateTableFromFields(this.fieldModelList);
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.mfController.semanticCheck(this.fieldModelList);
            this.setErrorMessage(null);
            this.setMessage(TranMessages.getLabel().getString("WB203"));
        }
        catch (InvalidInputException e) {
            if (e.getErrorCode() == 4) {
                this.setMessage(e.getMessage(), 2);
                this.setPageComplete(true);
            }
            this.setErrorMessage(e.getMessage());
            this.setPageComplete(false);
            throw new ModelException(e.getMessage());
        }
    }

    public TableItem[] getTableItems() {
        return this.getFieldTab().getItems();
    }

    public int getSelectionIndex() {
        return this.getFieldTab().getSelectionIndex();
    }

    public void setSelection(int index) {
        this.getFieldTab().setSelection(index);
        this.getFieldTab().showSelection();
    }

    public TranMessageModel getTranMessageModel() {
        return this.tranMessage;
    }

    public void mouseDoubleClick(MouseEvent arg0) {
        try {
            if (this.fieldTab.getSelectionCount() == 1) {
                this.handleEdit();
            }
        }
        catch (ModelException iie) {
            if (iie.getErrorCode() == 12) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)TranMessages.getError().getString("EISRC25"), (String)iie.getMessage());
                this.setPageComplete(false);
            } else if (iie.getErrorCode() == 4) {
                this.setMessage(iie.getMessage(), 2);
                this.setPageComplete(true);
            } else {
                this.setErrorMessage(iie.getMessage());
                this.setPageComplete(false);
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "mouseDoubleClick(MouseEvent e)", e);
            logger.error(e);
        }
    }

    public void mouseDown(MouseEvent arg0) {
    }

    public void mouseUp(MouseEvent arg0) {
    }

    public void setFindDialogOpen(boolean isFindDialogOpen) {
        this.isFindDialogOpen = isFindDialogOpen;
    }
}

