/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.transaction.fieldEditor;

import com.ibm.im.ims.transaction.controller.datastructure.DBDConstants;
import com.ibm.im.ims.transaction.controller.editor.EditFieldController;
import com.ibm.im.ims.transaction.controller.editor.IModelChangeListener;
import com.ibm.im.ims.transaction.controller.editor.InvalidInputException;
import com.ibm.im.ims.transaction.controller.editor.ModelChangeEvent;
import com.ibm.im.ims.transaction.model.utilities.ModelException;
import com.ibm.im.ims.transaction.model.utilities.Utility;
import com.ibm.im.ims.workbench.transaction.fieldEditor.EditFieldWizard;
import com.ibm.im.ims.workbench.transaction.fieldEditor.EditFieldWizardPage0;
import com.ibm.im.ims.workbench.transaction.model.FieldModel;
import com.ibm.im.ims.workbench.transaction.resources.utilities.TranMessages;
import com.ibm.im.ims.workbench.transaction.utilities.EAMessageControl;
import com.ibm.im.ims.workbench.transaction.utilities.TextFocusHightlightListener;
import com.ibm.im.ims.workbench.transaction.utilities.UIHelper;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class EditFieldWizardPage2
extends WizardPage
implements SelectionListener,
IModelChangeListener,
ModifyListener,
FocusListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private EditFieldController efController;
    private UIHelper uih;
    private Display display;
    private Group groupMarshaller;
    private Group groupAppType;
    private Combo comboAppDatatype;
    private Combo comboPhysDatatype;
    private Combo comboIsSigned;
    private Combo comboDependOn;
    private String cmbPhysDtCurrVal;
    private Label isSignedLabel;
    private Label reqDateFormatLabel;
    private Label appDatatypeInput;
    private Label dateFormatLabel;
    private Label lblDependOn;
    private Label lblMinOccurs;
    private Label lblMaxOccurs;
    private Label reqedLabelMinOccurs1;
    private Label reqLabelMaxOccurs;
    private Label reqLabelDependOn;
    private Label physDatatypeInput;
    private Label reqLabelSignedInput;
    private Label reqLabelPrecision;
    private Label encodingInput;
    private Label precisionInput;
    private Label scaleInput;
    private Label regLabelScale;
    private Label reqLblEncoding;
    private Label exampleTextInput;
    private Label appInlineTextLabel;
    private Label fieldLengthLabel;
    private Text textDateFormat;
    private Text textEncoding;
    private Text textPrecision;
    private Text textScale;
    private Text textOverflow;
    private Text textUserName;
    private Text textUserClassName;
    private Text textValue;
    private Text textMinOccurs;
    private Text textMaxOccurs;
    private Text textFieldLength;
    private Button buttonAddName;
    private Button buttonUp;
    private Button buttonDown;
    private Button buttonRemove;
    private Button buttonClearAll;
    private Button isPureDBCS;
    Table propertyTable;
    private EAMessageControl msgControl = null;
    private EAMessageControl pdtMsgControl = null;
    private TextFocusHightlightListener textFocusHighLight;
    private static final String INFORMATION_STR = TranMessages.getError().getString("EISRC25");
    private static final String[] pageAttrs = new String[]{"APP_DATATYPE", "PHY_DATATYPE", "ENCODING", "PRECISION", "SCALE", "IS_SIGNED", "OVERFLOW_SEGM", "PATTERN", "DEPENDSON", "MIN_OCCURS", "MAX_OCCURS", "LENGTH"};
    private final String[] appDatatypeItems = new String[]{DBDConstants.ARRAY.toString(), DBDConstants.BINARY.toString(), DBDConstants.BIT.toString(), DBDConstants.BYTE.toString(), DBDConstants.CHAR.toString(), DBDConstants.DATE.toString(), DBDConstants.DECIMAL.toString(), DBDConstants.DOUBLE.toString(), DBDConstants.FLOAT.toString(), DBDConstants.INT.toString(), DBDConstants.LONG.toString(), DBDConstants.OTHER.toString(), DBDConstants.SHORT.toString(), DBDConstants.STRUCT.toString(), DBDConstants.TIME.toString(), DBDConstants.TIMESTAMP.toString(), DBDConstants.UBYTE.toString(), DBDConstants.USHORT.toString(), DBDConstants.UINT.toString(), DBDConstants.ULONG.toString()};
    private final String[] physicalDatatypeItems = new String[]{"", DBDConstants.BINARY.toString(), DBDConstants.BIT.toString(), DBDConstants.BLOB.toString(), DBDConstants.BYTE.toString(), DBDConstants.CHAR.toString(), DBDConstants.CLOB.toString(), DBDConstants.DOUBLE.toString(), DBDConstants.FLOAT.toString(), DBDConstants.INT.toString(), DBDConstants.LONG.toString(), DBDConstants.PACKEDDECIMAL.toString(), DBDConstants.SHORT.toString(), DBDConstants.ZONEDDECIMAL.toString()};
    private final String[] YNItems = new String[]{TranMessages.getLabel().getString("YES"), TranMessages.getLabel().getString("NO")};
    private PhysWidgetStates currPhysState = PhysWidgetStates.OTHER;
    private AppWidgetStates currAppState = AppWidgetStates.OTHER;
    private Composite composite = null;
    private int reqFieldSize = 10;
    private int leftLabelSize = 120;
    private int rightLabelSize = 100;
    private int verticalOffset = 10;
    private int horizontalOffset = 15;
    private int marginLabelAndText = 10;
    private static final String DEPEND_ON_LABEL = TranMessages.getLabel().getString("EDIT_FIELD_WIZARD_DEPENDS_ON") + TranMessages.getColon().getString("COLON");
    private static final String MIN_OCCURS_LABEL = TranMessages.getLabel().getString("EDIT_FIELD_WIZARD_MIN_OCCURS") + TranMessages.getColon().getString("COLON");
    private static final String MAX_OCCURS_LABEL = TranMessages.getLabel().getString("EDIT_FIELD_WIZARD_MAX_OCCURS") + TranMessages.getColon().getString("COLON");

    protected EditFieldWizardPage2(EditFieldController efController) {
        super("EditFieldWizardPage2");
        this.efController = efController;
        this.efController.addModelChangeListener((IModelChangeListener)this);
        this.setTitle(TranMessages.getDescription().getString("WB01A"));
        this.setDescription(TranMessages.getDescription().getString("WB15A"));
        this.setImageDescriptor(ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"/icons/EFWAdd.gif"));
        this.setPageComplete(false);
        if (efController.getActionType().equals("EDIT")) {
            this.setImageDescriptor(ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"/icons/EFWEdit.gif"));
            this.setPageComplete(true);
        }
    }

    public boolean isPhysDecimal() {
        return this.currPhysState == PhysWidgetStates.PACKEDDECIMAL || this.currPhysState == PhysWidgetStates.ZONEDDECIMAL;
    }

    public boolean isPhysChar() {
        return this.currPhysState == PhysWidgetStates.CHAR;
    }

    public void createControl(Composite parent) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", new Object[0]);
        try {
            int minLeftSize;
            int comboWidth;
            int minimumSize;
            this.uih = new UIHelper();
            this.display = parent.getDisplay();
            this.uih.setDisplay(this.display);
            this.composite = new Composite(parent, 0);
            this.textFocusHighLight = new TextFocusHightlightListener();
            FormLayout formLayout = new FormLayout();
            formLayout.marginHeight = 5;
            formLayout.marginWidth = 5;
            this.composite.setLayout((Layout)formLayout);
            FormData fd = new FormData();
            this.composite.setLayoutData((Object)fd);
            this.groupAppType = new Group(this.composite, 0);
            FormData fd1 = this.uih.genFormData(new FormAttachment((Control)this.composite, 0), null, new FormAttachment(0, 0), new FormAttachment(100));
            this.groupAppType.setText(TranMessages.getLabel().getString("WB017A"));
            this.groupAppType.setLayout((Layout)formLayout);
            this.groupAppType.setLayoutData((Object)fd1);
            this.msgControl = new EAMessageControl((Composite)this.groupAppType);
            this.appInlineTextLabel = new Label((Composite)this.groupAppType, 0);
            this.appInlineTextLabel.setText(TranMessages.getDescription().getString("WB467"));
            FormData fd_inlineText = this.uih.genFormData(new FormAttachment((Control)this.groupAppType, 3), null, new FormAttachment(0, 0), new FormAttachment(100, -2));
            this.appInlineTextLabel.setLayoutData((Object)fd_inlineText);
            this.appDatatypeInput = new Label((Composite)this.groupAppType, 0);
            this.appDatatypeInput.setText(TranMessages.getLabel().getString("WB342") + TranMessages.getColon().getString("COLON"));
            this.appDatatypeInput.setToolTipText(Utility.formatMessage((String)TranMessages.getDescription().getString("WB461")));
            FormData fd2 = this.uih.genFormData(new FormAttachment((Control)this.appInlineTextLabel, this.verticalOffset), null, new FormAttachment(0, this.reqFieldSize), null);
            this.appDatatypeInput.setLayoutData((Object)fd2);
            this.groupMarshaller = new Group(this.composite, 0);
            FormData marshallerFD = this.uih.genFormData(new FormAttachment((Control)this.groupAppType, this.verticalOffset), null, new FormAttachment(0, 0), new FormAttachment(100));
            FormLayout marshallerFL = new FormLayout();
            marshallerFL.marginHeight = 5;
            marshallerFL.marginWidth = 5;
            this.groupMarshaller.setText(TranMessages.getLabel().getString("WB345"));
            this.groupMarshaller.setLayout((Layout)marshallerFL);
            this.groupMarshaller.setLayoutData((Object)marshallerFD);
            this.pdtMsgControl = new EAMessageControl((Composite)this.groupMarshaller);
            this.physDatatypeInput = new Label((Composite)this.groupMarshaller, 0);
            this.physDatatypeInput.setText(TranMessages.getLabel().getString("WB344") + TranMessages.getColon().getString("COLON"));
            this.physDatatypeInput.setToolTipText(Utility.formatMessage((String)TranMessages.getDescription().getString("WB16A")));
            FormData marshallerGrpFD = this.uih.genFormData(new FormAttachment((Control)this.groupMarshaller, this.verticalOffset), null, new FormAttachment(0, this.reqFieldSize), null);
            this.physDatatypeInput.setLayoutData((Object)marshallerGrpFD);
            this.getMaxLabelSizes();
            fd = this.uih.genFormData(new FormAttachment((Control)this.appInlineTextLabel, this.verticalOffset + 2), null, new FormAttachment(0, 0), null);
            this.uih.genRequiredSymbol((Composite)this.groupAppType, 0, fd, this.groupAppType.getDisplay().getSystemColor(3));
            this.comboAppDatatype = new Combo((Composite)this.groupAppType, 12);
            this.comboAppDatatype.setToolTipText(Utility.formatMessage((String)TranMessages.getDescription().getString("WB461")));
            FormData fd3 = this.uih.genFormData(new FormAttachment((Control)this.appInlineTextLabel, this.verticalOffset), null, new FormAttachment(0, this.leftLabelSize), new FormAttachment(50, -this.horizontalOffset));
            this.comboAppDatatype.setLayoutData((Object)fd3);
            this.comboAppDatatype.setItems(this.appDatatypeItems);
            fd = this.uih.genFormData(new FormAttachment((Control)this.appInlineTextLabel, this.verticalOffset + 2), null, new FormAttachment(50, 0), null);
            fd = this.uih.genFormData(new FormAttachment((Control)this.appInlineTextLabel, this.verticalOffset + 2), null, new FormAttachment(50, this.reqFieldSize), null);
            this.fieldLengthLabel = new Label((Composite)this.groupAppType, 0);
            this.fieldLengthLabel.setText(TranMessages.getLabel().getString("WB013A") + TranMessages.getColon().getString("COLON"));
            this.fieldLengthLabel.setLayoutData((Object)fd);
            fd = this.uih.genFormData(new FormAttachment((Control)this.appInlineTextLabel, this.verticalOffset), null, new FormAttachment(50, this.rightLabelSize), new FormAttachment(100, -this.horizontalOffset));
            this.textFieldLength = new Text((Composite)this.groupAppType, 2052);
            this.textFieldLength.setLayoutData((Object)fd);
            this.textFieldLength.addFocusListener((FocusListener)this);
            this.comboPhysDatatype = new Combo((Composite)this.groupMarshaller, 12);
            Object[] inserts = new Object[]{TranMessages.getColon().getString("COLON")};
            this.comboPhysDatatype.setToolTipText(Utility.formatMessage((String)TranMessages.getDescription().getString("WB083", inserts)));
            FormData marshallerGrpFD0 = this.uih.genFormData(new FormAttachment((Control)this.groupMarshaller, this.verticalOffset), null, new FormAttachment(0, this.leftLabelSize), new FormAttachment(50, -this.horizontalOffset));
            this.comboPhysDatatype.setLayoutData((Object)marshallerGrpFD0);
            this.comboPhysDatatype.setItems(this.physicalDatatypeItems);
            this.comboPhysDatatype.notifyListeners(13, new Event());
            this.pdtMsgControl.addControl((Control)this.comboPhysDatatype);
            this.initDatatypeCombos();
            this.disposeAndCreateNecessaryWidgets();
            this.initLengthWidgetValue();
            this.initAppWidgetValues();
            this.initPhysWidgetValues();
            this.addStaticWidgetListeners();
            this.addDynamicWidgetListeners();
            this.addMessageControlsLengthWidgets();
            this.addMessageControlsForDynamicWidgets();
            if (this.efController.getActionType().equals("EDIT")) {
                this.validatePage(false, false);
            }
            if ((minimumSize = this.leftLabelSize + this.rightLabelSize + (comboWidth = Utility.getTextWidth((Composite)this.composite, (int)0, (String)EditFieldWizardPage0.REDEFINES_LABEL)) * 2 + this.marginLabelAndText * 2) / 2 < (minLeftSize = this.getMinimumLeftSize())) {
                minimumSize = minLeftSize * 2;
            }
            if (minimumSize > this.getContainer().getShell().getMinimumSize().x) {
                this.getContainer().getShell().setMinimumSize(minimumSize, 655);
            }
            this.setControl((Control)this.composite);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.composite, "com.ibm.im.ims.workbench.transaction.manage_field_wizard");
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "createControcl(Composite parent)", e);
            logger.error(e);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", new Object[0]);
    }

    private int getMinimumLeftSize() {
        int retVal = 0;
        int index = 0;
        int i = 0;
        while (i < this.physicalDatatypeItems.length) {
            String dataType = this.physicalDatatypeItems[i];
            if (dataType.length() > retVal) {
                retVal = dataType.length();
                index = i;
            }
            ++i;
        }
        retVal = this.leftLabelSize + this.marginLabelAndText * 4 + this.horizontalOffset * 2 + Utility.getTextWidth((Composite)this.composite, (int)0, (String)this.physicalDatatypeItems[index]);
        return retVal;
    }

    private void initDatatypeCombos() {
        DBDConstants physDatatype;
        DBDConstants appDatatype = this.efController.getAppDatatype();
        if (appDatatype != null) {
            this.comboAppDatatype.setText(appDatatype.toString());
        }
        if ((physDatatype = this.efController.getPhysicalDataType()) != null) {
            this.comboPhysDatatype.setText(physDatatype.toString());
        } else {
            this.comboPhysDatatype.setText("");
        }
        this.cmbPhysDtCurrVal = this.comboPhysDatatype.getText();
    }

    private void disposeAndCreateNecessaryWidgets() throws ModelException {
        this.disposeAndCreateAppWidgets();
        this.disposeAndCreatePhysWidgets();
    }

    private void addMessageControlsForDynamicWidgets() {
        String appDatatypeStr = this.comboAppDatatype.getText();
        if (appDatatypeStr.equals(DBDConstants.ARRAY.toString())) {
            this.addMessageControlsArrayWidgets();
        } else if (appDatatypeStr.equals(DBDConstants.DATE.toString()) || appDatatypeStr.equals(DBDConstants.TIME.toString()) || appDatatypeStr.equals(DBDConstants.TIMESTAMP.toString())) {
            this.addMessageControlsDateWidgets();
        }
        String physDatatypeStr = this.comboPhysDatatype.getText().trim();
        if (physDatatypeStr.equalsIgnoreCase(DBDConstants.CHAR.toString())) {
            this.addMessageControlsCharWidgets();
        } else if (physDatatypeStr.equalsIgnoreCase(DBDConstants.PACKEDDECIMAL.toString()) || physDatatypeStr.equalsIgnoreCase(DBDConstants.ZONEDDECIMAL.toString())) {
            this.addMessageControlsDecimalWidgets();
        }
    }

    private void initPhysWidgetValues() throws InvalidInputException {
        String physDatatypeStr = this.comboPhysDatatype.getText().trim();
        String appDatatypeStr = this.comboAppDatatype.getText();
        if (physDatatypeStr.equalsIgnoreCase(DBDConstants.CHAR.toString())) {
            this.initCharWidgetValues();
        } else if (physDatatypeStr.equalsIgnoreCase(DBDConstants.PACKEDDECIMAL.toString()) || physDatatypeStr.equalsIgnoreCase(DBDConstants.ZONEDDECIMAL.toString()) || appDatatypeStr.equalsIgnoreCase(DBDConstants.DECIMAL.toString()) && physDatatypeStr.equalsIgnoreCase(DBDConstants.BINARY.toString())) {
            this.initDecimalWidgetValues();
        }
        if ((physDatatypeStr.isEmpty() || !physDatatypeStr.equalsIgnoreCase(DBDConstants.CHAR.toString())) && this.isPureDBCS != null) {
            this.isPureDBCS.setSelection(false);
            this.isPureDBCS.setVisible(false);
        }
    }

    private void initAppWidgetValues() {
        String appDatatypeStr = this.comboAppDatatype.getText();
        if (appDatatypeStr.equals(DBDConstants.ARRAY.toString())) {
            this.initArrayWidgetValues();
        } else if (appDatatypeStr.equals(DBDConstants.DATE.toString()) || appDatatypeStr.equals(DBDConstants.TIME.toString()) || appDatatypeStr.equals(DBDConstants.TIMESTAMP.toString())) {
            this.initDateWidgetValues();
        }
    }

    private void initDecimalWidgetValues() {
        DBDConstants isSignedObj;
        Integer precisionInteger = this.efController.getPrecision();
        if (precisionInteger != null) {
            if (precisionInteger >= 0) {
                String precisionStr = precisionInteger.toString();
                this.textPrecision.setText(precisionStr);
            } else {
                this.textPrecision.setText("");
            }
        }
        this.textPrecision.setToolTipText(Utility.formatMessage((String)TranMessages.getDescription().getString("WB18A")));
        Integer scaleInteger = this.efController.getScale();
        if (scaleInteger != null) {
            if (scaleInteger >= 0) {
                String scaleStr = scaleInteger.toString();
                this.textScale.setText(scaleStr);
            } else {
                this.textScale.setText("");
            }
        }
        if ((isSignedObj = this.efController.getIsSigned()) != null) {
            if (isSignedObj == DBDConstants.Y) {
                this.comboIsSigned.setText(this.YNItems[0]);
            } else if (isSignedObj == DBDConstants.N) {
                this.comboIsSigned.setText(this.YNItems[1]);
            }
        }
    }

    private void initCharWidgetValues() {
        String encodingStr = this.efController.getEncoding();
        if (encodingStr != null) {
            this.textEncoding.setText(encodingStr);
        }
    }

    private void addDateWidgetListeners() {
        this.textDateFormat.addModifyListener((ModifyListener)this);
        this.textDateFormat.addFocusListener((FocusListener)this.textFocusHighLight);
    }

    private void addArrayWidgetListeners() {
        this.comboDependOn.addModifyListener((ModifyListener)this);
        this.comboDependOn.addFocusListener((FocusListener)this);
        this.textMinOccurs.addModifyListener((ModifyListener)this);
        this.textMinOccurs.addFocusListener((FocusListener)this.textFocusHighLight);
        this.textMaxOccurs.addModifyListener((ModifyListener)this);
        this.textMaxOccurs.addFocusListener((FocusListener)this.textFocusHighLight);
    }

    private void addDynamicWidgetListeners() {
        String appDatatypeStr = this.comboAppDatatype.getText();
        if (appDatatypeStr.equals(DBDConstants.ARRAY.toString())) {
            this.addArrayWidgetListeners();
        } else if (appDatatypeStr.equals(DBDConstants.DATE.toString()) || appDatatypeStr.equals(DBDConstants.TIME.toString()) || appDatatypeStr.equals(DBDConstants.TIMESTAMP.toString())) {
            this.addDateWidgetListeners();
        }
        String physDatatypeStr = this.comboPhysDatatype.getText().trim();
        if (physDatatypeStr.equalsIgnoreCase(DBDConstants.CHAR.toString())) {
            this.addCharListeners();
        } else if (physDatatypeStr.equalsIgnoreCase(DBDConstants.PACKEDDECIMAL.toString()) || physDatatypeStr.equalsIgnoreCase(DBDConstants.ZONEDDECIMAL.toString()) || appDatatypeStr.equalsIgnoreCase(DBDConstants.DECIMAL.toString()) && physDatatypeStr.equalsIgnoreCase(DBDConstants.BINARY.toString())) {
            this.addDecimalListeners();
        } else if (physDatatypeStr.equalsIgnoreCase(DBDConstants.USER.toString())) {
            this.addUserListeners();
        }
    }

    private void addStaticWidgetListeners() {
        this.comboAppDatatype.addModifyListener((ModifyListener)this);
        this.comboPhysDatatype.addModifyListener((ModifyListener)this);
        this.addLengthWidgetListeners();
    }

    private void addUserListeners() {
        this.textUserClassName.addModifyListener((ModifyListener)this);
        this.textUserClassName.addFocusListener((FocusListener)this.textFocusHighLight);
        this.textUserName.addModifyListener((ModifyListener)this);
        this.textUserName.addFocusListener((FocusListener)this.textFocusHighLight);
        this.textValue.addModifyListener((ModifyListener)this);
        this.textValue.addFocusListener((FocusListener)this.textFocusHighLight);
        this.buttonAddName.addSelectionListener((SelectionListener)this);
        this.buttonUp.addSelectionListener((SelectionListener)this);
        this.buttonDown.addSelectionListener((SelectionListener)this);
        this.buttonRemove.addSelectionListener((SelectionListener)this);
        this.buttonClearAll.addSelectionListener((SelectionListener)this);
    }

    private void addDecimalListeners() {
        this.textPrecision.addModifyListener((ModifyListener)this);
        this.textPrecision.addFocusListener((FocusListener)this.textFocusHighLight);
        this.textScale.addModifyListener((ModifyListener)this);
        this.textScale.addFocusListener((FocusListener)this.textFocusHighLight);
        this.comboIsSigned.addModifyListener((ModifyListener)this);
    }

    private void addCharListeners() {
        this.textEncoding.addModifyListener((ModifyListener)this);
        this.textEncoding.addFocusListener((FocusListener)this.textFocusHighLight);
        this.isPureDBCS.addSelectionListener((SelectionListener)this);
    }

    private void addCharWidgets() {
        FormData fd = this.uih.genFormData(new FormAttachment((Control)this.comboPhysDatatype, this.verticalOffset), null, new FormAttachment((Control)this.comboPhysDatatype, 0), null);
        this.reqLblEncoding = this.uih.genRequiredSymbol((Composite)this.comboPhysDatatype, 0, fd, this.comboPhysDatatype.getDisplay().getSystemColor(3));
        this.reqLblEncoding.setFont(this.getFont());
        this.encodingInput = new Label((Composite)this.groupMarshaller, 0);
        this.encodingInput.setText(TranMessages.getLabel().getString("IMS_ENCODING") + TranMessages.getColon().getString("COLON"));
        this.encodingInput.setToolTipText(TranMessages.getDescription().getString("WB22A"));
        FormData fd1 = this.uih.genFormData(new FormAttachment((Control)this.comboPhysDatatype, this.verticalOffset), null, new FormAttachment(0, this.reqFieldSize), null);
        this.encodingInput.setLayoutData((Object)fd1);
        FormData fd2 = this.uih.genFormData(new FormAttachment((Control)this.comboPhysDatatype, this.verticalOffset), null, new FormAttachment(0, this.leftLabelSize), new FormAttachment(50, -this.horizontalOffset));
        this.textEncoding = new Text((Composite)this.groupMarshaller, 2052);
        this.textEncoding.setTextLimit(255);
        this.textEncoding.setLayoutData((Object)fd2);
        Object[] inserts = new Object[]{new String(Character.toChars(8482)), TranMessages.getColon().getString("COLON")};
        this.textEncoding.setToolTipText(TranMessages.getDescription().getString("WB23A", inserts));
        FormData fd3 = this.uih.genFormData(new FormAttachment((Control)this.comboPhysDatatype, this.verticalOffset), null, new FormAttachment(50, this.reqFieldSize), null);
        this.exampleTextInput = new Label((Composite)this.groupMarshaller, 0);
        this.exampleTextInput.setText(TranMessages.getLabel().getString("WB041A") + TranMessages.getColon().getString("COLON") + " Cp1047");
        this.exampleTextInput.setToolTipText(Utility.formatMessage((String)(TranMessages.getLabel().getString("WB041A") + TranMessages.getColon().getString("COLON") + "Cp1047")));
        this.exampleTextInput.setLayoutData((Object)fd3);
        FormData fd4 = this.uih.genFormData(new FormAttachment((Control)this.comboPhysDatatype, this.verticalOffset), null, new FormAttachment(50, this.rightLabelSize), new FormAttachment(100, -this.horizontalOffset));
        this.isPureDBCS = new Button((Composite)this.groupMarshaller, 32);
        this.isPureDBCS.setText("DBCS");
        this.isPureDBCS.setLayoutData((Object)fd4);
        this.isPureDBCS.setVisible(false);
        this.addMessageControlsCharWidgets();
    }

    private void addMessageControlsCharWidgets() {
        this.pdtMsgControl.addControl((Control)this.textEncoding);
        this.pdtMsgControl.addControl((Control)this.isPureDBCS);
    }

    private void disposeCharWidgets() {
        this.disposeWidget((Control)this.encodingInput);
        this.encodingInput = null;
        this.disposeWidget((Control)this.exampleTextInput);
        this.exampleTextInput = null;
        this.disposeWidget((Control)this.reqLblEncoding);
        this.reqLblEncoding = null;
        this.disposeWidget((Control)this.textEncoding);
        this.textEncoding = null;
        this.disposeWidget((Control)this.isPureDBCS);
        this.isPureDBCS = null;
        this.groupMarshaller.layout();
    }

    private void addDecimalWidgets() {
        FormData formAppTypeFD1 = this.uih.genFormData(new FormAttachment((Control)this.comboPhysDatatype, this.verticalOffset), null, new FormAttachment(0, 0), null);
        this.reqLabelPrecision = this.uih.genRequiredSymbol((Composite)this.groupMarshaller, 0, formAppTypeFD1, this.groupMarshaller.getDisplay().getSystemColor(3));
        this.reqLabelPrecision.setFont(this.getFont());
        FormData formAppTypeFD2 = this.uih.genFormData(new FormAttachment((Control)this.comboPhysDatatype, this.verticalOffset), null, new FormAttachment(0, this.reqFieldSize), null);
        this.precisionInput = new Label((Composite)this.groupMarshaller, 0);
        this.precisionInput.setText(TranMessages.getLabel().getString("WB023A") + TranMessages.getColon().getString("COLON"));
        this.precisionInput.setToolTipText(Utility.formatMessage((String)TranMessages.getDescription().getString("WB090")));
        this.precisionInput.setLayoutData((Object)formAppTypeFD2);
        FormData formAppTypeFD3 = this.uih.genFormData(new FormAttachment((Control)this.comboPhysDatatype, this.verticalOffset), null, new FormAttachment(0, this.leftLabelSize), new FormAttachment(50, -this.horizontalOffset));
        this.textPrecision = new Text((Composite)this.groupMarshaller, 2052);
        this.textPrecision.setTextLimit(255);
        this.textPrecision.setLayoutData((Object)formAppTypeFD3);
        FormData formAppTypeFD4 = this.uih.genFormData(new FormAttachment((Control)this.comboPhysDatatype, this.verticalOffset), null, new FormAttachment(50, 0), null);
        this.regLabelScale = this.uih.genRequiredSymbol((Composite)this.groupMarshaller, 0, formAppTypeFD4, this.groupMarshaller.getDisplay().getSystemColor(3));
        this.regLabelScale.setFont(this.getFont());
        FormData formAppTypeFD5 = this.uih.genFormData(new FormAttachment((Control)this.comboPhysDatatype, this.verticalOffset), null, new FormAttachment(50, this.reqFieldSize), null);
        this.scaleInput = new Label((Composite)this.groupMarshaller, 0);
        this.scaleInput.setText(TranMessages.getLabel().getString("WB024A") + TranMessages.getColon().getString("COLON"));
        this.scaleInput.setToolTipText(Utility.formatMessage((String)TranMessages.getDescription().getString("WB19A")));
        this.scaleInput.setLayoutData((Object)formAppTypeFD5);
        FormData formAppTypeFD6 = this.uih.genFormData(new FormAttachment((Control)this.comboPhysDatatype, this.verticalOffset), null, new FormAttachment(50, this.rightLabelSize), new FormAttachment(100, -this.horizontalOffset));
        this.textScale = new Text((Composite)this.groupMarshaller, 2052);
        this.textScale.setTextLimit(255);
        this.textScale.setToolTipText(Utility.formatMessage((String)TranMessages.getDescription().getString("WB080")));
        this.textScale.setLayoutData((Object)formAppTypeFD6);
        FormData formAppTypeFD7 = this.uih.genFormData(new FormAttachment((Control)this.textPrecision, this.verticalOffset), null, new FormAttachment(0, 0), null);
        this.reqLabelSignedInput = this.uih.genRequiredSymbol((Composite)this.groupMarshaller, 0, formAppTypeFD7, this.groupMarshaller.getDisplay().getSystemColor(3));
        this.reqLabelSignedInput.setFont(this.getFont());
        FormData formAppTypeFD8 = this.uih.genFormData(new FormAttachment((Control)this.textPrecision, this.verticalOffset), null, new FormAttachment(0, this.reqFieldSize), null);
        this.isSignedLabel = new Label((Composite)this.groupMarshaller, 0);
        this.isSignedLabel.setText(TranMessages.getLabel().getString("WB025A") + TranMessages.getColon().getString("COLON"));
        this.isSignedLabel.setToolTipText(Utility.formatMessage((String)TranMessages.getDescription().getString("WB20A")));
        this.isSignedLabel.setLayoutData((Object)formAppTypeFD8);
        this.comboIsSigned = new Combo((Composite)this.groupMarshaller, 12);
        FormData formAppTypeFD9 = this.uih.genFormData(new FormAttachment((Control)this.textPrecision, this.verticalOffset), null, new FormAttachment(0, this.leftLabelSize), new FormAttachment(50, -this.horizontalOffset));
        this.comboIsSigned.setTextLimit(255);
        this.comboIsSigned.setToolTipText(Utility.formatMessage((String)TranMessages.getDescription().getString("WB20A")));
        this.comboIsSigned.setLayoutData((Object)formAppTypeFD9);
        this.comboIsSigned.setItems(this.YNItems);
        this.addMessageControlsDecimalWidgets();
    }

    private void addMessageControlsDecimalWidgets() {
        this.pdtMsgControl.addControl((Control)this.textPrecision);
        this.pdtMsgControl.addControl((Control)this.textScale);
        this.pdtMsgControl.addControl((Control)this.comboIsSigned);
    }

    private void disposeDecimalWidgets() {
        this.disposeWidget((Control)this.precisionInput);
        this.precisionInput = null;
        this.disposeWidget((Control)this.scaleInput);
        this.scaleInput = null;
        this.disposeWidget((Control)this.isSignedLabel);
        this.isSignedLabel = null;
        this.disposeWidget((Control)this.reqLabelPrecision);
        this.reqLabelPrecision = null;
        this.disposeWidget((Control)this.textPrecision);
        this.textPrecision = null;
        this.disposeWidget((Control)this.regLabelScale);
        this.regLabelScale = null;
        this.disposeWidget((Control)this.textScale);
        this.textScale = null;
        this.disposeWidget((Control)this.reqLabelSignedInput);
        this.reqLabelSignedInput = null;
        this.disposeWidget((Control)this.comboIsSigned);
        this.comboIsSigned = null;
        this.groupMarshaller.layout();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        try {
            if (visible) {
                this.comboAppDatatype.setFocus();
                this.validatePage(false, this.efController.hasBeenEdited());
                this.handleEnablement();
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "setVisible(boolean visible)", e);
            logger.error(e);
        }
    }

    private void handleEnablement() throws InvalidInputException {
        this.comboAppDatatype.setEnabled(true);
        if (this.comboAppDatatype.getText().equals(DBDConstants.ARRAY.value()) || this.comboAppDatatype.getText().equals(DBDConstants.STRUCT.value())) {
            this.comboPhysDatatype.setEnabled(false);
        } else {
            this.comboPhysDatatype.setEnabled(true);
        }
        if (this.comboAppDatatype.getText().equals(DBDConstants.DECIMAL.value()) || this.comboAppDatatype.getText().equals(DBDConstants.ARRAY.value()) || this.comboAppDatatype.getText().equals(DBDConstants.STRUCT.value())) {
            this.textFieldLength.setEnabled(false);
        } else {
            this.textFieldLength.setEnabled(true);
        }
        DBDConstants adt = this.efController.getAppDatatype();
        if (adt != null && adt.equals((Object)DBDConstants.ARRAY)) {
            Integer minOccurs = this.efController.getMinOccurs();
            Integer maxOccurs = this.efController.getMaxOccurs();
            if (maxOccurs != null && minOccurs != null) {
                if (minOccurs != null && maxOccurs != null && minOccurs.equals(maxOccurs)) {
                    this.comboDependOn.setEnabled(false);
                } else {
                    this.comboDependOn.setEnabled(true);
                }
            }
        }
        this.setLengthTooltips();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent event) {
        try {
            int movetopos;
            int movefrompos;
            if (event.widget == this.buttonAddName) {
                this.doAddTableItem();
            }
            if (event.widget == this.buttonRemove) {
                this.propertyTable.remove(this.propertyTable.getSelectionIndices());
            }
            if (event.widget == this.buttonClearAll) {
                this.propertyTable.removeAll();
            }
            if (event.widget == this.buttonUp) {
                movefrompos = 0;
                movetopos = 0;
                movefrompos = this.propertyTable.getSelectionIndex();
                if (movefrompos >= 0 && (movetopos = movefrompos - 1) >= 0) {
                    this.moveTableItem(this.propertyTable, movefrompos, movetopos);
                }
            }
            if (event.widget == this.buttonDown) {
                movefrompos = 0;
                movetopos = 0;
                int itemCnt = 0;
                if (this.propertyTable != null) {
                    itemCnt = this.propertyTable.getItemCount();
                }
                if ((movefrompos = this.propertyTable.getSelectionIndex()) >= 0 && (movetopos = movefrompos + 1) < itemCnt) {
                    this.moveTableItem(this.propertyTable, movefrompos, movetopos);
                }
            }
            this.validatePage(false, true);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "widgetSelected(SelectionEvent event)", e);
            logger.error(e);
        }
    }

    public void moveTableItem(Table table, int from, int to) {
        TableItem item2MoveDown = table.getItem(from);
        TableItem item2MoveUp = table.getItem(to);
        TableItem newTableItemDown = new TableItem(table, 0, to);
        TableItem newTableItemUp = new TableItem(table, 0, from);
        newTableItemUp.setText(item2MoveUp.getText());
        newTableItemDown.setText(item2MoveDown.getText());
        table.setSelection(newTableItemDown);
        item2MoveUp.dispose();
        item2MoveDown.dispose();
    }

    private void disposeAndCreatePhysWidgets() {
        String physDatatypeStr = this.comboPhysDatatype.getText().trim();
        String appDatatypeStr = this.comboAppDatatype.getText().trim();
        if (physDatatypeStr.equalsIgnoreCase(DBDConstants.CHAR.toString())) {
            if (this.currPhysState == PhysWidgetStates.PACKEDDECIMAL || this.currPhysState == PhysWidgetStates.ZONEDDECIMAL || this.currPhysState == PhysWidgetStates.BINARYDECIMAL) {
                this.disposeDecimalWidgets();
            } else if (this.currPhysState == PhysWidgetStates.CHAR) {
                return;
            }
            this.addCharWidgets();
            this.currPhysState = PhysWidgetStates.CHAR;
        } else if (physDatatypeStr.equalsIgnoreCase(DBDConstants.PACKEDDECIMAL.toString())) {
            if (this.currPhysState == PhysWidgetStates.CHAR) {
                this.disposeCharWidgets();
            } else {
                if (this.currPhysState == PhysWidgetStates.PACKEDDECIMAL) {
                    return;
                }
                if (this.currPhysState == PhysWidgetStates.ZONEDDECIMAL || this.currPhysState == PhysWidgetStates.BINARYDECIMAL) {
                    this.disposeDecimalWidgets();
                    this.currPhysState = PhysWidgetStates.PACKEDDECIMAL;
                }
            }
            this.addDecimalWidgets();
            this.currPhysState = PhysWidgetStates.PACKEDDECIMAL;
        } else if (physDatatypeStr.equalsIgnoreCase(DBDConstants.ZONEDDECIMAL.toString())) {
            if (this.currPhysState == PhysWidgetStates.CHAR) {
                this.disposeCharWidgets();
            } else {
                if (this.currPhysState == PhysWidgetStates.ZONEDDECIMAL) {
                    return;
                }
                if (this.currPhysState == PhysWidgetStates.PACKEDDECIMAL || this.currPhysState == PhysWidgetStates.BINARYDECIMAL) {
                    this.disposeDecimalWidgets();
                    this.currPhysState = PhysWidgetStates.ZONEDDECIMAL;
                }
            }
            this.addDecimalWidgets();
            this.currPhysState = PhysWidgetStates.ZONEDDECIMAL;
        } else if (physDatatypeStr.equalsIgnoreCase(DBDConstants.BINARY.toString())) {
            if (this.currPhysState == PhysWidgetStates.CHAR) {
                this.disposeCharWidgets();
            } else if (this.currPhysState == PhysWidgetStates.BINARYDECIMAL) {
                if (appDatatypeStr.equalsIgnoreCase(DBDConstants.DECIMAL.toString())) {
                    return;
                }
                this.disposeDecimalWidgets();
            } else if (this.currPhysState == PhysWidgetStates.ZONEDDECIMAL) {
                this.disposeDecimalWidgets();
            } else if (this.currPhysState == PhysWidgetStates.PACKEDDECIMAL) {
                this.disposeDecimalWidgets();
            }
            if (appDatatypeStr.equalsIgnoreCase(DBDConstants.DECIMAL.toString())) {
                this.addDecimalWidgets();
                this.currPhysState = PhysWidgetStates.BINARYDECIMAL;
            } else {
                this.currPhysState = PhysWidgetStates.OTHER;
            }
        } else {
            if (this.currPhysState == PhysWidgetStates.CHAR) {
                this.disposeCharWidgets();
            } else if (this.currPhysState == PhysWidgetStates.PACKEDDECIMAL || this.currPhysState == PhysWidgetStates.ZONEDDECIMAL || this.currPhysState == PhysWidgetStates.BINARYDECIMAL) {
                this.disposeDecimalWidgets();
            }
            this.currPhysState = PhysWidgetStates.OTHER;
        }
        this.groupMarshaller.layout();
        this.composite.layout();
    }

    private void doAddTableItem() {
        String propName = this.textUserName.getText();
        String propValue = this.textValue.getText();
        if (propName.length() > 0 && propValue.length() > 0) {
            String itemTableStr = propName + " = " + propValue;
            TableItem propertyItem = new TableItem(this.propertyTable, 16384);
            propertyItem.setText(itemTableStr);
            this.textUserName.removeModifyListener((ModifyListener)this);
            this.textValue.removeModifyListener((ModifyListener)this);
            this.textUserName.setText("");
            this.textValue.setText("");
            this.textUserName.addModifyListener((ModifyListener)this);
            this.textValue.addModifyListener((ModifyListener)this);
            this.propertyTable.setSelection(0);
        }
    }

    public String getAppDatatypeInput() {
        String appDatatypeInput = null;
        appDatatypeInput = this.comboAppDatatype.getText().trim();
        return appDatatypeInput;
    }

    public String getDatePatternInput() {
        String datePattern = null;
        if (this.textDateFormat != null) {
            datePattern = this.textDateFormat.getText().trim();
        }
        return datePattern;
    }

    public String getPhysDatatypeInput() {
        String physDatatypeInput = null;
        physDatatypeInput = this.comboPhysDatatype.getText().trim();
        return physDatatypeInput;
    }

    public String getPrecisionInput() {
        String precision = "";
        if (this.currPhysState == PhysWidgetStates.PACKEDDECIMAL || this.currPhysState == PhysWidgetStates.ZONEDDECIMAL) {
            precision = this.textPrecision.getText().trim();
        }
        return precision;
    }

    public String getScaleInput() {
        String scale = "";
        if (this.currPhysState == PhysWidgetStates.PACKEDDECIMAL || this.currPhysState == PhysWidgetStates.ZONEDDECIMAL) {
            scale = this.textScale.getText().trim();
        }
        return scale;
    }

    private String getisSignedInput() {
        String isSigned = "";
        if (this.currPhysState == PhysWidgetStates.PACKEDDECIMAL || this.currPhysState == PhysWidgetStates.ZONEDDECIMAL || this.currPhysState == PhysWidgetStates.BINARYDECIMAL) {
            isSigned = this.comboIsSigned.getText().trim();
            isSigned = isSigned.equals(this.YNItems[0]) ? "YES" : "NO";
        }
        return isSigned;
    }

    public EditFieldWizard getWiz() {
        return (EditFieldWizard)this.getWizard();
    }

    public void modifyText(ModifyEvent e) {
        try {
            String newVal;
            try {
                this.validateAttributeChangeable(e.widget);
            }
            catch (InvalidInputException iie) {
                String currentErrorMessage = this.getErrorMessage();
                this.setErrorMessage(iie.getMessage());
                MessageDialog.openInformation((Shell)this.getWiz().getShell(), (String)INFORMATION_STR, (String)iie.getMessage());
                this.setErrorMessage(currentErrorMessage);
                return;
            }
            if (e.widget == this.comboAppDatatype) {
                this.disposeAndCreateAppWidgets();
                this.disposeAndCreatePhysWidgets();
                this.removeAllListeners();
                this.initAppWidgetValues();
                this.initPhysWidgetValues();
                this.addDynamicWidgetListeners();
                this.addStaticWidgetListeners();
            } else if (e.widget == this.comboPhysDatatype && !(newVal = this.comboPhysDatatype.getText()).equals(this.cmbPhysDtCurrVal)) {
                this.cmbPhysDtCurrVal = newVal;
                this.disposeAndCreatePhysWidgets();
                this.removeAllListeners();
                this.initPhysWidgetValues();
                this.addDynamicWidgetListeners();
                this.addStaticWidgetListeners();
            }
            this.validatePage(false, true);
            this.handleEnablement();
            this.updateRequiredLabels();
        }
        catch (Throwable err) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "modifyText(ModifyEvent e)", err);
            logger.error(err);
        }
    }

    private void validateAttributeChangeable(Widget widget) throws InvalidInputException, ModelException {
        InvalidInputException iie = null;
        if (widget == this.comboAppDatatype) {
            iie = this.efController.validateAttrChangable("APP_DATATYPE", (Object)this.comboAppDatatype.getText());
            if (iie != null) {
                throw iie;
            }
        } else if (widget == this.comboPhysDatatype) {
            iie = this.efController.validateAttrChangable("PHY_DATATYPE", (Object)this.comboPhysDatatype.getText());
            if (iie != null) {
                throw iie;
            }
        } else if (widget == this.textScale) {
            String newScaleStr = this.textScale.getText();
            try {
                Integer.parseInt(newScaleStr);
            }
            catch (NumberFormatException numberFormatException) {
                String[] attrs = new String[]{"SCALE"};
                throw new InvalidInputException(TranMessages.getError().getString("EISRC46"), attrs);
            }
            iie = this.efController.validateAttrChangable("SCALE", (Object)newScaleStr);
            if (iie != null) {
                throw iie;
            }
        }
    }

    private void removeAllListeners() {
        this.comboAppDatatype.removeModifyListener((ModifyListener)this);
        this.comboPhysDatatype.removeModifyListener((ModifyListener)this);
        this.textFieldLength.removeModifyListener((ModifyListener)this);
        if (this.comboDependOn != null) {
            this.comboDependOn.removeModifyListener((ModifyListener)this);
            this.comboDependOn.removeFocusListener((FocusListener)this);
        }
        if (this.textMinOccurs != null) {
            this.textMinOccurs.removeModifyListener((ModifyListener)this);
            this.textMinOccurs.removeFocusListener((FocusListener)this.textFocusHighLight);
        }
        if (this.textMaxOccurs != null) {
            this.textMaxOccurs.removeModifyListener((ModifyListener)this);
            this.textMaxOccurs.removeFocusListener((FocusListener)this.textFocusHighLight);
        }
        if (this.textDateFormat != null) {
            this.textDateFormat.removeModifyListener((ModifyListener)this);
            this.textDateFormat.removeFocusListener((FocusListener)this.textFocusHighLight);
        }
        if (this.textPrecision != null) {
            this.textPrecision.removeModifyListener((ModifyListener)this);
            this.textPrecision.removeFocusListener((FocusListener)this.textFocusHighLight);
        }
        if (this.textScale != null) {
            this.textScale.removeModifyListener((ModifyListener)this);
            this.textScale.removeFocusListener((FocusListener)this.textFocusHighLight);
        }
        if (this.comboIsSigned != null) {
            this.comboIsSigned.removeModifyListener((ModifyListener)this);
        }
        if (this.textOverflow != null) {
            this.textOverflow.removeModifyListener((ModifyListener)this);
            this.textOverflow.removeFocusListener((FocusListener)this.textFocusHighLight);
        }
        if (this.textUserClassName != null) {
            this.textUserClassName.removeModifyListener((ModifyListener)this);
            this.textUserClassName.removeFocusListener((FocusListener)this.textFocusHighLight);
        }
        if (this.textUserName != null) {
            this.textUserName.removeModifyListener((ModifyListener)this);
            this.textUserName.removeFocusListener((FocusListener)this.textFocusHighLight);
        }
        if (this.textValue != null) {
            this.textValue.removeModifyListener((ModifyListener)this);
            this.textValue.removeFocusListener((FocusListener)this.textFocusHighLight);
        }
        if (this.textEncoding != null) {
            this.textEncoding.removeModifyListener((ModifyListener)this);
            this.textEncoding.removeFocusListener((FocusListener)this.textFocusHighLight);
        }
        if (this.isPureDBCS != null) {
            this.isPureDBCS.removeSelectionListener((SelectionListener)this);
        }
        if (this.buttonAddName != null) {
            this.buttonAddName.removeSelectionListener((SelectionListener)this);
        }
        if (this.buttonUp != null) {
            this.buttonUp.removeSelectionListener((SelectionListener)this);
        }
        if (this.buttonDown != null) {
            this.buttonDown.removeSelectionListener((SelectionListener)this);
        }
        if (this.buttonRemove != null) {
            this.buttonRemove.removeSelectionListener((SelectionListener)this);
        }
        if (this.buttonClearAll != null) {
            this.buttonClearAll.removeSelectionListener((SelectionListener)this);
        }
    }

    private void updateRequiredLabels() {
        DBDConstants adt = this.efController.getAppDatatype();
        if (adt == DBDConstants.ARRAY) {
            Integer minOccurs = this.efController.getMinOccurs();
            Integer maxOccurs = this.efController.getMaxOccurs();
            if (minOccurs != null && maxOccurs != null && maxOccurs > minOccurs) {
                this.reqLabelDependOn.setText("*");
                this.reqLabelDependOn.pack();
            } else {
                this.reqLabelDependOn.setText("");
                this.reqLabelDependOn.pack();
            }
        }
    }

    private void validateInput() throws InvalidInputException, ModelException {
        String adt = this.comboAppDatatype.getText();
        String pdt = this.comboPhysDatatype.getText();
        if (adt != null && !adt.isEmpty()) {
            this.efController.setAppDatatype(DBDConstants.fromValue((String)adt));
            pdt = this.comboPhysDatatype.getText();
        }
        if (!(pdt != null && !pdt.isEmpty() || adt.equals(DBDConstants.DECIMAL.value()) || adt.equals(DBDConstants.OTHER.value()))) {
            this.efController.clearPhysicalDataType();
        } else if (pdt == null || pdt.isEmpty()) {
            this.efController.setPhysicalDataType(null);
        } else {
            this.efController.setPhysicalDataType(DBDConstants.fromValue((String)pdt));
        }
        String fieldLength = this.textFieldLength.getText().trim();
        adt = this.comboAppDatatype.getText();
        pdt = this.comboPhysDatatype.getText();
        if (adt != null && !this.efController.isDynamicArray()) {
            if (adt.equals(DBDConstants.ARRAY.value()) || adt.equals(DBDConstants.STRUCT.value())) {
                if (!fieldLength.isEmpty()) {
                    this.efController.setBytes(fieldLength);
                }
            } else {
                this.efController.setBytes(fieldLength);
            }
        }
        if (adt.equals(DBDConstants.DATE.value()) || adt.equals(DBDConstants.TIME.value()) || adt.equals(DBDConstants.TIMESTAMP.value())) {
            this.efController.setPattern(this.textDateFormat.getText());
        }
        if (adt.equals(DBDConstants.ARRAY.value())) {
            this.efController.setMinOccurs(this.textMinOccurs.getText());
            this.efController.setMaxOccurs(this.textMaxOccurs.getText());
            this.efController.setDependsOn(this.comboDependOn.getText());
        }
        if (pdt.equals(DBDConstants.PACKEDDECIMAL.value()) || pdt.equals(DBDConstants.ZONEDDECIMAL.value()) || adt.equals(DBDConstants.DECIMAL.value()) && pdt.equals(DBDConstants.BINARY.value())) {
            if (this.textPrecision != null) {
                this.efController.setPrecision(this.textPrecision.getText());
            }
            if (this.textScale != null) {
                this.efController.setScale(this.textScale.getText());
            }
            if (this.comboIsSigned != null) {
                this.efController.setIsSigned(this.getisSignedInput());
            }
        }
        if (pdt.equals(DBDConstants.CHAR.value())) {
            String fieldEncoding = this.textEncoding.getText();
            this.efController.setEncoding(fieldEncoding);
        }
    }

    public void validatePage(boolean suppressErrorMessage, boolean invokedDueToUserEdit) throws ModelException {
        try {
            this.clearValidationMessages();
            if (invokedDueToUserEdit) {
                this.validateInput();
            }
            String[] attrsToCheck = new String[]{"APP_DATATYPE", "PATTERN", "MIN_OCCURS", "MAX_OCCURS", "DEPENDSON", "PRECISION", "SCALE", "IS_SIGNED", "LENGTH"};
            this.efController.validateRequiredFields(attrsToCheck);
            this.efController.semanticCheck();
            this.setPageComplete(true);
        }
        catch (InvalidInputException iie) {
            String[] errorAttrs;
            logger.throwing(((Object)((Object)this)).getClass().getName(), "", (Throwable)iie);
            int errorCode = iie.getErrorCode();
            if (!suppressErrorMessage) {
                String message = iie.getMessage();
                if (errorCode == 12) {
                    MessageDialog.openInformation((Shell)this.getWiz().getShell(), (String)INFORMATION_STR, (String)iie.getMessage());
                } else {
                    this.setErrorMessage(message);
                    this.setValidationMessages(iie);
                }
            }
            if (Utility.allAttrsOnPage((String[])(errorAttrs = iie.getAttrNames()), (String[])pageAttrs) && errorCode != 12) {
                this.setPageComplete(false);
            }
            this.setPageComplete(true);
        }
    }

    private void clearValidationMessages() {
        this.setErrorMessage(null);
        this.msgControl.clearValidationMessage((Control)this.textFieldLength);
        this.pdtMsgControl.clearValidationMessage((Control)this.comboPhysDatatype);
        String appDatatypeStr = this.comboAppDatatype.getText();
        if (appDatatypeStr.equals(DBDConstants.ARRAY.toString())) {
            this.msgControl.clearValidationMessage((Control)this.comboDependOn);
            this.msgControl.clearValidationMessage((Control)this.textMinOccurs);
            this.msgControl.clearValidationMessage((Control)this.textMaxOccurs);
        } else if (appDatatypeStr.equals(DBDConstants.DATE.toString()) || appDatatypeStr.equals(DBDConstants.TIME.toString()) || appDatatypeStr.equals(DBDConstants.TIMESTAMP.toString())) {
            this.msgControl.clearValidationMessage((Control)this.textDateFormat);
        }
        String physDatatypeStr = this.comboPhysDatatype.getText().trim();
        if (physDatatypeStr.equalsIgnoreCase(DBDConstants.CHAR.toString())) {
            this.pdtMsgControl.clearValidationMessage((Control)this.textEncoding);
        } else if (physDatatypeStr.equalsIgnoreCase(DBDConstants.PACKEDDECIMAL.toString()) || physDatatypeStr.equalsIgnoreCase(DBDConstants.ZONEDDECIMAL.toString()) || appDatatypeStr.equals(DBDConstants.DECIMAL.toString()) && physDatatypeStr.equals(DBDConstants.BINARY.toString())) {
            this.pdtMsgControl.clearValidationMessage((Control)this.textPrecision);
            this.pdtMsgControl.clearValidationMessage((Control)this.textScale);
            this.pdtMsgControl.clearValidationMessage((Control)this.comboIsSigned);
        } else if (physDatatypeStr.equalsIgnoreCase(DBDConstants.USER.toString())) {
            this.pdtMsgControl.clearValidationMessage((Control)this.textUserClassName);
        }
    }

    private void setValidationMessages(InvalidInputException iie) {
        String[] attrs = iie.getAttrNames();
        int i = 0;
        while (i < attrs.length) {
            String attrName = attrs[i];
            if (attrName.equals("ENCODING")) {
                this.pdtMsgControl.setValidationMessage((Control)this.textEncoding, iie.getMessage(), 3);
            } else if (attrName.equals("PRECISION")) {
                this.pdtMsgControl.setValidationMessage((Control)this.textPrecision, iie.getMessage(), 3);
            } else if (attrName.equals("SCALE")) {
                this.pdtMsgControl.setValidationMessage((Control)this.textScale, iie.getMessage(), 3);
            } else if (attrName.equals("IS_SIGNED")) {
                this.pdtMsgControl.setValidationMessage((Control)this.comboIsSigned, iie.getMessage(), 3);
            } else if (attrName.equals("OVERFLOW_SEGM")) {
                this.pdtMsgControl.setValidationMessage((Control)this.textOverflow, iie.getMessage(), 3);
            } else if (attrName.equals("PATTERN")) {
                this.msgControl.setValidationMessage((Control)this.textDateFormat, iie.getMessage(), 3);
            } else if (attrName.equals("DEPENDSON")) {
                this.msgControl.setValidationMessage((Control)this.comboDependOn, iie.getMessage(), 3);
            } else if (attrName.equals("MIN_OCCURS")) {
                this.msgControl.setValidationMessage((Control)this.textMinOccurs, iie.getMessage(), 3);
            } else if (attrName.equals("MAX_OCCURS")) {
                this.msgControl.setValidationMessage((Control)this.textMaxOccurs, iie.getMessage(), 3);
            } else if (attrName.equals("LENGTH")) {
                this.msgControl.setValidationMessage((Control)this.textFieldLength, iie.getMessage(), 3);
            } else if (attrName.equals("PHY_DATATYPE")) {
                this.pdtMsgControl.setValidationMessage((Control)this.comboPhysDatatype, iie.getMessage(), 3);
            }
            ++i;
        }
    }

    private void addDateWidgets() {
        FormData formAppTypeFD6 = this.uih.genFormData(new FormAttachment((Control)this.comboAppDatatype, this.verticalOffset + 2), null, new FormAttachment(0, 0), null);
        this.reqDateFormatLabel = this.uih.genRequiredSymbol((Composite)this.groupAppType, 0, formAppTypeFD6, this.groupAppType.getDisplay().getSystemColor(3));
        this.dateFormatLabel = new Label((Composite)this.groupAppType, 0);
        this.dateFormatLabel.setText(TranMessages.getLabel().getString("WB022A") + TranMessages.getColon().getString("COLON"));
        this.dateFormatLabel.setToolTipText(Utility.formatMessage((String)TranMessages.getDescription().getString("WB17A")));
        FormData fd = this.uih.genFormData(new FormAttachment((Control)this.comboAppDatatype, this.verticalOffset), null, new FormAttachment(0, this.reqFieldSize), null);
        this.dateFormatLabel.setLayoutData((Object)fd);
        this.textDateFormat = new Text((Composite)this.groupAppType, 2052);
        this.textDateFormat.setTextLimit(255);
        Object[] inserts = new Object[]{TranMessages.getColon().getString("COLON")};
        this.textDateFormat.setToolTipText(Utility.formatMessage((String)TranMessages.getDescription().getString("WB17B", inserts)));
        FormData fd1 = this.uih.genFormData(new FormAttachment((Control)this.comboAppDatatype, this.verticalOffset), null, new FormAttachment(0, this.leftLabelSize), new FormAttachment(50, -this.horizontalOffset));
        this.textDateFormat.setLayoutData((Object)fd1);
        Object[] inserts2 = new Object[]{new String(Character.toChars(8482)), TranMessages.getColon().getString("COLON")};
        this.textDateFormat.setToolTipText(Utility.formatMessage((String)TranMessages.getDescription().getString("WB091", inserts2)));
        this.addMessageControlsDateWidgets();
    }

    private void addMessageControlsDateWidgets() {
        this.msgControl.addControl((Control)this.textDateFormat);
    }

    private void initDateWidgetValues() {
        String dateFormat = this.efController.getPattern();
        if (dateFormat == null) {
            dateFormat = "";
        }
        this.textDateFormat.setText(dateFormat);
    }

    private void initLengthWidgetValue() throws ModelException {
        String appDataType = this.comboAppDatatype.getText();
        if (appDataType.equals(DBDConstants.STRUCT.value()) || appDataType.equals(DBDConstants.ARRAY.value())) {
            String bytesStr = this.efController.getBytes();
            if (bytesStr.equals("0")) {
                String maxBytesStr = this.efController.getMaxBytes();
                this.textFieldLength.setText(maxBytesStr);
            } else {
                this.textFieldLength.setText(bytesStr);
            }
        } else {
            String bytesStr = this.efController.getBytes();
            this.textFieldLength.setText(bytesStr);
        }
        this.setLengthTooltips();
    }

    private void setLengthTooltips() {
        String adt = this.comboAppDatatype.getText();
        String lengthTooltips = TranMessages.getDescription().getString("WB04A");
        if (adt.equals(DBDConstants.ARRAY.value()) || adt.equals(DBDConstants.STRUCT.value())) {
            lengthTooltips = TranMessages.getDescription().getString("WB04B");
        } else if (adt.equals(DBDConstants.DECIMAL.value())) {
            Object[] inserts = new String[]{TranMessages.getLabel().getString("WB344")};
            lengthTooltips = TranMessages.getDescription().getString("WB04C", inserts);
        }
        this.fieldLengthLabel.setToolTipText(Utility.formatMessage((String)lengthTooltips));
    }

    private void addArrayWidgets() throws ModelException {
        FormData formAppTypeFD3 = this.uih.genFormData(new FormAttachment((Control)this.comboAppDatatype, this.verticalOffset + 2), null, new FormAttachment(0, 0), null);
        this.reqedLabelMinOccurs1 = this.uih.genRequiredSymbol((Composite)this.groupAppType, 0, formAppTypeFD3, this.groupAppType.getDisplay().getSystemColor(3));
        this.reqedLabelMinOccurs1.setFont(this.getFont());
        FormData formAppTypeFD4 = this.uih.genFormData(new FormAttachment((Control)this.comboAppDatatype, this.verticalOffset), null, new FormAttachment(0, this.reqFieldSize), null);
        this.lblMinOccurs = new Label((Composite)this.groupAppType, 0);
        this.lblMinOccurs.setText(MIN_OCCURS_LABEL);
        this.lblMinOccurs.setToolTipText(Utility.formatMessage((String)TranMessages.getDescription().getString("WB463A")));
        this.lblMinOccurs.setLayoutData((Object)formAppTypeFD4);
        FormData formAppTypeFD5 = this.uih.genFormData(new FormAttachment((Control)this.comboAppDatatype, this.verticalOffset), null, new FormAttachment(0, this.leftLabelSize), new FormAttachment(50, -this.horizontalOffset));
        this.textMinOccurs = new Text((Composite)this.groupAppType, 2052);
        this.textMinOccurs.setTextLimit(255);
        this.textMinOccurs.setToolTipText(Utility.formatMessage((String)TranMessages.getDescription().getString("WB463B")));
        this.textMinOccurs.setLayoutData((Object)formAppTypeFD5);
        FormData formAppTypeFD6 = this.uih.genFormData(new FormAttachment((Control)this.comboAppDatatype, this.verticalOffset), null, new FormAttachment(50, 0), null);
        this.reqLabelMaxOccurs = this.uih.genRequiredSymbol((Composite)this.groupAppType, 0, formAppTypeFD6, this.groupAppType.getDisplay().getSystemColor(3));
        this.reqLabelMaxOccurs.setFont(this.getFont());
        FormData formAppTypeFD7 = this.uih.genFormData(new FormAttachment((Control)this.comboAppDatatype, this.verticalOffset), null, new FormAttachment(50, this.reqFieldSize), null);
        this.lblMaxOccurs = new Label((Composite)this.groupAppType, 0);
        this.lblMaxOccurs.setText(MAX_OCCURS_LABEL);
        this.lblMaxOccurs.setToolTipText(Utility.formatMessage((String)TranMessages.getDescription().getString("WB465A")));
        this.lblMaxOccurs.setLayoutData((Object)formAppTypeFD7);
        FormData formAppTypeFD8 = this.uih.genFormData(new FormAttachment((Control)this.comboAppDatatype, this.verticalOffset), null, new FormAttachment(50, this.rightLabelSize), new FormAttachment(100, -this.horizontalOffset));
        this.textMaxOccurs = new Text((Composite)this.groupAppType, 2052);
        this.textMaxOccurs.setTextLimit(255);
        this.textMaxOccurs.setToolTipText(Utility.formatMessage((String)TranMessages.getDescription().getString("WB465B")));
        this.textMaxOccurs.setLayoutData((Object)formAppTypeFD8);
        FormData formAppTypeFD = this.uih.genFormData(new FormAttachment((Control)this.textMinOccurs, this.verticalOffset + 2), null, new FormAttachment(0, 0), null);
        this.reqLabelDependOn = this.uih.genRequiredSymbol((Composite)this.groupAppType, 0, formAppTypeFD, this.groupAppType.getDisplay().getSystemColor(3));
        this.reqLabelDependOn.setFont(this.getFont());
        FormData formAppTypeFD1 = this.uih.genFormData(new FormAttachment((Control)this.textMinOccurs, this.verticalOffset + 2), null, new FormAttachment(0, this.reqFieldSize), null);
        this.lblDependOn = new Label((Composite)this.groupAppType, 0);
        this.lblDependOn.setText(DEPEND_ON_LABEL);
        this.lblDependOn.setToolTipText(Utility.formatMessage((String)TranMessages.getDescription().getString("WB462")));
        this.lblDependOn.setLayoutData((Object)formAppTypeFD1);
        FormData formAppTypeFD2 = this.uih.genFormData(new FormAttachment((Control)this.textMinOccurs, this.verticalOffset + 2), null, new FormAttachment(0, this.leftLabelSize), new FormAttachment(50, -this.horizontalOffset));
        this.comboDependOn = new Combo((Composite)this.groupAppType, 2060);
        this.populateDependOnCombo();
        this.comboDependOn.setLayoutData((Object)formAppTypeFD2);
        this.addMessageControlsArrayWidgets();
    }

    private void addMessageControlsArrayWidgets() {
        this.msgControl.addControl((Control)this.comboDependOn);
        this.msgControl.addControl((Control)this.textMinOccurs);
        this.msgControl.addControl((Control)this.textMaxOccurs);
    }

    private void addMessageControlsLengthWidgets() {
        this.msgControl.addControl((Control)this.textFieldLength);
    }

    private void addLengthWidgetListeners() {
        this.textFieldLength.addModifyListener((ModifyListener)this);
    }

    private void initArrayWidgetValues() {
        String dependson = this.efController.getDependsOn();
        if (dependson == null) {
            dependson = "";
        }
        this.comboDependOn.setText(dependson);
        Integer minOccurs = this.efController.getMinOccurs();
        Integer maxOccurs = this.efController.getMaxOccurs();
        if (minOccurs == null) {
            this.textMinOccurs.setText("");
        } else {
            this.textMinOccurs.setText(minOccurs.toString());
        }
        if (maxOccurs == null) {
            this.textMaxOccurs.setText("");
        } else {
            this.textMaxOccurs.setText(maxOccurs.toString());
        }
    }

    private void disposeDateWidgets() {
        this.disposeWidget((Control)this.reqDateFormatLabel);
        this.reqDateFormatLabel = null;
        this.disposeWidget((Control)this.dateFormatLabel);
        this.dateFormatLabel = null;
        this.disposeWidget((Control)this.textDateFormat);
        this.textDateFormat = null;
    }

    private void disposeArrayWidgets() {
        this.disposeWidget((Control)this.reqedLabelMinOccurs1);
        this.reqedLabelMinOccurs1 = null;
        this.disposeWidget((Control)this.lblMinOccurs);
        this.lblMinOccurs = null;
        this.disposeWidget((Control)this.textMinOccurs);
        this.textMinOccurs = null;
        this.disposeWidget((Control)this.reqLabelMaxOccurs);
        this.reqLabelMaxOccurs = null;
        this.disposeWidget((Control)this.lblMaxOccurs);
        this.lblMaxOccurs = null;
        this.disposeWidget((Control)this.textMaxOccurs);
        this.textMaxOccurs = null;
        this.disposeWidget((Control)this.reqLabelDependOn);
        this.reqLabelDependOn = null;
        this.disposeWidget((Control)this.lblDependOn);
        this.lblDependOn = null;
        this.disposeWidget((Control)this.comboDependOn);
        this.comboDependOn = null;
    }

    private void disposeWidget(Control uiCtrl) {
        if (uiCtrl != null) {
            if (uiCtrl.getParent().equals(this.groupAppType)) {
                this.msgControl.removeControl(uiCtrl);
            } else if (uiCtrl.getParent().equals(this.groupMarshaller)) {
                this.pdtMsgControl.removeControl(uiCtrl);
            }
            uiCtrl.dispose();
        }
    }

    private void disposeAndCreateAppWidgets() throws ModelException {
        String appDatatypeStr = this.comboAppDatatype.getText();
        if (appDatatypeStr.equals(DBDConstants.ARRAY.toString())) {
            if (this.currAppState == AppWidgetStates.DATE || this.currAppState == AppWidgetStates.TIME || this.currAppState == AppWidgetStates.TIMESTAMP) {
                this.disposeDateWidgets();
            } else if (this.currAppState == AppWidgetStates.ARRAY) {
                return;
            }
            this.addArrayWidgets();
            this.currAppState = AppWidgetStates.ARRAY;
        } else if (appDatatypeStr.equals(DBDConstants.DATE.toString()) || appDatatypeStr.equals(DBDConstants.TIME.toString()) || appDatatypeStr.equals(DBDConstants.TIMESTAMP.toString())) {
            if (this.currAppState == AppWidgetStates.ARRAY) {
                this.disposeArrayWidgets();
            } else if (this.currAppState == AppWidgetStates.DATE || this.currAppState == AppWidgetStates.TIME || this.currAppState == AppWidgetStates.TIMESTAMP) {
                return;
            }
            this.addDateWidgets();
            this.currAppState = appDatatypeStr.equals(DBDConstants.DATE.toString()) ? AppWidgetStates.DATE : (appDatatypeStr.equals(DBDConstants.TIME.toString()) ? AppWidgetStates.TIME : AppWidgetStates.TIMESTAMP);
        } else {
            if (this.currAppState == AppWidgetStates.ARRAY) {
                this.disposeArrayWidgets();
            } else if (this.currAppState == AppWidgetStates.DATE || this.currAppState == AppWidgetStates.TIME || this.currAppState == AppWidgetStates.TIMESTAMP) {
                this.disposeDateWidgets();
            }
            this.currAppState = AppWidgetStates.OTHER;
        }
        this.groupAppType.layout();
        this.composite.layout();
    }

    private void getMaxLabelSizes() {
        int[] leftLabelSizes = new int[]{Utility.getTextWidth((Composite)this.composite, (int)0, (String)this.appDatatypeInput.getText()), Utility.getTextWidth((Composite)this.composite, (int)0, (String)this.physDatatypeInput.getText()), Utility.getTextWidth((Composite)this.composite, (int)0, (String)MIN_OCCURS_LABEL), Utility.getTextWidth((Composite)this.composite, (int)0, (String)(TranMessages.getLabel().getString("IMS_ENCODING") + TranMessages.getColon().getString("COLON"))), Utility.getTextWidth((Composite)this.composite, (int)0, (String)(TranMessages.getLabel().getString("WB023A") + TranMessages.getColon().getString("COLON"))), Utility.getTextWidth((Composite)this.composite, (int)0, (String)DEPEND_ON_LABEL), Utility.getTextWidth((Composite)this.composite, (int)0, (String)(TranMessages.getLabel().getString("WB022A") + TranMessages.getColon().getString("COLON")))};
        this.leftLabelSize = Utility.getMaxSize((int[])leftLabelSizes) + this.marginLabelAndText;
        int[] rightLabelSizes = new int[]{Utility.getTextWidth((Composite)this.composite, (int)0, (String)(TranMessages.getLabel().getString("WB013A") + TranMessages.getColon().getString("COLON"))), Utility.getTextWidth((Composite)this.composite, (int)0, (String)MAX_OCCURS_LABEL), Utility.getTextWidth((Composite)this.composite, (int)0, (String)(TranMessages.getLabel().getString("WB041A") + TranMessages.getColon().getString("COLON") + "Cp1047")), Utility.getTextWidth((Composite)this.composite, (int)0, (String)(TranMessages.getLabel().getString("WB024A") + TranMessages.getColon().getString("COLON")))};
        this.rightLabelSize = Utility.getMaxSize((int[])rightLabelSizes) + this.marginLabelAndText;
    }

    private void populateDependOnCombo() throws ModelException {
        List depOnCandidates = this.efController.getDependsOnCandidates();
        for (FieldModel fm : depOnCandidates) {
            this.comboDependOn.add(fm.getName());
        }
    }

    public void focusGained(FocusEvent event) {
        try {
            if (event.widget == this.comboDependOn && this.comboDependOn.getItemCount() == 0) {
                this.textMinOccurs.setFocus();
                Object[] inserts = new Object[]{TranMessages.getLabel().getString("EDIT_FIELD_WIZARD_DEPENDS_ON"), TranMessages.getLabel().getString("EDIT_FIELD_WIZARD_MIN_OCCURS"), TranMessages.getLabel().getString("EDIT_FIELD_WIZARD_MAX_OCCURS"), TranMessages.getLabel().getString("EDIT_FIELD_WIZARD_DEPENDS_ON")};
                String infoMsg = TranMessages.getError().getString("EDIT_FIELD_WIZ_14", inserts);
                MessageDialog.openInformation((Shell)this.getWiz().getShell(), (String)INFORMATION_STR, (String)infoMsg);
            } else if (event.widget == this.textFieldLength) {
                int valLength = this.textFieldLength.getText().length();
                this.textFieldLength.setSelection(0, valLength);
            }
        }
        catch (Throwable err) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "focusGained(FocusEvent arg0)", err);
            logger.error(err);
        }
    }

    public void focusLost(FocusEvent arg0) {
    }

    public void handleModelChange(ModelChangeEvent modelChangeEvent) {
        try {
            this.removeAllListeners();
            String[] stringArray = modelChangeEvent.getAttrs();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                Integer scale;
                String attr = stringArray[n2];
                DBDConstants adt = this.efController.getAppDatatype();
                DBDConstants pdt = this.efController.getPhysicalDataType();
                if (attr.equals("APP_DATATYPE")) {
                    if (adt != null) {
                        this.comboAppDatatype.setText(adt.value());
                    } else {
                        this.comboAppDatatype.setText(DBDConstants.CHAR.toString());
                    }
                    this.disposeAndCreateAppWidgets();
                    this.initAppWidgetValues();
                } else if (attr.equals("PHY_DATATYPE")) {
                    if (pdt != null) {
                        if (pdt.equals((Object)DBDConstants.BINARY)) {
                            this.comboPhysDatatype.setText(DBDConstants.BINARY.value());
                        } else if (pdt.equals((Object)DBDConstants.BIT)) {
                            this.comboPhysDatatype.setText(DBDConstants.BIT.value());
                        } else if (pdt.equals((Object)DBDConstants.BLOB)) {
                            this.comboPhysDatatype.setText(DBDConstants.BLOB.value());
                        } else if (pdt.equals((Object)DBDConstants.BYTE)) {
                            this.comboPhysDatatype.setText(DBDConstants.BYTE.value());
                        } else if (pdt.equals((Object)DBDConstants.CHAR)) {
                            this.comboPhysDatatype.setText(DBDConstants.CHAR.value());
                        } else if (pdt.equals((Object)DBDConstants.CLOB)) {
                            this.comboPhysDatatype.setText(DBDConstants.CLOB.value());
                        } else if (pdt.equals((Object)DBDConstants.PACKEDDECIMAL)) {
                            this.comboPhysDatatype.setText(DBDConstants.PACKEDDECIMAL.value());
                        } else if (pdt.equals((Object)DBDConstants.DOUBLE)) {
                            this.comboPhysDatatype.setText(DBDConstants.DOUBLE.value());
                        } else if (pdt.equals((Object)DBDConstants.FLOAT)) {
                            this.comboPhysDatatype.setText(DBDConstants.FLOAT.value());
                        } else if (pdt.equals((Object)DBDConstants.INT)) {
                            this.comboPhysDatatype.setText(DBDConstants.INT.value());
                        } else if (pdt.equals((Object)DBDConstants.LONG)) {
                            this.comboPhysDatatype.setText(DBDConstants.LONG.value());
                        } else if (pdt.equals((Object)DBDConstants.SHORT)) {
                            this.comboPhysDatatype.setText(DBDConstants.SHORT.value());
                        } else if (pdt.equals((Object)DBDConstants.BIT)) {
                            this.comboPhysDatatype.setText(DBDConstants.BIT.value());
                        }
                    } else {
                        this.comboPhysDatatype.setText("");
                    }
                    this.cmbPhysDtCurrVal = this.comboPhysDatatype.getText();
                    this.disposeAndCreatePhysWidgets();
                    this.initPhysWidgetValues();
                } else if (attr.equals("LENGTH")) {
                    String len = this.efController.getBytes();
                    this.textFieldLength.setText(len);
                } else if (attr.equals("DEPENDSON")) {
                    String dependOn = this.efController.getDependsOn();
                    if (dependOn == null) {
                        this.msgControl.clearValidationMessage((Control)this.comboDependOn);
                        this.comboDependOn.setText("");
                    }
                } else if (attr.equals("SCALE") && (scale = this.efController.getScale()) != null) {
                    this.textScale.setText(String.valueOf(scale));
                }
                ++n2;
            }
            this.addDynamicWidgetListeners();
            this.addStaticWidgetListeners();
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "handleModelChange(ModelChangeEvent modelChangeEvent)", e);
            logger.error(e);
        }
    }

    private static enum AppWidgetStates {
        ARRAY,
        DATE,
        TIME,
        TIMESTAMP,
        OTHER;

    }

    private static enum PhysWidgetStates {
        CHAR,
        PACKEDDECIMAL,
        ZONEDDECIMAL,
        OTHER,
        BINARYDECIMAL;

    }
}

