/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.transaction.fieldEditor;

import com.ibm.im.ims.transaction.controller.datastructure.DBDConstants;
import com.ibm.im.ims.transaction.controller.editor.EditFieldController;
import com.ibm.im.ims.transaction.controller.editor.IModelChangeListener;
import com.ibm.im.ims.transaction.controller.editor.InvalidInputException;
import com.ibm.im.ims.transaction.controller.editor.ModelChangeEvent;
import com.ibm.im.ims.transaction.model.utilities.ModelException;
import com.ibm.im.ims.transaction.model.utilities.Utility;
import com.ibm.im.ims.workbench.transaction.fieldEditor.EditFieldWizard;
import com.ibm.im.ims.workbench.transaction.model.FieldModel;
import com.ibm.im.ims.workbench.transaction.resources.utilities.TranMessages;
import com.ibm.im.ims.workbench.transaction.utilities.EAMessageControl;
import com.ibm.im.ims.workbench.transaction.utilities.UIHelper;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class EditFieldWizardPage0
extends WizardPage
implements SelectionListener,
VerifyListener,
ModifyListener,
FocusListener,
IModelChangeListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private EditFieldController efController;
    private static final int adjustment = 2;
    private static final int require_label_space = 3;
    private static final int status_label_space = 4;
    private static final int margin = 5;
    private static final String[] pageAttrs = new String[]{"ORIG_NAME", "ALIAS", "PARENT", "START", "REDEFINES", "REMARKS"};
    private static final String INFORMATION_STR = TranMessages.getError().getString("EISRC25");
    private static final String FLDNAME_LABEL = TranMessages.getLabel().getString("WB010A") + TranMessages.getColon().getString("COLON");
    private static final String FLDALIAS_LABEL = TranMessages.getLabel().getString("WB211") + TranMessages.getColon().getString("COLON");
    private static final String MESSAGE_LABEL = TranMessages.getLabel().getString("EDIT_FIELD_WIZARD_LOCATION_MESSAGE") + TranMessages.getColon().getString("COLON");
    private static final String SEGMENT_LABEL = TranMessages.getLabel().getString("EDIT_FIELD_WIZARD_LOCATION_SEGMENT") + TranMessages.getColon().getString("COLON");
    private static final String PARENT_LABEL = TranMessages.getLabel().getString("EDIT_FIELD_WIZARD_LOCATION_PARENT") + TranMessages.getColon().getString("COLON");
    private static final String START_AFTER_LABEL = TranMessages.getLabel().getString("EDIT_FIELD_WIZARD_POSITION_START_AFTER") + TranMessages.getColon().getString("COLON");
    protected static final String REDEFINES_LABEL = TranMessages.getLabel().getString("EDIT_FIELD_WIZARD_REDEFINES") + TranMessages.getColon().getString("COLON");
    private static final String REMARKS_LABEL = TranMessages.getLabel().getString("EMP_REMARKS") + TranMessages.getColon().getString("COLON");
    private static final String FLD_ALIAS_LABEL_HOVER_TEXT = Utility.formatMessage((String)TranMessages.getDescription().getString("WB460"));
    private static final String PARENT_LABEL_HOVER_TEXT = Utility.formatMessage((String)TranMessages.getDescription().getString("WB460C"));
    private static final String REMARKS_LABEL_HOVER_TEXT = TranMessages.getDescription().getString("WB099");
    private static final String REMARKS_TEXT_HOVER_TEXT = TranMessages.getDescription().getString("WB100");
    private static final String START_TEXT_HOVER_TEXT = Utility.formatMessage((String)TranMessages.getDescription().getString("WB460D"));
    private Text fieldName;
    private Text fieldAlias;
    private Text messageName;
    private Text segmentName;
    private Combo comboParentField;
    private Combo comboStartAfter;
    private Combo comboRedefinesField;
    private Text textRemarks;
    private EAMessageControl msgControl;
    private Label labelFldName;
    private Label labelFldAlias;
    private Label labelMsg;
    private Label labelSeg;
    private Label labelParentField;
    private Label labelStart;
    private Label labelRedefines;
    private Label labelRemarks;
    private Label fldNameReq;

    protected EditFieldWizardPage0(EditFieldController efController) {
        super("EditFieldWizardPage0");
        this.setTitle(TranMessages.getDescription().getString("WB34A2"));
        this.setDescription(TranMessages.getDescription().getString("WB35A2"));
        if (efController.getActionType().equals("EDIT")) {
            this.setTitle(TranMessages.getDescription().getString("WB34A1"));
            this.setDescription(TranMessages.getDescription().getString("WB35A1"));
        }
        this.efController = efController;
        this.efController.addModelChangeListener((IModelChangeListener)this);
        this.setImageDescriptor(ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"/icons/EFWAdd.gif"));
        this.setPageComplete(false);
        if (efController.getActionType().equals("EDIT")) {
            this.setImageDescriptor(ImageDescriptor.createFromFile(((Object)((Object)this)).getClass(), (String)"/icons/EFWEdit.gif"));
            this.setPageComplete(true);
        }
    }

    public void createControl(Composite parent) {
        logger.entering(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", new Object[0]);
        try {
            Composite composite = new Composite(parent, 0);
            this.msgControl = new EAMessageControl(composite);
            UIHelper uih = new UIHelper();
            Display display = parent.getDisplay();
            uih.setDisplay(display);
            FormLayout layout = new FormLayout();
            layout.marginWidth = 5;
            layout.marginHeight = 5;
            composite.setLayout((Layout)layout);
            FormData fd = uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment(0, 0), new FormAttachment(100, 0));
            Composite nameComposite = new Composite(composite, 0);
            nameComposite.setLayout((Layout)layout);
            nameComposite.setLayoutData((Object)fd);
            fd = uih.genFormData(new FormAttachment((Control)this.messageName, 8), null, new FormAttachment(0, 5), null);
            this.fldNameReq = uih.genRequiredSymbol(nameComposite, 0, fd, composite.getDisplay().getSystemColor(3));
            fd = uih.genFormData(new FormAttachment((Control)this.messageName, 5), null, new FormAttachment((Control)this.fldNameReq, 5), null);
            this.labelFldName = new Label(nameComposite, 0);
            this.labelFldName.setText(FLDNAME_LABEL);
            this.labelFldName.pack();
            this.labelFldName.setLayoutData((Object)fd);
            fd = uih.genFormData(new FormAttachment((Control)this.messageName, 3), null, new FormAttachment((Control)this.labelFldName, 5), new FormAttachment(50, -20));
            if (this.efController.getActionType().equals("ADD")) {
                this.fieldName = new Text(nameComposite, 2048);
                this.fldNameReq.setVisible(true);
            } else {
                this.fieldName = new Text(nameComposite, 2056);
                this.fldNameReq.setVisible(false);
            }
            this.fieldName.setLayoutData((Object)fd);
            fd = uih.genFormData(new FormAttachment((Control)this.segmentName, 8), null, new FormAttachment(50, 5), null);
            Label fldAliasReq = uih.genRequiredSymbol(nameComposite, 0, fd, composite.getDisplay().getSystemColor(3));
            fldAliasReq.setVisible(true);
            fd = uih.genFormData(new FormAttachment((Control)nameComposite, 5), null, new FormAttachment((Control)fldAliasReq, 5), null);
            this.labelFldAlias = new Label(nameComposite, 0);
            this.labelFldAlias.setText(FLDALIAS_LABEL);
            this.labelFldAlias.setToolTipText(FLD_ALIAS_LABEL_HOVER_TEXT);
            this.labelFldAlias.pack();
            this.labelFldAlias.setLayoutData((Object)fd);
            fd = uih.genFormData(new FormAttachment((Control)this.segmentName, 3), null, new FormAttachment((Control)this.labelFldAlias, 5), new FormAttachment(100, -20));
            this.fieldAlias = new Text(nameComposite, 2048);
            this.fieldAlias.setLayoutData((Object)fd);
            fd = uih.genFormData(new FormAttachment((Control)nameComposite, 0), null, new FormAttachment(0, 5), new FormAttachment(100, -5));
            Group fieldLocationGroup = new Group(composite, 0);
            fieldLocationGroup.setLayout((Layout)layout);
            fieldLocationGroup.setLayoutData((Object)fd);
            fieldLocationGroup.setText(TranMessages.getLabel().getString("EDIT_FIELD_WIZARD_LOCATION_TRAN"));
            fd = uih.genFormData(new FormAttachment(0, 5), null, new FormAttachment(0, 8), null);
            Label msgLabelReq = uih.genRequiredSymbol((Composite)fieldLocationGroup, 0, fd, composite.getDisplay().getSystemColor(3));
            msgLabelReq.setVisible(false);
            fd = uih.genFormData(new FormAttachment(0, 5), null, new FormAttachment((Control)msgLabelReq, 5), null);
            this.labelMsg = new Label((Composite)fieldLocationGroup, 0);
            this.labelMsg.setText(MESSAGE_LABEL);
            this.labelMsg.pack();
            this.labelMsg.setLayoutData((Object)fd);
            fd = uih.genFormData(new FormAttachment(0, 3), null, new FormAttachment((Control)this.labelMsg, 5), new FormAttachment(50, -20));
            this.messageName = new Text((Composite)fieldLocationGroup, 2056);
            this.messageName.setLayoutData((Object)fd);
            fd = uih.genFormData(new FormAttachment(0, 8), null, new FormAttachment(50, 5), null);
            Label segLabelReq = uih.genRequiredSymbol((Composite)fieldLocationGroup, 0, fd, composite.getDisplay().getSystemColor(3));
            segLabelReq.setVisible(false);
            fd = uih.genFormData(new FormAttachment(0, 5), null, new FormAttachment((Control)segLabelReq, 5), null);
            this.labelSeg = new Label((Composite)fieldLocationGroup, 0);
            this.labelSeg.setText(SEGMENT_LABEL);
            this.labelSeg.pack();
            this.labelSeg.setLayoutData((Object)fd);
            fd = uih.genFormData(new FormAttachment(0, 3), null, new FormAttachment((Control)this.labelFldAlias, 5), new FormAttachment(100, -20));
            this.segmentName = new Text((Composite)fieldLocationGroup, 2056);
            this.segmentName.setLayoutData((Object)fd);
            fd = uih.genFormData(new FormAttachment((Control)this.messageName, 8), null, new FormAttachment(0, 5), null);
            Label parentLabelReq = uih.genRequiredSymbol((Composite)fieldLocationGroup, 0, fd, composite.getDisplay().getSystemColor(3));
            fd = uih.genFormData(new FormAttachment((Control)this.messageName, 7), null, new FormAttachment((Control)parentLabelReq, 5), null);
            this.labelParentField = new Label((Composite)fieldLocationGroup, 0);
            this.labelParentField.setText(PARENT_LABEL);
            this.labelParentField.setToolTipText(PARENT_LABEL_HOVER_TEXT);
            this.labelParentField.pack();
            this.labelParentField.setLayoutData((Object)fd);
            fd = uih.genFormData(new FormAttachment((Control)this.messageName, 3), null, new FormAttachment((Control)this.labelParentField, 5), new FormAttachment(50, -20));
            this.comboParentField = new Combo((Composite)fieldLocationGroup, 2056);
            this.comboParentField.setLayoutData((Object)fd);
            fd = uih.genFormData(new FormAttachment((Control)this.segmentName, 8), null, new FormAttachment(50, 5), null);
            Label startAfterReq = uih.genRequiredSymbol((Composite)fieldLocationGroup, 0, fd, composite.getDisplay().getSystemColor(3));
            fd = uih.genFormData(new FormAttachment((Control)this.segmentName, 5), null, new FormAttachment((Control)startAfterReq, 5), null);
            this.labelStart = new Label((Composite)fieldLocationGroup, 0);
            this.labelStart.setText(START_AFTER_LABEL);
            this.labelStart.pack();
            this.labelStart.setLayoutData((Object)fd);
            fd = uih.genFormData(new FormAttachment((Control)this.segmentName, 3), null, new FormAttachment((Control)this.labelStart, 5), new FormAttachment(100, -20));
            this.comboStartAfter = new Combo((Composite)fieldLocationGroup, 2056);
            this.comboStartAfter.setToolTipText(START_TEXT_HOVER_TEXT);
            this.comboStartAfter.setLayoutData((Object)fd);
            fd = uih.genFormData(new FormAttachment((Control)fieldLocationGroup, 10), null, new FormAttachment((Control)this.fldNameReq, 5), null);
            this.labelRedefines = new Label(composite, 0);
            this.labelRedefines.setText(REDEFINES_LABEL);
            this.labelRedefines.setToolTipText(TranMessages.getDescription().getString("WB63A"));
            this.labelRedefines.pack();
            this.labelRedefines.setLayoutData((Object)fd);
            fd = uih.genFormData(new FormAttachment((Control)fieldLocationGroup, 8), null, new FormAttachment((Control)this.labelRedefines, 5), new FormAttachment(50, -20));
            this.comboRedefinesField = new Combo(composite, 2056);
            this.comboRedefinesField.setLayoutData((Object)fd);
            fd = uih.genFormData(new FormAttachment((Control)this.comboRedefinesField, 10), null, new FormAttachment((Control)this.fldNameReq, 5), null);
            this.labelRemarks = new Label(composite, 0);
            this.labelRemarks.setText(REMARKS_LABEL);
            this.labelRemarks.setToolTipText(REMARKS_LABEL_HOVER_TEXT);
            this.labelRemarks.pack();
            this.labelRemarks.setLayoutData((Object)fd);
            fd = uih.genFormData(new FormAttachment((Control)this.comboRedefinesField, 8), new FormAttachment(80), new FormAttachment((Control)this.labelRemarks, 5), new FormAttachment(100, -24));
            this.textRemarks = new Text(composite, 2114);
            this.textRemarks.setToolTipText(REMARKS_TEXT_HOVER_TEXT);
            this.textRemarks.setTextLimit(256);
            this.textRemarks.setLayoutData((Object)fd);
            this.alignControls();
            this.initWidgetValues();
            this.addMessageControls();
            if (this.efController.getActionType().equals("EDIT")) {
                this.validatePage(false, false);
            } else if (this.efController.getActionType().equals("ADD")) {
                this.validatePage(true, false);
            }
            this.handleEnablement();
            this.addListeners();
            int[] leftLabelSizes = new int[]{Utility.getTextWidth((Composite)parent, (int)0, (String)MESSAGE_LABEL), Utility.getTextWidth((Composite)parent, (int)0, (String)PARENT_LABEL), Utility.getTextWidth((Composite)parent, (int)0, (String)REDEFINES_LABEL), Utility.getTextWidth((Composite)parent, (int)0, (String)REMARKS_LABEL)};
            int leftLabelSize = Utility.getMaxSize((int[])leftLabelSizes) + 5;
            int[] rightLabelSizes = new int[]{Utility.getTextWidth((Composite)parent, (int)0, (String)SEGMENT_LABEL), Utility.getTextWidth((Composite)parent, (int)0, (String)FLDALIAS_LABEL), Utility.getTextWidth((Composite)parent, (int)0, (String)START_AFTER_LABEL)};
            int rightLabelSize = Utility.getMaxSize((int[])rightLabelSizes) + 5;
            int comboWidth = Utility.getTextWidth((Composite)composite, (int)0, (String)REDEFINES_LABEL);
            int minimumSize = leftLabelSize + rightLabelSize + comboWidth * 4 + 20;
            this.getContainer().getShell().setMinimumSize(minimumSize, 655);
            this.setControl((Control)composite);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.im.ims.workbench.transaction.manage_field_wizard");
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", e);
            logger.error(e);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", new Object[0]);
    }

    private void addMessageControls() {
        this.msgControl.addControl((Control)this.comboStartAfter);
        this.msgControl.setValidationMessage((Control)this.comboStartAfter, "blah", 3);
        this.msgControl.clearValidationMessage((Control)this.comboStartAfter);
        this.msgControl.addControl((Control)this.comboParentField);
        this.msgControl.setValidationMessage((Control)this.comboParentField, "blah", 3);
        this.msgControl.clearValidationMessage((Control)this.comboParentField);
        this.msgControl.addControl((Control)this.comboRedefinesField);
        this.msgControl.addControl((Control)this.textRemarks);
        this.msgControl.addControl((Control)this.fieldName);
        this.msgControl.setValidationMessage((Control)this.fieldName, "blah", 3);
        this.msgControl.clearValidationMessage((Control)this.fieldName);
        this.msgControl.addControl((Control)this.fieldAlias);
        this.msgControl.setValidationMessage((Control)this.fieldAlias, "blah", 3);
        this.msgControl.clearValidationMessage((Control)this.fieldAlias);
    }

    private void alignControls() {
        this.alignLeftControls();
        this.alignRightControls();
    }

    private void alignLeftControls() {
        int leftOffset = this.getMaxLeftLabelSize() + 5;
        this.setFormDataLayout((Control)this.messageName, 0, leftOffset);
        this.setFormDataLayout((Control)this.fieldName, 0, leftOffset);
        this.setFormDataLayout((Control)this.comboParentField, 0, leftOffset);
        this.setFormDataLayout((Control)this.comboRedefinesField, 0, leftOffset + 10);
        this.setFormDataLayout((Control)this.textRemarks, 0, leftOffset + 10);
    }

    private void alignRightControls() {
        int rightOffset = this.getMaxRightLabelSize();
        this.setFormDataLayout((Control)this.segmentName, 50, rightOffset);
        this.setFormDataLayout((Control)this.fieldAlias, 50, rightOffset);
        this.setFormDataLayout((Control)this.comboStartAfter, 50, rightOffset);
    }

    private void setFormDataLayout(Control control, int startPos, int offset) {
        FormData fd = (FormData)control.getLayoutData();
        fd.left = new FormAttachment(startPos, offset + 25 + this.fldNameReq.getSize().x);
        control.setLayoutData((Object)fd);
    }

    private int getMaxSize(int[] labelSize) {
        Arrays.sort(labelSize);
        return labelSize[labelSize.length - 1];
    }

    private int getMaxLeftLabelSize() {
        int[] allLeftLabelSize = new int[]{this.labelFldName.getSize().x, this.labelMsg.getSize().x, this.labelParentField.getSize().x, this.labelRedefines.getSize().x, this.labelRemarks.getSize().x};
        return this.getMaxSize(allLeftLabelSize);
    }

    private int getMaxRightLabelSize() {
        int[] allRightLabelSize = new int[]{this.labelFldAlias.getSize().x, this.labelSeg.getSize().x, this.labelStart.getSize().x};
        return this.getMaxSize(allRightLabelSize);
    }

    private void initWidgetValues() throws ModelException, InvalidInputException {
        this.initContainerCombo();
        this.initParentFieldCombo();
        this.initFieldPosition();
        this.initRedefinesCombo();
        if (!this.efController.getActionType().equals("MOVE")) {
            this.initRemarks();
        }
    }

    private void initContainerCombo() {
        int segNum;
        String msgName = this.efController.getMessageName();
        if (msgName != null) {
            this.messageName.setText(msgName);
        }
        if ((segNum = this.efController.getSegmentNumber()) >= 0) {
            this.segmentName.setText(TranMessages.getLabel().getString("WB454") + " " + segNum);
        }
        if (this.efController.getActionType().equals("EDIT")) {
            String fieldAlias;
            String fieldName = this.efController.getOriginalName();
            if (fieldName != null) {
                this.fieldName.setText(fieldName);
            }
            if ((fieldAlias = this.efController.getName()) != null) {
                this.fieldAlias.setText(fieldAlias);
            }
        }
    }

    private void initParentFieldCombo() throws ModelException, InvalidInputException {
        String parentField;
        this.comboParentField.removeAll();
        ArrayList fieldList = this.efController.getFieldList();
        if (fieldList != null) {
            for (FieldModel fieldModel : fieldList) {
                DBDConstants appDataType = fieldModel.getAppDatatype();
                if (appDataType == null || !appDataType.equals((Object)DBDConstants.ARRAY) && !appDataType.equals((Object)DBDConstants.STRUCT) || fieldModel.getName().equals(this.efController.getName()) || !this.efController.isValidParent(fieldModel)) continue;
                this.comboParentField.add(fieldModel.getName());
            }
        }
        if ((parentField = this.efController.getParentField()) != null) {
            this.comboParentField.setText(parentField);
        }
    }

    private void initStartAfterCombo() throws ModelException {
        this.comboStartAfter.removeAll();
        String fieldName = this.efController.getName();
        String parentFieldName = this.efController.getParentField();
        boolean isNewField = this.efController.getActionType().equals("ADD");
        this.comboStartAfter.add("NONE");
        ArrayList fieldList = this.efController.getFieldList();
        if (fieldList != null) {
            for (FieldModel currentFieldModel : fieldList) {
                FieldModel currentParentFieldModel = currentFieldModel.getParentField();
                String currentParentField = "";
                if (currentParentFieldModel != null) {
                    currentParentField = currentParentFieldModel.getName();
                }
                if (!isNewField && currentFieldModel.getName().equals(fieldName) || !currentParentField.equals(parentFieldName)) continue;
                this.comboStartAfter.add(currentFieldModel.getName());
            }
        }
    }

    private void initFieldPosition() throws ModelException {
        this.initStartAfterCombo();
        String startAfterStr = this.efController.getStartAfter();
        if (startAfterStr != null && !startAfterStr.isEmpty()) {
            this.comboStartAfter.setText(startAfterStr);
        } else {
            this.comboStartAfter.setText("NONE");
        }
    }

    private void initRemarks() throws ModelException {
        String remarksStr = this.efController.getRemarks();
        if (remarksStr != null) {
            this.textRemarks.setText(remarksStr);
        }
    }

    private void initRedefinesCombo() throws ModelException {
        this.comboRedefinesField.removeAll();
        this.comboRedefinesField.add("");
        this.comboRedefinesField.select(0);
        if (!this.efController.getActionType().equals("MOVE")) {
            String followsField = this.comboStartAfter.getText();
            if (!followsField.equals("NONE")) {
                this.comboRedefinesField.add(followsField);
            }
            String redefinesName = this.efController.getRedefines();
            if (followsField != null && !followsField.isEmpty() && !followsField.equals("NONE") && redefinesName != null) {
                this.comboRedefinesField.select(1);
            }
        }
    }

    private void validateInput() throws InvalidInputException, ModelException {
        if (this.efController.getActionType().equals("ADD")) {
            this.efController.setOriginalName(this.fieldName.getText());
        }
        this.efController.setAlias(this.fieldAlias.getText());
        this.efController.setParentField(this.comboParentField.getText());
        this.efController.setStartAfter(this.comboStartAfter.getText());
        this.efController.setRedefines(this.comboRedefinesField.getText());
        this.efController.setRemarks(this.textRemarks.getText());
    }

    public void modifyText(ModifyEvent e) {
        try {
            try {
                this.validateAttributeChangeable(e.widget);
            }
            catch (InvalidInputException iie) {
                String message = iie.getMessage();
                MessageDialog.openInformation((Shell)this.getWiz().getShell(), (String)INFORMATION_STR, (String)message);
                if (e.widget == this.fieldAlias) {
                    this.fieldAlias.removeModifyListener((ModifyListener)this);
                    this.fieldAlias.setText(this.efController.getOriginalAlias());
                    this.fieldAlias.addModifyListener((ModifyListener)this);
                } else if (e.widget != this.comboRedefinesField) {
                    this.setErrorMessage(message);
                    this.setValidationMessages(iie);
                }
                return;
            }
            this.validatePage(false, true);
            this.handleEnablement();
        }
        catch (Throwable err) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "modifyText(ModifyEvent e)", err);
            logger.error(err);
        }
    }

    private void validateAttributeChangeable(Widget widget) throws InvalidInputException, ModelException {
        InvalidInputException iie = null;
        if (widget == this.comboParentField) {
            iie = this.efController.validateAttrChangable("PARENT", null);
        } else if (widget == this.comboStartAfter) {
            iie = this.efController.validateAttrChangable("START", null);
        } else if (widget == this.comboRedefinesField) {
            iie = this.efController.validateAttrChangable("REDEFINES", null);
        } else if (widget == this.fieldAlias) {
            iie = this.efController.validateAttrChangable("ALIAS", null);
        }
        if (iie != null) {
            throw iie;
        }
    }

    public void validatePage(boolean suppressErrorMessage, boolean invokedDueToUserEdit) throws ModelException {
        try {
            this.clearValidationMessages();
            if (invokedDueToUserEdit) {
                this.validateInput();
            }
            String[] attrsToCheck = new String[]{"ORIG_NAME", "ALIAS", "PARENT", "START"};
            this.efController.validateRequiredFields(attrsToCheck);
            this.efController.semanticCheck();
            this.setPageComplete(true);
        }
        catch (InvalidInputException iie) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "", (Throwable)iie);
            if (!suppressErrorMessage) {
                String message = iie.getMessage();
                this.setErrorMessage(message);
                this.setValidationMessages(iie);
            }
            if (this.efController.getActionType().equals("MOVE")) {
                this.setPageComplete(false);
            }
            String[] errorAttrs = iie.getAttrNames();
            if (Utility.allAttrsOnPage((String[])errorAttrs, (String[])pageAttrs)) {
                this.setPageComplete(false);
            }
            this.setPageComplete(true);
        }
    }

    private void clearValidationMessages() {
        this.setErrorMessage(null);
        this.msgControl.clearValidationMessage((Control)this.fieldName);
        this.msgControl.clearValidationMessage((Control)this.fieldAlias);
        this.msgControl.clearValidationMessage((Control)this.comboParentField);
        this.msgControl.clearValidationMessage((Control)this.comboStartAfter);
        this.msgControl.clearValidationMessage((Control)this.comboRedefinesField);
        this.msgControl.clearValidationMessage((Control)this.textRemarks);
    }

    private void setValidationMessages(InvalidInputException iie) throws ModelException {
        String[] attrs = iie.getAttrNames();
        String message = iie.getMessage();
        int i = 0;
        while (i < attrs.length) {
            String attrName = attrs[i];
            if (attrName.equals("PARENT")) {
                if (iie.getErrorCode() == 1) {
                    MessageDialog.openInformation((Shell)this.getWiz().getShell(), (String)INFORMATION_STR, (String)iie.getMessage());
                }
            } else if (attrName.equals("START")) {
                if (iie.getErrorCode() == 1) {
                    MessageDialog.openInformation((Shell)this.getWiz().getShell(), (String)INFORMATION_STR, (String)iie.getMessage());
                }
                this.msgControl.setValidationMessage((Control)this.comboStartAfter, message, 3);
            } else if (attrName.equals("REDEFINES")) {
                this.msgControl.setValidationMessage((Control)this.comboRedefinesField, message, 3);
            } else if (attrName.equals("REMARKS")) {
                this.msgControl.setValidationMessage((Control)this.textRemarks, message, 3);
            } else if (attrName.equals("ALIAS")) {
                this.msgControl.setValidationMessage((Control)this.fieldAlias, message, 3);
            } else if (attrName.equals("ORIG_NAME")) {
                this.msgControl.setValidationMessage((Control)this.fieldName, message, 3);
            }
            ++i;
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        try {
            if (visible && this.canFlipToNextPage() && !this.efController.getActionType().equals("MOVE")) {
                this.validatePage(false, this.efController.hasBeenEdited());
                this.handleEnablement();
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "setVisible(boolean visible)", e);
            logger.error(e);
        }
    }

    public void verifyText(VerifyEvent e) {
        try {
            if (e.widget == this.textRemarks) {
                if (e.character == '\t') {
                    e.text = null;
                    this.textRemarks.traverse(16);
                } else if (e.character == '\r') {
                    e.text = null;
                    this.textRemarks.traverse(4, (KeyEvent)e);
                }
            }
            this.setPageComplete(this.isPageComplete());
        }
        catch (Throwable err) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "verifyText(VerifyEvent e)", err);
            logger.error(err);
        }
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void widgetSelected(SelectionEvent e) {
        try {
            try {
                this.validateAttributeChangeable(e.widget);
            }
            catch (InvalidInputException iie) {
                MessageDialog.openInformation((Shell)this.getWiz().getShell(), (String)INFORMATION_STR, (String)iie.getMessage());
                return;
            }
            this.validatePage(false, true);
            this.handleEnablement();
            this.comboStartAfter.setFocus();
        }
        catch (Throwable err) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "modifyText(ModifyEvent e)", err);
            logger.error(err);
        }
    }

    private void handleEnablement() {
        String redefinesStr = this.efController.getRedefines();
        if (redefinesStr != null && !redefinesStr.isEmpty()) {
            this.comboParentField.setEnabled(false);
            this.comboStartAfter.setEnabled(false);
        } else {
            this.comboParentField.setEnabled(true);
            this.comboStartAfter.setEnabled(true);
        }
        String parentStr = this.efController.getParentField();
        if (parentStr == null || parentStr.isEmpty()) {
            this.comboStartAfter.setEnabled(false);
            this.comboRedefinesField.setEnabled(false);
        } else {
            this.comboStartAfter.setEnabled(true);
            this.comboRedefinesField.setEnabled(true);
        }
    }

    private void addListeners() {
        this.fieldName.addModifyListener((ModifyListener)this);
        this.fieldAlias.addModifyListener((ModifyListener)this);
        this.comboParentField.addModifyListener((ModifyListener)this);
        this.comboStartAfter.addModifyListener((ModifyListener)this);
        this.comboRedefinesField.addModifyListener((ModifyListener)this);
        this.comboRedefinesField.addFocusListener((FocusListener)this);
        this.textRemarks.addModifyListener((ModifyListener)this);
        this.textRemarks.addVerifyListener((VerifyListener)this);
    }

    private void removeListeners() {
        this.fieldName.removeModifyListener((ModifyListener)this);
        this.fieldAlias.removeModifyListener((ModifyListener)this);
        this.comboParentField.removeModifyListener((ModifyListener)this);
        this.comboStartAfter.removeModifyListener((ModifyListener)this);
        this.comboRedefinesField.removeModifyListener((ModifyListener)this);
        this.comboRedefinesField.removeFocusListener((FocusListener)this);
        this.textRemarks.removeModifyListener((ModifyListener)this);
        this.textRemarks.removeVerifyListener((VerifyListener)this);
    }

    protected String getRemarks() {
        return this.textRemarks.getText();
    }

    protected String getStartAfterFieldName() {
        return this.comboStartAfter.getText();
    }

    protected String getIMSName() {
        return this.fieldName.getText();
    }

    protected EditFieldWizard getWiz() {
        return (EditFieldWizard)this.getWizard();
    }

    public void focusGained(FocusEvent arg0) {
    }

    public void focusLost(FocusEvent arg0) {
    }

    public void handleModelChange(ModelChangeEvent e) {
        try {
            this.removeListeners();
            String[] stringArray = e.getAttrs();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String attr = stringArray[n2];
                if (attr.equals("PARENT")) {
                    this.initParentFieldCombo();
                    this.initFieldPosition();
                } else if (attr.equals("START")) {
                    this.initFieldPosition();
                    this.initRedefinesCombo();
                } else if (attr.equals("REDEFINES")) {
                    this.initRedefinesCombo();
                }
                ++n2;
            }
            this.addListeners();
        }
        catch (Throwable exc) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "", exc);
            logger.error(exc);
        }
    }
}

