/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.transaction.fieldEditor;

import com.ibm.im.ims.transaction.controller.editor.EditFieldController;
import com.ibm.im.ims.workbench.transaction.fieldEditor.EditFieldWizardPage0;
import com.ibm.im.ims.workbench.transaction.fieldEditor.EditFieldWizardPage2;
import com.ibm.im.ims.workbench.transaction.resources.utilities.TranMessages;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.ArrayList;
import java.util.logging.Level;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;

public class EditFieldWizard
extends Wizard {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    public ArrayList<String> propertyList;
    private EditFieldWizardPage0 editFieldWizardPage0;
    private EditFieldWizardPage2 editFieldWizardPage2;
    private EditFieldController efController;

    public EditFieldWizard(EditFieldController efController) {
        this.setWindowTitle(TranMessages.getLabel().getString("WB039A"));
        if (efController.getActionType().equals("ADD")) {
            this.setWindowTitle(TranMessages.getLabel().getString("WB258"));
        }
        this.efController = efController;
        this.setHelpAvailable(false);
    }

    public boolean performFinish() {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(((Object)((Object)this)).getClass().getName(), "performFinish()", new Object[0]);
        }
        try {
            this.efController.performFinish();
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "performFinish()", e);
            logger.error(e);
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(((Object)((Object)this)).getClass().getName(), "performFinish()", new Object[0]);
        }
        return true;
    }

    public boolean canFinish() {
        boolean hasBeenEdited = this.efController.hasBeenEdited();
        boolean page0Complete = this.editFieldWizardPage0.isPageComplete();
        boolean page2Complete = this.editFieldWizardPage2 == null || this.editFieldWizardPage2.isPageComplete();
        boolean semanticErrorsExist = false;
        try {
            if (hasBeenEdited && this.editFieldWizardPage2 != null) {
                this.efController.semanticCheck();
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "addPages()", e);
            semanticErrorsExist = true;
        }
        return page0Complete && page2Complete && hasBeenEdited && !semanticErrorsExist;
    }

    public void addPages() {
        try {
            this.editFieldWizardPage0 = new EditFieldWizardPage0(this.efController);
            this.addPage((IWizardPage)this.editFieldWizardPage0);
            if (!this.efController.getActionType().equals("MOVE")) {
                this.editFieldWizardPage2 = new EditFieldWizardPage2(this.efController);
                this.addPage((IWizardPage)this.editFieldWizardPage2);
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "addPages()", e);
            logger.error(e);
        }
    }

    public String getIMSName() {
        return this.editFieldWizardPage0.getName();
    }

    protected String getStartAfterFieldName() {
        return this.editFieldWizardPage0.getStartAfterFieldName();
    }
}

