/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.transaction.editors;

import com.ibm.im.ims.metadata.testcase.IoMessagePairType;
import com.ibm.im.ims.metadata.testcase.Testcase;
import com.ibm.im.ims.metadata.transaction.FieldType;
import com.ibm.im.ims.metadata.transaction.MessageType;
import com.ibm.im.ims.metadata.transaction.SegmentType;
import com.ibm.im.ims.metadata.transaction.Transaction;
import com.ibm.im.ims.transaction.controller.datastructure.DataStructureSegmentAssociation;
import com.ibm.im.ims.transaction.controller.editor.ManageFieldsController;
import com.ibm.im.ims.transaction.controller.editor.TranEditorController;
import com.ibm.im.ims.transaction.model.utilities.FieldTypeToolTipTreeListener;
import com.ibm.im.ims.transaction.model.utilities.ModelException;
import com.ibm.im.ims.transaction.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.transaction.model.utilities.Utility;
import com.ibm.im.ims.workbench.transaction.Activator;
import com.ibm.im.ims.workbench.transaction.common.ui.EAMessageControl;
import com.ibm.im.ims.workbench.transaction.editors.MultiPageEditor;
import com.ibm.im.ims.workbench.transaction.editors.TransactionEditorContentProvider;
import com.ibm.im.ims.workbench.transaction.editors.TransactionEditorLabelProvider;
import com.ibm.im.ims.workbench.transaction.fieldEditor.ManageFieldWizard;
import com.ibm.im.ims.workbench.transaction.model.FieldModel;
import com.ibm.im.ims.workbench.transaction.model.TranDataStructureModel;
import com.ibm.im.ims.workbench.transaction.model.TranDataStructuresFolder;
import com.ibm.im.ims.workbench.transaction.model.TranMessageModel;
import com.ibm.im.ims.workbench.transaction.model.TranMessagesFolder;
import com.ibm.im.ims.workbench.transaction.model.TranModel;
import com.ibm.im.ims.workbench.transaction.model.TranSegmentModel;
import com.ibm.im.ims.workbench.transaction.model.TranSegmentsFolder;
import com.ibm.im.ims.workbench.transaction.model.TranTreeObject;
import com.ibm.im.ims.workbench.transaction.model.TranTreeParent;
import com.ibm.im.ims.workbench.transaction.preferences.EnWPreferencesPage;
import com.ibm.im.ims.workbench.transaction.resources.utilities.TranMessages;
import com.ibm.im.ims.workbench.transaction.utilities.InfoDialog;
import com.ibm.im.ims.workbench.transaction.utilities.UIHelper;
import com.ibm.im.ims.workbench.transaction.wizard.editdatastructure.EditDataStructureAndFieldWizard;
import com.ibm.im.ims.workbench.transaction.wizard.editmessage.EditMessageWizard;
import com.ibm.im.ims.workbench.transaction.wizard.importds.ImportDSTranMessageMetadataWizard;
import com.ibm.ims.dli.types.ConversionException;
import com.ibm.ims.dli.types.UnsupportedTypeConversion;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import com.ibm.ims.transaction.messages.walkers.MessageWalkerException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Vector;
import javax.xml.bind.JAXBException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class TransactionEditorPage
extends FormPage
implements SelectionListener,
ModifyListener,
VerifyListener,
KeyListener,
MouseListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2017. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private MultiPageEditor editorParent;
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private Button importDsButton;
    private Button addButton;
    private Button editButton;
    private Button copyButton;
    private Button pasteButton;
    private Button importDsMetadataButton;
    private Button removeButton;
    private Button moveUpButton;
    private Button moveDownButton;
    private Button addEditFieldsButton;
    private int margin = 5;
    private int buttonWidth;
    public static Color COLOR_WHITE = new Color((Device)PlatformUI.createDisplay(), 255, 255, 255);
    public static Color COLOR_RED = new Color((Device)PlatformUI.createDisplay(), 255, 0, 0);
    private Form form;
    private TranEditorController controller;
    private Text textTrancode;
    private TreeViewer viewer;
    private Tree tree;
    private ArrayList<Object> nodesToBeRemoved = null;
    private boolean multiplePastes;
    private EAMessageControl msgControl = new EAMessageControl();

    public TransactionEditorPage(MultiPageEditor parent, Composite compositeContainer, TranEditorController controller) {
        super(null, "TransactionEditor", "");
        this.editorParent = parent;
        this.controller = controller;
        this.createContent(compositeContainer);
    }

    public TranEditorController getController() {
        return this.controller;
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    private void createContent(Composite parent) {
        FormColors formColors = new FormColors(parent.getDisplay());
        formColors.markShared();
        FormToolkit toolkit = new FormToolkit(formColors);
        this.form = toolkit.createForm(parent);
        int[] labelSizes = new int[]{Utility.getTextWidth((Composite)this.form, (int)0, (String)TranMessages.getLabel().getString("TNT_BUTTON_IMPORT_DATA_STRUCTURE")), Utility.getTextWidth((Composite)this.form, (int)0, (String)TranMessages.getLabel().getString("TNT_BUTTON_ADD")), Utility.getTextWidth((Composite)this.form, (int)0, (String)TranMessages.getLabel().getString("TNT_BUTTON_EDIT")), Utility.getTextWidth((Composite)this.form, (int)0, (String)TranMessages.getLabel().getString("TNT_BUTTON_COPY")), Utility.getTextWidth((Composite)this.form, (int)0, (String)TranMessages.getLabel().getString("TNT_BUTTON_PASTE")), Utility.getTextWidth((Composite)this.form, (int)0, (String)TranMessages.getLabel().getString("TNT_BUTTON_REMOVE")), Utility.getTextWidth((Composite)this.form, (int)0, (String)TranMessages.getLabel().getString("TNT_BUTTON_MOVEUP")), Utility.getTextWidth((Composite)this.form, (int)0, (String)TranMessages.getLabel().getString("TNT_BUTTON_MOVEDOWN")), Utility.getTextWidth((Composite)this.form, (int)0, (String)TranMessages.getLabel().getString("WB038A"))};
        this.buttonWidth = Utility.getMaxSize((int[])labelSizes) + this.margin;
        this.createEditor(toolkit);
    }

    private void createEditor(FormToolkit toolkit) {
        Composite composite = this.form.getBody();
        composite.setLayout((Layout)new GridLayout());
        Section section = toolkit.createSection(composite, 128);
        section.setText(TranMessages.getLabel().getString("TMME_TITLE"));
        section.setDescription(TranMessages.getDescription().getString("TMME_DESC"));
        section.setLayoutData((Object)new GridData(4, 4, true, true));
        toolkit.createCompositeSeparator((Composite)section);
        Composite client = toolkit.createComposite((Composite)section, 64);
        client.setLayout((Layout)new GridLayout(2, false));
        section.setClient((Control)client);
        this.createTrancodeComposite(client);
        this.viewer = new TreeViewer(client, 2818);
        this.viewer.setContentProvider((IContentProvider)new TransactionEditorContentProvider(this));
        this.viewer.setLabelProvider((IBaseLabelProvider)new TransactionEditorLabelProvider());
        this.viewer.setInput((Object)this.controller.getInvisibleRoot());
        GridData treeGridData = new GridData(4, 4, true, true);
        treeGridData.verticalSpan = 10;
        this.tree = this.viewer.getTree();
        this.tree.setLayoutData((Object)treeGridData);
        this.tree.addSelectionListener((SelectionListener)this);
        this.tree.addMouseListener((MouseListener)this);
        this.tree.addKeyListener((KeyListener)this);
        this.tree.addMouseMoveListener((MouseMoveListener)new FieldTypeToolTipTreeListener(this.tree));
        toolkit.paintBordersFor(client);
        this.addButtons(toolkit, client);
        section.setClient((Control)client);
    }

    private void createTrancodeComposite(Composite parent) {
        UIHelper uih = new UIHelper();
        uih.setDisplay(parent.getDisplay());
        FormLayout formLayout = new FormLayout();
        formLayout.spacing = this.margin;
        Composite trancodeComposite = new Composite(parent, 0);
        trancodeComposite.setBackground(parent.getBackground());
        trancodeComposite.setLayout((Layout)formLayout);
        FormData fd = uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment(0, 0), null);
        Label labelTrancode = new Label(trancodeComposite, 0);
        labelTrancode.setBackground(parent.getBackground());
        labelTrancode.setText(TranMessages.getLabel().getString("NPNT_TRAN_CODE") + TranMessages.getColon().getString("COLON"));
        labelTrancode.setLayoutData((Object)fd);
        fd = uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment((Control)labelTrancode, this.margin), new FormAttachment(100, -this.margin * 4));
        this.textTrancode = new Text(trancodeComposite, 2048);
        this.textTrancode.setLayoutData((Object)fd);
        this.textTrancode.setText(this.controller.getTran().getTranCode());
        this.textTrancode.addModifyListener((ModifyListener)this);
        this.textTrancode.addVerifyListener((VerifyListener)this);
        this.textTrancode.setTextLimit(8);
        this.msgControl.addControl((Control)this.textTrancode);
        if (!this.controller.isUnitTest()) {
            this.textTrancode.setEditable(false);
        }
        GridData tcgd = new GridData(1, 2, true, false, 2, 1);
        tcgd.widthHint = Utility.getTextWidth((Composite)parent, (int)0, (String)(TranMessages.getLabel().getString("NPNT_TRAN_CODE") + TranMessages.getColon().getString("COLON"))) + this.margin * 6 + Utility.getTextWidth((Composite)parent, (int)0, (String)"WWWWWWWW");
        trancodeComposite.setLayoutData((Object)tcgd);
    }

    public void dispose() {
        this.msgControl.removeControl((Control)this.textTrancode);
        this.textTrancode.removeModifyListener((ModifyListener)this);
        this.textTrancode.removeVerifyListener((VerifyListener)this);
        this.textTrancode.dispose();
        this.importDsButton.dispose();
        this.addButton.dispose();
        this.editButton.dispose();
        this.copyButton.dispose();
        this.pasteButton.dispose();
        this.removeButton.dispose();
        this.moveUpButton.dispose();
        this.moveDownButton.dispose();
        this.addEditFieldsButton.dispose();
        this.form.dispose();
        super.dispose();
    }

    private void addButtons(FormToolkit toolkit, Composite client) {
        this.importDsButton = toolkit.createButton(client, TranMessages.getLabel().getString("TNT_BUTTON_IMPORT_DATA_STRUCTURE"), 8);
        GridData gd = new GridData(2);
        gd.widthHint = this.buttonWidth;
        this.importDsButton.setLayoutData((Object)gd);
        this.importDsButton.addSelectionListener((SelectionListener)this);
        this.importDsButton.setEnabled(true);
        this.importDsButton.setToolTipText(TranMessages.getLabel().getString("TNT_BUTTON_IMPORT_DATA_STRUCTURE_HOVER"));
        this.importDsMetadataButton = toolkit.createButton(client, TranMessages.getLabel().getString("TNT_BUTTON_IMPORT_EDITED_DATA_STRUCTURE"), 8);
        gd = new GridData(2);
        gd.widthHint = this.buttonWidth;
        this.importDsMetadataButton.setLayoutData((Object)gd);
        this.importDsMetadataButton.addSelectionListener((SelectionListener)this);
        this.importDsMetadataButton.setEnabled(true);
        this.importDsMetadataButton.setToolTipText(TranMessages.getLabel().getString("TNT_BUTTON_IMPORT_EDITED_DATA_STRUCTURE_HOVER"));
        this.addButton = toolkit.createButton(client, TranMessages.getLabel().getString("TNT_BUTTON_ADD"), 8);
        gd = new GridData(2);
        gd.widthHint = this.buttonWidth;
        this.addButton.setLayoutData((Object)gd);
        this.addButton.addSelectionListener((SelectionListener)this);
        this.addButton.setEnabled(false);
        this.editButton = toolkit.createButton(client, TranMessages.getLabel().getString("TNT_BUTTON_EDIT"), 8);
        gd = new GridData(2);
        gd.widthHint = this.buttonWidth;
        this.editButton.setLayoutData((Object)gd);
        this.editButton.addSelectionListener((SelectionListener)this);
        this.editButton.setEnabled(false);
        this.editButton.setToolTipText(TranMessages.getLabel().getString("TNT_BUTTON_EDIT_HOVER", (Object[])new String[]{TranMessages.getLabel().getString("TNT_HOVER_ENTITY_MESSAGE")}));
        this.copyButton = toolkit.createButton(client, TranMessages.getLabel().getString("TNT_BUTTON_COPY"), 8);
        gd = new GridData(2);
        gd.widthHint = this.buttonWidth;
        this.copyButton.setLayoutData((Object)gd);
        this.copyButton.addSelectionListener((SelectionListener)this);
        this.copyButton.setEnabled(false);
        this.copyButton.setToolTipText(TranMessages.getLabel().getString("TNT_BUTTON_COPY_HOVER"));
        this.pasteButton = toolkit.createButton(client, TranMessages.getLabel().getString("TNT_BUTTON_PASTE"), 8);
        gd = new GridData(2);
        gd.widthHint = this.buttonWidth;
        this.pasteButton.setLayoutData((Object)gd);
        this.pasteButton.addSelectionListener((SelectionListener)this);
        this.pasteButton.setEnabled(false);
        this.pasteButton.setToolTipText(TranMessages.getLabel().getString("TNT_BUTTON_PASTE_HOVER"));
        this.removeButton = toolkit.createButton(client, TranMessages.getLabel().getString("TNT_BUTTON_REMOVE"), 8);
        gd = new GridData(2);
        gd.widthHint = this.buttonWidth;
        this.removeButton.setLayoutData((Object)gd);
        this.removeButton.addSelectionListener((SelectionListener)this);
        this.removeButton.setEnabled(false);
        this.removeButton.setToolTipText(TranMessages.getLabel().getString("TNT_BUTTON_REMOVE_HOVER"));
        this.moveUpButton = toolkit.createButton(client, TranMessages.getLabel().getString("TNT_BUTTON_MOVEUP"), 8);
        gd = new GridData(2);
        gd.widthHint = this.buttonWidth;
        this.moveUpButton.setLayoutData((Object)gd);
        this.moveUpButton.addSelectionListener((SelectionListener)this);
        this.moveUpButton.setEnabled(false);
        this.moveDownButton = toolkit.createButton(client, TranMessages.getLabel().getString("TNT_BUTTON_MOVEDOWN"), 8);
        gd = new GridData(2);
        gd.widthHint = this.buttonWidth;
        this.moveDownButton.setLayoutData((Object)gd);
        this.moveDownButton.addSelectionListener((SelectionListener)this);
        this.moveDownButton.setEnabled(false);
        this.addEditFieldsButton = toolkit.createButton(client, TranMessages.getLabel().getString("WB038A"), 8);
        gd = new GridData(2);
        gd.widthHint = this.buttonWidth;
        this.addEditFieldsButton.setLayoutData((Object)gd);
        this.addEditFieldsButton.addSelectionListener((SelectionListener)this);
        this.addEditFieldsButton.setEnabled(false);
    }

    public Composite getPage() {
        return this.form;
    }

    private String[] getAffectedTestcases() throws CoreException, JAXBException {
        String projectName = this.editorParent.getProjectName();
        String[] testcaseFileNames = ProjectTreeFileHelper.getTestCaseFileNames((String)projectName);
        Vector<Testcase> testcases = new Vector<Testcase>();
        HashMap<BigInteger, String> testcaseNameMap = new HashMap<BigInteger, String>();
        HashSet<String> affectedTestcases = new HashSet<String>();
        BigInteger tranId = this.controller.getTran().getId();
        int id = 1;
        int i = 0;
        while (i < testcaseFileNames.length) {
            if (testcaseFileNames[i] != null && !testcaseFileNames[i].isEmpty()) {
                Testcase currTestcase = ProjectTreeFileHelper.unmarshallTestcase((String)projectName, (String)testcaseFileNames[i]);
                currTestcase.setId(new BigInteger(Integer.toString(id)));
                ++id;
                testcases.add(currTestcase);
                testcaseNameMap.put(currTestcase.getId(), testcaseFileNames[i]);
            }
            ++i;
        }
        for (Testcase currTestcase : testcases) {
            List iomps = currTestcase.getIoMessagePair();
            int i2 = 0;
            while (i2 < iomps.size()) {
                IoMessagePairType currIomp = (IoMessagePairType)iomps.get(i2);
                if (tranId.equals(currIomp.getTranId())) {
                    affectedTestcases.add((String)testcaseNameMap.get(currTestcase.getId()));
                }
                ++i2;
            }
        }
        return affectedTestcases.toArray(new String[0]);
    }

    private boolean editDespiteChangingTestcases() throws CoreException, JAXBException {
        IPreferenceStore store;
        String[] affectedTestcases;
        boolean retVal = true;
        if (this.controller.isUnitTest() && (affectedTestcases = this.getAffectedTestcases()).length > 0 && !(store = Activator.getDefault().getPreferenceStore()).getBoolean(EnWPreferencesPage.messageTypes[1])) {
            String fullDialogWarningMsg = EnWPreferencesPage.errorCodes[1] + " - " + TranMessages.getError().getString("PPEW_" + EnWPreferencesPage.messageTypes[1]);
            int i = 0;
            while (i < affectedTestcases.length) {
                fullDialogWarningMsg = fullDialogWarningMsg + "\n" + affectedTestcases[i];
                ++i;
            }
            fullDialogWarningMsg = fullDialogWarningMsg + TranMessages.getError().getString("PPEW_DO_CONTINUE");
            InfoDialog infoDialog = new InfoDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), TranMessages.getLabel().getString("WRND_DIALOG_TITLE"), null, fullDialogWarningMsg, 2, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
            infoDialog.setWarningType(1);
            int retCode = infoDialog.open();
            if (retCode == 1) {
                retVal = false;
            }
        }
        return retVal;
    }

    private void handleAddMessage() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.getFirstElement() instanceof TranMessagesFolder) {
            TranMessagesFolder msgFolder = (TranMessagesFolder)selection.getFirstElement();
            EditMessageWizard editMessageWizard = new EditMessageWizard(this.controller.getTran(), null, msgFolder.getMessageType());
            WizardDialog dialog = new WizardDialog(this.getPage().getShell(), (IWizard)editMessageWizard);
            dialog.create();
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                TranMessageModel newMsgModel = this.controller.addMessage(msgFolder, editMessageWizard.getMessageName(), editMessageWizard.getMessageRemarks());
                this.viewer.refresh();
                this.viewer.setExpandedState((Object)newMsgModel, true);
                TranTreeObject[] segFolderArray = newMsgModel.getChildren();
                TranSegmentsFolder segFolder = (TranSegmentsFolder)segFolderArray[0];
                this.viewer.setExpandedState((Object)segFolder, true);
                TranTreeObject[] segmentArray = segFolder.getChildren();
                TranSegmentModel segment = (TranSegmentModel)segmentArray[0];
                this.viewer.setExpandedState((Object)segment, true);
                TranTreeObject[] dsFolderArray = segment.getChildren();
                TranDataStructuresFolder dsfolder = (TranDataStructuresFolder)dsFolderArray[0];
                this.viewer.setSelection((ISelection)new StructuredSelection((Object)dsfolder), true);
                this.editorParent.setDirty(true);
            }
        }
    }

    private void handleEditMessage() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.getFirstElement() instanceof TranMessageModel) {
            TranMessageModel msgNode = (TranMessageModel)selection.getFirstElement();
            EditMessageWizard editMessageWizard = new EditMessageWizard(this.controller.getTran(), msgNode, msgNode.getMessageType());
            WizardDialog dialog = new WizardDialog(this.getPage().getShell(), (IWizard)editMessageWizard);
            dialog.create();
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                this.controller.editMessage(msgNode, editMessageWizard.getMessageName(), editMessageWizard.getMessageRemarks());
                this.viewer.refresh();
                this.editorParent.setDirty(true);
            }
        }
    }

    private void handleEditDataStructure() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        TranDataStructureModel dsNode = (TranDataStructureModel)selection.getFirstElement();
        Vector existingDsNames = this.controller.getExistingDsNamesForPaste((Object)dsNode);
        EditDataStructureAndFieldWizard editDsWizard = new EditDataStructureAndFieldWizard((TranTreeObject)dsNode, existingDsNames);
        WizardDialog dialog = new WizardDialog(this.getPage().getShell(), (IWizard)editDsWizard);
        dialog.create();
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            this.controller.editDataStructure(dsNode, editDsWizard.getFieldName(), editDsWizard.getRemarks());
            this.viewer.refresh();
            this.editorParent.setDirty(true);
        }
    }

    private void handleEditField() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        FieldModel fieldNode = (FieldModel)selection.getFirstElement();
        EditDataStructureAndFieldWizard editDsWizard = new EditDataStructureAndFieldWizard((TranTreeObject)fieldNode, null);
        WizardDialog dialog = new WizardDialog(this.getPage().getShell(), (IWizard)editDsWizard);
        dialog.create();
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            this.controller.editField(fieldNode, editDsWizard.getFieldName(), editDsWizard.getRemarks());
            this.viewer.refresh();
            this.editorParent.setDirty(true);
        }
    }

    private void handleRemove() throws MessageWalkerException {
        Object currNode;
        ArrayList<TranTreeObject> onlyTheseNeedToBeRemoved = new ArrayList<TranTreeObject>();
        Vector<TranSegmentsFolder> segmentFoldersAffected = null;
        Object[] expandedElements = null;
        int i = 0;
        while (i < this.nodesToBeRemoved.size()) {
            currNode = (TranTreeObject)this.nodesToBeRemoved.get(i);
            if (currNode instanceof TranSegmentModel) {
                Object msgNode = ((TranTreeObject)currNode.getParent()).getParent();
                if (!this.nodesToBeRemoved.contains(msgNode)) {
                    onlyTheseNeedToBeRemoved.add((TranTreeObject)currNode);
                }
            } else if (currNode instanceof TranDataStructureModel) {
                Object segNode = ((TranTreeObject)currNode.getParent()).getParent();
                Object msgNode = ((TranTreeObject)((TranTreeObject)segNode).getParent()).getParent();
                if (!this.nodesToBeRemoved.contains(segNode) && !this.nodesToBeRemoved.contains(msgNode)) {
                    onlyTheseNeedToBeRemoved.add((TranTreeObject)currNode);
                }
            } else if (currNode instanceof TranMessageModel) {
                onlyTheseNeedToBeRemoved.add((TranTreeObject)currNode);
            }
            ++i;
        }
        i = 0;
        while (i < onlyTheseNeedToBeRemoved.size()) {
            currNode = onlyTheseNeedToBeRemoved.get(i);
            if (currNode instanceof TranMessageModel) {
                this.controller.removeMessage((TranMessageModel)currNode);
                this.editorParent.setDirty(true);
                this.viewer.refresh();
            } else if (currNode instanceof TranSegmentModel) {
                TranSegmentModel currSegmentModel = (TranSegmentModel)currNode;
                if (segmentFoldersAffected == null) {
                    segmentFoldersAffected = new Vector<TranSegmentsFolder>();
                }
                TranSegmentsFolder segFolder = (TranSegmentsFolder)currSegmentModel.getParent();
                segmentFoldersAffected.add(segFolder);
                expandedElements = this.viewer.getExpandedElements();
                this.controller.removeSegment(currSegmentModel);
                this.editorParent.setDirty(true);
                this.viewer.refresh();
            } else if (currNode instanceof TranDataStructureModel) {
                this.controller.removeDataStructure((TranDataStructureModel)currNode);
                this.editorParent.setDirty(true);
                this.viewer.refresh();
            }
            ++i;
        }
        if (segmentFoldersAffected != null) {
            for (TranSegmentsFolder tranSegmentsFolder : segmentFoldersAffected) {
                this.controller.populateSegmentNodes(tranSegmentsFolder.getSegments(), tranSegmentsFolder);
                this.viewer.refresh();
                if (expandedElements == null) continue;
                this.expandTree(expandedElements);
            }
        }
    }

    private void handleAddSegment() throws MessageWalkerException {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.getFirstElement() instanceof TranSegmentsFolder) {
            Object[] expandedElements = this.viewer.getExpandedElements();
            TranSegmentsFolder segFolder = (TranSegmentsFolder)selection.getFirstElement();
            this.controller.addSegment(segFolder);
            this.controller.populateSegmentNodes(segFolder.getSegments(), segFolder);
            this.viewer.refresh();
            this.updateExpandTreeWithNewNodes(segFolder, expandedElements);
            this.expandTree(expandedElements);
            this.editorParent.setDirty(true);
        }
    }

    private void updateExpandTreeWithNewNodes(TranSegmentsFolder segFolder, Object[] expandedElements) {
        Vector<TranSegmentModel> alreadyReplacedSegs = new Vector<TranSegmentModel>();
        int i = 0;
        while (i < expandedElements.length) {
            if (expandedElements[i] == segFolder) {
                ++i;
                while (i < expandedElements.length && expandedElements[i] instanceof TranSegmentModel) {
                    TranTreeObject[] newSegs = segFolder.getChildren();
                    TranSegmentModel expandedSeg = (TranSegmentModel)expandedElements[i];
                    int j = 0;
                    while (j < newSegs.length) {
                        TranSegmentModel currSeg = (TranSegmentModel)newSegs[j];
                        if (expandedSeg.getName().equals(currSeg.getName())) {
                            alreadyReplacedSegs.add(currSeg);
                            expandedElements[i] = currSeg;
                            if (i + 1 >= expandedElements.length || !(expandedElements[i + 1] instanceof TranDataStructuresFolder)) break;
                            TranDataStructuresFolder dsFolder = (TranDataStructuresFolder)currSeg.getChildren()[0];
                            expandedElements[++i] = dsFolder;
                            ++i;
                            while (i < expandedElements.length && expandedElements[i] instanceof TranDataStructureModel) {
                                TranTreeObject[] newDsNodes = dsFolder.getChildren();
                                TranDataStructureModel expandedDs = (TranDataStructureModel)expandedElements[i];
                                int k = 0;
                                while (k < newDsNodes.length) {
                                    TranDataStructureModel currDs = (TranDataStructureModel)newDsNodes[k];
                                    if (expandedDs.getName().equals(currDs.getName())) {
                                        expandedElements[i] = currDs;
                                        break;
                                    }
                                    ++k;
                                }
                                ++i;
                            }
                            break;
                        }
                        ++j;
                    }
                    if (i >= expandedElements.length || !alreadyReplacedSegs.contains(expandedElements[i])) continue;
                    ++i;
                }
                break;
            }
            ++i;
        }
    }

    private void handleCopy() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Object selectedNode = selection.getFirstElement();
        if (selectedNode instanceof TranDataStructureModel) {
            this.controller.copyDataStructure((TranDataStructureModel)selectedNode);
            this.viewer.refresh();
            this.multiplePastes = false;
        }
    }

    private void handlePaste() throws UnsupportedTypeConversion, IOException, ConversionException, MessageWalkerException {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Object selectedNode = selection.getFirstElement();
        if (selectedNode instanceof TranDataStructureModel || selectedNode instanceof TranDataStructuresFolder) {
            String collidedName;
            if (this.multiplePastes) {
                this.controller.reCopyDsForMultiplePastes();
            }
            if ((collidedName = this.controller.checkNameCollisionForPaste(selectedNode)) != null) {
                Vector existingDsNames = this.controller.getExistingDsNamesForPaste(selectedNode);
                this.controller.renameDsForPaste(collidedName, existingDsNames);
            }
            this.controller.pasteDataStructure(selectedNode);
            this.viewer.refresh();
            this.multiplePastes = true;
            if (selectedNode instanceof TranDataStructuresFolder) {
                this.viewer.setExpandedState(selectedNode, true);
            }
            this.editorParent.setDirty(true);
        }
    }

    private void handleMoveUp() {
        Object[] expandedElements = this.viewer.getExpandedElements();
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Object selectedNode = selection.getFirstElement();
        if (selectedNode instanceof TranDataStructureModel) {
            this.controller.moveUpDataStructure((TranDataStructureModel)selectedNode);
        } else if (selectedNode instanceof TranSegmentModel) {
            this.controller.moveUpSegment((TranSegmentModel)selectedNode);
        }
        this.viewer.refresh();
        this.expandTree(expandedElements);
        this.editorParent.setDirty(true);
    }

    private void handleMoveDown() {
        Object[] expandedElements = this.viewer.getExpandedElements();
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Object selectedNode = selection.getFirstElement();
        if (selectedNode instanceof TranDataStructureModel) {
            this.controller.moveDownDataStructure((TranDataStructureModel)selectedNode);
        } else if (selectedNode instanceof TranSegmentModel) {
            this.controller.moveDownSegment((TranSegmentModel)selectedNode);
        }
        this.viewer.refresh();
        this.expandTree(expandedElements);
        this.editorParent.setDirty(true);
    }

    private void handleAddEditFields() throws MessageWalkerException, UnsupportedTypeConversion, IOException, ConversionException {
        Vector<String> expandedElements = this.getExpandedElements();
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        ManageFieldsController mfController = new ManageFieldsController(this.controller);
        ManageFieldWizard mfWizard = new ManageFieldWizard(mfController, selection);
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)mfWizard);
        dialog.create();
        dialog.getShell().setSize(800, 650);
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            Transaction clonedTransaction = mfController.getClonedInvisibleRoot().getTran();
            this.controller.setInvisibleRoot(new TranModel(clonedTransaction));
            this.editorParent.setDirty(true);
            this.viewer.setInput((Object)this.controller.getInvisibleRoot());
            this.viewer.refresh();
            this.setExpanded(expandedElements, this.controller.getInvisibleRoot().getChildren());
        }
    }

    private Vector<String> getExpandedElements() {
        Object[] objects = this.viewer.getVisibleExpandedElements();
        Vector<String> retVal = new Vector<String>();
        int i = 0;
        while (i < objects.length) {
            if (objects[i] instanceof TranTreeParent) {
                TranTreeParent object = (TranTreeParent)objects[i];
                retVal.add(this.getPath(object, object.getName()));
            }
            ++i;
        }
        return retVal;
    }

    private String getPath(TranTreeParent node, String name) {
        if (node.getParent() == null) {
            return name;
        }
        TranTreeParent parent = (TranTreeParent)node.getParent();
        return this.getPath((TranTreeParent)node.getParent(), parent.getName() + File.separator + name);
    }

    private void setExpanded(Vector<String> expandedElements, TranTreeObject[] nodes) {
        int i = 0;
        while (i < nodes.length) {
            TranTreeObject node = nodes[i];
            for (String name : expandedElements) {
                String objName;
                if (!(node instanceof TranTreeParent) || !(objName = this.getPath((TranTreeParent)node, node.getName())).equals(name)) continue;
                this.viewer.setExpandedState((Object)node, true);
                if (!(node instanceof TranTreeParent)) continue;
                this.setExpanded(expandedElements, ((TranTreeParent)node).getChildren());
            }
            ++i;
        }
    }

    private void expandTree(Object[] expandElements) {
        int i = 0;
        while (i < expandElements.length) {
            TranTreeObject currNode = (TranTreeObject)expandElements[i];
            boolean shouldExpand = true;
            TranTreeObject ancestorNode = (TranTreeObject)currNode.getParent();
            while (ancestorNode != null && ancestorNode != this.controller.getInvisibleRoot()) {
                boolean isExpanded = this.viewer.getExpandedState((Object)ancestorNode);
                if (!isExpanded) {
                    shouldExpand = false;
                    break;
                }
                ancestorNode = (TranTreeObject)ancestorNode.getParent();
            }
            if (shouldExpand) {
                this.viewer.expandToLevel(expandElements[i], 1);
            }
            ++i;
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent event) {
        try {
            if (event.widget == this.importDsButton) {
                if (this.editDespiteChangingTestcases()) {
                    this.handleImportDS();
                }
            } else if (event.widget == this.importDsMetadataButton) {
                if (this.editDespiteChangingTestcases()) {
                    this.handleImportDSMetadata();
                }
            } else if (event.widget == this.addButton) {
                IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
                Object selectedNode = selection.getFirstElement();
                if (this.editDespiteChangingTestcases()) {
                    if (selectedNode instanceof TranMessagesFolder) {
                        this.handleAddMessage();
                    } else {
                        this.handleAddSegment();
                    }
                }
            } else if (event.widget == this.editButton) {
                IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
                Object selectedNode = selection.getFirstElement();
                if (selectedNode instanceof TranMessageModel) {
                    this.handleEditMessage();
                } else if (selectedNode instanceof TranDataStructureModel) {
                    this.handleEditDataStructure();
                } else if (selectedNode instanceof FieldModel) {
                    this.handleEditField();
                }
            } else if (event.widget == this.removeButton) {
                if (this.editDespiteChangingTestcases()) {
                    this.handleRemove();
                }
            } else if (event.widget == this.copyButton) {
                this.handleCopy();
            } else if (event.widget == this.pasteButton) {
                if (this.editDespiteChangingTestcases()) {
                    this.handlePaste();
                }
            } else if (event.widget == this.moveUpButton) {
                if (this.editDespiteChangingTestcases()) {
                    this.handleMoveUp();
                }
            } else if (event.widget == this.moveDownButton) {
                if (this.editDespiteChangingTestcases()) {
                    this.handleMoveDown();
                }
            } else if (event.widget == this.addEditFieldsButton && this.editDespiteChangingTestcases()) {
                this.handleAddEditFields();
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "", e);
            logger.error(e);
        }
        this.enableButtons();
    }

    private void enableButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        this.addButton.setEnabled(false);
        this.editButton.setEnabled(false);
        this.copyButton.setEnabled(false);
        this.pasteButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.moveUpButton.setEnabled(false);
        this.moveDownButton.setEnabled(false);
        this.addEditFieldsButton.setEnabled(false);
        this.importDsMetadataButton.setEnabled(false);
        if (this.nodesToBeRemoved == null) {
            this.nodesToBeRemoved = new ArrayList();
        } else {
            this.nodesToBeRemoved.clear();
        }
        if (selection.size() > 1) {
            boolean canRemove = true;
            for (Object selectedNode : selection) {
                if (selectedNode instanceof TranMessagesFolder || selectedNode instanceof FieldModel) {
                    canRemove = false;
                    break;
                }
                if (selectedNode instanceof TranSegmentsFolder) {
                    Object msgNode = ((TranTreeObject)selectedNode).getParent();
                    if (this.nodesToBeRemoved.contains(msgNode)) continue;
                    canRemove = false;
                    break;
                }
                if (selectedNode instanceof TranDataStructuresFolder) {
                    Object segNode = ((TranTreeObject)selectedNode).getParent();
                    Object msgNode = ((TranTreeObject)((TranTreeObject)segNode).getParent()).getParent();
                    if (this.nodesToBeRemoved.contains(segNode) || this.nodesToBeRemoved.contains(msgNode)) continue;
                    canRemove = false;
                    break;
                }
                this.nodesToBeRemoved.add(selectedNode);
            }
            if (canRemove) {
                this.removeButton.setEnabled(true);
            }
        } else {
            Object selectedNode = selection.getFirstElement();
            if (selectedNode instanceof TranMessagesFolder || selectedNode instanceof TranSegmentsFolder) {
                String entity = TranMessages.getLabel().getString("TNT_HOVER_ENTITY_MESSAGE");
                if (selectedNode instanceof TranSegmentsFolder) {
                    entity = TranMessages.getLabel().getString("TNT_HOVER_ENTITY_SEGMENT");
                }
                this.addButton.setToolTipText(TranMessages.getLabel().getString("TNT_BUTTON_ADD_HOVER", (Object[])new String[]{entity}));
                this.addButton.setEnabled(true);
            } else if (selectedNode instanceof TranMessageModel) {
                this.editButton.setEnabled(true);
                this.nodesToBeRemoved.add(selectedNode);
                this.removeButton.setEnabled(true);
            } else if (selectedNode instanceof TranSegmentModel) {
                TranTreeObject DSFolder;
                this.nodesToBeRemoved.add(selectedNode);
                this.removeButton.setEnabled(true);
                if (this.controller.canMoveUp((TranTreeObject)selectedNode)) {
                    this.moveUpButton.setEnabled(true);
                    this.moveUpButton.setToolTipText(TranMessages.getLabel().getString("TNT_BUTTON_MOVEUP_HOVER", (Object[])new String[]{TranMessages.getLabel().getString("TNT_HOVER_ENTITY_SEGMENT")}));
                }
                if (this.controller.canMoveDown((TranTreeObject)selectedNode)) {
                    this.moveDownButton.setEnabled(true);
                    this.moveDownButton.setToolTipText(TranMessages.getLabel().getString("TNT_BUTTON_MOVEDOWN_HOVER", (Object[])new String[]{TranMessages.getLabel().getString("TNT_HOVER_ENTITY_SEGMENT")}));
                }
                if (((TranDataStructuresFolder)(DSFolder = ((TranSegmentModel)selectedNode).getChildren()[0])).getChildren().length > 0) {
                    this.addEditFieldsButton.setEnabled(true);
                }
            } else if (selectedNode instanceof TranDataStructuresFolder) {
                if (this.controller.canPaste()) {
                    this.pasteButton.setEnabled(true);
                }
                this.importDsMetadataButton.setEnabled(true);
                if (((TranDataStructuresFolder)selectedNode).getChildren().length > 0) {
                    this.addEditFieldsButton.setEnabled(true);
                }
            } else if (selectedNode instanceof TranDataStructureModel) {
                this.copyButton.setEnabled(true);
                this.editButton.setEnabled(true);
                this.addEditFieldsButton.setEnabled(true);
                if (this.controller.canPaste()) {
                    this.pasteButton.setEnabled(true);
                }
                this.nodesToBeRemoved.add(selectedNode);
                this.removeButton.setEnabled(true);
                if (this.controller.canMoveUp((TranTreeObject)selectedNode)) {
                    this.moveUpButton.setEnabled(true);
                    this.moveUpButton.setToolTipText(TranMessages.getLabel().getString("TNT_BUTTON_MOVEUP_HOVER", (Object[])new String[]{TranMessages.getLabel().getString("TNT_HOVER_ENTITY_DATASTRUCTURE")}));
                }
                if (this.controller.canMoveDown((TranTreeObject)selectedNode)) {
                    this.moveDownButton.setEnabled(true);
                    this.moveDownButton.setToolTipText(TranMessages.getLabel().getString("TNT_BUTTON_MOVEDOWN_HOVER", (Object[])new String[]{TranMessages.getLabel().getString("TNT_HOVER_ENTITY_DATASTRUCTURE")}));
                }
            } else if (selectedNode instanceof FieldModel) {
                this.addEditFieldsButton.setEnabled(true);
            }
        }
    }

    private void handleImportDS() throws UnsupportedTypeConversion, IOException, ConversionException, MessageWalkerException, ModelException {
        Vector<DataStructureSegmentAssociation> importResult;
        Vector<String> expandedElements = this.getExpandedElements();
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        String selectedMessageName = null;
        String selectedSegmentName = null;
        if (selection.size() == 1) {
            Object selectedObject = selection.getFirstElement();
            if (selectedObject instanceof TranMessageModel) {
                selectedMessageName = this.getSelectedMessageName(((TranMessageModel)selectedObject).getMessage(), ((TranMessageModel)selectedObject).getMessageType());
            } else if (selectedObject instanceof TranSegmentsFolder) {
                TranSegmentsFolder segFolder = (TranSegmentsFolder)selectedObject;
                selectedMessageName = this.getSelectedMessageName(((TranMessageModel)segFolder.getParent()).getMessage(), ((TranMessageModel)segFolder.getParent()).getMessageType());
            } else if (selectedObject instanceof TranSegmentModel) {
                TranSegmentModel tranSegmentModel = (TranSegmentModel)selectedObject;
                selectedSegmentName = tranSegmentModel.getName();
                TranSegmentsFolder segFolder = (TranSegmentsFolder)tranSegmentModel.getParent();
                selectedMessageName = this.getSelectedMessageName(((TranMessageModel)segFolder.getParent()).getMessage(), ((TranMessageModel)segFolder.getParent()).getMessageType());
            } else if (selectedObject instanceof TranDataStructuresFolder) {
                TranDataStructuresFolder dsFolder = (TranDataStructuresFolder)selectedObject;
                TranSegmentModel tranSegmentModel = (TranSegmentModel)dsFolder.getParent();
                selectedSegmentName = tranSegmentModel.getName();
                TranSegmentsFolder segFolder = (TranSegmentsFolder)tranSegmentModel.getParent();
                selectedMessageName = this.getSelectedMessageName(((TranMessageModel)segFolder.getParent()).getMessage(), ((TranMessageModel)segFolder.getParent()).getMessageType());
            } else if (selectedObject instanceof TranDataStructureModel) {
                dataStructure = (TranDataStructureModel)selectedObject;
                dsFolder = (TranDataStructuresFolder)dataStructure.getParent();
                tranSegmentModel = (TranSegmentModel)dsFolder.getParent();
                selectedSegmentName = tranSegmentModel.getName();
                segFolder = (TranSegmentsFolder)tranSegmentModel.getParent();
                selectedMessageName = this.getSelectedMessageName(((TranMessageModel)segFolder.getParent()).getMessage(), ((TranMessageModel)segFolder.getParent()).getMessageType());
            } else if (selectedObject instanceof FieldModel) {
                selectedObject = ((FieldModel)selectedObject).getParent();
                dataStructure = (TranDataStructureModel)selectedObject;
                dsFolder = (TranDataStructuresFolder)dataStructure.getParent();
                tranSegmentModel = (TranSegmentModel)dsFolder.getParent();
                selectedSegmentName = tranSegmentModel.getName();
                segFolder = (TranSegmentsFolder)tranSegmentModel.getParent();
                selectedMessageName = this.getSelectedMessageName(((TranMessageModel)segFolder.getParent()).getMessage(), ((TranMessageModel)segFolder.getParent()).getMessageType());
            }
        }
        ImportDSTranMessageMetadataWizard dsMsgMetadataWizard = new ImportDSTranMessageMetadataWizard(this, selectedMessageName, selectedSegmentName);
        WizardDialog dialog = new WizardDialog(this.getPage().getShell(), (IWizard)dsMsgMetadataWizard);
        dialog.create();
        dialog.getShell().setSize(dsMsgMetadataWizard.getShell().getMinimumSize());
        if (dialog.open() == 0 && (importResult = dsMsgMetadataWizard.getImportResult()) != null) {
            Object[] importDsArray = importResult.toArray();
            int i = 0;
            while (i < importDsArray.length) {
                DataStructureSegmentAssociation dssa = (DataStructureSegmentAssociation)importDsArray[i];
                String possibleCollideName = dssa.dataStructure.getName();
                if (dssa.nameCollision) {
                    if (dssa.replace) {
                        this.controller.preserveFieldInfoAndRemoveDs(dssa);
                    } else {
                        Vector existingDsNames = this.controller.getExistingDsNamesForImport(dssa);
                        this.controller.renameDsForImport(possibleCollideName, existingDsNames, dssa);
                    }
                }
                this.controller.checkNameCollisionAmongImportDS(possibleCollideName, importResult, i);
                ++i;
            }
            this.controller.addImportedDS(importResult);
            ManageFieldsController mfController = new ManageFieldsController(this.controller);
            for (DataStructureSegmentAssociation dssa : importResult) {
                TranSegmentModel tranSegmentModel = mfController.getSegmentNode(dssa.messageId.intValue(), dssa.segmentId.intValue());
                if (tranSegmentModel.getChildren().length <= 0) continue;
                tranSegmentModel.updateSegmentStartValues();
            }
            Transaction clonedTransaction = mfController.getClonedInvisibleRoot().getTran();
            this.controller.setInvisibleRoot(new TranModel(clonedTransaction));
            this.viewer.setInput((Object)this.controller.getInvisibleRoot());
            this.viewer.refresh();
            this.editorParent.setDirty(true);
            this.setExpanded(expandedElements, this.controller.getInvisibleRoot().getChildren());
        }
    }

    private void handleImportDSMetadata() throws JAXBException, CoreException, UnsupportedTypeConversion, IOException, ConversionException, MessageWalkerException {
        FileDialog fDialog;
        String result;
        Object selectedObject;
        Vector<String> expandedElements = this.getExpandedElements();
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        BigInteger segmentId = null;
        BigInteger messageId = null;
        String msgName = null;
        if (selection.size() == 1 && (selectedObject = selection.getFirstElement()) instanceof TranDataStructuresFolder) {
            TranDataStructuresFolder dsFolder = (TranDataStructuresFolder)selectedObject;
            TranSegmentModel tranSegmentModel = (TranSegmentModel)dsFolder.getParent();
            TranSegmentsFolder segFolder = (TranSegmentsFolder)tranSegmentModel.getParent();
            segmentId = tranSegmentModel.getSegment().getId();
            TranMessageModel msgModel = (TranMessageModel)segFolder.getParent();
            messageId = msgModel.getMessage().getId();
        }
        if (segmentId != null && messageId != null && (result = (fDialog = new FileDialog(this.getPage().getShell(), 4)).open()) != null && !result.isEmpty()) {
            String path = fDialog.getFilterPath();
            Object fileName = fDialog.getFileName();
            fileName = path + File.separator + (String)fileName;
            File metadataFile = new File((String)fileName);
            FileInputStream fis = new FileInputStream(metadataFile);
            Transaction tran = ProjectTreeFileHelper.unmarshallTran((InputStream)fis);
            FieldType dataStructure = null;
            dataStructure = this.getFirstDSFound(tran.getInputMessage());
            msgName = "dummyMsgName **IN**";
            if (dataStructure == null) {
                dataStructure = this.getFirstDSFound(tran.getOutputMessage());
                msgName = "dummyMsgName **OUT**";
            }
            DataStructureSegmentAssociation importResult = new DataStructureSegmentAssociation(messageId, segmentId, dataStructure, metadataFile.getName());
            importResult.messageName = msgName;
            Vector<DataStructureSegmentAssociation> importResultList = new Vector<DataStructureSegmentAssociation>();
            importResultList.add(importResult);
            if (importResult != null) {
                this.controller.addImportedDS(importResultList);
                this.viewer.refresh();
                this.editorParent.setDirty(true);
                this.setExpanded(expandedElements, this.controller.getInvisibleRoot().getChildren());
            }
        }
    }

    private FieldType getFirstDSFound(List<MessageType> msgTypes) {
        FieldType dataStructure = null;
        int i = 0;
        while (i < msgTypes.size()) {
            if (dataStructure != null) break;
            MessageType currMsgType = msgTypes.get(i);
            List segTypes = currMsgType.getSegment();
            int j = 0;
            while (j < segTypes.size()) {
                SegmentType currSegType = (SegmentType)segTypes.get(j);
                List fieldTypeList = currSegType.getField();
                if (fieldTypeList.size() > 0) {
                    dataStructure = (FieldType)fieldTypeList.get(0);
                    break;
                }
                ++j;
            }
            ++i;
        }
        return dataStructure;
    }

    private String getSelectedMessageName(MessageType messageType, int msgDirection) {
        Object selectedMessageName = messageType.getName();
        selectedMessageName = msgDirection == 0 ? (String)selectedMessageName + " **IN**" : (String)selectedMessageName + " **OUT**";
        return selectedMessageName;
    }

    public MultiPageEditor getParent() {
        return this.editorParent;
    }

    public void modifyText(ModifyEvent event) {
        if (event.widget == this.textTrancode) {
            String tranCode = this.textTrancode.getText().trim();
            this.msgControl.clearValidationMessage((Control)this.textTrancode);
            if (tranCode == null || tranCode.isEmpty() || !Utility.isValidName((String)tranCode)) {
                this.msgControl.setValidationMessage((Control)this.textTrancode, TranMessages.getError().getString("IPC_NAME_ERROR", (Object[])new String[]{TranMessages.getLabel().getString("NPNT_TRAN_CODE")}), 1);
                this.editorParent.setDirty(false);
            } else {
                this.controller.getTran().setTranCode(tranCode);
                this.editorParent.setDirty(true);
            }
        }
    }

    public void verifyText(VerifyEvent arg0) {
        try {
            if (arg0.widget == this.textTrancode && arg0.character >= 'a' && arg0.character <= 'z') {
                arg0.text = arg0.text.toUpperCase();
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "verifyText(VerifyEvent event)", e);
            logger.error(e);
        }
    }

    public void mouseDoubleClick(MouseEvent event) {
        try {
            Object sourceObj = event.getSource();
            if (sourceObj == this.tree) {
                IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
                Object selectedNode = selection.getFirstElement();
                if (selectedNode instanceof TranMessageModel) {
                    TranMessageModel msgNode = (TranMessageModel)selection.getFirstElement();
                    EditMessageWizard editMessageWizard = new EditMessageWizard(this.controller.getTran(), msgNode, msgNode.getMessageType());
                    WizardDialog dialog = new WizardDialog(this.getPage().getShell(), (IWizard)editMessageWizard);
                    dialog.create();
                    dialog.open();
                    if (dialog.getReturnCode() == 0) {
                        this.controller.editMessage(msgNode, editMessageWizard.getMessageName(), editMessageWizard.getMessageRemarks());
                        this.viewer.refresh();
                        this.editorParent.setDirty(true);
                    }
                } else if (selectedNode instanceof TranSegmentModel) {
                    TranTreeObject DSFolder = ((TranSegmentModel)selectedNode).getChildren()[0];
                    if (((TranDataStructuresFolder)DSFolder).getChildren().length > 0) {
                        this.addEditFieldsButton.setEnabled(true);
                        this.handleAddEditFields();
                    }
                } else if (selectedNode instanceof TranDataStructuresFolder) {
                    if (((TranDataStructuresFolder)selection.getFirstElement()).getChildren().length > 0) {
                        this.handleAddEditFields();
                    }
                } else if (selectedNode instanceof TranDataStructureModel) {
                    this.handleAddEditFields();
                } else if (selectedNode instanceof FieldModel) {
                    this.handleAddEditFields();
                }
            }
        }
        catch (Throwable ex) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "", ex);
            logger.error(ex);
        }
    }

    public void mouseDown(MouseEvent arg0) {
    }

    public void mouseUp(MouseEvent arg0) {
    }

    public void keyPressed(KeyEvent arg0) {
    }

    public void keyReleased(KeyEvent event) {
        try {
            IStructuredSelection selection;
            Object sourceObj;
            int kc = event.keyCode;
            if (kc == 13 && (sourceObj = event.getSource()) == this.tree && (selection = (IStructuredSelection)this.viewer.getSelection()).getFirstElement() instanceof TranMessageModel) {
                TranMessageModel msgNode = (TranMessageModel)selection.getFirstElement();
                EditMessageWizard editMessageWizard = new EditMessageWizard(this.controller.getTran(), msgNode, msgNode.getMessageType());
                WizardDialog dialog = new WizardDialog(this.getPage().getShell(), (IWizard)editMessageWizard);
                dialog.create();
                dialog.open();
                if (dialog.getReturnCode() == 0) {
                    this.controller.editMessage(msgNode, editMessageWizard.getMessageName(), editMessageWizard.getMessageRemarks());
                    this.viewer.refresh();
                    this.editorParent.setDirty(true);
                }
            }
        }
        catch (Throwable ex) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "", ex);
            logger.error(ex);
        }
    }
}

