/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.transaction.editors;

import com.ibm.im.ims.metadata.transaction.FieldType;
import com.ibm.im.ims.workbench.transaction.model.FieldModel;
import com.ibm.im.ims.workbench.transaction.model.MessageUnit;
import com.ibm.im.ims.workbench.transaction.model.MessageUnitFolder;
import com.ibm.im.ims.workbench.transaction.model.TranDataStructureModel;
import com.ibm.im.ims.workbench.transaction.model.TranDataStructuresFolder;
import com.ibm.im.ims.workbench.transaction.model.TranMessageModel;
import com.ibm.im.ims.workbench.transaction.model.TranMessagesFolder;
import com.ibm.im.ims.workbench.transaction.model.TranSegmentModel;
import com.ibm.im.ims.workbench.transaction.model.TranSegmentsFolder;
import com.ibm.im.ims.workbench.transaction.utilities.Images;
import com.ibm.ims.transaction.messages.walkers.MessageWalker;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class TransactionEditorLabelProvider
extends LabelProvider {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public String getText(Object obj) {
        if (obj instanceof FieldModel && ((FieldModel)obj).getFieldType() != null) {
            FieldModel fieldModel = (FieldModel)obj;
            FieldType fieldType = fieldModel.getFieldType();
            StringBuilder fieldLabel = new StringBuilder(fieldType.getName());
            fieldLabel.append(TransactionEditorLabelProvider.getArrayDecoration(fieldType));
            return fieldLabel.toString();
        }
        return obj.toString();
    }

    public Image getImage(Object obj) {
        if (obj instanceof MessageUnit) {
            return Images.getMessageUnitImage();
        }
        if (obj instanceof MessageUnitFolder) {
            return Images.getMessageUnitsFolderImage();
        }
        if (obj instanceof TranDataStructuresFolder) {
            return Images.getDataStructuresFolderImage();
        }
        if (obj instanceof TranDataStructureModel) {
            return Images.getDataStructureImage();
        }
        if (obj instanceof FieldModel) {
            return Images.getFieldImage();
        }
        if (obj instanceof TranMessageModel) {
            int messageType = ((TranMessageModel)obj).getMessageType();
            if (messageType == 0) {
                return Images.getInputMessageImage();
            }
            return Images.getOutputMessageImage();
        }
        if (obj instanceof TranMessagesFolder) {
            return Images.getOutputMessagesFolderImage();
        }
        if (obj instanceof TranSegmentModel) {
            return Images.getSegmentImage();
        }
        if (obj instanceof TranSegmentsFolder) {
            return Images.getSegmentsFolderImage();
        }
        return null;
    }

    public static String getArrayDecoration(FieldType fieldType) {
        StringBuilder decorator = new StringBuilder();
        if (MessageWalker.isArray((FieldType)fieldType)) {
            decorator.append(" [");
            if (MessageWalker.isFixedLengthArrayField((FieldType)fieldType)) {
                decorator.append(fieldType.getMaxOccurs());
            } else {
                decorator.append(String.valueOf(fieldType.getMinOccurs()) + "..." + String.valueOf(fieldType.getMaxOccurs()));
            }
            decorator.append("]");
        }
        return decorator.toString();
    }
}

