/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.transaction.editors;

import com.ibm.im.ims.workbench.transaction.editors.TestcaseEditorPage;
import com.ibm.im.ims.workbench.transaction.testcase.model.DataStructureNode;
import com.ibm.im.ims.workbench.transaction.testcase.model.FieldNode;
import com.ibm.im.ims.workbench.transaction.testcase.model.IOMessageNode;
import com.ibm.im.ims.workbench.transaction.testcase.model.IOMessagePairNode;
import com.ibm.im.ims.workbench.transaction.testcase.model.JsonFieldNode;
import com.ibm.im.ims.workbench.transaction.testcase.model.JsonMessageNode;
import com.ibm.im.ims.workbench.transaction.testcase.model.SegmentNode;
import com.ibm.im.ims.workbench.transaction.testcase.model.TestCaseFolderNode;
import com.ibm.im.ims.workbench.transaction.testcase.model.TestCaseNode;
import com.ibm.im.ims.workbench.transaction.utilities.Images;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class TestcaseFieldLayoutLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public Image getColumnImage(Object element, int columnIndex) {
        if (columnIndex == 0) {
            if (element instanceof TestCaseFolderNode) {
                return Images.getMessageUnitsFolderImage();
            }
            if (element instanceof IOMessagePairNode) {
                int curr_state = ((IOMessagePairNode)element).getState();
                if (curr_state == 1) {
                    return Images.getNextToRunImage();
                }
                if (curr_state == 0) {
                    return Images.getAlreadyRanImage();
                }
                if (curr_state == 2) {
                    return Images.getCannotRunYetImage();
                }
                if (curr_state == 3) {
                    return Images.getMessageUnitImage();
                }
            } else {
                if (element instanceof IOMessageNode) {
                    int type = ((IOMessageNode)element).getType();
                    if (type == 0) {
                        return Images.getInputMessageImage();
                    }
                    return Images.getOutputMessageImage();
                }
                if (element instanceof JsonMessageNode) {
                    int type = ((JsonMessageNode)element).getType();
                    if (type == 0) {
                        return Images.getInputMessageImage();
                    }
                    return Images.getOutputMessageImage();
                }
                if (element instanceof SegmentNode) {
                    return Images.getSegmentImage();
                }
                if (element instanceof DataStructureNode) {
                    return Images.getDataStructureImage();
                }
                if (element instanceof FieldNode || element instanceof JsonFieldNode) {
                    return Images.getFieldImage();
                }
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        Object retVal = null;
        String colLabel = TestcaseEditorPage.COLUMN_NAMES[columnIndex];
        if (colLabel == TestcaseEditorPage.IOMP_NODES) {
            JsonFieldNode fn;
            String arrayIxStr;
            if (element instanceof TestCaseNode) {
                retVal = ((TestCaseNode)element).getName();
            }
            if (element instanceof JsonFieldNode && (arrayIxStr = (fn = (JsonFieldNode)element).getArrayIxStr()) != null && !arrayIxStr.isEmpty()) {
                retVal = arrayIxStr + " " + (String)retVal;
            }
        } else if (colLabel == TestcaseEditorPage.DATA_TYPE) {
            if (element instanceof FieldNode) {
                FieldNode fn = (FieldNode)element;
                retVal = fn.getFieldType().getApplicationDatatype().getDatatype().toString();
            } else if (element instanceof JsonFieldNode) {
                JsonFieldNode fn = (JsonFieldNode)element;
                retVal = fn.getInterfaceFieldType().getAssociatedFieldType().getApplicationDatatype().getDatatype().toString();
            }
        } else if (colLabel == TestcaseEditorPage.FIELD_VALUE) {
            if (element instanceof FieldNode) {
                FieldNode fn = (FieldNode)element;
                String value = fn.getFieldValue().getFieldValue();
                retVal = value == null ? "" : value;
            } else if (element instanceof JsonFieldNode) {
                JsonFieldNode fn = (JsonFieldNode)element;
                retVal = fn.getValue();
            }
        } else if (colLabel == TestcaseEditorPage.START_BYTE) {
            if (element instanceof FieldNode) {
                FieldNode fn = (FieldNode)element;
                retVal = String.valueOf(fn.getFieldValue().getStartPos());
            } else if (element instanceof JsonFieldNode) {
                retVal = "";
            } else if (element instanceof DataStructureNode) {
                DataStructureNode dsNode = (DataStructureNode)element;
                retVal = String.valueOf(dsNode.getFieldValue().getStartPos());
            }
        } else if (colLabel == TestcaseEditorPage.FIELD_LENGTH) {
            if (element instanceof FieldNode) {
                FieldNode fn = (FieldNode)element;
                retVal = String.valueOf(fn.getFieldValue().getSize());
            } else if (element instanceof JsonFieldNode) {
                retVal = "";
            } else if (element instanceof DataStructureNode) {
                DataStructureNode dsNode = (DataStructureNode)element;
                retVal = String.valueOf(dsNode.getFieldValue().getSize());
            }
        }
        return retVal;
    }

    public Image getImage(Object element) {
        return this.getColumnImage(element, 0);
    }

    public String getText(Object element) {
        return this.getColumnText(element, 0);
    }
}

