/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.transaction.editors;

import com.ibm.im.ims.metadata.testcase.IoMessagePairType;
import com.ibm.im.ims.metadata.testcase.Testcase;
import com.ibm.im.ims.metadata.transaction.DatatypeType;
import com.ibm.im.ims.transaction.controller.editor.FieldValueEditorController;
import com.ibm.im.ims.transaction.controller.editor.TestcaseEditorController;
import com.ibm.im.ims.transaction.model.utilities.ImporterException;
import com.ibm.im.ims.transaction.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.transaction.model.utilities.TrantocMapManager;
import com.ibm.im.ims.transaction.model.utilities.Utility;
import com.ibm.im.ims.workbench.transaction.dialog.editfield.EditFieldDialog;
import com.ibm.im.ims.workbench.transaction.editors.MultiPageEditor;
import com.ibm.im.ims.workbench.transaction.editors.TestcaseFieldLayoutContentProvider;
import com.ibm.im.ims.workbench.transaction.editors.TestcaseFieldLayoutLabelProvider;
import com.ibm.im.ims.workbench.transaction.resources.utilities.TranMessages;
import com.ibm.im.ims.workbench.transaction.testcase.model.DataStructureNode;
import com.ibm.im.ims.workbench.transaction.testcase.model.FieldNode;
import com.ibm.im.ims.workbench.transaction.testcase.model.IOMessageNode;
import com.ibm.im.ims.workbench.transaction.testcase.model.IOMessagePairNode;
import com.ibm.im.ims.workbench.transaction.testcase.model.JsonFieldNode;
import com.ibm.im.ims.workbench.transaction.testcase.model.SegmentNode;
import com.ibm.im.ims.workbench.transaction.testcase.model.TestCaseFolderNode;
import com.ibm.im.ims.workbench.transaction.testcase.model.TestCaseNode;
import com.ibm.im.ims.workbench.transaction.wizard.editmessagepair.EditMessagePairWizard;
import com.ibm.im.ims.workbench.transaction.wizard.importmsg.ImportTranMessageWizard;
import com.ibm.ims.dli.types.ConversionException;
import com.ibm.ims.dli.types.UnsupportedTypeConversion;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import com.ibm.ims.transaction.messages.walkers.MessageWalkerException;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import java.util.Vector;
import javax.xml.bind.JAXBException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.FormColors;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class TestcaseEditorPage
extends FormPage
implements SelectionListener,
KeyListener,
MouseListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private TestcaseEditorController controller;
    private MultiPageEditor editorParent;
    private Composite composite;
    private TreeViewer viewer;
    private Tree tree;
    public static final String IOMP_NODES = TranMessages.getLabel().getString("TCMLE_COLNAME_IOPAIR");
    public static final String FIELD_VALUE = TranMessages.getLabel().getString("TCMLE_COLNAME_FIELDVALUE");
    public static final String DATA_TYPE = TranMessages.getLabel().getString("TCMLE_COLNAME_DATATYPE");
    public static final String START_BYTE = TranMessages.getLabel().getString("TCMLE_COLNAME_STARTBYTE");
    public static final String FIELD_LENGTH = TranMessages.getLabel().getString("TCMLE_COLNAME_FIELDLENGTH");
    public static final String[] COLUMN_NAMES = new String[]{IOMP_NODES, FIELD_VALUE, FIELD_LENGTH, DATA_TYPE, START_BYTE};
    private Button importMsgButton;
    private Button addButton;
    private Button editButton;
    private Button copyButton;
    private Button pasteButton;
    private Button removeButton;
    private Button moveUpButton;
    private Button moveDownButton;
    private static final int NUM_BUTTONS = 11;
    private int buttonWidth;
    private int margin = 5;

    public TestcaseEditorPage(MultiPageEditor parent, Composite compositeContainer, TestcaseEditorController controller) {
        super(null, "TestcaseMessageFieldLayoutEditor", parent.getTitle());
        this.controller = controller;
        this.editorParent = parent;
        this.createContent(compositeContainer);
    }

    public void refreshEditor() throws JAXBException, CoreException, UnsupportedTypeConversion, IOException, ConversionException {
        String tcFileName = Utility.removeFileExt((String)this.editorParent.getPartName());
        Testcase tc = ProjectTreeFileHelper.unmarshallTestcase((String)this.getProjectName(), (String)tcFileName);
        this.controller = new TestcaseEditorController(this.getProjectName(), tc, null);
        this.controller.setTestcaseFilename(tcFileName);
        this.viewer.setInput((Object)this.controller.getInvisibleRoot());
        this.viewer.expandToLevel(2);
    }

    private void createContent(Composite parent) {
        FormColors formColors = new FormColors(parent.getDisplay());
        formColors.markShared();
        FormToolkit toolkit = new FormToolkit(formColors);
        this.composite = toolkit.createComposite(parent, 64);
        this.composite.setLayout((Layout)new GridLayout());
        Section section = toolkit.createSection(this.composite, 160);
        section.setText(TranMessages.getLabel().getString("TCMFLE_TITLE"));
        section.setDescription(TranMessages.getDescription().getString("TCFLE_DESC"));
        section.setLayoutData((Object)new GridData(4, 4, true, true));
        section.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                TestcaseEditorPage.this.resizeColumns();
            }
        });
        toolkit.createCompositeSeparator((Composite)section);
        Composite client = toolkit.createComposite((Composite)section, 64);
        client.setLayout((Layout)new GridLayout(2, false));
        section.setClient((Control)client);
        Tree tree = new Tree(client, 68354);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
        tree.setLayoutData((Object)new GridData(4, 4, true, true));
        int i = 0;
        while (i < COLUMN_NAMES.length) {
            TreeColumn column = new TreeColumn(tree, 16384);
            column.setAlignment(16384);
            column.setText(COLUMN_NAMES[i]);
            ++i;
        }
        this.viewer = new TreeViewer(tree);
        this.viewer.setColumnProperties(COLUMN_NAMES);
        this.viewer.setContentProvider((IContentProvider)new TestcaseFieldLayoutContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TestcaseFieldLayoutLabelProvider());
        this.resizeColumns();
        this.viewer.setInput((Object)this.controller.getInvisibleRoot());
        this.viewer.expandToLevel(2);
        GridData treeGridData = new GridData(4, 4, true, true);
        treeGridData.verticalSpan = 11;
        this.viewer.getTree().setLayoutData((Object)treeGridData);
        this.tree = this.viewer.getTree();
        this.tree.addSelectionListener((SelectionListener)this);
        this.tree.addKeyListener((KeyListener)this);
        this.tree.addMouseListener((MouseListener)this);
        this.tree.addMouseMoveListener((MouseMoveListener)new FieldModelMouseTrackListener(this.tree));
        int[] labelSizes = new int[]{Utility.getTextWidth((Composite)parent, (int)0, (String)TranMessages.getLabel().getString("TNT_BUTTON_IMPORT_FIELD_VALUES")), Utility.getTextWidth((Composite)parent, (int)0, (String)TranMessages.getLabel().getString("TNT_BUTTON_IMPORT_MSG")), Utility.getTextWidth((Composite)parent, (int)0, (String)TranMessages.getLabel().getString("TNT_BUTTON_ADD")), Utility.getTextWidth((Composite)parent, (int)0, (String)TranMessages.getLabel().getString("TNT_BUTTON_EDIT")), Utility.getTextWidth((Composite)parent, (int)0, (String)TranMessages.getLabel().getString("TNT_BUTTON_COPY")), Utility.getTextWidth((Composite)parent, (int)0, (String)TranMessages.getLabel().getString("TNT_BUTTON_PASTE")), Utility.getTextWidth((Composite)parent, (int)0, (String)TranMessages.getLabel().getString("TNT_BUTTON_REMOVE")), Utility.getTextWidth((Composite)parent, (int)0, (String)TranMessages.getLabel().getString("TNT_BUTTON_MOVEUP")), Utility.getTextWidth((Composite)parent, (int)0, (String)TranMessages.getLabel().getString("TNT_BUTTON_MOVEDOWN"))};
        this.buttonWidth = Utility.getMaxSize((int[])labelSizes) + this.margin;
        this.importMsgButton = toolkit.createButton(client, TranMessages.getLabel().getString("TNT_BUTTON_IMPORT_MSG"), 8);
        GridData gd = new GridData(2);
        gd.widthHint = this.buttonWidth;
        this.importMsgButton.setLayoutData((Object)gd);
        this.importMsgButton.addSelectionListener((SelectionListener)this);
        this.importMsgButton.setEnabled(false);
        this.importMsgButton.setToolTipText(TranMessages.getLabel().getString("TNT_BUTTON_IMPORT_MSG_HOVER"));
        this.addButton = toolkit.createButton(client, TranMessages.getLabel().getString("TNT_BUTTON_ADD"), 8);
        gd = new GridData(2);
        gd.widthHint = this.buttonWidth;
        this.addButton.setLayoutData((Object)gd);
        this.addButton.addSelectionListener((SelectionListener)this);
        if (this.controller.isUnitTest()) {
            this.addButton.setEnabled(true);
        } else {
            this.addButton.setEnabled(false);
        }
        this.addButton.setToolTipText(TranMessages.getLabel().getString("TNT_BUTTON_ADD_HOVER", (Object[])new String[]{TranMessages.getLabel().getString("TNT_HOVER_ENTITY_IOMESSAGEPAIR")}));
        this.editButton = toolkit.createButton(client, TranMessages.getLabel().getString("TNT_BUTTON_EDIT"), 8);
        gd = new GridData(2);
        gd.widthHint = this.buttonWidth;
        this.editButton.setLayoutData((Object)gd);
        this.editButton.addSelectionListener((SelectionListener)this);
        this.editButton.setEnabled(false);
        this.editButton.setToolTipText(TranMessages.getLabel().getString("TNT_BUTTON_EDIT_HOVER", (Object[])new String[]{TranMessages.getLabel().getString("TNT_HOVER_ENTITY_IOMESSAGEPAIR")}));
        this.copyButton = toolkit.createButton(client, TranMessages.getLabel().getString("TNT_BUTTON_COPY"), 8);
        gd = new GridData(2);
        gd.widthHint = this.buttonWidth;
        this.copyButton.setLayoutData((Object)gd);
        this.copyButton.addSelectionListener((SelectionListener)this);
        this.copyButton.setEnabled(false);
        this.copyButton.setToolTipText(TranMessages.getLabel().getString("TNT_BUTTON_COPY_HOVER_TC"));
        this.pasteButton = toolkit.createButton(client, TranMessages.getLabel().getString("TNT_BUTTON_PASTE"), 8);
        gd = new GridData(2);
        gd.widthHint = this.buttonWidth;
        this.pasteButton.setLayoutData((Object)gd);
        this.pasteButton.addSelectionListener((SelectionListener)this);
        this.pasteButton.setEnabled(false);
        this.pasteButton.setToolTipText(TranMessages.getLabel().getString("TNT_BUTTON_PASTE_HOVER_TC"));
        this.removeButton = toolkit.createButton(client, TranMessages.getLabel().getString("TNT_BUTTON_REMOVE"), 8);
        gd = new GridData(2);
        gd.widthHint = this.buttonWidth;
        this.removeButton.setLayoutData((Object)gd);
        this.removeButton.addSelectionListener((SelectionListener)this);
        this.removeButton.setEnabled(false);
        this.removeButton.setToolTipText(TranMessages.getLabel().getString("TNT_BUTTON_REMOVE_HOVER"));
        this.moveUpButton = toolkit.createButton(client, TranMessages.getLabel().getString("TNT_BUTTON_MOVEUP"), 8);
        gd = new GridData(2);
        gd.widthHint = this.buttonWidth;
        this.moveUpButton.setLayoutData((Object)gd);
        this.moveUpButton.addSelectionListener((SelectionListener)this);
        this.moveUpButton.setEnabled(false);
        this.moveUpButton.setToolTipText(TranMessages.getLabel().getString("TNT_BUTTON_MOVEUP_HOVER", (Object[])new String[]{TranMessages.getLabel().getString("TNT_HOVER_ENTITY_IOMESSAGEPAIR")}));
        this.moveDownButton = toolkit.createButton(client, TranMessages.getLabel().getString("TNT_BUTTON_MOVEDOWN"), 8);
        gd = new GridData(2);
        gd.widthHint = this.buttonWidth;
        this.moveDownButton.setLayoutData((Object)gd);
        this.moveDownButton.addSelectionListener((SelectionListener)this);
        this.moveDownButton.setEnabled(false);
        this.moveDownButton.setToolTipText(TranMessages.getLabel().getString("TNT_BUTTON_MOVEDOWN_HOVER", (Object[])new String[]{TranMessages.getLabel().getString("TNT_HOVER_ENTITY_IOMESSAGEPAIR")}));
    }

    private void resizeColumns() {
        Rectangle area = this.composite.getClientArea();
        int width = area.width - 31 - Utility.getTextWidth((Composite)this.composite, (int)0, (String)TranMessages.getLabel().getString("TNT_BUTTON_IMPORT_FIELD_VALUES"));
        TreeColumn[] tableColumns = this.viewer.getTree().getColumns();
        int i = 0;
        while (i < tableColumns.length) {
            String colLabel = COLUMN_NAMES[i];
            if (colLabel == IOMP_NODES) {
                tableColumns[i].setWidth(width / tableColumns.length * 2);
            } else if (colLabel == DATA_TYPE) {
                tableColumns[i].setWidth(width / tableColumns.length);
            } else if (colLabel == FIELD_VALUE) {
                tableColumns[i].setWidth(width / tableColumns.length * 2);
            } else if (colLabel == START_BYTE) {
                tableColumns[i].setWidth(width / tableColumns.length);
            } else if (colLabel == FIELD_LENGTH) {
                tableColumns[i].setWidth(width / tableColumns.length);
            }
            ++i;
        }
    }

    public Composite getPage() {
        return this.composite;
    }

    private IOMessagePairNode getIompNode(TestCaseNode node) {
        TestCaseNode parent = node.getParentNode();
        while (!(parent instanceof IOMessagePairNode)) {
            parent = parent.getParentNode();
        }
        return (IOMessagePairNode)parent;
    }

    private void enableButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        this.importMsgButton.setEnabled(false);
        this.addButton.setEnabled(false);
        this.editButton.setEnabled(false);
        this.copyButton.setEnabled(false);
        this.pasteButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.moveUpButton.setEnabled(false);
        this.moveDownButton.setEnabled(false);
        if (selection.size() > 1) {
            Vector<IOMessagePairNode> removedIompParents = new Vector<IOMessagePairNode>();
            boolean canRemove = true;
            for (Object selectedNode : selection) {
                if (selectedNode instanceof IOMessagePairNode) {
                    removedIompParents.add((IOMessagePairNode)selectedNode);
                    continue;
                }
                IOMessagePairNode iompParent = this.getIompNode((TestCaseNode)selectedNode);
                if (!removedIompParents.isEmpty() && removedIompParents.contains(iompParent)) continue;
                canRemove = false;
                break;
            }
            if (canRemove) {
                this.removeButton.setEnabled(true);
            }
        } else {
            JsonFieldNode fieldNode;
            DatatypeType dataType;
            Object selectedNode;
            if (this.controller.isUnitTest()) {
                this.addButton.setEnabled(true);
            }
            if ((selectedNode = selection.getFirstElement()) instanceof IOMessagePairNode) {
                this.importMsgButton.setEnabled(true);
                this.editButton.setEnabled(true);
                this.removeButton.setEnabled(true);
                this.copyButton.setEnabled(true);
                this.copyButton.setToolTipText(TranMessages.getLabel().getString("TNT_BUTTON_COPY_IOMP_HOVER"));
                if (this.controller.canPasteInteraction()) {
                    this.pasteButton.setEnabled(true);
                    this.pasteButton.setToolTipText(TranMessages.getLabel().getString("TNT_BUTTON_PASTE_IOMP_HOVER"));
                }
                if (this.controller.canMoveUp((IOMessagePairNode)selectedNode)) {
                    this.moveUpButton.setEnabled(true);
                }
                if (this.controller.canMoveDown((IOMessagePairNode)selectedNode)) {
                    this.moveDownButton.setEnabled(true);
                }
            } else if (selectedNode instanceof SegmentNode) {
                SegmentNode segNode = (SegmentNode)selectedNode;
                IOMessageNode msgNode = (IOMessageNode)segNode.getParentNode();
                this.copyButton.setEnabled(msgNode.getType() == 0);
                this.copyButton.setToolTipText(TranMessages.getLabel().getString("TNT_BUTTON_COPY_HOVER_TC"));
                if (this.controller.canPasteFieldValues()) {
                    this.pasteButton.setEnabled(msgNode.getType() == 0);
                    this.pasteButton.setToolTipText(TranMessages.getLabel().getString("TNT_BUTTON_PASTE_HOVER_TC"));
                }
            } else if (selectedNode instanceof IOMessageNode) {
                this.addButton.setEnabled(false);
                this.editButton.setEnabled(true);
            } else if (selectedNode instanceof FieldNode) {
                FieldNode fieldNode2 = (FieldNode)selectedNode;
                DataStructureNode dsNode = (DataStructureNode)fieldNode2.getParentNode();
                SegmentNode segNode = (SegmentNode)dsNode.getParentNode();
                IOMessageNode msgNode = (IOMessageNode)segNode.getParentNode();
                int msgType = msgNode.getType();
                if (msgType == 0) {
                    DatatypeType adt = fieldNode2.getFieldType().getApplicationDatatype().getDatatype();
                    if (adt == DatatypeType.ARRAY || adt == DatatypeType.STRUCT) {
                        this.editButton.setEnabled(false);
                    } else {
                        this.editButton.setEnabled(true);
                    }
                }
            } else if (selectedNode instanceof JsonFieldNode && (dataType = (fieldNode = (JsonFieldNode)selectedNode).getInterfaceFieldType().getAssociatedFieldType().getApplicationDatatype().getDatatype()) != DatatypeType.ARRAY && dataType != DatatypeType.STRUCT) {
                this.editButton.setEnabled(true);
            }
        }
    }

    private void handleRemove() throws CoreException {
        Object[] expandedElements = this.viewer.getExpandedElements();
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        for (Object selectedNode : selection) {
            if (selectedNode instanceof IOMessagePairNode) {
                this.controller.removeMessagePair((IOMessagePairNode)selectedNode);
            }
            this.viewer.refresh();
            this.expandTree(expandedElements);
            this.editorParent.setDirty(true);
        }
    }

    private void handleAddMessagePair() throws CoreException {
        Object[] expandedElements = this.viewer.getExpandedElements();
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        TestCaseNode node = (TestCaseNode)selection.getFirstElement();
        EditMessagePairWizard editMessagePairWizard = new EditMessagePairWizard(null, this.controller);
        WizardDialog dialog = new WizardDialog(this.getPage().getShell(), (IWizard)editMessagePairWizard);
        dialog.create();
        dialog.open();
        if (node == null || node instanceof TestCaseFolderNode) {
            if (dialog.getReturnCode() == 0) {
                TestCaseNode folder = (TestCaseNode)this.tree.getItem(0).getData();
                this.controller.addMessagePair(true, folder, editMessagePairWizard.getMessagePairName(), editMessagePairWizard.getInteractionType());
                this.editorParent.setDirty(true);
            }
        } else if (dialog.getReturnCode() == 0) {
            while (!(node instanceof IOMessagePairNode)) {
                node = node.getParentNode();
            }
            IOMessagePairNode msgPairToAddAfter = (IOMessagePairNode)node;
            this.controller.addMessagePair(false, (TestCaseNode)msgPairToAddAfter, editMessagePairWizard.getMessagePairName(), editMessagePairWizard.getInteractionType());
            this.editorParent.setDirty(true);
        }
        this.viewer.refresh();
        this.expandTree(expandedElements);
    }

    public void expandTree(Object[] expandElements) {
        int i = 0;
        while (i < expandElements.length) {
            TestCaseNode currNode = (TestCaseNode)expandElements[i];
            boolean shouldExpand = true;
            for (TestCaseNode ancestorNode = currNode.getParentNode(); ancestorNode != this.controller.getInvisibleRoot(); ancestorNode = ancestorNode.getParentNode()) {
                if (ancestorNode != null) {
                    boolean isExpanded = this.viewer.getExpandedState((Object)ancestorNode);
                    if (isExpanded) continue;
                    shouldExpand = false;
                    break;
                }
                shouldExpand = false;
                break;
            }
            if (shouldExpand) {
                this.viewer.expandToLevel(expandElements[i], 1);
            }
            ++i;
        }
    }

    private void handleEdit() throws CoreException, NumberFormatException, JAXBException, UnsupportedTypeConversion, IOException, ConversionException, MessageWalkerException {
        Object[] expandedElements = this.viewer.getExpandedElements();
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        TestCaseNode node = (TestCaseNode)selection.getFirstElement();
        if (node instanceof IOMessagePairNode) {
            IOMessagePairNode msgPairNode = (IOMessagePairNode)node;
            EditMessagePairWizard editMessagePairWizard = new EditMessagePairWizard(msgPairNode, this.controller);
            WizardDialog dialog = new WizardDialog(this.getPage().getShell(), (IWizard)editMessagePairWizard);
            dialog.create();
            dialog.open();
            if (dialog.getReturnCode() == 0) {
                this.controller.editMessagePair(msgPairNode, editMessagePairWizard.getMessagePairName());
                this.expandTree(expandedElements);
                this.viewer.refresh();
                this.editorParent.setDirty(true);
            }
        } else if (node instanceof IOMessageNode) {
            this.doImport((IOMessagePairNode)node.getParentNode());
        } else if (node instanceof FieldNode) {
            FieldNode fieldNode = (FieldNode)node;
            this.editFieldValue(fieldNode);
        }
    }

    private void editFieldValue(FieldNode fieldNode) throws NumberFormatException, JAXBException, CoreException, UnsupportedTypeConversion, IOException, ConversionException {
        DatatypeType adt = fieldNode.getFieldType().getApplicationDatatype().getDatatype();
        if (adt == DatatypeType.ARRAY || adt == DatatypeType.STRUCT) {
            return;
        }
        IOMessagePairNode ioMessagePairNode = (IOMessagePairNode)fieldNode.getParentNode().getParentNode().getParentNode().getParentNode();
        String encoding = ioMessagePairNode.getMessagePair().getInteraction().getImsConnectCodepage();
        FieldValueEditorController fveController = new FieldValueEditorController(fieldNode.getFieldType(), fieldNode.getFieldValue().getFieldValue(), encoding);
        EditFieldDialog dialog = new EditFieldDialog(this.getPage().getShell(), TranMessages.getLabel().getString("EFVD_DIALOG_TITLE", (Object[])new String[]{fieldNode.getName()}), fveController);
        dialog.open();
        int rc = dialog.getReturnCode();
        if (rc == 0) {
            Object[] expandedElements = this.viewer.getExpandedElements();
            this.controller.editFieldValue(fieldNode, fveController.getNewFieldValue());
            this.viewer.refresh();
            this.expandTree(expandedElements);
            this.editorParent.setDirty(true);
            TestCaseNode tcNode = fieldNode.getParentNode();
            List peerNodes = tcNode.getChildren();
            int i = 0;
            while (i < peerNodes.size()) {
                TestCaseNode currNode = (TestCaseNode)peerNodes.get(i);
                if (currNode == fieldNode && i < peerNodes.size() - 1) {
                    this.viewer.setSelection((ISelection)new StructuredSelection(peerNodes.get(i + 1)), true);
                    break;
                }
                ++i;
            }
        }
    }

    private void handleMoveUp() throws CoreException {
        Object[] expandedElements = this.viewer.getExpandedElements();
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Object selectedNode = selection.getFirstElement();
        if (selectedNode instanceof IOMessagePairNode) {
            this.controller.moveUpMessagePair((IOMessagePairNode)selectedNode);
            this.viewer.refresh();
            this.expandTree(expandedElements);
            this.editorParent.setDirty(true);
        }
    }

    private void handleMoveDown() throws CoreException {
        Object[] expandedElements = this.viewer.getExpandedElements();
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Object selectedNode = selection.getFirstElement();
        if (selectedNode instanceof IOMessagePairNode) {
            this.controller.moveDownMessagePair((IOMessagePairNode)selectedNode);
            this.viewer.refresh();
            this.expandTree(expandedElements);
            this.editorParent.setDirty(true);
        }
    }

    private void handleCopyFieldValues() throws UnsupportedTypeConversion, IOException, ConversionException {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Object selectedNode = selection.getFirstElement();
        if (selectedNode instanceof SegmentNode) {
            this.controller.copyFieldValues((SegmentNode)selectedNode);
        }
    }

    private void handleCopyInteraction() throws UnsupportedTypeConversion, IOException, ConversionException {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Object selectedNode = selection.getFirstElement();
        if (selectedNode instanceof IOMessagePairNode) {
            this.controller.copyInteraction((IOMessagePairNode)selectedNode);
        }
    }

    private void handlePasteFieldValues() throws NumberFormatException, JAXBException, CoreException, UnsupportedTypeConversion, IOException, ConversionException {
        Object[] expandedElements = this.viewer.getExpandedElements();
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Object selectedNode = selection.getFirstElement();
        if (selectedNode instanceof SegmentNode) {
            this.controller.pasteFieldValues((SegmentNode)selectedNode);
            this.viewer.refresh();
            this.expandTree(expandedElements);
            this.editorParent.setDirty(true);
        }
    }

    private void handlePasteInteraction() throws NumberFormatException, JAXBException, CoreException, UnsupportedTypeConversion, IOException, ConversionException {
        Object[] expandedElements = this.viewer.getExpandedElements();
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Object selectedNode = selection.getFirstElement();
        if (selectedNode instanceof IOMessagePairNode) {
            this.controller.pasteInteraction((IOMessagePairNode)selectedNode);
            this.viewer.refresh();
            this.expandTree(expandedElements);
            this.editorParent.setDirty(true);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        try {
            if (e.widget == this.importMsgButton) {
                this.handleImportMessages();
            } else if (e.widget == this.addButton) {
                this.handleAddMessagePair();
            } else if (e.widget == this.editButton) {
                this.handleEdit();
            } else if (e.widget == this.copyButton) {
                IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
                Object selectedNode = selection.getFirstElement();
                if (selectedNode instanceof IOMessagePairNode) {
                    this.handleCopyInteraction();
                } else {
                    this.handleCopyFieldValues();
                }
            } else if (e.widget == this.pasteButton) {
                IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
                Object selectedNode = selection.getFirstElement();
                if (selectedNode instanceof IOMessagePairNode) {
                    this.handlePasteInteraction();
                } else {
                    this.handlePasteFieldValues();
                }
            } else if (e.widget == this.removeButton) {
                this.handleRemove();
            } else if (e.widget == this.moveUpButton) {
                this.handleMoveUp();
            } else if (e.widget == this.moveDownButton) {
                this.handleMoveDown();
            }
            this.enableButtons();
        }
        catch (Throwable ex) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "widgetSelected()", ex);
            logger.error(ex);
        }
    }

    private void handleImportPayload() throws CoreException, IOException, UnsupportedTypeConversion, ConversionException, JAXBException, ImporterException {
        File file;
        FileDialog dialog = new FileDialog(new Shell(), 4096);
        dialog.setText(TranMessages.getLabel().getString("TNT_BUTTON_IMPORT_FIELD_VALUES"));
        String selectedFile = dialog.open();
        if (selectedFile != null && !selectedFile.isEmpty() && (file = new File(selectedFile)).exists() && file.isFile()) {
            byte[] payload = ProjectTreeFileHelper.importFileToByteArray((File)file);
            IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
            Object selectedNode = selection.getFirstElement();
            if (selectedNode instanceof SegmentNode) {
                SegmentNode segNode = (SegmentNode)selectedNode;
                this.controller.importSegmentPayload(segNode, payload);
                this.viewer.refresh();
                this.editorParent.setDirty(true);
            }
        }
    }

    private void doImport(IOMessagePairNode ioMessagePairNode) throws JAXBException, CoreException, UnsupportedTypeConversion, IOException, ConversionException {
        Object[] expandedElements = this.viewer.getExpandedElements();
        String projectName = this.controller.getProjectName();
        IoMessagePairType ioMessagePair = ioMessagePairNode.getMessagePair();
        BigInteger currentTranId = ioMessagePair.getTranId();
        BigInteger currentInputMsgId = ioMessagePair.getInputMessageId();
        BigInteger currentOutputMsgId = ioMessagePair.getOutputMessageId();
        ImportTranMessageWizard importTranMessageWizard = new ImportTranMessageWizard(ioMessagePairNode, projectName);
        WizardDialog dialog = new WizardDialog(this.getPage().getShell(), (IWizard)importTranMessageWizard);
        dialog.create();
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            BigInteger newTranId = importTranMessageWizard.getTranId();
            BigInteger newInputMsgId = importTranMessageWizard.getInputMessageId();
            BigInteger newOutputMsgId = importTranMessageWizard.getOutputMessageId();
            boolean inputChanged = false;
            boolean outputChanged = false;
            boolean tranChanged = false;
            if (!newTranId.equals(currentTranId)) {
                inputChanged = true;
                outputChanged = true;
                tranChanged = true;
            } else {
                if (currentInputMsgId == null && newInputMsgId != null || currentInputMsgId != null && newInputMsgId != null && !newInputMsgId.equals(currentInputMsgId)) {
                    inputChanged = true;
                }
                if (currentOutputMsgId == null && newOutputMsgId != null || currentOutputMsgId != null && newOutputMsgId != null && !newOutputMsgId.equals(currentOutputMsgId)) {
                    outputChanged = true;
                }
            }
            boolean okToMakeChange = true;
            if (currentTranId != null && inputChanged && currentInputMsgId != null) {
                okToMakeChange = MessageDialog.openConfirm((Shell)this.editorParent.getSite().getShell(), (String)TranMessages.getError().getString("ITMW_ERR_CONFIRMATION"), (String)TranMessages.getError().getString("ITMW_ERR_LOSE_FIELD_VALUE"));
            }
            if (okToMakeChange) {
                if (tranChanged) {
                    ioMessagePair.setTranId(newTranId);
                    ioMessagePairNode.setTran(TrantocMapManager.getTransaction((String)projectName, (BigInteger)newTranId));
                }
                if (inputChanged) {
                    ioMessagePair.setInputMessageId(newInputMsgId);
                    ioMessagePairNode.setInputMessageNode(null);
                }
                if (outputChanged) {
                    ioMessagePair.setOutputMessageId(newOutputMsgId);
                    ioMessagePairNode.setCurrentActiveOutputMsg(null);
                    ioMessagePairNode.setOutputMessageNode(null);
                }
                this.controller.populateIoMessageNodes(ioMessagePairNode);
                this.viewer.refresh();
                this.expandTree(expandedElements);
                this.editorParent.setDirty(true);
            }
        }
    }

    private void handleImportMessages() throws CoreException, JAXBException, UnsupportedTypeConversion, IOException, ConversionException {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Object selectedNode = selection.getFirstElement();
        if (selectedNode instanceof IOMessagePairNode) {
            IOMessagePairNode ioMessagePairNode = (IOMessagePairNode)selectedNode;
            this.doImport(ioMessagePairNode);
        }
    }

    public TestcaseEditorController getController() {
        return this.controller;
    }

    public String getProjectName() {
        return this.editorParent.getProjectName();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void keyPressed(KeyEvent event) {
    }

    public void keyReleased(KeyEvent event) {
        try {
            Object sourceObj;
            int kc = event.keyCode;
            if (kc == 13 && (sourceObj = event.getSource()) == this.tree) {
                IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
                TestCaseNode node = (TestCaseNode)selection.getFirstElement();
                if (node instanceof IOMessagePairNode) {
                    IOMessagePairNode msgPairNode = (IOMessagePairNode)node;
                    EditMessagePairWizard editMessagePairWizard = new EditMessagePairWizard(msgPairNode, this.controller);
                    WizardDialog dialog = new WizardDialog(this.getPage().getShell(), (IWizard)editMessagePairWizard);
                    dialog.create();
                    dialog.open();
                    if (dialog.getReturnCode() == 0) {
                        Object[] expandedElements = this.viewer.getExpandedElements();
                        this.controller.editMessagePair(msgPairNode, editMessagePairWizard.getMessagePairName());
                        this.expandTree(expandedElements);
                        this.viewer.refresh();
                        this.editorParent.setDirty(true);
                    }
                } else if (node instanceof FieldNode) {
                    FieldNode fieldNode = (FieldNode)node;
                    DatatypeType dataType = fieldNode.getFieldType().getApplicationDatatype().getDatatype();
                    if (dataType == DatatypeType.ARRAY || dataType == DatatypeType.STRUCT) {
                        Object[] inserts = new Object[]{dataType.toString()};
                        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)TranMessages.getLabel().getString("IDSW_ERR"), (String)TranMessages.getError().getString("TCMLE_INVALID_FIELD_FOR_EDIT", inserts));
                    } else {
                        DataStructureNode dsNode = (DataStructureNode)fieldNode.getParentNode();
                        SegmentNode segNode = (SegmentNode)dsNode.getParentNode();
                        IOMessageNode msgNode = (IOMessageNode)segNode.getParentNode();
                        int msgType = msgNode.getType();
                        if (msgType == 0) {
                            this.editFieldValue(fieldNode);
                        }
                    }
                }
            }
        }
        catch (Throwable ex) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "widgetSelected()", ex);
            logger.error(ex);
        }
    }

    public void mouseDoubleClick(MouseEvent event) {
        try {
            Object sourceObj = event.getSource();
            if (sourceObj == this.tree) {
                IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
                TestCaseNode node = (TestCaseNode)selection.getFirstElement();
                if (node instanceof IOMessagePairNode) {
                    IOMessagePairNode msgPairNode = (IOMessagePairNode)node;
                    EditMessagePairWizard editMessagePairWizard = new EditMessagePairWizard(msgPairNode, this.controller);
                    WizardDialog dialog = new WizardDialog(this.getPage().getShell(), (IWizard)editMessagePairWizard);
                    dialog.create();
                    dialog.open();
                    if (dialog.getReturnCode() == 0) {
                        Object[] expandedElements = this.viewer.getExpandedElements();
                        this.controller.editMessagePair(msgPairNode, editMessagePairWizard.getMessagePairName());
                        this.expandTree(expandedElements);
                        this.viewer.refresh();
                        this.editorParent.setDirty(true);
                    }
                } else if (node instanceof FieldNode) {
                    FieldNode fieldNode = (FieldNode)node;
                    DatatypeType dataType = fieldNode.getFieldType().getApplicationDatatype().getDatatype();
                    if (dataType == DatatypeType.ARRAY || dataType == DatatypeType.STRUCT) {
                        Object[] inserts = new Object[]{dataType.toString()};
                        MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)TranMessages.getLabel().getString("IDSW_ERR"), (String)TranMessages.getError().getString("TCMLE_INVALID_FIELD_FOR_EDIT", inserts));
                    } else {
                        DataStructureNode dsNode = (DataStructureNode)fieldNode.getParentNode();
                        SegmentNode segNode = (SegmentNode)dsNode.getParentNode();
                        IOMessageNode msgNode = (IOMessageNode)segNode.getParentNode();
                        int msgType = msgNode.getType();
                        if (msgType == 0) {
                            this.editFieldValue(fieldNode);
                        }
                    }
                }
            }
        }
        catch (Throwable ex) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "widgetSelected()", ex);
            logger.error(ex);
        }
    }

    public void mouseDown(MouseEvent arg0) {
    }

    public void mouseUp(MouseEvent arg0) {
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    private class FieldModelMouseTrackListener
    extends MouseTrackAdapter
    implements MouseMoveListener {
        private Tree tree;

        public FieldModelMouseTrackListener(Tree tree) {
            this.tree = tree;
        }

        public void mouseMove(MouseEvent me) {
            TreeItem item = this.tree.getItem(new Point(me.x, me.y));
            if (item != null && item.getData() instanceof JsonFieldNode && ((JsonFieldNode)item.getData()).getInterfaceFieldType().getAssociatedFieldType() != null) {
                String fullPathString = ((JsonFieldNode)item.getData()).getFullPathString();
                this.tree.setToolTipText(fullPathString);
            } else {
                this.tree.setToolTipText(null);
            }
        }
    }
}

