/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.transaction.editors;

import com.ibm.im.ims.transaction.controller.datastructure.DataStructureSegmentAssociation;
import com.ibm.im.ims.transaction.controller.editor.TranEditorController;
import com.ibm.im.ims.workbench.transaction.messages.TranModelMessages;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RenameDsDialog
extends TitleAreaDialog
implements ModifyListener,
SelectionListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Text dsNameText;
    private Button okButton;
    private TranEditorController controller;
    private Vector<String> existingDsNames;
    private String collidedName;
    private String newDsName;
    private DataStructureSegmentAssociation dssa;
    private static final Color COLOR_RED = Display.getDefault().getSystemColor(3);

    public RenameDsDialog(Shell parentShell, String collidedName, Vector<String> existingDsNames, TranEditorController controller, DataStructureSegmentAssociation dssa) {
        super(parentShell);
        this.controller = controller;
        this.collidedName = collidedName;
        this.existingDsNames = existingDsNames;
        this.dssa = dssa;
    }

    public void create() {
        super.create();
        String shellTitle = TranModelMessages.getLabel().getString("RND_SHELL_MSG");
        String dialogMessage = TranModelMessages.getLabel().getString("RND_DESC_MSG");
        this.getShell().setText(shellTitle);
        this.setTitle(TranModelMessages.getLabel().getString("RND_TITLE_MSG"));
        this.setMessage(dialogMessage);
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new FormLayout());
        container.setLayoutData((Object)new GridData(1808));
        Composite composite = new Composite(container, 0);
        composite.setLayout((Layout)new GridLayout(3, false));
        FormData fd_composite = new FormData();
        fd_composite.bottom = new FormAttachment(100);
        fd_composite.right = new FormAttachment(100);
        fd_composite.top = new FormAttachment(0);
        fd_composite.left = new FormAttachment(0);
        composite.setLayoutData((Object)fd_composite);
        Label reqNameLabel = new Label(composite, 0);
        reqNameLabel.setText("*");
        reqNameLabel.setForeground(COLOR_RED);
        Label lblNewLabel = new Label(composite, 0);
        lblNewLabel.setText(TranModelMessages.getLabel().getString("GCW_CONNECTION_NAME") + TranModelMessages.getColon().getString("COLON"));
        this.dsNameText = new Text(composite, 2048);
        this.dsNameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.newDsName = this.getInitialName();
        this.dsNameText.setText(this.newDsName);
        this.dsNameText.setEnabled(true);
        this.addListeners();
        return area;
    }

    private String getInitialName() {
        String startName = TranModelMessages.getLabel().getString("RND_COPY") + this.collidedName;
        int i = 2;
        String name = startName;
        while (this.nameCollision(name)) {
            name = startName + i;
            ++i;
        }
        return name;
    }

    private void addListeners() {
        this.dsNameText.addModifyListener((ModifyListener)this);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.okButton.addSelectionListener((SelectionListener)this);
        this.getButton(0).setEnabled(true);
    }

    protected Point getInitialSize() {
        return new Point(459, 200);
    }

    private boolean nameCollision(String name) {
        boolean retVal = false;
        Iterator<String> iter = this.existingDsNames.iterator();
        while (iter.hasNext()) {
            if (!name.equalsIgnoreCase(iter.next())) continue;
            retVal = true;
            break;
        }
        return retVal;
    }

    public void modifyText(ModifyEvent event) {
        boolean canFinish = false;
        if (event.widget == this.dsNameText) {
            String newName = this.dsNameText.getText();
            if (newName.isEmpty()) {
                this.setErrorMessage(TranModelMessages.getError().getString("RCN_MISSING_NAME"));
            } else if (this.nameCollision(newName)) {
                Object[] inserts = new String[]{newName};
                this.setErrorMessage(TranModelMessages.getError().getString("RCN_COLLIDED_NAME", inserts));
            } else {
                canFinish = true;
                this.newDsName = newName;
                this.setErrorMessage(null);
            }
        }
        this.getButton(0).setEnabled(canFinish);
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.widget == this.okButton) {
            if (this.dssa == null) {
                this.controller.setCopiedFieldName(this.newDsName);
            } else {
                this.dssa.dataStructure.setName(this.newDsName);
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }
}

