/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.transaction.editors;

import com.ibm.im.ims.metadata.testcase.IoMessagePairType;
import com.ibm.im.ims.metadata.testcase.Testcase;
import com.ibm.im.ims.metadata.transaction.Transaction;
import com.ibm.im.ims.transaction.controller.editor.TestcaseEditorController;
import com.ibm.im.ims.transaction.controller.editor.TranEditorController;
import com.ibm.im.ims.transaction.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.workbench.transaction.editors.TestcaseEditorPage;
import com.ibm.im.ims.workbench.transaction.editors.TransactionEditorPage;
import com.ibm.im.ims.workbench.transaction.messages.TranModelMessages;
import com.ibm.im.ims.workbench.transaction.model.TranDataStructuresFolder;
import com.ibm.im.ims.workbench.transaction.model.TranTreeObject;
import com.ibm.im.ims.workbench.transaction.resources.utilities.TranMessages;
import com.ibm.im.ims.workbench.transaction.utilities.UIHelper;
import com.ibm.im.ims.workbench.transaction.wizard.newtestcase.NewTestCaseWizard;
import com.ibm.im.ims.workbench.transaction.wizard.runtimeconsole.RuntimeConsoleManager;
import com.ibm.ims.dli.types.ConversionException;
import com.ibm.ims.dli.types.UnsupportedTypeConversion;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import com.ibm.ims.transaction.messages.walkers.MessageWalkerException;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.MultiPageEditorPart;

public class MultiPageEditor
extends MultiPageEditorPart {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    public boolean isAtmtestCaseName = false;
    String tcName;
    private boolean isDirty = false;
    private String projectName;
    private String serverName;
    private String tranName;
    private String testcaseName;
    private TestcaseEditorPage testcaseEditor;
    private TransactionEditorPage tranEditor;
    private ResourceTracker resourceTracker;

    void addPages() throws JAXBException, CoreException, MessageWalkerException, UnsupportedTypeConversion, IOException, ConversionException {
        FileEditorInput fileInput = (FileEditorInput)this.getEditorInput();
        String fileName = fileInput.getName();
        if (fileName.indexOf(".trn") > 0) {
            this.tranName = fileName.substring(0, fileName.indexOf(".trn"));
            IFile file = fileInput.getFile();
            IPath path = file.getFullPath();
            this.projectName = path.segments()[0];
            if (path.segments().length > 2 && path.segment(1).equals("Server Transactions")) {
                this.serverName = path.segment(2);
            }
            Transaction tran = ProjectTreeFileHelper.unmarshallTran((String)this.projectName, (String)this.serverName, (String)this.tranName);
            TranEditorController tranCtrl = null;
            tranCtrl = this.serverName != null ? new TranEditorController(tran, this.projectName, this.serverName) : new TranEditorController(tran, this.projectName);
            this.tranEditor = new TransactionEditorPage(this, this.getContainer(), tranCtrl);
            this.addPage((Control)this.tranEditor.getPage());
            this.setPartName(fileName);
            this.setPageText(0, TranMessages.getLabel().getString("TMME_PAGE_NAME"));
            List dsFolders = tranCtrl.findFirstDsFolderNodes();
            if (!dsFolders.isEmpty()) {
                TranDataStructuresFolder dsFolder = (TranDataStructuresFolder)dsFolders.get(0);
                TranTreeObject[] children = dsFolder.getChildren();
                if (children == null || children.length == 0) {
                    this.tranEditor.getViewer().setSelection((ISelection)new StructuredSelection((Object)dsFolder), true);
                }
                for (TranDataStructuresFolder expandFolder : dsFolders) {
                    this.tranEditor.getViewer().expandToLevel((Object)expandFolder, 1);
                }
            }
        } else if (fileName.indexOf(".ttc") > 0) {
            IFile file = fileInput.getFile();
            IPath path = file.getFullPath();
            this.projectName = path.segments()[0];
            this.testcaseName = fileName.substring(0, fileName.indexOf(".ttc"));
            Testcase testcase = ProjectTreeFileHelper.unmarshallTestcase((String)this.projectName, (String)this.testcaseName);
            TestcaseEditorController testcaseCtrl = new TestcaseEditorController(this.projectName, testcase, null);
            testcaseCtrl.setTestcaseFilename(this.testcaseName);
            this.testcaseEditor = new TestcaseEditorPage(this, this.getContainer(), testcaseCtrl);
            this.setPartName(fileName);
            this.addPage((Control)this.testcaseEditor.getPage());
            this.setPageText(0, TranMessages.getLabel().getString("TCMFLE_PAGE_NAME"));
        }
    }

    public void transactionFileChanged(int tranId) throws JAXBException, CoreException, UnsupportedTypeConversion, IOException, ConversionException {
        TestcaseEditorController tcEditorController;
        boolean needToRefreshEditor = false;
        if (this.testcaseEditor != null && (tcEditorController = this.testcaseEditor.getController()).isUnitTest()) {
            List iomps = tcEditorController.getTestCase().getIoMessagePair();
            for (IoMessagePairType ioMessagePairType : iomps) {
                BigInteger tranIdBigInt = ioMessagePairType.getTranId();
                if (tranIdBigInt == null || tranIdBigInt.intValue() != tranId) continue;
                needToRefreshEditor = true;
                break;
            }
        }
        if (needToRefreshEditor) {
            this.testcaseEditor.refreshEditor();
        }
    }

    public String getTestCaseFileName() {
        String retVal = null;
        if (this.testcaseEditor != null) {
            retVal = this.testcaseEditor.getController().getTestcaseFilename();
        }
        return retVal;
    }

    public void refreshTestcaseEditor() throws JAXBException, CoreException, UnsupportedTypeConversion, IOException, ConversionException {
        this.testcaseEditor.refreshEditor();
    }

    protected void createPages() {
        try {
            this.addPages();
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "", e);
            logger.error(e);
        }
    }

    public void setDirty(boolean dirty) {
        if (this.isDirty != dirty) {
            this.isDirty = dirty;
            this.firePropertyChange(257);
        }
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    protected void firePropertyChange(int propertyId) {
        super.firePropertyChange(propertyId);
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            if (this.tranEditor != null) {
                this.tranEditor.getController().doSave(this.projectName, ((IFileEditorInput)this.getEditorInput()).getFile());
            } else {
                this.testcaseEditor.getController().doSave(this.projectName);
                RuntimeConsoleManager rcManager = RuntimeConsoleManager.getSingletonInstance();
                rcManager.markUpdated(this.projectName, this.testcaseName);
            }
            this.setDirty(false);
        }
        catch (Throwable e) {
            logger.error(e);
            UIHelper.displayErrorDialog(this.getSite().getShell(), TranModelMessages.getError().getString("TME_SAVE_TRAN_FAILED"), e);
        }
    }

    public void doSaveAs() {
        try {
            if (this.testcaseEditor != null) {
                this.testcaseEditor.getController().updateJaxbFromMessagePayloadManager();
                Testcase existingTcForDup = this.testcaseEditor.getController().getTestCase();
                NewTestCaseWizard newTcWiz = new NewTestCaseWizard();
                newTcWiz.setProjectName(this.projectName);
                newTcWiz.setExistingTCForDup(existingTcForDup);
                newTcWiz.setExistingTCForDupName(this.testcaseName);
                IWorkbench workbench = PlatformUI.getWorkbench();
                IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
                WizardDialog dialog = new WizardDialog(workbenchWindow.getShell(), (IWizard)newTcWiz);
                int retCode = dialog.open();
                if (retCode == 0) {
                    this.setDirty(false);
                    IFile newDupTcFile = newTcWiz.getNewDupFile();
                    ProjectTreeFileHelper.launchTranEditor((IFile)newDupTcFile);
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeEditor((IEditorPart)this, false);
                }
            }
        }
        catch (Throwable e) {
            logger.error(e);
        }
    }

    public void gotoMarker(IMarker marker) {
        this.setActivePage(0);
        IDE.gotoMarker((IEditorPart)this.getEditor(0), (IMarker)marker);
    }

    public void init(IEditorSite site, IEditorInput editorInput) throws PartInitException {
        if (!(editorInput instanceof IFileEditorInput)) {
            throw new PartInitException(TranModelMessages.getError().getString("INVALIDINPUT_FILEEDITOR"));
        }
        super.init(site, editorInput);
    }

    public boolean isSaveAsAllowed() {
        boolean retVal = false;
        if (this.testcaseEditor != null) {
            retVal = true;
        }
        return retVal;
    }

    public String getProjectName() {
        return this.projectName;
    }

    private void closeEditor(final boolean save) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                MultiPageEditor.this.getSite().getPage().closeEditor((IEditorPart)MultiPageEditor.this, save);
            }
        });
    }

    private ResourceTracker getResourceTracker() {
        if (this.resourceTracker == null) {
            this.resourceTracker = new ResourceTracker();
        }
        return this.resourceTracker;
    }

    protected void setInput(IEditorInput input) {
        IFile file;
        if (this.getEditorInput() != null) {
            file = ((FileEditorInput)this.getEditorInput()).getFile();
            file.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.getResourceTracker());
        }
        super.setInput(input);
        if (this.getEditorInput() != null) {
            file = ((FileEditorInput)this.getEditorInput()).getFile();
            file.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.getResourceTracker());
            this.setPartName(file.getName());
        }
    }

    public void dispose() {
        super.dispose();
        IFile file = ((FileEditorInput)this.getEditorInput()).getFile();
        if (file != null) {
            file.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this.getResourceTracker());
        }
        this.resourceTracker = null;
    }

    private class ResourceTracker
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        private ResourceTracker() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            IResourceDelta delta = event.getDelta();
            try {
                if (delta != null) {
                    delta.accept((IResourceDeltaVisitor)this);
                }
            }
            catch (CoreException e) {
                logger.error((Throwable)e);
            }
        }

        public boolean visit(IResourceDelta delta) {
            if (delta == null || !delta.getResource().equals((Object)((IFileEditorInput)MultiPageEditor.this.getEditorInput()).getFile())) {
                return true;
            }
            if (delta.getKind() == 2) {
                if ((0x2000 & delta.getFlags()) == 0) {
                    MultiPageEditor.this.closeEditor(false);
                } else {
                    final IFile newFile = ResourcesPlugin.getWorkspace().getRoot().getFile(delta.getMovedToPath());
                    Display display = MultiPageEditor.this.getSite().getShell().getDisplay();
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            MultiPageEditor.this.setInput((IEditorInput)new FileEditorInput(newFile));
                        }
                    });
                }
            }
            return false;
        }
    }
}

