/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.transaction.dialog.editfield;

import com.ibm.im.ims.transaction.controller.editor.FieldValueEditorController;
import com.ibm.im.ims.workbench.transaction.Activator;
import com.ibm.im.ims.workbench.transaction.common.ui.EAMessageControl;
import com.ibm.im.ims.workbench.transaction.resources.utilities.TranMessages;
import com.ibm.im.ims.workbench.transaction.utilities.TextFocusHightlightListener;
import com.ibm.im.ims.workbench.transaction.utilities.UIHelper;
import com.ibm.im.ims.workbench.transaction.utilities.Utility;
import com.ibm.ims.dli.types.ConversionException;
import com.ibm.ims.dli.types.UnsupportedTypeConversion;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.io.IOException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class EditFieldDialog
extends Dialog
implements SelectionListener,
VerifyListener,
ModifyListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private String searchDialogTitle;
    private static final int margin = 10;
    private UIHelper uih;
    private Text fieldDataTypeText;
    private Text fieldValueText;
    private Combo fieldValueTypeCombo;
    private FieldValueEditorController fveController;
    private boolean isHex;
    private boolean isHexOrig;
    private static final String STORED_WIDTH = "com.ibm.im.ims.workbench.transaction.dialog.editfield.STORED_WIDTH";
    private static final String STORED_HEIGHT = "com.ibm.im.ims.workbench.transaction.dialog.editfield.STORED_HEIGHT";
    private static final String HEXADECIMAL = "X (HEXADECIMAL)";
    private static final String CHARACTER = "C (CHARACTER)";
    private static final String[] valueTypes = new String[]{"X (HEXADECIMAL)", "C (CHARACTER)"};
    private EAMessageControl msgControl = new EAMessageControl();

    public EditFieldDialog(Shell parentShell, String searchDialogTitle, FieldValueEditorController fveController) {
        super(parentShell);
        this.searchDialogTitle = searchDialogTitle;
        this.setShellStyle(67632);
        this.fveController = fveController;
        this.uih = new UIHelper();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.searchDialogTitle);
        int minimumWidth = Utility.getTextWidth((Composite)shell, 0, this.searchDialogTitle) * 2;
        int minimumHeight = minimumWidth * 2 / 3;
        shell.setMinimumSize(minimumWidth, minimumHeight);
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        int width = store.getInt(STORED_WIDTH);
        int height = store.getInt(STORED_HEIGHT);
        if (width < minimumWidth || height < minimumHeight) {
            width = minimumWidth;
            height = minimumHeight;
        }
        shell.setSize(width, height);
        Display display = PlatformUI.getWorkbench().getDisplay();
        Rectangle screen = display.getMonitors()[0].getBounds();
        shell.setLocation((screen.width - width) / 2, (screen.height - height) / 2);
    }

    protected Control createDialogArea(Composite dialogParent) {
        Composite parent = (Composite)super.createDialogArea(dialogParent);
        GridData gd = new GridData(4, 4, true, true, 1, 1);
        parent.setLayoutData((Object)gd);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 10;
        parent.setLayout((Layout)formLayout);
        Display display = parent.getDisplay();
        this.uih.setDisplay(display);
        int[] labelSizes = new int[]{Utility.getTextWidth(parent, 0, TranMessages.getLabel().getString("TCMLE_COLNAME_DATATYPE")), Utility.getTextWidth(parent, 0, TranMessages.getLabel().getString("TCMLE_COLNAME_FIELDVALUE"))};
        int colonWidth = Utility.getTextWidth(parent, 0, TranMessages.getColon().getString("COLON"));
        int labelWidth = Utility.getMaxSize(labelSizes) + colonWidth + 10;
        FormData fd = this.uih.genFormData(new FormAttachment(0, 10), null, new FormAttachment(0, 10), null);
        Label fieldDataTypeLabel = new Label(parent, 64);
        fieldDataTypeLabel.setText(TranMessages.getLabel().getString("TCMLE_COLNAME_DATATYPE") + TranMessages.getColon().getString("COLON"));
        fieldDataTypeLabel.setLayoutData((Object)fd);
        fd = this.uih.genFormData(new FormAttachment(0, 10), null, new FormAttachment(0, labelWidth), new FormAttachment(100, -10));
        this.fieldDataTypeText = new Text(parent, 2124);
        this.fieldDataTypeText.setLayoutData((Object)fd);
        this.fieldDataTypeText.setText(this.fveController.getDataType());
        fd = this.uih.genFormData(new FormAttachment((Control)fieldDataTypeLabel, 10), null, new FormAttachment(0, 10), null);
        Label fieldValueTypeLabel = new Label(parent, 0);
        fieldValueTypeLabel.setText("Value type");
        fieldValueTypeLabel.setLayoutData((Object)fd);
        fd = this.uih.genFormData(new FormAttachment((Control)fieldDataTypeLabel, 10), null, new FormAttachment(0, labelWidth), new FormAttachment(100, -10));
        this.fieldValueTypeCombo = new Combo(parent, 2056);
        this.fieldValueTypeCombo.setItems(valueTypes);
        this.isHexOrig = this.fveController.getIsHex();
        if (this.isHexOrig) {
            this.fieldValueTypeCombo.setText(HEXADECIMAL);
        } else {
            this.fieldValueTypeCombo.setText(CHARACTER);
        }
        this.fieldValueTypeCombo.setLayoutData((Object)fd);
        fd = this.uih.genFormData(new FormAttachment((Control)fieldValueTypeLabel, 10), null, new FormAttachment(0, 10), null);
        Label fieldValueLabel = new Label(parent, 64);
        fieldValueLabel.setText(TranMessages.getLabel().getString("TCMLE_COLNAME_FIELDVALUE") + TranMessages.getColon().getString("COLON"));
        fieldValueLabel.setLayoutData((Object)fd);
        fd = this.uih.genFormData(new FormAttachment((Control)fieldValueTypeLabel, 10), null, new FormAttachment(0, labelWidth), new FormAttachment(100, -10));
        this.fieldValueText = new Text(parent, 2116);
        this.fieldValueText.setLayoutData((Object)fd);
        String origValue = this.fveController.getOrigFieldValue();
        if (origValue == null) {
            origValue = "";
        }
        this.fieldValueText.setText(origValue);
        this.fieldValueText.forceFocus();
        this.fieldValueText.addModifyListener((ModifyListener)this);
        this.fieldValueText.addFocusListener((FocusListener)new TextFocusHightlightListener());
        this.msgControl.addControl((Control)this.fieldValueText);
        this.addListeners();
        return parent;
    }

    public boolean close() {
        this.msgControl.removeControl((Control)this.fieldValueText);
        this.fieldValueText.dispose();
        this.fieldDataTypeText.dispose();
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        Point size = this.getShell().getSize();
        store.setValue(STORED_WIDTH, size.x);
        store.setValue(STORED_HEIGHT, size.y);
        return super.close();
    }

    protected void okPressed() {
        try {
            String newValue = this.fieldValueText.getText();
            String origValue = this.fveController.getOrigFieldValue();
            if (origValue != null && origValue.equals(newValue) && this.isHexOrig == this.isHex) {
                super.cancelPressed();
            } else {
                this.fveController.setNewFieldValue(newValue);
                this.fveController.setIsHex(this.isHex);
                super.okPressed();
            }
        }
        catch (Throwable t) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "okPressed()", t);
            logger.error(t);
        }
    }

    private void addListeners() {
        this.fieldValueTypeCombo.addSelectionListener((SelectionListener)this);
        this.fieldValueText.addModifyListener((ModifyListener)this);
        this.fieldValueText.addVerifyListener((VerifyListener)this);
    }

    public void removeListeners() {
        this.fieldValueTypeCombo.removeSelectionListener((SelectionListener)this);
        this.fieldValueText.removeModifyListener((ModifyListener)this);
        this.fieldValueText.removeVerifyListener((VerifyListener)this);
    }

    public void modifyText(ModifyEvent arg0) {
        this.validatePage();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        try {
            if (e.widget == this.fieldValueTypeCombo) {
                if (this.fieldValueTypeCombo.getText().equals(CHARACTER)) {
                    this.isHex = false;
                } else {
                    this.isHex = true;
                    this.fieldValueText.setText(this.fieldValueText.getText().toUpperCase());
                }
                this.validatePage();
            }
        }
        catch (Throwable err) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "widgetSelected(SelectionEvent e)", err);
            logger.error(err);
        }
    }

    public void verifyText(VerifyEvent e) {
        try {
            if (e.widget == this.fieldValueText && this.isHex && e.character >= 'a' && e.character <= 'z') {
                String upperCaseChar;
                e.text = upperCaseChar = e.text.toUpperCase();
            }
        }
        catch (Throwable err) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "verifyText(VerifyEvent e)", err);
            logger.error(err);
        }
    }

    private void validatePage() {
        this.msgControl.clearValidationMessage((Control)this.fieldValueText);
        String errorMessage = null;
        String fieldValue = this.fieldValueText.getText();
        try {
            if (this.isHex) {
                this.fveController.validateFieldValueHex(fieldValue);
            } else {
                this.fveController.validateFieldValue(fieldValue);
            }
        }
        catch (UnsupportedTypeConversion unsupportedTypeConversion) {
            errorMessage = TranMessages.getError().getString("TCMLE_INVALID_FIELD_VALUE", (Object[])new String[]{fieldValue, this.fveController.getDataType(), this.fveController.getFieldName()});
            this.msgControl.setValidationMessage((Control)this.fieldValueText, errorMessage, 1);
        }
        catch (ConversionException conversionException) {
            errorMessage = TranMessages.getError().getString("TCMLE_INVALID_FIELD_VALUE", (Object[])new String[]{fieldValue, this.fveController.getDataType(), this.fveController.getFieldName()});
            this.msgControl.setValidationMessage((Control)this.fieldValueText, errorMessage, 1);
        }
        catch (NumberFormatException numberFormatException) {
            errorMessage = TranMessages.getError().getString("TCMLE_INVALID_FIELD_VALUE", (Object[])new String[]{fieldValue, this.fveController.getDataType(), this.fveController.getFieldName()});
            this.msgControl.setValidationMessage((Control)this.fieldValueText, errorMessage, 1);
        }
        catch (IOException e) {
            errorMessage = e.getMessage();
            this.msgControl.setValidationMessage((Control)this.fieldValueText, errorMessage, 1);
            logger.throwing(((Object)((Object)this)).getClass().getName(), "modifyText()", (Throwable)e);
            logger.error((Throwable)e);
        }
        if (errorMessage != null) {
            this.getButton(0).setEnabled(false);
        } else {
            this.getButton(0).setEnabled(true);
        }
    }
}

