/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.transaction.common.ui;

import com.ibm.im.ims.metadata.testcase.InteractionType;
import com.ibm.im.ims.transaction.model.utilities.Utility;
import com.ibm.im.ims.workbench.transaction.Activator;
import com.ibm.im.ims.workbench.transaction.common.ui.EAMessageControl;
import com.ibm.im.ims.workbench.transaction.resources.utilities.TranMessages;
import com.ibm.im.ims.workbench.transaction.utilities.UIHelper;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.HashMap;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

public class InteractionSpecComposite
extends Composite
implements ModifyListener,
VerifyListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final int MARGIN = 5;
    private static final int SPACING = 4;
    private static final String YES = TranMessages.getLabel().getString("YES");
    private static final String NO = TranMessages.getLabel().getString("NO");
    private static final String API_INTERNAL_ACK = TranMessages.getLabel().getString("IPC_ACK_SOURCE_CONNECT");
    private static final String CLIENT_ACK_NAK = TranMessages.getLabel().getString("IPC_ACK_SOURCE_APPL");
    private static final String RESUME_TPIPE_SINGLE_WAIT = TranMessages.getLabel().getString("IPC_RESUME_TPIPE_SINGLE_WAIT");
    private static final String RESUME_TPIPE_SINGLE_NOWAIT = TranMessages.getLabel().getString("IPC_RESUME_TPIPE_SINGLE_NOWAIT");
    private static final String RESUME_TPIPE_AUTO = TranMessages.getLabel().getString("IPC_RESUME_TPIPE_AUTO");
    private static final String RESUME_TPIPE_NOAUTO = TranMessages.getLabel().getString("IPC_RESUME_TPIPE_NOAUTO");
    private static final String COMMIT_MODE_0 = TranMessages.getLabel().getString("IPC_COMMIT_MODE_0");
    private static final String COMMIT_MODE_1 = TranMessages.getLabel().getString("IPC_COMMIT_MODE_1");
    private static final String SYNC_LEVEL_CONFIRM = TranMessages.getLabel().getString("IPC_SYNC_LEVEL_CONFIRM");
    private static final String SYNC_LEVEL_NONE = TranMessages.getLabel().getString("IPC_SYNC_LEVEL_NONE");
    private static final String INTERACTION_TYPE_DESC_SENDRECV = TranMessages.getLabel().getString("IPC_DESC_SENDRECV");
    private static final String INTERACTION_TYPE_DESC_ACK = TranMessages.getLabel().getString("IPC_DESC_ACK");
    private static final String INTERACTION_TYPE_DESC_CANCELTIMER = TranMessages.getLabel().getString("IPC_DESC_CANCELTIMER");
    private static final String INTERACTION_TYPE_DESC_ENDCONVERSATION = TranMessages.getLabel().getString("IPC_DESC_END_CONVERSATION");
    private static final String INTERACTION_TYPE_DESC_SENDONLYACK = TranMessages.getLabel().getString("IPC_DESC_SENDONLYACK");
    private static final String INTERACTION_TYPE_DESC_NAK = TranMessages.getLabel().getString("IPC_DESC_NAK");
    private static final String INTERACTION_TYPE_DESC_SENDONLYXCFORDEREDDELIVERY = TranMessages.getLabel().getString("IPC_DESC_SENDONLYXCFORDEREDDELIVERY");
    private static final String INTERACTION_TYPE_DESC_RESUMETPIPE = TranMessages.getLabel().getString("IPC_DESC_RESUMETPIPE");
    private static final String INTERACTION_TYPE_DESC_SENDONLY = TranMessages.getLabel().getString("IPC_DESC_SENDONLY");
    private static final String INTERACTION_TYPE_DESC_RECEIVE = TranMessages.getLabel().getString("IPC_DESC_RECEIVE");
    private static final String[] NOYES = new String[]{NO, YES};
    private static final String[] PROVIDERS = new String[]{API_INTERNAL_ACK, CLIENT_ACK_NAK};
    private static final String[] TYPES = new String[]{RESUME_TPIPE_SINGLE_WAIT, RESUME_TPIPE_SINGLE_NOWAIT, RESUME_TPIPE_AUTO, RESUME_TPIPE_NOAUTO};
    private static final String[] MODES = new String[]{COMMIT_MODE_0, COMMIT_MODE_1};
    private static final String[] LEVELS = new String[]{SYNC_LEVEL_CONFIRM, SYNC_LEVEL_NONE};
    private static final String[] REQUESTS = new String[]{INTERACTION_TYPE_DESC_SENDRECV, INTERACTION_TYPE_DESC_ACK, INTERACTION_TYPE_DESC_CANCELTIMER, INTERACTION_TYPE_DESC_ENDCONVERSATION, INTERACTION_TYPE_DESC_SENDONLYACK, INTERACTION_TYPE_DESC_NAK, INTERACTION_TYPE_DESC_SENDONLYXCFORDEREDDELIVERY, INTERACTION_TYPE_DESC_RESUMETPIPE, INTERACTION_TYPE_DESC_SENDONLY, INTERACTION_TYPE_DESC_RECEIVE};
    private static final String IPC_IMS_DATASTORE_NAME = TranMessages.getLabel().getString("IPC_IMS_DATASTORE_NAME") + TranMessages.getColon().getString("COLON");
    private static final String IPC_IMS_DATASTORE_NAME_HOVER = Utility.formatMessage((String)TranMessages.getDescription().getString("IPC_IMS_DATASTORE_NAME_HOVER"));
    private static final String IPC_IMS_CONNECT_USER_EXIT = TranMessages.getLabel().getString("IPC_IMS_CONNECT_USER_EXIT") + TranMessages.getColon().getString("COLON");
    private static final String IPC_IMS_CONNECT_USER_EXIT_HOVER = Utility.formatMessage((String)TranMessages.getDescription().getString("IPC_IMS_CONNECT_USER_EXIT_HOVER"));
    private static final String IPC_INPUT_MSG_INCLUDE_LLZZ = TranMessages.getLabel().getString("IPC_INPUT_MSG_INCLUDE_LLZZ") + TranMessages.getColon().getString("COLON");
    private static final String IPC_INPUT_MSG_INCLUDE_LLZZ_HOVER = Utility.formatMessage((String)TranMessages.getDescription().getString("IPC_INPUT_MSG_INCLUDE_LLZZ_HOVER"));
    private static final String IPC_OUTPUT_MSG_INCLUDE_LLZZ = TranMessages.getLabel().getString("IPC_OUTPUT_MSG_INCLUDE_LLZZ") + TranMessages.getColon().getString("COLON");
    private static final String IPC_OUTPUT_MSG_INCLUDE_LLZZ_HOVER = Utility.formatMessage((String)TranMessages.getDescription().getString("IPC_OUTPUT_MSG_INCLUDE_LLZZ_HOVER"));
    private static final String IPC_RESPONSE_INCLUDE_LLLL = TranMessages.getLabel().getString("IPC_RESPONSE_INCLUDE_LLLL") + TranMessages.getColon().getString("COLON");
    private static final String IPC_RESPONSE_INCLUDE_LLLL_HOVER = Utility.formatMessage((String)TranMessages.getDescription().getString("IPC_RESPONSE_INCLUDE_LLLL_HOVER"));
    private static final String IPC_ACK_PROVIDER = TranMessages.getLabel().getString("IPC_ACK_PROVIDER") + TranMessages.getColon().getString("COLON");
    private static final String IPC_ACK_PROVIDER_HOVER = Utility.formatMessage((String)TranMessages.getDescription().getString("IPC_ACK_PROVIDER_HOVER"));
    private static final String IPC_INPUT_MESSAGE_OPTIONS = TranMessages.getLabel().getString("IPC_INPUT_MESSAGE_OPTIONS") + TranMessages.getColon().getString("COLON");
    private static final String IPC_INPUT_MESSAGE_OPTIONS_HOVER = Utility.formatMessage((String)TranMessages.getDescription().getString("IPC_INPUT_MESSAGE_OPTIONS_HOVER"));
    private static final String IPC_RESUME_TPIPE_PROCESSING = TranMessages.getLabel().getString("IPC_RESUME_TPIPE_PROCESSING") + TranMessages.getColon().getString("COLON");
    private static final String IPC_RETURN_MFS_MOD_NAME = TranMessages.getLabel().getString("IPC_RETURN_MFS_MOD_NAME") + TranMessages.getColon().getString("COLON");
    private static final String IPC_COMMIT_MODE = TranMessages.getLabel().getString("IPC_COMMIT_MODE") + TranMessages.getColon().getString("COLON");
    private static final String IPC_SYNC_LEVEL = TranMessages.getLabel().getString("IPC_SYNC_LEVEL") + TranMessages.getColon().getString("COLON");
    private static final String IPC_INTERACTION_TYPE_DESC = TranMessages.getLabel().getString("IPC_INTERACTION_TYPE_DESC") + TranMessages.getColon().getString("COLON");
    private static final String IPC_INTERACTION_TYPE_DESC_HOVER = Utility.formatMessage((String)TranMessages.getDescription().getString("IPC_INTERACTION_TYPE_DESC_HOVER"));
    private static final String IPC_TRAN_CODE = TranMessages.getLabel().getString("IPC_TRAN_CODE") + TranMessages.getColon().getString("COLON");
    private static final String IPC_TRAN_CODE_HOVER = Utility.formatMessage((String)TranMessages.getDescription().getString("IPC_TRAN_CODE_HOVER"));
    private static final String IPC_LTERM_OVERRIDE_NAME = TranMessages.getLabel().getString("IPC_LTERM_OVERRIDE_NAME") + TranMessages.getColon().getString("COLON");
    private static final String IPC_LTERM_OVERRIDE_NAME_HOVER = Utility.formatMessage((String)TranMessages.getDescription().getString("IPC_LTERM_OVERRIDE_NAME_HOVER"));
    private static final String IPC_PURGE_UNDELIVERABLE_OUTPUT = TranMessages.getLabel().getString("IPC_PURGE_UNDELIVERABLE_OUTPUT");
    private static final String IPC_REROUTE_NAME = TranMessages.getLabel().getString("IPC_REROUTE_NAME") + TranMessages.getColon().getString("COLON");
    private static final String IPC_REROUTE_NAME_HOVER = Utility.formatMessage((String)TranMessages.getDescription().getString("IPC_REROUTE_NAME_HOVER"));
    private static final String IPC_REROUTE_NAME_LABEL_HOVER = Utility.formatMessage((String)TranMessages.getDescription().getString("IPC_REROUTE_NAME_LABEL_HOVER"));
    private static final String IPC_REROUTE_UNDELIVERABLE_OUTPUT = TranMessages.getLabel().getString("IPC_REROUTE_UNDELIVERABLE_OUTPUT");
    private static final String IPC_RESUMETPIPE_ALTERNATE_CLIENTID = TranMessages.getLabel().getString("IPC_RESUMETPIPE_ALTERNATE_CLIENTID") + TranMessages.getColon().getString("COLON");
    private static final String IPC_RESUMETPIPE_ALTERNATE_CLIENTID_HOVER = Utility.formatMessage((String)TranMessages.getDescription().getString("IPC_RESUMETPIPE_ALTERNATE_CLIENTID_HOVER"));
    private static final String IPC_RESUMETPIPE_ALTERNATE_CLIENTID_LABEL_HOVER = Utility.formatMessage((String)TranMessages.getDescription().getString("IPC_RESUMETPIPE_ALTERNATE_CLIENTID_LABEL_HOVER"));
    private static final String IPC_RACF_USERID = TranMessages.getLabel().getString("IPC_RACF_USERID") + TranMessages.getColon().getString("COLON");
    private static final String IPC_RACF_USERID_HOVER = Utility.formatMessage((String)TranMessages.getDescription().getString("IPC_RACF_USERID_HOVER"));
    private static final String IPC_RACF_GROUP_NAME = TranMessages.getLabel().getString("IPC_RACF_GROUP_NAME") + TranMessages.getColon().getString("COLON");
    private static final String IPC_RACF_GROUP_NAME_HOVER = Utility.formatMessage((String)TranMessages.getDescription().getString("IPC_RACF_GROUP_NAME_HOVER"));
    private static final String IPC_RACF_APPL_NAME = TranMessages.getLabel().getString("IPC_RACF_APPL_NAME") + TranMessages.getColon().getString("COLON");
    private static final String IPC_RACF_APPL_NAME_HOVER = Utility.formatMessage((String)TranMessages.getDescription().getString("IPC_RACF_APPL_NAME_HOVER"));
    private static final String IPC_RACF_APPL_NAME_LABEL_HOVER = Utility.formatMessage((String)TranMessages.getDescription().getString("IPC_RACF_APPL_NAME_LABEL_HOVER"));
    private static final String IPC_IMS_CONNECT_TIMEOUT = TranMessages.getLabel().getString("IPC_IMS_CONNECT_TIMEOUT") + TranMessages.getColon().getString("COLON");
    private static final String IPC_IMS_CONNECT_TIMEOUT_HOVER = Utility.formatMessage((String)TranMessages.getDescription().getString("IPC_IMS_CONNECT_TIMEOUT_HOVER"));
    private static final String IPC_IMS_CONNECT_TIMEOUT_LABEL_HOVER = Utility.formatMessage((String)TranMessages.getDescription().getString("IPC_IMS_CONNECT_TIMEOUT_LABEL_HOVER"));
    private static final String IPC_INTERACTION_TIMEOUT = TranMessages.getLabel().getString("IPC_INTERACTION_TIMEOUT") + TranMessages.getColon().getString("COLON");
    private static final String IPC_INTERACTION_TIMEOUT_HOVER = Utility.formatMessage((String)TranMessages.getDescription().getString("IPC_INTERACTION_TIMEOUT_HOVER"));
    private static final String IPC_INTERACTION_TIMEOUT_LABEL_HOVER = Utility.formatMessage((String)TranMessages.getDescription().getString("IPC_INTERACTION_TIMEOUT_LABEL_HOVER"));
    private static final String IPC_IMS_CONNECT_CODEPAGE = TranMessages.getLabel().getString("IPC_IMS_CONNECT_CODEPAGE") + TranMessages.getColon().getString("COLON");
    private static final String IPC_IMS_CONNECT_CODEPAGE_HOVER = Utility.formatMessage((String)TranMessages.getDescription().getString("IPC_IMS_CONNECT_CODEPAGE_HOVER"));
    private static final String IPC_IMS_CONNECT_CODEPAGE_LABEL_HOVER = Utility.formatMessage((String)TranMessages.getDescription().getString("IPC_IMS_CONNECT_CODEPAGE_LABEL_HOVER"));
    private static final String IPC_IMS_CONNECT_TRACEFILE = TranMessages.getLabel().getString("IPC_IMS_CONNECT_TRACEFILE") + TranMessages.getColon().getString("COLON");
    private static final String IPC_IMS_CONNECT_TRACEFILE_HOVER = Utility.formatMessage((String)TranMessages.getDescription().getString("IPC_IMS_CONNECT_TRACEFILE_HOVER"));
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private EAMessageControl msgControl = null;
    private HashMap<Control, String> errorMessages = new HashMap();
    private Text imsDatastoreName;
    private Text imsConnectUserMessageExitIdentifier;
    private Combo inputMessageDataSegmentsIncludeLlzzAndTrancode;
    private Combo outputMessageDataSegmentsIncludeLlzz;
    private Combo responseIncludesLlll;
    private Combo ackNakProvider;
    private Text inputMessageOptions;
    private Combo resumeTpipeProcessing;
    private Combo returnMfsModname;
    private Combo commitMode;
    private Combo syncLevel;
    private Combo interactionTypeDescription;
    private Text trancode;
    private Text ltermOverrideName;
    private Combo purgeUndeliverableOutput;
    private Text rerouteName;
    private Combo rerouteUndeliverableOutput;
    private Text resumeTpipeAlternateClientId;
    private Text racfUserId;
    private Text racfGroupName;
    private Text racfApplName;
    private Text imsConnectTimeout;
    private Text interactionTimeout;
    private Text imsConnectCodepage;
    private Text traceFileText;
    private Control currentControl = null;
    private int rightMargin = 0;
    private InteractionType interaction;
    private Composite parent;
    private UIHelper uih = new UIHelper();

    public InteractionSpecComposite(Composite parent, boolean isEAMessageNeeded, InteractionType interaction) {
        super(parent, 16);
        this.interaction = interaction;
        this.parent = parent;
        if (isEAMessageNeeded) {
            this.msgControl = new EAMessageControl();
            this.rightMargin = 15;
        }
        this.createControl();
        this.setLayout((Layout)new GridLayout(1, true));
    }

    private void createControl() {
        logger.entering(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", new Object[0]);
        try {
            int[] labelSizes = new int[]{Utility.getTextWidth((Composite)this.parent, (int)0, (String)IPC_IMS_DATASTORE_NAME), Utility.getTextWidth((Composite)this.parent, (int)0, (String)IPC_IMS_CONNECT_USER_EXIT), Utility.getTextWidth((Composite)this.parent, (int)0, (String)IPC_INPUT_MSG_INCLUDE_LLZZ), Utility.getTextWidth((Composite)this.parent, (int)0, (String)IPC_OUTPUT_MSG_INCLUDE_LLZZ), Utility.getTextWidth((Composite)this.parent, (int)0, (String)IPC_RESPONSE_INCLUDE_LLLL), Utility.getTextWidth((Composite)this.parent, (int)0, (String)IPC_ACK_PROVIDER), Utility.getTextWidth((Composite)this.parent, (int)0, (String)IPC_INPUT_MESSAGE_OPTIONS), Utility.getTextWidth((Composite)this.parent, (int)0, (String)IPC_RESUME_TPIPE_PROCESSING), Utility.getTextWidth((Composite)this.parent, (int)0, (String)IPC_RETURN_MFS_MOD_NAME), Utility.getTextWidth((Composite)this.parent, (int)0, (String)IPC_COMMIT_MODE), Utility.getTextWidth((Composite)this.parent, (int)0, (String)IPC_SYNC_LEVEL), Utility.getTextWidth((Composite)this.parent, (int)0, (String)IPC_INTERACTION_TYPE_DESC), Utility.getTextWidth((Composite)this.parent, (int)0, (String)IPC_TRAN_CODE), Utility.getTextWidth((Composite)this.parent, (int)0, (String)IPC_LTERM_OVERRIDE_NAME), Utility.getTextWidth((Composite)this.parent, (int)0, (String)IPC_PURGE_UNDELIVERABLE_OUTPUT), Utility.getTextWidth((Composite)this.parent, (int)0, (String)IPC_REROUTE_NAME), Utility.getTextWidth((Composite)this.parent, (int)0, (String)IPC_REROUTE_UNDELIVERABLE_OUTPUT), Utility.getTextWidth((Composite)this.parent, (int)0, (String)IPC_RESUMETPIPE_ALTERNATE_CLIENTID), Utility.getTextWidth((Composite)this.parent, (int)0, (String)IPC_RACF_USERID), Utility.getTextWidth((Composite)this.parent, (int)0, (String)IPC_RACF_GROUP_NAME), Utility.getTextWidth((Composite)this.parent, (int)0, (String)IPC_RACF_APPL_NAME), Utility.getTextWidth((Composite)this.parent, (int)0, (String)IPC_IMS_CONNECT_TIMEOUT), Utility.getTextWidth((Composite)this.parent, (int)0, (String)IPC_INTERACTION_TIMEOUT), Utility.getTextWidth((Composite)this.parent, (int)0, (String)IPC_IMS_CONNECT_CODEPAGE), Utility.getTextWidth((Composite)this.parent, (int)0, (String)IPC_IMS_CONNECT_TRACEFILE)};
            int requiredLabelWidth = Utility.getTextWidth((Composite)this.parent, (int)0, (String)"*");
            int labelWidth = Utility.getMaxSize((int[])labelSizes) + requiredLabelWidth;
            int style = 0;
            Display display = this.parent.getDisplay();
            Font font = this.parent.getFont();
            Color color = this.parent.getForeground();
            this.uih.setDisplay(display);
            FormLayout layout = new FormLayout();
            FormData formLayoutData = this.uih.genFormData(new FormAttachment(0, 0), new FormAttachment(100, 0), new FormAttachment(0, 0), new FormAttachment(100, 0));
            ScrolledForm form = new ScrolledForm(this.parent);
            form.setExpandHorizontal(true);
            form.setExpandVertical(true);
            form.setLayout((Layout)layout);
            if (this.parent.getLayout() instanceof GridLayout) {
                form.setLayoutData((Object)new GridData(1808));
            } else {
                form.setLayoutData((Object)formLayoutData);
            }
            Composite composite = form.getBody();
            composite.setLayout((Layout)layout);
            formLayoutData = this.uih.genFormData(new FormAttachment(0, 0), null, new FormAttachment(0, 0), new FormAttachment(100, 0));
            Section section1 = new Section(composite, 66);
            section1.setText(TranMessages.getLabel().getString("IPC_GROUP_1"));
            section1.setLayout((Layout)layout);
            section1.setLayoutData((Object)formLayoutData);
            Composite composite1 = new Composite((Composite)section1, 16);
            composite1.setLayout((Layout)layout);
            FormData fd = this.uih.genFormData(new FormAttachment(0, 9), null, new FormAttachment(0, 0), null);
            Label dataStoreLabel = this.uih.genLabel(composite1, style, IPC_IMS_DATASTORE_NAME, color, fd, true);
            fd = this.uih.genFormData(new FormAttachment(0, 9), null, new FormAttachment(0, labelWidth), new FormAttachment(100, -this.rightMargin));
            this.imsDatastoreName = new Text(composite1, 2048);
            this.imsDatastoreName.setTextLimit(8);
            this.imsDatastoreName.setToolTipText(IPC_IMS_DATASTORE_NAME_HOVER);
            this.imsDatastoreName.setLayoutData((Object)fd);
            this.imsDatastoreName.setFont(font);
            fd = this.uih.genFormData(new FormAttachment((Control)dataStoreLabel, 9), null, new FormAttachment(0, 0), null);
            Label codePageLabel = this.uih.genLabel(composite1, style, IPC_IMS_CONNECT_CODEPAGE, color, fd, false);
            codePageLabel.setToolTipText(IPC_IMS_CONNECT_CODEPAGE_LABEL_HOVER);
            fd = this.uih.genFormData(new FormAttachment((Control)dataStoreLabel, 9), null, new FormAttachment(0, labelWidth), new FormAttachment(100, -this.rightMargin));
            this.imsConnectCodepage = new Text(composite1, 2048);
            this.imsConnectCodepage.setToolTipText(IPC_IMS_CONNECT_CODEPAGE_HOVER);
            this.imsConnectCodepage.setLayoutData((Object)fd);
            this.imsConnectCodepage.setFont(font);
            fd = this.uih.genFormData(new FormAttachment((Control)codePageLabel, 9), null, new FormAttachment(0, 0), null);
            Label userExitLabel = this.uih.genLabel(composite1, style, IPC_IMS_CONNECT_USER_EXIT, color, fd, false);
            fd = this.uih.genFormData(new FormAttachment((Control)codePageLabel, 9), null, new FormAttachment(0, labelWidth), new FormAttachment(100, -this.rightMargin));
            this.imsConnectUserMessageExitIdentifier = new Text(composite1, 2048);
            this.imsConnectUserMessageExitIdentifier.setTextLimit(8);
            this.imsConnectUserMessageExitIdentifier.setToolTipText(IPC_IMS_CONNECT_USER_EXIT_HOVER);
            this.imsConnectUserMessageExitIdentifier.setLayoutData((Object)fd);
            this.imsConnectUserMessageExitIdentifier.setFont(font);
            fd = this.uih.genFormData(new FormAttachment((Control)userExitLabel, 9), null, new FormAttachment(0, 0), null);
            Label includeLLZZLabel = this.uih.genLabel(composite1, style, IPC_INPUT_MSG_INCLUDE_LLZZ, color, fd, false);
            includeLLZZLabel.setToolTipText(IPC_INPUT_MSG_INCLUDE_LLZZ_HOVER);
            fd = this.uih.genFormData(new FormAttachment((Control)userExitLabel, 9), null, new FormAttachment(0, labelWidth), new FormAttachment(100, -this.rightMargin));
            this.inputMessageDataSegmentsIncludeLlzzAndTrancode = new Combo(composite1, 8);
            this.inputMessageDataSegmentsIncludeLlzzAndTrancode.setItems(NOYES);
            this.inputMessageDataSegmentsIncludeLlzzAndTrancode.setLayoutData((Object)fd);
            this.inputMessageDataSegmentsIncludeLlzzAndTrancode.setFont(font);
            fd = this.uih.genFormData(new FormAttachment((Control)includeLLZZLabel, 9), null, new FormAttachment(0, 0), null);
            Label outputIncludeLLZZLabel = this.uih.genLabel(composite1, style, IPC_OUTPUT_MSG_INCLUDE_LLZZ, color, fd, false);
            outputIncludeLLZZLabel.setToolTipText(IPC_OUTPUT_MSG_INCLUDE_LLZZ_HOVER);
            fd = this.uih.genFormData(new FormAttachment((Control)includeLLZZLabel, 9), null, new FormAttachment(0, labelWidth), new FormAttachment(100, -this.rightMargin));
            this.outputMessageDataSegmentsIncludeLlzz = new Combo(composite1, 8);
            this.outputMessageDataSegmentsIncludeLlzz.setItems(NOYES);
            this.outputMessageDataSegmentsIncludeLlzz.setLayoutData((Object)fd);
            this.outputMessageDataSegmentsIncludeLlzz.setFont(font);
            fd = this.uih.genFormData(new FormAttachment((Control)outputIncludeLLZZLabel, 9), null, new FormAttachment(0, 0), null);
            Label includeLLLLLabel = this.uih.genLabel(composite1, style, IPC_RESPONSE_INCLUDE_LLLL, color, fd, false);
            includeLLLLLabel.setToolTipText(IPC_RESPONSE_INCLUDE_LLLL_HOVER);
            fd = this.uih.genFormData(new FormAttachment((Control)outputIncludeLLZZLabel, 9), null, new FormAttachment(0, labelWidth), new FormAttachment(100, -this.rightMargin));
            this.responseIncludesLlll = new Combo(composite1, 8);
            this.responseIncludesLlll.setItems(NOYES);
            this.responseIncludesLlll.setLayoutData((Object)fd);
            this.responseIncludesLlll.setFont(font);
            fd = this.uih.genFormData(new FormAttachment((Control)includeLLLLLabel, 9), null, new FormAttachment(0, 0), null);
            Label ackProviderLabel = this.uih.genLabel(composite1, style, IPC_ACK_PROVIDER, color, fd, false);
            ackProviderLabel.setToolTipText(IPC_ACK_PROVIDER_HOVER);
            fd = this.uih.genFormData(new FormAttachment((Control)includeLLLLLabel, 9), null, new FormAttachment(0, labelWidth), new FormAttachment(100, -this.rightMargin));
            this.ackNakProvider = new Combo(composite1, 8);
            this.ackNakProvider.setItems(PROVIDERS);
            this.ackNakProvider.setLayoutData((Object)fd);
            this.ackNakProvider.setFont(font);
            fd = this.uih.genFormData(new FormAttachment((Control)ackProviderLabel, 9), null, new FormAttachment(0, 0), null);
            Label resumeTpipeOptionLabel = this.uih.genLabel(composite1, style, IPC_RESUME_TPIPE_PROCESSING, color, fd, false);
            fd = this.uih.genFormData(new FormAttachment((Control)ackProviderLabel, 9), null, new FormAttachment(0, labelWidth), new FormAttachment(100, -this.rightMargin));
            this.resumeTpipeProcessing = new Combo(composite1, 8);
            this.resumeTpipeProcessing.setItems(TYPES);
            this.resumeTpipeProcessing.setLayoutData((Object)fd);
            this.resumeTpipeProcessing.setFont(font);
            fd = this.uih.genFormData(new FormAttachment((Control)resumeTpipeOptionLabel, 9), null, new FormAttachment(0, 0), null);
            Label returnMfsModNameLabel = this.uih.genLabel(composite1, style, IPC_RETURN_MFS_MOD_NAME, color, fd, false);
            fd = this.uih.genFormData(new FormAttachment((Control)resumeTpipeOptionLabel, 9), null, new FormAttachment(0, labelWidth), new FormAttachment(100, -this.rightMargin));
            this.returnMfsModname = new Combo(composite1, 8);
            this.returnMfsModname.setItems(NOYES);
            this.returnMfsModname.setLayoutData((Object)fd);
            this.returnMfsModname.setFont(font);
            fd = this.uih.genFormData(new FormAttachment((Control)returnMfsModNameLabel, 9), null, new FormAttachment(0, 0), null);
            Label commitModeLabel = this.uih.genLabel(composite1, style, IPC_COMMIT_MODE, color, fd, false);
            fd = this.uih.genFormData(new FormAttachment((Control)returnMfsModNameLabel, 9), null, new FormAttachment(0, labelWidth), new FormAttachment(100, -this.rightMargin));
            this.commitMode = new Combo(composite1, 8);
            this.commitMode.setItems(MODES);
            this.commitMode.setLayoutData((Object)fd);
            this.commitMode.setFont(font);
            fd = this.uih.genFormData(new FormAttachment((Control)commitModeLabel, 9), null, new FormAttachment(0, 0), null);
            Label syncLevel_Label = this.uih.genLabel(composite1, style, IPC_SYNC_LEVEL, color, fd, false);
            fd = this.uih.genFormData(new FormAttachment((Control)commitModeLabel, 9), null, new FormAttachment(0, labelWidth), new FormAttachment(100, -this.rightMargin));
            this.syncLevel = new Combo(composite1, 8);
            this.syncLevel.setItems(LEVELS);
            this.syncLevel.setLayoutData((Object)fd);
            this.syncLevel.setFont(font);
            fd = this.uih.genFormData(new FormAttachment((Control)syncLevel_Label, 9), null, new FormAttachment(0, 0), null);
            Label typeDescriptionLabel = this.uih.genLabel(composite1, style, IPC_INTERACTION_TYPE_DESC, color, fd, false);
            typeDescriptionLabel.setToolTipText(IPC_INTERACTION_TYPE_DESC_HOVER);
            fd = this.uih.genFormData(new FormAttachment((Control)syncLevel_Label, 9), null, new FormAttachment(0, labelWidth), new FormAttachment(100, -this.rightMargin));
            this.interactionTypeDescription = new Combo(composite1, 8);
            this.interactionTypeDescription.setItems(REQUESTS);
            this.interactionTypeDescription.setLayoutData((Object)fd);
            this.interactionTypeDescription.setFont(font);
            fd = this.uih.genFormData(new FormAttachment((Control)typeDescriptionLabel, 9), null, new FormAttachment(0, 0), null);
            Label ltermOverrideLabel = this.uih.genLabel(composite1, style, IPC_LTERM_OVERRIDE_NAME, color, fd, false);
            fd = this.uih.genFormData(new FormAttachment((Control)typeDescriptionLabel, 9), null, new FormAttachment(0, labelWidth), new FormAttachment(100, -this.rightMargin));
            this.ltermOverrideName = new Text(composite1, 2048);
            this.ltermOverrideName.setTextLimit(8);
            this.ltermOverrideName.setToolTipText(IPC_LTERM_OVERRIDE_NAME_HOVER);
            this.ltermOverrideName.setLayoutData((Object)fd);
            this.ltermOverrideName.setFont(font);
            fd = this.uih.genFormData(new FormAttachment((Control)ltermOverrideLabel, 9), null, new FormAttachment(0, 0), null);
            Label rerouteUndeliverableLabel = this.uih.genLabel(composite1, style, IPC_REROUTE_UNDELIVERABLE_OUTPUT + TranMessages.getColon().getString("COLON"), color, fd, false);
            fd = this.uih.genFormData(new FormAttachment((Control)ltermOverrideLabel, 9), null, new FormAttachment(0, labelWidth), new FormAttachment(100, -this.rightMargin));
            this.rerouteUndeliverableOutput = new Combo(composite1, 8);
            this.rerouteUndeliverableOutput.setItems(NOYES);
            this.rerouteUndeliverableOutput.setLayoutData((Object)fd);
            this.rerouteUndeliverableOutput.setFont(font);
            fd = this.uih.genFormData(new FormAttachment((Control)rerouteUndeliverableLabel, 9), null, new FormAttachment(0, 0), null);
            Label rerouteNameLabel = this.uih.genLabel(composite1, style, IPC_REROUTE_NAME, color, fd, false);
            rerouteNameLabel.setToolTipText(IPC_REROUTE_NAME_LABEL_HOVER);
            fd = this.uih.genFormData(new FormAttachment((Control)rerouteUndeliverableLabel, 9), null, new FormAttachment(0, labelWidth), new FormAttachment(100, -this.rightMargin));
            this.rerouteName = new Text(composite1, 2048);
            this.rerouteName.setTextLimit(8);
            this.rerouteName.setToolTipText(IPC_REROUTE_NAME_HOVER);
            this.rerouteName.setLayoutData((Object)fd);
            this.rerouteName.setFont(font);
            fd = this.uih.genFormData(new FormAttachment((Control)rerouteNameLabel, 9), null, new FormAttachment(0, 0), null);
            Label purgeUnderliverableLabel = this.uih.genLabel(composite1, style, IPC_PURGE_UNDELIVERABLE_OUTPUT + TranMessages.getColon().getString("COLON"), color, fd, false);
            fd = this.uih.genFormData(new FormAttachment((Control)rerouteNameLabel, 9), null, new FormAttachment(0, labelWidth), new FormAttachment(100, -this.rightMargin));
            this.purgeUndeliverableOutput = new Combo(composite1, 2056);
            this.purgeUndeliverableOutput.setItems(NOYES);
            this.purgeUndeliverableOutput.setLayoutData((Object)fd);
            this.purgeUndeliverableOutput.setFont(font);
            fd = this.uih.genFormData(new FormAttachment((Control)purgeUnderliverableLabel, 9), null, new FormAttachment(0, 0), null);
            Label alternateClientIdLabel = this.uih.genLabel(composite1, style, IPC_RESUMETPIPE_ALTERNATE_CLIENTID, color, fd, false);
            alternateClientIdLabel.setToolTipText(IPC_RESUMETPIPE_ALTERNATE_CLIENTID_LABEL_HOVER);
            fd = this.uih.genFormData(new FormAttachment((Control)purgeUnderliverableLabel, 9), null, new FormAttachment(0, labelWidth), new FormAttachment(100, -this.rightMargin));
            this.resumeTpipeAlternateClientId = new Text(composite1, 2048);
            this.resumeTpipeAlternateClientId.setTextLimit(8);
            this.resumeTpipeAlternateClientId.setToolTipText(IPC_RESUMETPIPE_ALTERNATE_CLIENTID_HOVER);
            this.resumeTpipeAlternateClientId.setLayoutData((Object)fd);
            this.resumeTpipeAlternateClientId.setFont(font);
            fd = this.uih.genFormData(new FormAttachment((Control)alternateClientIdLabel, 9), null, new FormAttachment(0, 0), null);
            Label connectTimeoutLabel = this.uih.genLabel(composite1, style, IPC_IMS_CONNECT_TIMEOUT, color, fd, false);
            connectTimeoutLabel.setToolTipText(IPC_IMS_CONNECT_TIMEOUT_LABEL_HOVER);
            fd = this.uih.genFormData(new FormAttachment((Control)alternateClientIdLabel, 9), null, new FormAttachment(0, labelWidth), new FormAttachment(100, -this.rightMargin));
            this.imsConnectTimeout = new Text(composite1, 2048);
            this.imsConnectTimeout.setToolTipText(IPC_IMS_CONNECT_TIMEOUT_HOVER);
            this.imsConnectTimeout.setLayoutData((Object)fd);
            this.imsConnectTimeout.setFont(font);
            fd = this.uih.genFormData(new FormAttachment((Control)connectTimeoutLabel, 9), null, new FormAttachment(0, 0), null);
            Label interactionTimeoutLabel = this.uih.genLabel(composite1, style, IPC_INTERACTION_TIMEOUT, color, fd, false);
            interactionTimeoutLabel.setToolTipText(IPC_INTERACTION_TIMEOUT_LABEL_HOVER);
            fd = this.uih.genFormData(new FormAttachment((Control)connectTimeoutLabel, 9), null, new FormAttachment(0, labelWidth), new FormAttachment(100, -this.rightMargin));
            this.interactionTimeout = new Text(composite1, 2048);
            this.interactionTimeout.setToolTipText(IPC_INTERACTION_TIMEOUT_HOVER);
            this.interactionTimeout.setLayoutData((Object)fd);
            this.interactionTimeout.setFont(font);
            fd = this.uih.genFormData(new FormAttachment((Control)codePageLabel, 9), null, new FormAttachment(0, 0), null);
            this.uih.genLabel(composite1, style, IPC_IMS_CONNECT_TRACEFILE, color, fd, false);
            fd = this.uih.genFormData(new FormAttachment((Control)codePageLabel, 9), null, new FormAttachment(0, labelWidth), new FormAttachment(100, -this.rightMargin));
            this.traceFileText = new Text(composite1, 2048);
            this.traceFileText.setToolTipText(IPC_IMS_CONNECT_TRACEFILE_HOVER);
            this.traceFileText.setLayoutData((Object)fd);
            this.traceFileText.setFont(font);
            section1.setClient((Control)composite1);
            formLayoutData = this.uih.genFormData(new FormAttachment((Control)section1, 0), new FormAttachment(100, 0), new FormAttachment(0, 0), new FormAttachment(100, 0));
            Section section2 = new Section(composite, 2);
            section2.setText(TranMessages.getLabel().getString("IPC_GROUP_2"));
            section2.setLayout((Layout)layout);
            section2.setLayoutData((Object)formLayoutData);
            Composite composite2 = new Composite((Composite)section2, 16);
            composite2.setLayout((Layout)layout);
            fd = this.uih.genFormData(new FormAttachment(0, 9), null, new FormAttachment(0, 0), null);
            Label userIdLabel = this.uih.genLabel(composite2, style, IPC_RACF_USERID, color, fd, true);
            fd = this.uih.genFormData(new FormAttachment(0, 9), null, new FormAttachment(0, labelWidth), new FormAttachment(100, -this.rightMargin));
            this.racfUserId = new Text(composite2, 2048);
            this.racfUserId.setTextLimit(8);
            this.racfUserId.setToolTipText(IPC_RACF_USERID_HOVER);
            this.racfUserId.setLayoutData((Object)fd);
            this.racfUserId.setFont(font);
            fd = this.uih.genFormData(new FormAttachment((Control)userIdLabel, 9), null, new FormAttachment(0, 0), null);
            Label groupNameLabel = this.uih.genLabel(composite2, style, IPC_RACF_GROUP_NAME, color, fd, false);
            fd = this.uih.genFormData(new FormAttachment((Control)userIdLabel, 9), null, new FormAttachment(0, labelWidth), new FormAttachment(100, -this.rightMargin));
            this.racfGroupName = new Text(composite2, 2048);
            this.racfGroupName.setTextLimit(8);
            this.racfGroupName.setToolTipText(IPC_RACF_GROUP_NAME_HOVER);
            this.racfGroupName.setLayoutData((Object)fd);
            this.racfGroupName.setFont(font);
            fd = this.uih.genFormData(new FormAttachment((Control)groupNameLabel, 9), null, new FormAttachment(0, 0), null);
            Label appNameLabel = this.uih.genLabel(composite2, style, IPC_RACF_APPL_NAME, color, fd, false);
            appNameLabel.setToolTipText(IPC_RACF_APPL_NAME_LABEL_HOVER);
            fd = this.uih.genFormData(new FormAttachment((Control)groupNameLabel, 9), null, new FormAttachment(0, labelWidth), new FormAttachment(100, -this.rightMargin));
            this.racfApplName = new Text(composite2, 2048);
            this.racfApplName.setTextLimit(8);
            this.racfApplName.setToolTipText(IPC_RACF_APPL_NAME_HOVER);
            this.racfApplName.setLayoutData((Object)fd);
            this.racfApplName.setFont(font);
            section2.setClient((Control)composite2);
            this.initialize();
            this.addListeners();
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", e);
            logger.error(e);
        }
        logger.exiting(((Object)((Object)this)).getClass().getName(), "createControl(Composite parent)", new Object[0]);
    }

    public void initialize() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        if (this.msgControl != null) {
            this.createErrorMessageControl();
        }
        if (this.interaction != null) {
            String dsName = this.interaction.getImsDatastoreName();
            if (dsName == null || dsName.trim().isEmpty()) {
                dsName = store.getString("IPC_IMS_DATASTORE_NAME");
                this.interaction.setImsDatastoreName(dsName);
            }
            this.imsDatastoreName.setText(dsName);
            String userExit = this.interaction.getImsConnectUserMessageExitIdentifier();
            if (userExit == null || userExit.trim().isEmpty()) {
                userExit = store.getString("IPC_IMS_CONNECT_USER_EXIT");
                this.interaction.setImsConnectUserMessageExitIdentifier(userExit);
            }
            this.imsConnectUserMessageExitIdentifier.setText(userExit);
            Boolean llzzIncluded = this.interaction.isInputMessageDataSegmentsIncludeLlzzAndTrancode();
            if (llzzIncluded == null) {
                llzzIncluded = store.getBoolean("IPC_INPUT_MSG_INCLUDE_LLZZ");
                this.interaction.setInputMessageDataSegmentsIncludeLlzzAndTrancode(llzzIncluded);
            }
            if (llzzIncluded.booleanValue()) {
                this.inputMessageDataSegmentsIncludeLlzzAndTrancode.setText(YES);
            } else {
                this.inputMessageDataSegmentsIncludeLlzzAndTrancode.setText(NO);
            }
            Boolean outputllzzIncluded = this.interaction.isOutputMessageDataSegmentsIncludeLlzz();
            if (outputllzzIncluded == null) {
                outputllzzIncluded = store.getBoolean("IPC_OUTPUT_MSG_INCLUDE_LLZZ");
                this.interaction.setOutputMessageDataSegmentsIncludeLlzz(outputllzzIncluded);
            }
            if (outputllzzIncluded.booleanValue()) {
                this.outputMessageDataSegmentsIncludeLlzz.setText(YES);
            } else {
                this.outputMessageDataSegmentsIncludeLlzz.setText(NO);
            }
            Boolean llllIncluded = this.interaction.isResponseIncludesLlll();
            if (llllIncluded == null) {
                llllIncluded = store.getBoolean("IPC_REROUTE_UNDELIVERABLE_OUTPUT");
                this.interaction.setResponseIncludesLlll(llllIncluded);
            }
            if (llllIncluded.booleanValue()) {
                this.responseIncludesLlll.setText(YES);
            } else {
                this.responseIncludesLlll.setText(NO);
            }
            Byte ackProvider = this.interaction.getAckNakProvider();
            if (ackProvider == null) {
                ackProvider = (byte)store.getInt("IPC_ACK_PROVIDER");
                this.interaction.setAckNakProvider(ackProvider);
            }
            if (ackProvider.equals((byte)0)) {
                this.ackNakProvider.setText(API_INTERNAL_ACK);
            } else {
                this.ackNakProvider.setText(CLIENT_ACK_NAK);
            }
            BigInteger type = this.interaction.getResumeTpipeProcessing();
            if (type == null) {
                type = BigInteger.valueOf(store.getInt("IPC_RESUME_TPIPE_PROCESSING"));
                this.interaction.setResumeTpipeProcessing(type);
            }
            if (type.intValue() == 16) {
                this.resumeTpipeProcessing.setText(RESUME_TPIPE_SINGLE_WAIT);
            } else if (type.intValue() == 1) {
                this.resumeTpipeProcessing.setText(RESUME_TPIPE_SINGLE_NOWAIT);
            } else if (type.intValue() == 2) {
                this.resumeTpipeProcessing.setText(RESUME_TPIPE_AUTO);
            } else if (type.intValue() == 4) {
                this.resumeTpipeProcessing.setText(RESUME_TPIPE_NOAUTO);
            }
            Boolean returnMfs = this.interaction.isReturnMfsModname();
            if (returnMfs == null) {
                returnMfs = store.getBoolean("IPC_RETURN_MFS_MOD_NAME");
                this.interaction.setReturnMfsModname(returnMfs);
            }
            if (!returnMfs.booleanValue()) {
                this.returnMfsModname.setText(NO);
            } else {
                this.returnMfsModname.setText(YES);
            }
            Byte commMode = this.interaction.getCommitMode();
            if (commMode == null) {
                commMode = (byte)store.getInt("IPC_COMMIT_MODE");
                this.interaction.setCommitMode(commMode);
            }
            if (commMode.equals((byte)64)) {
                this.commitMode.setText(COMMIT_MODE_0);
            } else {
                this.commitMode.setText(COMMIT_MODE_1);
            }
            Byte syncLvl = this.interaction.getSyncLevel();
            if (syncLvl == null) {
                syncLvl = (byte)store.getInt("IPC_SYNC_LEVEL");
                this.interaction.setSyncLevel(syncLvl);
            }
            if (syncLvl.equals((byte)1)) {
                this.syncLevel.setText(SYNC_LEVEL_CONFIRM);
            } else {
                this.syncLevel.setText(SYNC_LEVEL_NONE);
            }
            String description = this.interaction.getInteractionTypeDescription();
            if (description == null || description.trim().isEmpty()) {
                description = store.getString("IPC_INTERACTION_TYPE_DESC");
                this.interaction.setInteractionTypeDescription(description);
            }
            if (description.equals("SENDRECV")) {
                this.interactionTypeDescription.setText(INTERACTION_TYPE_DESC_SENDRECV);
            } else if (description.equals("ACK")) {
                this.interactionTypeDescription.setText(INTERACTION_TYPE_DESC_ACK);
            } else if (description.equals("CANCELTIMER")) {
                this.interactionTypeDescription.setText(INTERACTION_TYPE_DESC_CANCELTIMER);
            } else if (description.equals("ENDCONVERSATION")) {
                this.interactionTypeDescription.setText(INTERACTION_TYPE_DESC_ENDCONVERSATION);
            } else if (description.equals("SENDONLYACK")) {
                this.interactionTypeDescription.setText(INTERACTION_TYPE_DESC_SENDONLYACK);
            } else if (description.equals("NAK")) {
                this.interactionTypeDescription.setText(INTERACTION_TYPE_DESC_NAK);
            } else if (description.equals("SENDONLYXCFORDDLV")) {
                this.interactionTypeDescription.setText(INTERACTION_TYPE_DESC_SENDONLYXCFORDEREDDELIVERY);
            } else if (description.equals("RESUMETPIPE")) {
                this.interactionTypeDescription.setText(INTERACTION_TYPE_DESC_RESUMETPIPE);
            } else if (description.equals("SENDONLY")) {
                this.interactionTypeDescription.setText(INTERACTION_TYPE_DESC_SENDONLY);
            } else if (description.equals("RECEIVE")) {
                this.interactionTypeDescription.setText(INTERACTION_TYPE_DESC_RECEIVE);
            }
            String overrideName = this.interaction.getLtermOverrideName();
            if (overrideName == null || overrideName.isEmpty()) {
                overrideName = store.getString("IPC_LTERM_OVERRIDE_NAME");
                this.interaction.setLtermOverrideName(overrideName);
            }
            this.ltermOverrideName.setText(overrideName);
            Boolean isReroute = this.interaction.isRerouteUndeliverableOutput();
            if (isReroute == null) {
                isReroute = store.getBoolean("IPC_REROUTE_UNDELIVERABLE_OUTPUT");
                this.interaction.setRerouteUndeliverableOutput(isReroute);
            }
            if (!isReroute.booleanValue()) {
                this.rerouteUndeliverableOutput.setText(NO);
            } else {
                this.rerouteUndeliverableOutput.setText(YES);
            }
            String rerouteNm = this.interaction.getRerouteName();
            if (rerouteNm == null || rerouteNm.isEmpty()) {
                rerouteNm = store.getString("IPC_REROUTE_NAME");
                this.interaction.setRerouteName(rerouteNm);
            }
            this.rerouteName.setText(rerouteNm);
            Boolean isPurge = this.interaction.isPurgeUndeliverableOutput();
            if (isPurge == null) {
                isPurge = store.getBoolean("IPC_PURGE_UNDELIVERABLE_OUTPUT");
                this.interaction.setPurgeUndeliverableOutput(isPurge);
            }
            if (!isPurge.booleanValue()) {
                this.purgeUndeliverableOutput.setText(NO);
            } else {
                this.purgeUndeliverableOutput.setText(YES);
            }
            String clientId = this.interaction.getResumeTpipeAlternateClientId();
            if (clientId == null || clientId.isEmpty()) {
                clientId = store.getString("IPC_RESUMETPIPE_ALTERNATE_CLIENTID");
                this.interaction.setResumeTpipeAlternateClientId(clientId);
            }
            this.resumeTpipeAlternateClientId.setText(clientId);
            BigInteger cTimeout = this.interaction.getImsConnectTimeout();
            if (cTimeout == null) {
                cTimeout = BigInteger.valueOf(store.getInt("IPC_IMS_CONNECT_TIMEOUT"));
                this.interaction.setImsConnectTimeout(cTimeout);
            }
            this.imsConnectTimeout.setText(cTimeout.toString());
            BigInteger iTimeout = this.interaction.getInteractionTimeout();
            if (iTimeout == null) {
                iTimeout = BigInteger.valueOf(store.getInt("IPC_INTERACTION_TIMEOUT"));
                this.interaction.setInteractionTimeout(iTimeout);
            }
            this.interactionTimeout.setText(iTimeout.toString());
            String codePage = this.interaction.getImsConnectCodepage();
            if (codePage == null) {
                codePage = store.getString("IPC_IMS_CONNECT_CODEPAGE");
                this.interaction.setImsConnectCodepage(codePage);
            }
            this.imsConnectCodepage.setText(codePage);
            this.traceFileText.setText(store.getString("IPC_IMS_CONNECT_TRACEFILE"));
            String racfId = this.interaction.getRacfUserId();
            if (racfId == null) {
                racfId = store.getString("IPC_RACF_USERID");
                this.interaction.setRacfUserId(racfId);
            }
            this.racfUserId.setText(racfId);
            String racfGrpName = this.interaction.getRacfGroupName();
            if (racfGrpName == null) {
                racfGrpName = store.getString("IPC_RACF_GROUP_NAME");
                this.interaction.setRacfGroupName(racfGrpName);
            }
            this.racfGroupName.setText(racfGrpName);
            String racfAppl = this.interaction.getRacfApplName();
            if (racfAppl == null) {
                racfAppl = store.getString("IPC_RACF_APPL_NAME");
                this.interaction.setRacfApplName(racfAppl);
            }
            this.racfApplName.setText(racfAppl);
        }
    }

    private void createErrorMessageControl() {
        this.msgControl.addControl((Control)this.imsDatastoreName);
        this.msgControl.addControl((Control)this.imsConnectUserMessageExitIdentifier);
        this.msgControl.addControl((Control)this.inputMessageDataSegmentsIncludeLlzzAndTrancode);
        this.msgControl.addControl((Control)this.outputMessageDataSegmentsIncludeLlzz);
        this.msgControl.addControl((Control)this.responseIncludesLlll);
        this.msgControl.addControl((Control)this.ackNakProvider);
        this.msgControl.addControl((Control)this.resumeTpipeProcessing);
        this.msgControl.addControl((Control)this.returnMfsModname);
        this.msgControl.addControl((Control)this.commitMode);
        this.msgControl.addControl((Control)this.syncLevel);
        this.msgControl.addControl((Control)this.interactionTypeDescription);
        this.msgControl.addControl((Control)this.ltermOverrideName);
        this.msgControl.addControl((Control)this.purgeUndeliverableOutput);
        this.msgControl.addControl((Control)this.rerouteName);
        this.msgControl.addControl((Control)this.rerouteUndeliverableOutput);
        this.msgControl.addControl((Control)this.resumeTpipeAlternateClientId);
        this.msgControl.addControl((Control)this.racfUserId);
        this.msgControl.addControl((Control)this.racfGroupName);
        this.msgControl.addControl((Control)this.racfApplName);
        this.msgControl.addControl((Control)this.imsConnectTimeout);
        this.msgControl.addControl((Control)this.interactionTimeout);
        this.msgControl.addControl((Control)this.imsConnectCodepage);
        this.msgControl.addControl((Control)this.traceFileText);
    }

    private void removeErrorMessageControl() {
        this.msgControl.removeControl((Control)this.imsDatastoreName);
        this.msgControl.removeControl((Control)this.imsConnectUserMessageExitIdentifier);
        this.msgControl.removeControl((Control)this.inputMessageDataSegmentsIncludeLlzzAndTrancode);
        this.msgControl.removeControl((Control)this.outputMessageDataSegmentsIncludeLlzz);
        this.msgControl.removeControl((Control)this.responseIncludesLlll);
        this.msgControl.removeControl((Control)this.ackNakProvider);
        this.msgControl.removeControl((Control)this.resumeTpipeProcessing);
        this.msgControl.removeControl((Control)this.returnMfsModname);
        this.msgControl.removeControl((Control)this.commitMode);
        this.msgControl.removeControl((Control)this.syncLevel);
        this.msgControl.removeControl((Control)this.interactionTypeDescription);
        this.msgControl.removeControl((Control)this.ltermOverrideName);
        this.msgControl.removeControl((Control)this.purgeUndeliverableOutput);
        this.msgControl.removeControl((Control)this.rerouteName);
        this.msgControl.removeControl((Control)this.rerouteUndeliverableOutput);
        this.msgControl.removeControl((Control)this.resumeTpipeAlternateClientId);
        this.msgControl.removeControl((Control)this.racfUserId);
        this.msgControl.removeControl((Control)this.racfGroupName);
        this.msgControl.removeControl((Control)this.racfApplName);
        this.msgControl.removeControl((Control)this.imsConnectTimeout);
        this.msgControl.removeControl((Control)this.interactionTimeout);
        this.msgControl.removeControl((Control)this.imsConnectCodepage);
        this.msgControl.removeControl((Control)this.traceFileText);
    }

    private void setErrorMessageControl(String errorMessage) {
        if (errorMessage != null && !errorMessage.isEmpty()) {
            this.errorMessages.put(this.currentControl, errorMessage);
        } else {
            this.errorMessages.remove(this.currentControl);
            if (this.currentControl.equals(this.purgeUndeliverableOutput)) {
                this.errorMessages.remove(this.rerouteUndeliverableOutput);
            } else if (this.currentControl.equals(this.rerouteUndeliverableOutput)) {
                this.errorMessages.remove(this.purgeUndeliverableOutput);
            } else if (this.currentControl.equals(this.commitMode)) {
                this.errorMessages.remove(this.syncLevel);
            } else if (this.currentControl.equals(this.syncLevel)) {
                this.errorMessages.remove(this.commitMode);
            }
        }
        if (this.msgControl != null) {
            this.msgControl.clearValidationMessage(this.currentControl);
            if (errorMessage != null && !errorMessage.isEmpty()) {
                this.msgControl.setValidationMessage(this.currentControl, errorMessage, 1);
            }
        }
    }

    private void addListeners() {
        this.imsDatastoreName.addVerifyListener((VerifyListener)this);
        this.imsConnectUserMessageExitIdentifier.addVerifyListener((VerifyListener)this);
        this.ltermOverrideName.addVerifyListener((VerifyListener)this);
        this.rerouteName.addVerifyListener((VerifyListener)this);
        this.resumeTpipeAlternateClientId.addVerifyListener((VerifyListener)this);
        this.racfUserId.addVerifyListener((VerifyListener)this);
        this.racfGroupName.addVerifyListener((VerifyListener)this);
        this.racfApplName.addVerifyListener((VerifyListener)this);
        this.imsConnectCodepage.addVerifyListener((VerifyListener)this);
        this.imsDatastoreName.addModifyListener((ModifyListener)this);
        this.imsConnectUserMessageExitIdentifier.addModifyListener((ModifyListener)this);
        this.inputMessageDataSegmentsIncludeLlzzAndTrancode.addModifyListener((ModifyListener)this);
        this.outputMessageDataSegmentsIncludeLlzz.addModifyListener((ModifyListener)this);
        this.responseIncludesLlll.addModifyListener((ModifyListener)this);
        this.ackNakProvider.addModifyListener((ModifyListener)this);
        this.resumeTpipeProcessing.addModifyListener((ModifyListener)this);
        this.returnMfsModname.addModifyListener((ModifyListener)this);
        this.commitMode.addModifyListener((ModifyListener)this);
        this.syncLevel.addModifyListener((ModifyListener)this);
        this.interactionTypeDescription.addModifyListener((ModifyListener)this);
        this.ltermOverrideName.addModifyListener((ModifyListener)this);
        this.rerouteUndeliverableOutput.addModifyListener((ModifyListener)this);
        this.purgeUndeliverableOutput.addModifyListener((ModifyListener)this);
        this.rerouteName.addModifyListener((ModifyListener)this);
        this.resumeTpipeAlternateClientId.addModifyListener((ModifyListener)this);
        this.racfUserId.addModifyListener((ModifyListener)this);
        this.racfGroupName.addModifyListener((ModifyListener)this);
        this.racfApplName.addModifyListener((ModifyListener)this);
        this.imsConnectTimeout.addModifyListener((ModifyListener)this);
        this.interactionTimeout.addModifyListener((ModifyListener)this);
        this.imsConnectCodepage.addModifyListener((ModifyListener)this);
        this.traceFileText.addModifyListener((ModifyListener)this);
    }

    private void removeListeners() {
        this.imsDatastoreName.removeVerifyListener((VerifyListener)this);
        this.imsConnectUserMessageExitIdentifier.removeVerifyListener((VerifyListener)this);
        this.ltermOverrideName.removeVerifyListener((VerifyListener)this);
        this.rerouteName.removeVerifyListener((VerifyListener)this);
        this.resumeTpipeAlternateClientId.removeVerifyListener((VerifyListener)this);
        this.racfUserId.removeVerifyListener((VerifyListener)this);
        this.racfGroupName.removeVerifyListener((VerifyListener)this);
        this.racfApplName.removeVerifyListener((VerifyListener)this);
        this.imsConnectCodepage.removeVerifyListener((VerifyListener)this);
        this.imsDatastoreName.removeModifyListener((ModifyListener)this);
        this.imsConnectUserMessageExitIdentifier.removeModifyListener((ModifyListener)this);
        this.inputMessageDataSegmentsIncludeLlzzAndTrancode.removeModifyListener((ModifyListener)this);
        this.outputMessageDataSegmentsIncludeLlzz.removeModifyListener((ModifyListener)this);
        this.responseIncludesLlll.removeModifyListener((ModifyListener)this);
        this.ackNakProvider.removeModifyListener((ModifyListener)this);
        this.resumeTpipeProcessing.removeModifyListener((ModifyListener)this);
        this.returnMfsModname.removeModifyListener((ModifyListener)this);
        this.commitMode.removeModifyListener((ModifyListener)this);
        this.syncLevel.removeModifyListener((ModifyListener)this);
        this.interactionTypeDescription.removeModifyListener((ModifyListener)this);
        this.ltermOverrideName.removeModifyListener((ModifyListener)this);
        this.rerouteUndeliverableOutput.removeModifyListener((ModifyListener)this);
        this.purgeUndeliverableOutput.removeModifyListener((ModifyListener)this);
        this.rerouteName.removeModifyListener((ModifyListener)this);
        this.resumeTpipeAlternateClientId.removeModifyListener((ModifyListener)this);
        this.racfUserId.removeModifyListener((ModifyListener)this);
        this.racfGroupName.removeModifyListener((ModifyListener)this);
        this.racfApplName.removeModifyListener((ModifyListener)this);
        this.imsConnectTimeout.removeModifyListener((ModifyListener)this);
        this.interactionTimeout.removeModifyListener((ModifyListener)this);
        this.imsConnectCodepage.removeModifyListener((ModifyListener)this);
        this.traceFileText.removeModifyListener((ModifyListener)this);
    }

    private void disposeWidgets() {
        this.imsDatastoreName.dispose();
        this.imsConnectUserMessageExitIdentifier.dispose();
        this.inputMessageDataSegmentsIncludeLlzzAndTrancode.dispose();
        this.outputMessageDataSegmentsIncludeLlzz.dispose();
        this.responseIncludesLlll.dispose();
        this.ackNakProvider.dispose();
        this.resumeTpipeProcessing.dispose();
        this.returnMfsModname.dispose();
        this.commitMode.dispose();
        this.syncLevel.dispose();
        this.interactionTypeDescription.dispose();
        this.ltermOverrideName.dispose();
        this.purgeUndeliverableOutput.dispose();
        this.rerouteName.dispose();
        this.rerouteUndeliverableOutput.dispose();
        this.resumeTpipeAlternateClientId.dispose();
        this.racfUserId.dispose();
        this.racfGroupName.dispose();
        this.racfApplName.dispose();
        this.imsConnectTimeout.dispose();
        this.interactionTimeout.dispose();
        this.imsConnectCodepage.dispose();
        this.traceFileText.dispose();
    }

    public void dispose() {
        this.removeListeners();
        if (this.msgControl != null) {
            this.removeErrorMessageControl();
        }
        this.disposeWidgets();
        super.dispose();
    }

    public void modifyText(ModifyEvent event) {
        try {
            String errorMessage = null;
            this.currentControl = (Control)event.widget;
            if (event.widget == this.imsDatastoreName) {
                String dsName = this.imsDatastoreName.getText().trim();
                if (dsName.isEmpty() || !Utility.isValidName((String)dsName)) {
                    errorMessage = TranMessages.getError().getString("IPC_NAME_ERROR", (Object[])new String[]{TranMessages.getError().getString("IPC_NAME_DATA_STORE")});
                } else {
                    this.interaction.setImsDatastoreName(dsName);
                }
            } else if (event.widget == this.imsConnectUserMessageExitIdentifier) {
                String exitName = this.imsConnectUserMessageExitIdentifier.getText().trim();
                if (!exitName.isEmpty() && !Utility.isValidName((String)exitName.replace('*', '@'))) {
                    errorMessage = TranMessages.getError().getString("IPC_NAME_ERROR", (Object[])new String[]{TranMessages.getError().getString("IPC_NAME_CONNECT_USER_MESSAGE_EXIT")});
                } else {
                    this.interaction.setImsConnectUserMessageExitIdentifier(exitName);
                }
            } else if (event.widget == this.inputMessageDataSegmentsIncludeLlzzAndTrancode) {
                this.interaction.setInputMessageDataSegmentsIncludeLlzzAndTrancode(Boolean.valueOf(this.inputMessageDataSegmentsIncludeLlzzAndTrancode.getText().equals(YES)));
            } else if (event.widget == this.outputMessageDataSegmentsIncludeLlzz) {
                this.interaction.setOutputMessageDataSegmentsIncludeLlzz(Boolean.valueOf(this.outputMessageDataSegmentsIncludeLlzz.getText().equals(YES)));
            } else if (event.widget == this.responseIncludesLlll) {
                this.interaction.setResponseIncludesLlll(Boolean.valueOf(this.responseIncludesLlll.getText().equals(YES)));
            } else if (event.widget == this.ackNakProvider) {
                if (this.ackNakProvider.getText().equals(API_INTERNAL_ACK)) {
                    this.interaction.setAckNakProvider(Byte.valueOf((byte)0));
                } else {
                    this.interaction.setAckNakProvider(Byte.valueOf((byte)1));
                }
            } else if (event.widget != this.inputMessageOptions) {
                if (event.widget == this.resumeTpipeProcessing) {
                    String type = this.resumeTpipeProcessing.getText().trim();
                    if (type.equals(RESUME_TPIPE_SINGLE_NOWAIT)) {
                        this.interaction.setResumeTpipeProcessing(BigInteger.valueOf(1L));
                    } else if (type.equals(RESUME_TPIPE_AUTO)) {
                        this.interaction.setResumeTpipeProcessing(BigInteger.valueOf(2L));
                    } else if (type.equals(RESUME_TPIPE_NOAUTO)) {
                        this.interaction.setResumeTpipeProcessing(BigInteger.valueOf(4L));
                    } else {
                        this.interaction.setResumeTpipeProcessing(BigInteger.valueOf(16L));
                    }
                } else if (event.widget == this.returnMfsModname) {
                    this.interaction.setReturnMfsModname(Boolean.valueOf(this.returnMfsModname.getText().equals(YES)));
                } else if (event.widget == this.commitMode) {
                    String commitModeStr = this.commitMode.getText().trim();
                    String syncLevelStr = this.syncLevel.getText().trim();
                    if (commitModeStr.equals(COMMIT_MODE_0) && syncLevelStr.equals(SYNC_LEVEL_NONE)) {
                        errorMessage = TranMessages.getError().getString("IPC_COMMIT_SYNC_ERROR", (Object[])new String[]{commitModeStr, syncLevelStr});
                    } else if (commitModeStr.equals(COMMIT_MODE_0)) {
                        this.interaction.setCommitMode(Byte.valueOf((byte)64));
                    } else {
                        this.interaction.setCommitMode(Byte.valueOf((byte)32));
                    }
                } else if (event.widget == this.syncLevel) {
                    String commitModeStr = this.commitMode.getText().trim();
                    String syncLevelStr = this.syncLevel.getText().trim();
                    if (commitModeStr.equals(COMMIT_MODE_0) && syncLevelStr.equals(SYNC_LEVEL_NONE)) {
                        errorMessage = TranMessages.getError().getString("IPC_COMMIT_SYNC_ERROR", (Object[])new String[]{commitModeStr, syncLevelStr});
                    } else if (syncLevelStr.equals(SYNC_LEVEL_NONE)) {
                        this.interaction.setSyncLevel(Byte.valueOf((byte)0));
                    } else {
                        this.interaction.setSyncLevel(Byte.valueOf((byte)1));
                    }
                } else if (event.widget == this.interactionTypeDescription) {
                    String description = this.interactionTypeDescription.getText().trim();
                    if (description.equals(INTERACTION_TYPE_DESC_ACK)) {
                        this.interaction.setInteractionTypeDescription("ACK");
                    } else if (description.equals(INTERACTION_TYPE_DESC_CANCELTIMER)) {
                        this.interaction.setInteractionTypeDescription("CANCELTIMER");
                    } else if (description.equals(INTERACTION_TYPE_DESC_ENDCONVERSATION)) {
                        this.interaction.setInteractionTypeDescription("ENDCONVERSATION");
                    } else if (description.equals(INTERACTION_TYPE_DESC_SENDONLYACK)) {
                        this.interaction.setInteractionTypeDescription("SENDONLYACK");
                    } else if (description.equals(INTERACTION_TYPE_DESC_NAK)) {
                        this.interaction.setInteractionTypeDescription("NAK");
                    } else if (description.equals(INTERACTION_TYPE_DESC_SENDONLYXCFORDEREDDELIVERY)) {
                        this.interaction.setInteractionTypeDescription("SENDONLYXCFORDDLV");
                    } else if (description.equals(INTERACTION_TYPE_DESC_RESUMETPIPE)) {
                        this.interaction.setInteractionTypeDescription("RESUMETPIPE");
                    } else if (description.equals(INTERACTION_TYPE_DESC_SENDONLY)) {
                        this.interaction.setInteractionTypeDescription("SENDONLY");
                    } else if (description.equals(INTERACTION_TYPE_DESC_RECEIVE)) {
                        this.interaction.setInteractionTypeDescription("RECEIVE");
                    } else {
                        this.interaction.setInteractionTypeDescription("SENDRECV");
                    }
                } else if (event.widget != this.trancode) {
                    if (event.widget == this.ltermOverrideName) {
                        String ltermName = this.ltermOverrideName.getText().trim();
                        if (!ltermName.isEmpty() && !Utility.isValidName((String)ltermName)) {
                            errorMessage = TranMessages.getError().getString("IPC_NAME_ERROR", (Object[])new String[]{IPC_LTERM_OVERRIDE_NAME});
                        } else {
                            this.interaction.setLtermOverrideName(ltermName);
                        }
                    } else if (event.widget == this.rerouteUndeliverableOutput) {
                        String purgeOutput = this.purgeUndeliverableOutput.getText().trim();
                        String rerouteOutput = this.rerouteUndeliverableOutput.getText().trim();
                        if (rerouteOutput.equals(YES) && purgeOutput.equals(YES)) {
                            errorMessage = TranMessages.getError().getString("IPC_REROUTE_PURGE_ERROR", (Object[])new String[]{IPC_REROUTE_UNDELIVERABLE_OUTPUT, IPC_PURGE_UNDELIVERABLE_OUTPUT});
                        } else {
                            this.interaction.setRerouteUndeliverableOutput(Boolean.valueOf(rerouteOutput.equals(YES)));
                        }
                    } else if (event.widget == this.rerouteName) {
                        String rerouteNm = this.rerouteName.getText().trim();
                        if (!rerouteNm.isEmpty() && !Utility.isValidName((String)rerouteNm)) {
                            errorMessage = TranMessages.getError().getString("IPC_NAME_ERROR", (Object[])new String[]{IPC_REROUTE_NAME});
                        } else {
                            this.interaction.setRerouteName(rerouteNm);
                        }
                    } else if (event.widget == this.resumeTpipeAlternateClientId) {
                        String alternateClient = this.resumeTpipeAlternateClientId.getText().trim();
                        if (!alternateClient.isEmpty() && !Utility.isValidName((String)alternateClient)) {
                            errorMessage = TranMessages.getError().getString("IPC_NAME_ERROR", (Object[])new String[]{IPC_RESUMETPIPE_ALTERNATE_CLIENTID});
                        } else {
                            this.interaction.setResumeTpipeAlternateClientId(alternateClient);
                        }
                    } else if (event.widget == this.purgeUndeliverableOutput) {
                        String purgeOutput = this.purgeUndeliverableOutput.getText().trim();
                        String rerouteOutput = this.rerouteUndeliverableOutput.getText().trim();
                        if (rerouteOutput.equals(YES) && purgeOutput.equals(YES)) {
                            errorMessage = TranMessages.getError().getString("IPC_REROUTE_PURGE_ERROR", (Object[])new String[]{IPC_REROUTE_UNDELIVERABLE_OUTPUT, IPC_PURGE_UNDELIVERABLE_OUTPUT});
                        } else {
                            this.interaction.setPurgeUndeliverableOutput(Boolean.valueOf(purgeOutput.equals(YES)));
                        }
                    } else if (event.widget == this.imsConnectTimeout) {
                        String timeout = this.imsConnectTimeout.getText().trim();
                        if (!timeout.isEmpty()) {
                            if (!Utility.isStringNumeric((String)timeout) || Integer.valueOf(timeout) < 0) {
                                errorMessage = TranMessages.getError().getString("IPC_NUMERIC_ERROR", (Object[])new String[]{TranMessages.getError().getString("IPC_NUMERIC_CONNECTION_TO")});
                            } else {
                                this.interaction.setImsConnectTimeout(new BigInteger(timeout));
                            }
                        }
                    } else if (event.widget == this.interactionTimeout) {
                        String timeout = this.interactionTimeout.getText().trim();
                        if (!timeout.isEmpty()) {
                            if (!Utility.isStringNumeric((String)timeout) || Integer.valueOf(timeout) > Integer.MAX_VALUE || Integer.valueOf(timeout) == 0 || Integer.valueOf(timeout) < -1) {
                                errorMessage = TranMessages.getError().getString("IPC_NUMERIC_INTERACTION_TO_ERROR");
                            } else {
                                this.interaction.setInteractionTimeout(new BigInteger(timeout));
                            }
                        }
                    } else if (event.widget == this.imsConnectCodepage) {
                        String codePage = this.imsConnectCodepage.getText().trim();
                        if (!codePage.isEmpty()) {
                            try {
                                String dummyStr = "dummy";
                                dummyStr.getBytes(codePage);
                                this.interaction.setImsConnectCodepage(codePage);
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                errorMessage = TranMessages.getError().getString("IPC_VALUE_ERROR", (Object[])new String[]{TranMessages.getError().getString("IPC_VALUE_CODEPAGE")});
                            }
                        }
                    } else if (event.widget == this.traceFileText) {
                        String traceFile = this.traceFileText.getText().trim();
                        boolean fileNameOk = true;
                        if (!traceFile.isEmpty()) {
                            try {
                                File file = new File(traceFile);
                                boolean newFileCreated = false;
                                if (!file.exists()) {
                                    newFileCreated = file.createNewFile();
                                }
                                fileNameOk = file.isFile();
                                if (newFileCreated) {
                                    file.delete();
                                }
                            }
                            catch (Exception exception) {
                                fileNameOk = false;
                            }
                            if (!fileNameOk) {
                                errorMessage = TranMessages.getError().getString("IPC_VALUE_ERROR", (Object[])new String[]{TranMessages.getLabel().getString("IPC_IMS_CONNECT_TRACEFILE")});
                            }
                        }
                    } else if (event.widget == this.racfUserId) {
                        String userId = this.racfUserId.getText().trim();
                        if (!userId.isEmpty() && !Utility.isValidName((String)userId)) {
                            errorMessage = TranMessages.getError().getString("IPC_NAME_ERROR", (Object[])new String[]{IPC_RACF_USERID});
                        } else {
                            this.interaction.setRacfUserId(userId);
                        }
                    } else if (event.widget == this.racfGroupName) {
                        String groupName = this.racfGroupName.getText().trim();
                        if (!groupName.isEmpty() && !Utility.isValidName((String)groupName)) {
                            errorMessage = TranMessages.getError().getString("IPC_NAME_ERROR", (Object[])new String[]{IPC_RACF_GROUP_NAME});
                        } else {
                            this.interaction.setRacfGroupName(groupName);
                        }
                    } else if (event.widget == this.racfApplName) {
                        String applName = this.racfApplName.getText().trim();
                        if (!applName.isEmpty() && !Utility.isValidName((String)applName)) {
                            errorMessage = TranMessages.getError().getString("IPC_NAME_ERROR", (Object[])new String[]{IPC_RACF_APPL_NAME});
                        } else {
                            this.interaction.setRacfApplName(applName);
                        }
                    }
                }
            }
            this.setErrorMessageControl(errorMessage);
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "modifyText(ModifyEvent event)", e);
            logger.error(e);
        }
    }

    public String getErrorMessage() {
        String retVal = null;
        int numberOfErrors = this.errorMessages.size();
        if (numberOfErrors > 0) {
            if (this.currentControl != null) {
                retVal = this.errorMessages.get(this.currentControl);
            }
            if (retVal == null) {
                retVal = this.errorMessages.entrySet().iterator().next().getValue();
            }
        }
        return retVal;
    }

    public void verifyText(VerifyEvent event) {
        try {
            if (event.character >= 'a' && event.character <= 'z') {
                event.text = event.text.toUpperCase();
            }
        }
        catch (Throwable e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "verifyText(VerifyEvent event)", e);
            logger.error(e);
        }
    }

    public void addChildListener(Control control, ModifyListener modifyListener) {
        if (control instanceof Combo || control instanceof Text) {
            if (control instanceof Combo) {
                ((Combo)control).addModifyListener(modifyListener);
            } else {
                ((Text)control).addModifyListener(modifyListener);
            }
        } else if (control instanceof Composite) {
            Control[] controlArray = ((Composite)control).getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control childControl = controlArray[n2];
                this.addChildListener(childControl, modifyListener);
                ++n2;
            }
        }
    }

    public String getTraceFilePath() {
        return this.traceFileText.getText().trim();
    }
}

