/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.transaction.common.ui;

import com.ibm.im.ims.transaction.model.utilities.Utility;
import java.util.HashMap;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.PlatformUI;

public class EAMessageControl {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private HashMap<Control, Label> iconLabelMap = new HashMap();

    public void addControl(Control ctrl) {
        Label msgLabel = new Label(ctrl.getParent(), 16448);
        this.iconLabelMap.put(ctrl, msgLabel);
    }

    public void removeControl(Control ctrl) {
        Label lbl = this.iconLabelMap.get(ctrl);
        if (lbl != null) {
            this.iconLabelMap.remove(ctrl);
            lbl.dispose();
        }
    }

    public void clearValidationMessage(Control ctrl) {
        this.setValidationMessage(ctrl, null, 0);
    }

    public void setValidationMessage(Control ctrl, String messageText, int messageType) {
        if (ctrl == null) {
            return;
        }
        Label iconLabel = this.getIconLabel(ctrl);
        if (messageText != null) {
            Image image = null;
            switch (messageType) {
                case 2: {
                    image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
                    break;
                }
                case 4: {
                    image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
                    break;
                }
                case 1: {
                    image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
                }
            }
            iconLabel.setImage(image);
            iconLabel.setToolTipText(Utility.formatMessage((String)messageText));
        } else {
            iconLabel.setImage(null);
        }
        this.layoutIconLabel(ctrl);
    }

    private void layoutIconLabel(Control ctrl) {
        Label iconLabel = this.getIconLabel(ctrl);
        if (iconLabel != null) {
            FormData iconFD = new FormData();
            iconFD.top = new FormAttachment(ctrl, 0, 0x1000000);
            iconFD.left = new FormAttachment(ctrl, 0, 131072);
            iconLabel.setLayoutData((Object)iconFD);
        }
        ctrl.getParent().layout(true, true);
    }

    private Label getIconLabel(Control ctrl) {
        return this.iconLabelMap.get(ctrl);
    }
}

