/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.transaction;

import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.logging.Level;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class IMSTransactionPerspective
implements IPerspectiveFactory {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2024. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    public static final String ID = "com.ibm.im.ims.workbench.IMSTransactionPerspective";
    private static final String LEFT_TOP = "top_left";
    private static final String RIGHT_TOP = "top_right";
    private static final String LEFT_BOT = "bottom_left";
    private static final String BOTTOM = "bottom";

    public void createInitialLayout(IPageLayout layout) {
        try {
            if (logger.isLoggable(Level.FINER)) {
                logger.entering(this.getClass().getName(), "createInitialLayout(IPageLayout layout)", new Object[0]);
            }
            String editorArea = layout.getEditorArea();
            IFolderLayout lefttop = layout.createFolder(LEFT_TOP, 1, 0.25f, editorArea);
            IFolderLayout righttop = layout.createFolder(RIGHT_TOP, 2, 0.73f, editorArea);
            layout.createFolder(LEFT_BOT, 4, 0.5f, LEFT_TOP);
            IFolderLayout bottom = layout.createFolder(BOTTOM, 4, 0.7f, editorArea);
            lefttop.addView("org.eclipse.ui.navigator.ProjectExplorer");
            righttop.addView("org.eclipse.rse.ui.view.systemView");
            bottom.addView("com.ibm.cics.explorer.connections_view");
            bottom.addView("org.eclipse.ui.views.PropertySheet");
            bottom.addView("org.eclipse.ui.views.ProgressView");
            bottom.addView("org.eclipse.ui.views.ProblemView");
            layout.addShowViewShortcut("org.eclipse.ui.navigator.ProjectExplorer");
            layout.addShowViewShortcut("com.ibm.cics.explorer.connections_view");
            layout.addShowViewShortcut("org.eclipse.ui.views.ProgressView");
            layout.addShowViewShortcut("org.eclipse.ui.views.ProblemView");
            layout.addActionSet(editorArea);
            layout.addNewWizardShortcut("com.ibm.im.ims.workbench.transaction.project.wizard");
            layout.addNewWizardShortcut("com.ibm.im.ims.workbench.transaction.testcase.wizard");
            if (logger.isLoggable(Level.FINER)) {
                logger.exiting(this.getClass().getName(), "createInitialLayout(IPageLayout layout)", new Object[0]);
            }
        }
        catch (Throwable e) {
            logger.throwing(this.getClass().getName(), "createInitialLayout(IPageLayout layout)", e);
        }
    }

    public static boolean isActive() {
        boolean active = false;
        try {
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
            IWorkbenchPage page = window.getActivePage();
            IPerspectiveDescriptor perspective = page.getPerspective();
            active = ID.equals(perspective.getId());
        }
        catch (Exception e) {
            logger.throwing(IMSTransactionPerspective.class.getCanonicalName(), "isActive()", (Throwable)e);
        }
        return active;
    }
}

