/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.transaction;

import com.ibm.im.ims.workbench.transaction.preferences.EnWPreferencesPage;
import com.ibm.im.ims.workbench.transaction.utilities.TrantocMapUpdater;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.Vector;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin
implements IResourceChangeListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String PLUGIN_ID = "com.ibm.im.ims.workbench.transaction";
    public static final String TC_EDITOR_ID = "com.ibm.im.ims.workbench.transaction.editors.TestCaseEditor";
    private static Activator plugin;
    private static final IExplorerLogger logger;

    static {
        logger = ExplorerLogger.instance();
    }

    public void start(BundleContext context) throws Exception {
        try {
            super.start(context);
            logger.entering(((Object)((Object)this)).getClass().getName(), "start(BundleContext context)", new Object[0]);
            plugin = this;
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
            TrantocMapUpdater.populateTrantocMapManager();
            logger.exiting(((Object)((Object)this)).getClass().getName(), "start(BundleContext context)", new Object[0]);
        }
        catch (Throwable e) {
            logger.error(e);
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return Activator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        try {
            event.getDelta().accept((IResourceDeltaVisitor)new DeltaVisitor());
        }
        catch (Throwable e) {
            logger.error(e);
        }
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        store.setDefault(EnWPreferencesPage.messageTypes[0], false);
        store.setDefault(EnWPreferencesPage.messageTypes[1], false);
        this.initializeDefaultInteractionPreferences(store);
        this.initializeDefaultMobileDataConversionOptions(store);
    }

    private void initializeDefaultMobileDataConversionOptions(IPreferenceStore store) {
        store.setDefault("IPC_IMS_DATASTORE_NAME", "MYDSTRNM");
    }

    private void initializeDefaultInteractionPreferences(IPreferenceStore store) {
        store.setDefault("IPC_IMS_DATASTORE_NAME", "MYDSTRNM");
        store.setDefault("IPC_IMS_CONNECT_USER_EXIT", "*SAMPL1*");
        store.setDefault("IPC_INPUT_MSG_INCLUDE_LLZZ", true);
        store.setDefault("IPC_OUTPUT_MSG_INCLUDE_LLZZ", true);
        store.setDefault("IPC_RESPONSE_INCLUDE_LLLL", true);
        store.setDefault("IPC_ACK_PROVIDER", 0);
        store.setDefault("IPC_INPUT_MESSAGE_OPTIONS", 0);
        store.setDefault("IPC_RESUME_TPIPE_PROCESSING", 16);
        store.setDefault("IPC_RETURN_MFS_MOD_NAME", false);
        store.setDefault("IPC_COMMIT_MODE", 64);
        store.setDefault("IPC_SYNC_LEVEL", 1);
        store.setDefault("IPC_INTERACTION_TYPE_DESC", "SENDRECV");
        store.setDefault("IPC_LTERM_OVERRIDE_NAME", "        ");
        store.setDefault("IPC_PURGE_UNDELIVERABLE_OUTPUT", false);
        store.setDefault("IPC_REROUTE_NAME", "        ");
        store.setDefault("IPC_REROUTE_UNDELIVERABLE_OUTPUT", false);
        store.setDefault("IPC_RESUMETPIPE_ALTERNATE_CLIENTID", "        ");
        store.setDefault("IPC_IMS_CONNECT_TIMEOUT", 0);
        store.setDefault("IPC_INTERACTION_TIMEOUT", -1);
        store.setDefault("IPC_IMS_CONNECT_CODEPAGE", "CP037");
        store.setDefault("IPC_RACF_USERID", "");
        store.setDefault("IPC_RACF_GROUP_NAME", "");
        store.setDefault("IPC_RACF_APPL_NAME", "");
    }

    class DeltaVisitor
    implements IResourceDeltaVisitor {
        public boolean visit(IResourceDelta delta) throws CoreException {
            boolean retVal;
            block9: {
                retVal = true;
                try {
                    Vector<IPath> changedTranFiles = new Vector<IPath>();
                    int deltaKind = delta.getKind();
                    if (deltaKind != 4) break block9;
                    IResource resource = delta.getResource();
                    if (resource instanceof IFolder) {
                        if (resource.getFullPath().lastSegment().equals("Transactions")) {
                            IResourceDelta[] resourceDeltas = delta.getAffectedChildren();
                            int i = 0;
                            while (i < resourceDeltas.length) {
                                IPath fullPath = resourceDeltas[i].getFullPath();
                                if (fullPath != null) {
                                    changedTranFiles.add(fullPath);
                                }
                                ++i;
                            }
                            if (changedTranFiles.size() > 0) {
                                TrantocMapUpdater updater = new TrantocMapUpdater(changedTranFiles);
                                PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)updater);
                            }
                            retVal = false;
                        }
                        break block9;
                    }
                    if (!(resource instanceof IWorkspaceRoot)) break block9;
                    IResourceDelta[] resourceDeltas = delta.getAffectedChildren();
                    int i = 0;
                    while (i < resourceDeltas.length) {
                        IPath oldPath;
                        IProjectNature nature;
                        IResource currResource = resourceDeltas[i].getResource();
                        if (currResource instanceof IProject && currResource.exists() && ((IProject)currResource).isOpen() && (nature = ((IProject)currResource).getNature("com.ibm.im.ims.workbench.transaction.nature")) != null && (oldPath = resourceDeltas[i].getMovedFromPath()) != null) {
                            TrantocMapUpdater.refreshTrantocMapManager();
                            break;
                        }
                        ++i;
                    }
                }
                catch (Throwable e) {
                    logger.error(e);
                }
            }
            return retVal;
        }
    }
}

