/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.debug;

import com.ibm.im.ims.transaction.model.utilities.ProjectTreeFileHelper;
import com.ibm.im.ims.workbench.transaction.resources.utilities.TranMessages;
import com.ibm.im.ims.workbench.transaction.wizard.runtimeconsole.RuntimeConsoleWizard;
import com.ibm.im.ims.workbench.transaction.wizard.runtimeconsole.RuntimeConsoleWizardDialog;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class RunConfigDelegate
implements ILaunchConfigurationDelegate {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();

    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        try {
            final String testProject = configuration.getAttribute("TestProjectName", "");
            final String serverName = configuration.getAttribute("server", "");
            final String serverId = configuration.getAttribute("serverid", "");
            final String runConfigName = configuration.getName();
            if (ProjectTreeFileHelper.projectExists((String)testProject)) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            RuntimeConsoleWizard wizard = new RuntimeConsoleWizard(testProject, serverName, serverId, runConfigName);
                            RuntimeConsoleWizardDialog dialog = new RuntimeConsoleWizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                            dialog.create();
                            dialog.open();
                        }
                        catch (Throwable e) {
                            logger.error(e);
                        }
                    }
                });
            } else {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Object[] inserts = new Object[]{testProject};
                            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getDisplay().getActiveShell(), (String)TranMessages.getLabel().getString("IDSW_ERR"), (String)TranMessages.getError().getString("RCW_PROJECT_MISSING", inserts));
                        }
                        catch (Throwable e) {
                            logger.error(e);
                        }
                    }
                });
            }
        }
        catch (Throwable e) {
            logger.error(e);
        }
    }
}

