/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.debug;

import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.im.ims.transaction.controller.editor.TestcaseEditorController;
import com.ibm.im.ims.workbench.transaction.connections.utils.ImsTmConnectionUtil;
import com.ibm.im.ims.workbench.transaction.resources.utilities.TranMessages;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class IMSTransactionServerTab
extends AbstractLaunchConfigurationTab
implements SelectionListener,
ModifyListener,
VerifyListener {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private Combo serverCombo;
    public static final String ATTRIBUTE_SERVER = "server";
    public static final String ATTRIBUTE_SERVERID = "serverid";
    public static final String SERVER_NAME = TranMessages.getLabel().getString("RCW_SERVER_TAB");
    private Combo comboProjectNames;
    private static boolean newLC = false;
    public static final String TEST_PROJECT_NAME = "TestProjectName";
    public static final String[] serverTypeIds = new String[]{"com.ibm.im.ims.workbench.transaction.server"};
    private ConnectionProfile selectedConnectionProfile;
    private LinkedHashMap<Integer, String> connectionProfileIdToComboIndex;

    public void createControl(Composite parent) {
        Composite myComposite = new Composite(parent, 4);
        myComposite.setLayout((Layout)new GridLayout());
        Group group = new Group(myComposite, 0);
        group.setText(TranMessages.getLabel().getString("RCW_TRANSACTION_SERVER_INFO"));
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout(2, false));
        Label programTypeLabel = new Label((Composite)group, 0);
        programTypeLabel.setText(TranMessages.getLabel().getString("RCW_SERVER") + TranMessages.getColon().getString("COLON"));
        programTypeLabel.setLayoutData((Object)new GridData());
        this.serverCombo = new Combo((Composite)group, 2056);
        this.serverCombo.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        Label projLabel = new Label((Composite)group, 0);
        projLabel.setText(TranMessages.getLabel().getString("RCW_PROJECT_NAME") + TranMessages.getColon().getString("COLON"));
        projLabel.setLayoutData((Object)new GridData());
        this.comboProjectNames = new Combo((Composite)group, 2056);
        this.comboProjectNames.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.comboProjectNames.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IMSTransactionServerTab.this.setDirty(true);
                IMSTransactionServerTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.addListeners();
        this.setControl((Control)myComposite);
    }

    private void addListeners() {
        this.serverCombo.addSelectionListener((SelectionListener)this);
    }

    private void removeListeners() {
        this.serverCombo.removeSelectionListener((SelectionListener)this);
    }

    public static Text createText(FormToolkit toolkit, Composite parent, int style, String value) {
        Text text = toolkit == null ? new Text(parent, style) : toolkit.createText(parent, value, style);
        text.setText(value);
        return text;
    }

    public static GridLayout createMarginLessGridLayout(int numColumns, boolean makeColumnsEqualWidth) {
        GridLayout layout = new GridLayout(numColumns, makeColumnsEqualWidth);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        return layout;
    }

    public static Label createLabel(FormToolkit toolkit, Composite parent, int style, String text) {
        Label label = toolkit == null ? new Label(parent, style) : toolkit.createLabel(parent, text, style);
        label.setText(text);
        return label;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        newLC = true;
    }

    private static boolean matches(String a, String b) {
        return a == null || b == null || "*".equals(a) || "*".equals(b) || a.startsWith(b) || b.startsWith(a);
    }

    public static boolean isSupportedServer(String serverTypeId) {
        if (serverTypeIds == null) {
            return true;
        }
        int size = serverTypeIds.length;
        int i = 0;
        while (i < size) {
            if (IMSTransactionServerTab.matches(serverTypeId, serverTypeIds[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.removeListeners();
            this.serverCombo.removeAll();
            this.comboProjectNames.removeAll();
            List connectionProfiles = ImsTmConnectionUtil.getConnectionProfiles();
            String selectedProfileId = configuration.getAttribute(ATTRIBUTE_SERVERID, "");
            this.selectedConnectionProfile = null;
            this.connectionProfileIdToComboIndex = new LinkedHashMap();
            int connectionProfileIndex = 0;
            while (connectionProfileIndex < connectionProfiles.size()) {
                ConnectionProfile connectionProfile = (ConnectionProfile)connectionProfiles.get(connectionProfileIndex);
                String connectionProfileId = connectionProfile.getId();
                if (!selectedProfileId.isBlank() && selectedProfileId.equals(connectionProfileId)) {
                    this.selectedConnectionProfile = connectionProfile;
                }
                this.connectionProfileIdToComboIndex.put(connectionProfileIndex, connectionProfileId);
                this.serverCombo.add(connectionProfile.getName());
                ++connectionProfileIndex;
            }
            if (this.selectedConnectionProfile != null) {
                this.serverCombo.setText(this.selectedConnectionProfile.getName());
            }
            this.comboProjectNames.removeAll();
            this.populateProjectCombo();
            String projectName = configuration.getAttribute(TEST_PROJECT_NAME, "");
            if (projectName.equals("") && newLC) {
                newLC = false;
                IProject selProj = this.getSelectedProject();
                if (selProj != null && TestcaseEditorController.hasServiceTestProjectNature((IProject)selProj)) {
                    projectName = selProj.getName();
                }
            }
            this.comboProjectNames.setText(projectName);
            this.addListeners();
        }
        catch (CoreException e) {
            logger.error((Throwable)e);
        }
    }

    private void populateProjectCombo() {
        String[] tProjects = null;
        tProjects = TestcaseEditorController.getUnitTestProjects();
        this.comboProjectNames.setItems(tProjects);
    }

    private IProject getSelectedProject() {
        TreeSelection currSel;
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ISelection selection = workbenchWindow.getSelectionService().getSelection();
        if (selection instanceof TreeSelection && (currSel = (TreeSelection)selection).size() == 1) {
            Object selObj = currSel.getFirstElement();
            if (selObj instanceof IProject) {
                return (IProject)selObj;
            }
            if (selObj instanceof IResource) {
                return ((IResource)selObj).getProject();
            }
            if (selObj instanceof IFile) {
                return ((IFile)selObj).getProject();
            }
        }
        return null;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String serverName = this.serverCombo.getText();
        String serverId = this.connectionProfileIdToComboIndex.get(this.serverCombo.getSelectionIndex());
        configuration.setAttribute(ATTRIBUTE_SERVER, serverName);
        configuration.setAttribute(ATTRIBUTE_SERVERID, serverId);
        configuration.setAttribute(TEST_PROJECT_NAME, this.comboProjectNames.getText());
    }

    public String getName() {
        return SERVER_NAME;
    }

    public String getId() {
        if (this.selectedConnectionProfile != null) {
            return this.selectedConnectionProfile.getId();
        }
        return super.getId();
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        boolean retVal = true;
        if (this.serverCombo == null || this.serverCombo.getText().isEmpty()) {
            retVal = false;
        }
        if (this.comboProjectNames == null || this.comboProjectNames.getText().isEmpty()) {
            retVal = false;
        }
        return retVal;
    }

    public void modifyText(ModifyEvent event) {
    }

    public void verifyText(VerifyEvent event) {
    }

    public void widgetSelected(SelectionEvent event) {
        try {
            if (event.widget == this.serverCombo) {
                this.setDirty(true);
                this.comboProjectNames.removeAll();
                this.populateProjectCombo();
                this.updateLaunchConfigurationDialog();
            }
        }
        catch (Throwable e) {
            logger.error(e);
        }
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }
}

