/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.debug;

import com.ibm.im.ims.transaction.controller.editor.TestcaseEditorController;
import com.ibm.im.ims.workbench.debug.IMSTransactionServerTab;
import com.ibm.im.ims.workbench.transaction.resources.utilities.TranMessages;
import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class IMSTransactionProjectTab
extends AbstractLaunchConfigurationTab {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();
    private Combo comboProjectNames;
    private static boolean newLC = false;
    public static final String TEST_PROJECT_NAME = "TestProjectName";
    private static final String TEST_PROJECT_TAB = TranMessages.getLabel().getString("RCW_PROJECT_TAB");
    private IMSTransactionServerTab serverTab;

    public IMSTransactionProjectTab(IMSTransactionServerTab serverTab) {
        this.serverTab = serverTab;
    }

    public void createControl(Composite parent) {
        Composite myComposite = new Composite(parent, 4);
        myComposite.setLayout((Layout)new GridLayout());
        Group group = new Group(myComposite, 0);
        group.setText(TranMessages.getLabel().getString("RCW_TRANSACTION_PROJECT_INFO"));
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout(2, false));
        Label programTypeLabel = new Label((Composite)group, 0);
        programTypeLabel.setText(TranMessages.getLabel().getString("RCW_PROJECT_NAME") + TranMessages.getColon().getString("COLON"));
        programTypeLabel.setLayoutData((Object)new GridData());
        this.comboProjectNames = new Combo((Composite)group, 2056);
        this.comboProjectNames.setLayoutData((Object)new GridData(4, 128, true, false, 1, 1));
        this.comboProjectNames.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IMSTransactionProjectTab.this.setDirty(true);
                IMSTransactionProjectTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.setControl((Control)myComposite);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        newLC = true;
    }

    private IProject getSelectedProject() {
        TreeSelection currSel;
        IWorkbenchWindow workbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ISelection selection = workbenchWindow.getSelectionService().getSelection();
        if (selection instanceof TreeSelection && (currSel = (TreeSelection)selection).size() == 1) {
            Object selObj = currSel.getFirstElement();
            if (selObj instanceof IProject) {
                return (IProject)selObj;
            }
            if (selObj instanceof IResource) {
                return ((IResource)selObj).getProject();
            }
            if (selObj instanceof IFile) {
                return ((IFile)selObj).getProject();
            }
        }
        return null;
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.comboProjectNames.removeAll();
        this.populateProjectCombo();
        try {
            String projectName = configuration.getAttribute(TEST_PROJECT_NAME, "");
            if (projectName.equals("") && newLC) {
                newLC = false;
                IProject selProj = this.getSelectedProject();
                if (selProj != null && TestcaseEditorController.hasServiceTestProjectNature((IProject)selProj)) {
                    projectName = selProj.getName();
                }
            }
            this.comboProjectNames.setText(projectName);
        }
        catch (CoreException e) {
            logger.throwing(((Object)((Object)this)).getClass().getName(), "initializeFrom()", (Throwable)e);
            logger.error((Throwable)e);
        }
    }

    private void populateProjectCombo() {
        String[] tProjects = null;
        tProjects = TestcaseEditorController.getUnitTestProjects();
        this.comboProjectNames.setItems(tProjects);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(TEST_PROJECT_NAME, this.comboProjectNames.getText());
    }

    public String getName() {
        return TEST_PROJECT_TAB;
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        boolean retVal = true;
        this.setErrorMessage(null);
        this.setMessage(null);
        if (this.comboProjectNames == null || this.comboProjectNames.getText().isEmpty()) {
            retVal = false;
        }
        return retVal;
    }
}

