/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.im.ims.workbench.debug;

import com.ibm.ims.explorer.common.logger.IExplorerLogger;
import com.ibm.ims.explorer.eclipse.common.logger.ExplorerLogger;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchShortcut;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;

public class IMSTransactionLaunchShortcut
implements ILaunchShortcut {
    public static final String COPYRIGHT = "Licensed Material - Property of IBM. 5655-TDA (C) Copyright IBM Corp. 2010, 2014. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final IExplorerLogger logger = ExplorerLogger.instance();

    public void launch(ISelection selection, String mode) {
        TreeSelection currSel;
        IProject selectedProject = null;
        if (selection instanceof TreeSelection && (currSel = (TreeSelection)selection).size() == 1) {
            Object selObj = currSel.getFirstElement();
            if (selObj instanceof IProject) {
                selectedProject = (IProject)selObj;
            } else if (selObj instanceof IResource) {
                selectedProject = ((IResource)selObj).getProject();
            } else if (selObj instanceof IFile) {
                selectedProject = ((IFile)selObj).getProject();
            }
        }
        if (selectedProject != null) {
            String projectName = selectedProject.getName();
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType type = launchManager.getLaunchConfigurationType("com.ibm.im.ims.workbench.debug.launchConfigType");
            try {
                ILaunchConfiguration[] configurations = launchManager.getLaunchConfigurations(type);
                ILaunchConfiguration configuration = null;
                if (configurations.length > 0) {
                    int i = 0;
                    while (i < configurations.length) {
                        String currentProjectName = configurations[i].getAttribute("TestProjectName", "");
                        if (currentProjectName.equals(projectName)) {
                            configuration = configurations[i];
                            break;
                        }
                        ++i;
                    }
                    if (configuration == null) {
                        configuration = configurations[0];
                    }
                } else {
                    ILaunchConfigurationWorkingCopy workingCopy = type.newInstance((IContainer)selectedProject, projectName);
                    workingCopy.setAttribute("TestProjectName", projectName);
                    workingCopy.setMappedResources(new IResource[]{selectedProject});
                    configuration = workingCopy.doSave();
                }
                DebugUITools.openLaunchConfigurationDialog((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (ILaunchConfiguration)configuration, (String)DebugUITools.getLaunchGroup((ILaunchConfiguration)configuration, (String)"run").getIdentifier(), null);
            }
            catch (Throwable e) {
                logger.error(e);
            }
        }
    }

    public void launch(IEditorPart editor, String mode) {
    }
}

