/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.etools.marshall.util.bidi;

import com.ibm.etools.marshall.util.bidi.BidiFlag;
import com.ibm.etools.marshall.util.bidi.BidiText;
import com.ibm.etools.marshall.util.bidi.BidiTransform;

class BidiOrder {
    private static final String copyright = "Copyright IBM Corporation 2002,2005.";
    private static final int UBAT_B = 0;
    private static final int UBAT_S = 1;
    private static final int UBAT_L = 2;
    private static final int UBAT_R = 3;
    private static final int UBAT_EN = 4;
    private static final int UBAT_AN = 5;
    private static final int UBAT_ET = 6;
    private static final int UBAT_ES = 7;
    private static final int UBAT_CS = 8;
    private static final int UBAT_W = 9;
    private static final int UBAT_N = 10;
    private static final int UBAT_BD = 11;
    private static final int UBAT_AL = 12;
    private static final int UBAT_NSM = 13;
    private static final int ITIL = 11;
    private static final int ITCOND = 12;
    private static final byte TONATIONAL_FLAG = 1;
    private static final byte TONOMINAL_FLAG = 2;
    private static final byte CONTEXTUAL_FLAG = 4;
    private static final byte SWAPPING_FLAG = 8;
    private static final byte IMP_LTR = 4;
    private static final byte IMP_RTL = 8;
    private static final byte ORIG = 0;
    private static final byte FINAL = 1;
    private static final char[][] notSpacing = new char[][]{{'\u0300', '\u0385'}, {'\u0483', '\u0486'}, {'\u05b0', '\u05bd'}, {'\u05bf', '\u05bf'}, {'\u05c1', '\u05c2'}, {'\u05f5', '\u05f5'}, {'\u064b', '\u0652'}, {'\u0670', '\u0670'}, {'\u06d6', '\u06e4'}, {'\u06e7', '\u06e8'}, {'\u06ea', '\u06ed'}, {'\u0901', '\u0902'}, {'\u093c', '\u093c'}, {'\u0941', '\u0948'}, {'\u094d', '\u094d'}, {'\u0951', '\u0954'}, {'\u0962', '\u0963'}, {'\u0981', '\u0981'}, {'\u09bc', '\u09bc'}, {'\u09c1', '\u09c4'}, {'\u09cd', '\u09cd'}, {'\u09e2', '\u09e3'}, {'\u0a02', '\u0a02'}, {'\u0a3c', '\u0a3c'}, {'\u0a41', '\u0a4c'}, {'\u0a70', '\u0a71'}, {'\u0a81', '\u0a82'}, {'\u0abc', '\u0abc'}, {'\u0ac1', '\u0ac8'}, {'\u0acd', '\u0acd'}, {'\u0b01', '\u0b01'}, {'\u0b3c', '\u0b3c'}, {'\u0b3f', '\u0b3f'}, {'\u0b41', '\u0b43'}, {'\u0b4d', '\u0b4d'}, {'\u0bc0', '\u0bc0'}, {'\u0bcd', '\u0bcd'}, {'\u0c3e', '\u0c40'}, {'\u0c46', '\u0c56'}, {'\u0cbf', '\u0cbf'}, {'\u0cc6', '\u0cc6'}, {'\u0ccc', '\u0ccd'}, {'\u0d41', '\u0d43'}, {'\u0d4d', '\u0d4d'}, {'\u0e31', '\u0e31'}, {'\u0e34', '\u0e3a'}, {'\u0e47', '\u0e4d'}, {'\u0eb1', '\u0eb1'}, {'\u0eb4', '\u0ebc'}, {'\u0ec8', '\u0ecd'}, {'\u1026', '\u102a'}, {'\u102e', '\u102e'}, {'\u1030', '\u1030'}, {'\u1036', '\u1037'}, {'\u103b', '\u103b'}, {'\u103d', '\u103e'}, {'\u104b', '\u104c'}, {'\u20d0', '\u20ff'}, {'\u302a', '\u302f'}, {'\u3099', '\u309a'}};
    private static final char[][] symPairs = new char[][]{{'(', ')'}, {')', '('}, {'<', '>'}, {'>', '<'}, {'[', ']'}, {']', '['}, {'{', '}'}, {'}', '{'}, {'\u00ab', '\u00bb'}, {'\u00bb', '\u00ab'}, {'\u207d', '\u207e'}, {'\u207e', '\u207d'}, {'\u208d', '\u208e'}, {'\u208e', '\u208d'}, {'\u2329', '\u232a'}, {'\u232a', '\u2329'}, {'\ufe59', '\ufe5a'}, {'\ufe5a', '\ufe59'}, {'\ufe5b', '\ufe5c'}, {'\ufe5c', '\ufe5b'}, {'\ufe5d', '\ufe5e'}, {'\ufe5e', '\ufe5d'}, {'\ufe64', '\ufe65'}, {'\ufe65', '\ufe64'}};
    private static final short[][] impTab_LTR;
    private static final short[][] impTab_RTL;
    private static final short[][] impTab_LTR_r;
    private static final short[][] impTab_RTL_r;
    int ucb_ix;
    byte ucb_outLev;
    byte ucb_basLev;
    byte ucb_curLev;
    byte ucb_impLev;
    int ucb_impSta;
    boolean ucb_araLet;
    int ucb_lineSepPos;
    int ucb_condPos;
    int ucb_Shaping;
    int ucb_xType;
    byte ucb_wTarget;
    int ucb_pType;
    BidiFlag ics_num_flag;
    int ics_formShp;
    boolean ics_symmetric;
    BidiFlag ics_orient_in;
    BidiFlag ics_orient_out;
    BidiFlag ics_type_in;
    BidiFlag ics_type_out;
    BidiFlag ics_txtShp_flag;
    BidiTransform myBdx;
    int ics_size;
    int ics_size_out;
    int ics_orient;
    int ics_flip_flag;
    int ics_num;
    boolean ics_compc;
    char[] ics_buffer_in;
    char[] ics_buffer_out;
    byte[] specialTreatment;
    boolean visToVis;
    short[][] impTab;
    byte[][] typeArray;
    boolean reqImpToImp;
    int impToImpOrient;
    int impToImpPhase;

    static {
        short[][] sArrayArray = new short[9][];
        short[] sArray = new short[13];
        sArray[3] = 3;
        sArray[5] = 1;
        sArrayArray[0] = sArray;
        short[] sArray2 = new short[13];
        sArray2[3] = 3;
        sArray2[5] = 1;
        sArray2[6] = 4;
        sArray2[7] = 4;
        sArray2[8] = 2;
        sArray2[9] = 4;
        sArray2[10] = 4;
        sArray2[11] = 2;
        sArrayArray[1] = sArray2;
        short[] sArray3 = new short[13];
        sArray3[3] = 3;
        sArray3[5] = 1;
        sArray3[6] = 4;
        sArray3[7] = 4;
        sArray3[8] = 4;
        sArray3[9] = 4;
        sArray3[10] = 4;
        sArray3[11] = 2;
        sArray3[12] = 1;
        sArrayArray[2] = sArray3;
        short[] sArray4 = new short[13];
        sArray4[3] = 3;
        sArray4[4] = 6;
        sArray4[5] = 1;
        sArray4[6] = 5;
        sArray4[7] = 4;
        sArray4[8] = 4;
        sArray4[9] = 4;
        sArray4[10] = 4;
        sArray4[11] = 1;
        sArrayArray[3] = sArray4;
        short[] sArray5 = new short[13];
        sArray5[3] = 3;
        sArray5[4] = 102;
        sArray5[5] = 97;
        sArray5[6] = 5;
        sArray5[7] = 4;
        sArray5[8] = 4;
        sArray5[9] = 4;
        sArray5[10] = 4;
        sArray5[11] = 1;
        sArray5[12] = 1;
        sArrayArray[4] = sArray5;
        short[] sArray6 = new short[13];
        sArray6[3] = 3;
        sArray6[4] = 102;
        sArray6[5] = 65;
        sArray6[6] = 5;
        sArray6[7] = 4;
        sArray6[8] = 4;
        sArray6[9] = 4;
        sArray6[10] = 4;
        sArray6[11] = 1;
        sArray6[12] = 1;
        sArrayArray[5] = sArray6;
        short[] sArray7 = new short[13];
        sArray7[3] = 3;
        sArray7[4] = 6;
        sArray7[5] = 1;
        sArray7[6] = 8;
        sArray7[7] = 7;
        sArray7[8] = 7;
        sArray7[9] = 4;
        sArray7[10] = 4;
        sArray7[11] = 2;
        sArrayArray[6] = sArray7;
        short[] sArray8 = new short[13];
        sArray8[3] = 3;
        sArray8[4] = 6;
        sArray8[5] = 65;
        sArray8[6] = 5;
        sArray8[7] = 4;
        sArray8[8] = 4;
        sArray8[9] = 4;
        sArray8[10] = 4;
        sArray8[11] = 2;
        sArray8[12] = 1;
        sArrayArray[7] = sArray8;
        short[] sArray9 = new short[13];
        sArray9[3] = 3;
        sArray9[4] = 6;
        sArray9[5] = 1;
        sArray9[6] = 5;
        sArray9[7] = 4;
        sArray9[8] = 4;
        sArray9[9] = 4;
        sArray9[10] = 4;
        sArray9[11] = 2;
        sArrayArray[8] = sArray9;
        impTab_LTR = sArrayArray;
        short[][] sArrayArray2 = new short[10][];
        short[] sArray10 = new short[13];
        sArray10[2] = 7;
        sArray10[4] = 2;
        sArray10[5] = 5;
        sArray10[6] = 1;
        sArrayArray2[0] = sArray10;
        short[] sArray11 = new short[13];
        sArray11[2] = 167;
        sArray11[4] = 2;
        sArray11[5] = 165;
        sArray11[6] = 129;
        sArray11[12] = 1;
        sArrayArray2[1] = sArray11;
        short[] sArray12 = new short[13];
        sArray12[2] = 7;
        sArray12[4] = 2;
        sArray12[5] = 5;
        sArray12[6] = 4;
        sArray12[7] = 3;
        sArray12[8] = 3;
        sArray12[11] = 1;
        sArrayArray2[2] = sArray12;
        short[] sArray13 = new short[13];
        sArray13[2] = 39;
        sArray13[4] = 2;
        sArray13[5] = 37;
        sArray13[6] = 33;
        sArray13[11] = 1;
        sArray13[12] = 1;
        sArrayArray2[3] = sArray13;
        short[] sArray14 = new short[13];
        sArray14[2] = 7;
        sArray14[4] = 2;
        sArray14[5] = 5;
        sArray14[6] = 1;
        sArray14[11] = 1;
        sArrayArray2[4] = sArray14;
        short[] sArray15 = new short[13];
        sArray15[2] = 7;
        sArray15[4] = 2;
        sArray15[5] = 5;
        sArray15[6] = 1;
        sArray15[8] = 6;
        sArray15[11] = 1;
        sArrayArray2[5] = sArray15;
        short[] sArray16 = new short[13];
        sArray16[2] = 39;
        sArray16[4] = 36;
        sArray16[5] = 5;
        sArray16[6] = 33;
        sArray16[11] = 1;
        sArray16[12] = 1;
        sArrayArray2[6] = sArray16;
        short[] sArray17 = new short[13];
        sArray17[2] = 7;
        sArray17[4] = 9;
        sArray17[5] = 5;
        sArray17[6] = 8;
        sArray17[7] = 8;
        sArray17[8] = 8;
        sArray17[9] = 8;
        sArray17[10] = 8;
        sArray17[11] = 1;
        sArrayArray2[7] = sArray17;
        short[] sArray18 = new short[13];
        sArray18[2] = 7;
        sArray18[4] = 9;
        sArray18[5] = 37;
        sArray18[6] = 8;
        sArray18[7] = 8;
        sArray18[8] = 8;
        sArray18[9] = 8;
        sArray18[10] = 8;
        sArray18[11] = 1;
        sArray18[12] = 1;
        sArrayArray2[8] = sArray18;
        short[] sArray19 = new short[13];
        sArray19[2] = 7;
        sArray19[4] = 9;
        sArray19[5] = 5;
        sArray19[6] = 7;
        sArray19[7] = 8;
        sArray19[8] = 8;
        sArray19[9] = 8;
        sArray19[10] = 8;
        sArray19[11] = 1;
        sArrayArray2[9] = sArray19;
        impTab_RTL = sArrayArray2;
        short[][] sArrayArray3 = new short[9][];
        short[] sArray20 = new short[13];
        sArray20[3] = 3;
        sArrayArray3[0] = sArray20;
        short[] sArray21 = new short[13];
        sArray21[3] = 3;
        sArray21[6] = 4;
        sArray21[7] = 4;
        sArray21[8] = 2;
        sArray21[9] = 4;
        sArray21[10] = 4;
        sArray21[11] = 2;
        sArrayArray3[1] = sArray21;
        short[] sArray22 = new short[13];
        sArray22[3] = 3;
        sArray22[6] = 4;
        sArray22[7] = 4;
        sArray22[8] = 4;
        sArray22[9] = 4;
        sArray22[10] = 4;
        sArray22[11] = 1;
        sArray22[12] = 1;
        sArrayArray3[2] = sArray22;
        short[] sArray23 = new short[13];
        sArray23[3] = 3;
        sArray23[4] = 6;
        sArray23[5] = 6;
        sArray23[6] = 5;
        sArray23[7] = 4;
        sArray23[8] = 4;
        sArray23[9] = 4;
        sArray23[10] = 4;
        sArray23[11] = 1;
        sArrayArray3[3] = sArray23;
        short[] sArray24 = new short[13];
        sArray24[3] = 163;
        sArray24[4] = 6;
        sArray24[5] = 6;
        sArray24[6] = 5;
        sArray24[7] = 4;
        sArray24[8] = 4;
        sArray24[9] = 4;
        sArray24[10] = 4;
        sArray24[11] = 1;
        sArray24[12] = 1;
        sArrayArray3[4] = sArray24;
        short[] sArray25 = new short[13];
        sArray25[3] = 163;
        sArray25[4] = 198;
        sArray25[5] = 198;
        sArray25[6] = 5;
        sArray25[7] = 4;
        sArray25[8] = 4;
        sArray25[9] = 4;
        sArray25[10] = 4;
        sArray25[11] = 1;
        sArray25[12] = 1;
        sArrayArray3[5] = sArray25;
        short[] sArray26 = new short[13];
        sArray26[3] = 163;
        sArray26[4] = 6;
        sArray26[5] = 6;
        sArray26[6] = 8;
        sArray26[7] = 7;
        sArray26[8] = 7;
        sArray26[9] = 4;
        sArray26[10] = 4;
        sArray26[11] = 2;
        sArray26[12] = 1;
        sArrayArray3[6] = sArray26;
        short[] sArray27 = new short[13];
        sArray27[3] = 163;
        sArray27[4] = 198;
        sArray27[5] = 198;
        sArray27[6] = 5;
        sArray27[7] = 4;
        sArray27[8] = 4;
        sArray27[9] = 4;
        sArray27[10] = 4;
        sArray27[11] = 1;
        sArray27[12] = 1;
        sArrayArray3[7] = sArray27;
        short[] sArray28 = new short[13];
        sArray28[3] = 163;
        sArray28[4] = 6;
        sArray28[5] = 6;
        sArray28[6] = 5;
        sArray28[7] = 4;
        sArray28[8] = 4;
        sArray28[9] = 4;
        sArray28[10] = 4;
        sArray28[11] = 2;
        sArray28[12] = 1;
        sArrayArray3[8] = sArray28;
        impTab_LTR_r = sArrayArray3;
        short[][] sArrayArray4 = new short[12][];
        short[] sArray29 = new short[13];
        sArray29[2] = 7;
        sArray29[4] = 2;
        sArray29[5] = 2;
        sArray29[6] = 1;
        sArrayArray4[0] = sArray29;
        short[] sArray30 = new short[13];
        sArray30[2] = 167;
        sArray30[4] = 194;
        sArray30[5] = 194;
        sArray30[6] = 1;
        sArray30[12] = 1;
        sArrayArray4[1] = sArray30;
        sArrayArray4[2] = new short[]{160, 160, 7, 160, 2, 2, 4, 3, 3, 10, 10, 1, 1};
        short[] sArray31 = new short[13];
        sArray31[0] = 160;
        sArray31[1] = 160;
        sArray31[2] = 7;
        sArray31[3] = 160;
        sArray31[4] = 194;
        sArray31[5] = 194;
        sArray31[6] = 11;
        sArray31[7] = 10;
        sArray31[8] = 10;
        sArray31[9] = 10;
        sArray31[10] = 10;
        sArray31[12] = 1;
        sArrayArray4[3] = sArray31;
        sArrayArray4[4] = new short[]{160, 160, 7, 160, 2, 2, 4, 10, 10, 10, 10, 1, 1};
        short[] sArray32 = new short[13];
        sArray32[2] = 7;
        sArray32[4] = 2;
        sArray32[5] = 2;
        sArray32[6] = 1;
        sArray32[8] = 6;
        sArray32[11] = 1;
        sArrayArray4[5] = sArray32;
        short[] sArray33 = new short[13];
        sArray33[2] = 167;
        sArray33[4] = 164;
        sArray33[5] = 164;
        sArray33[6] = 161;
        sArray33[12] = 1;
        sArrayArray4[6] = sArray33;
        short[] sArray34 = new short[13];
        sArray34[2] = 7;
        sArray34[4] = 9;
        sArray34[5] = 9;
        sArray34[6] = 8;
        sArray34[7] = 8;
        sArray34[8] = 8;
        sArray34[9] = 8;
        sArray34[10] = 8;
        sArray34[11] = 1;
        sArrayArray4[7] = sArray34;
        short[] sArray35 = new short[13];
        sArray35[2] = 7;
        sArray35[4] = 9;
        sArray35[5] = 9;
        sArray35[6] = 8;
        sArray35[7] = 8;
        sArray35[8] = 8;
        sArray35[9] = 8;
        sArray35[10] = 8;
        sArray35[12] = 1;
        sArrayArray4[8] = sArray35;
        short[] sArray36 = new short[13];
        sArray36[2] = 7;
        sArray36[4] = 9;
        sArray36[5] = 9;
        sArray36[6] = 7;
        sArray36[7] = 8;
        sArray36[8] = 8;
        sArray36[9] = 8;
        sArray36[10] = 8;
        sArray36[11] = 1;
        sArrayArray4[9] = sArray36;
        short[] sArray37 = new short[13];
        sArray37[0] = 160;
        sArray37[1] = 160;
        sArray37[2] = 7;
        sArray37[3] = 160;
        sArray37[4] = 2;
        sArray37[5] = 2;
        sArray37[6] = 11;
        sArray37[7] = 10;
        sArray37[8] = 10;
        sArray37[9] = 10;
        sArray37[10] = 10;
        sArray37[12] = 1;
        sArrayArray4[10] = sArray37;
        short[] sArray38 = new short[13];
        sArray38[0] = 160;
        sArray38[1] = 160;
        sArray38[2] = 7;
        sArray38[3] = 160;
        sArray38[4] = 194;
        sArray38[5] = 194;
        sArray38[6] = 11;
        sArray38[7] = 10;
        sArray38[8] = 10;
        sArray38[9] = 10;
        sArray38[10] = 10;
        sArray38[12] = 1;
        sArrayArray4[11] = sArray38;
        impTab_RTL_r = sArrayArray4;
    }

    BidiOrder() {
    }

    private static boolean odd(int n) {
        return (n & 1) == 1;
    }

    private static boolean even(int n) {
        return (n & 1) == 0;
    }

    void invertMap(int[] buffer, int lower_limit, int upper_limit) {
        while (lower_limit < upper_limit) {
            int temp = buffer[lower_limit];
            buffer[lower_limit] = buffer[upper_limit];
            buffer[upper_limit] = temp;
            ++lower_limit;
            --upper_limit;
        }
    }

    private static boolean UCQSPAC(char x) {
        int low = 0;
        int high = notSpacing.length - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            if (x < notSpacing[mid][0]) {
                high = mid - 1;
                continue;
            }
            if (x > notSpacing[mid][1]) {
                low = mid + 1;
                continue;
            }
            return false;
        }
        return true;
    }

    private static char UCQSYMM(char x) {
        int low = 0;
        int high = 23;
        while (low <= high) {
            int mid = (low + high) / 2;
            char c = symPairs[mid][0];
            if (x < c) {
                high = mid - 1;
                continue;
            }
            if (x > c) {
                low = mid + 1;
                continue;
            }
            return symPairs[mid][1];
        }
        return x;
    }

    void fillTypeArray() {
        boolean isArabic = false;
        byte[][] ta = this.typeArray;
        int i = 0;
        while (i < this.ics_size) {
            byte cType;
            ta[i][0] = cType = BidiOrder.getChType(this.ics_buffer_in[i], this.myBdx.wordBreak);
            ta[i][1] = 10;
            switch (cType) {
                case 0: {
                    isArabic = false;
                    ta[i][1] = 0;
                    break;
                }
                case 1: {
                    ta[i][1] = 1;
                    break;
                }
                case 2: {
                    isArabic = false;
                    ta[i][1] = 2;
                    break;
                }
                case 3: {
                    isArabic = false;
                    char c = this.ics_buffer_in[i];
                    if (c >= '\u0600' && c <= '\u06ef' || c >= '\ufb50' && c <= '\ufefc') {
                        isArabic = true;
                    }
                    ta[i][1] = 3;
                    break;
                }
                case 12: {
                    isArabic = true;
                    ta[i][1] = 12;
                    break;
                }
                case 4: {
                    int wType;
                    if (isArabic) {
                        wType = 5;
                    } else {
                        wType = 4;
                        if (i >= 2 && ta[i - 1][0] == 7 && ta[i - 2][0] == 4) {
                            ta[i - 1][1] = 4;
                        }
                        int prev = i - 1;
                        while (prev >= 0 && ta[prev][0] == 6) {
                            ta[prev--][1] = 4;
                        }
                    }
                    if (i >= 2 && ta[i - 1][0] == 8 && ta[i - 2][0] == 4) {
                        ta[i - 1][1] = wType;
                    }
                    ta[i][1] = wType;
                    break;
                }
                case 5: {
                    if (i >= 2 && ta[i - 1][0] == 8 && ta[i - 2][1] == 5) {
                        ta[i - 1][1] = 5;
                    }
                    ta[i][1] = 5;
                    break;
                }
                case 9: {
                    ta[i][1] = 9;
                    break;
                }
                case 6: {
                    if (i <= 0 || ta[i - 1][1] != 4) break;
                    ta[i][1] = 4;
                    break;
                }
                case 13: {
                    if (i <= 0) break;
                    ta[i][1] = ta[i - 1][1];
                }
            }
            ++i;
        }
    }

    void fillTypeArray2() {
        boolean isArabic = false;
        byte[][] ta = this.typeArray;
        int i = 0;
        while (i < this.ics_size) {
            int k = this.myBdx.dstToSrcMap[i];
            byte cType = ta[k][0];
            ta[k][1] = 10;
            switch (cType) {
                case 0: {
                    isArabic = false;
                    ta[k][1] = 0;
                    break;
                }
                case 1: {
                    ta[k][1] = 1;
                    break;
                }
                case 2: {
                    isArabic = false;
                    ta[k][1] = 2;
                    break;
                }
                case 3: {
                    isArabic = false;
                    char c = this.ics_buffer_in[k];
                    if (c >= '\u0600' && c <= '\u06ef' || c >= '\ufb50' && c <= '\ufefc') {
                        isArabic = true;
                    }
                    ta[k][1] = 3;
                    break;
                }
                case 12: {
                    isArabic = true;
                    ta[k][1] = 12;
                    break;
                }
                case 4: {
                    int wType;
                    if (isArabic) {
                        wType = 5;
                    } else {
                        wType = 4;
                        if (i >= 2 && ta[this.myBdx.dstToSrcMap[i - 1]][0] == 7 && ta[this.myBdx.dstToSrcMap[i - 2]][0] == 4) {
                            ta[this.myBdx.dstToSrcMap[i - 1]][1] = 4;
                        }
                        int prev = i - 1;
                        while (prev >= 0 && ta[this.myBdx.dstToSrcMap[prev]][0] == 6) {
                            ta[this.myBdx.dstToSrcMap[prev--]][1] = 4;
                        }
                    }
                    if (i >= 2 && ta[this.myBdx.dstToSrcMap[i - 1]][0] == 8 && ta[this.myBdx.dstToSrcMap[i - 2]][0] == 4) {
                        ta[this.myBdx.dstToSrcMap[i - 1]][1] = wType;
                    }
                    ta[k][1] = wType;
                    break;
                }
                case 5: {
                    if (i >= 2 && ta[this.myBdx.dstToSrcMap[i - 1]][0] == 8 && ta[this.myBdx.dstToSrcMap[i - 2]][0] == 5) {
                        ta[this.myBdx.dstToSrcMap[i - 1]][1] = 5;
                    }
                    ta[k][1] = 5;
                    break;
                }
                case 9: {
                    ta[k][1] = 9;
                    break;
                }
                case 6: {
                    if (i <= 0 || ta[this.myBdx.dstToSrcMap[i - 1]][1] != 4) break;
                    ta[k][1] = 4;
                    break;
                }
            }
            ++i;
        }
    }

    private void implicitProcessing() {
        short sCond;
        int i;
        int newIS = this.impTab[this.ucb_impSta][this.ucb_xType];
        short Special = (short)(newIS >> 5);
        newIS = (short)(newIS & 0x1F);
        short newIL = this.impTab[newIS][11];
        if (Special > 0) {
            switch (Special) {
                case 1: {
                    i = this.ucb_condPos;
                    while (i < this.ucb_ix) {
                        this.myBdx.propertyMap[i] = this.ucb_curLev;
                        ++i;
                    }
                    this.ucb_condPos = -1;
                    break;
                }
                case 2: {
                    i = this.ucb_condPos;
                    while (i < this.ucb_ix) {
                        this.myBdx.propertyMap[i] = (byte)(this.ucb_curLev + 1);
                        ++i;
                    }
                    this.ucb_condPos = -1;
                    break;
                }
                case 3: {
                    i = this.ucb_condPos;
                    while (i < this.ucb_ix) {
                        this.myBdx.propertyMap[i] = (byte)(this.ucb_curLev + 1);
                        ++i;
                    }
                    this.myBdx.propertyMap[i] = (byte)(this.ucb_curLev + 2);
                    this.ucb_condPos = -1;
                    break;
                }
                case 4: {
                    this.ucb_condPos = this.ucb_ix;
                    break;
                }
                case 5: {
                    this.ucb_condPos = -1;
                    break;
                }
                case 6: {
                    this.myBdx.propertyMap[this.ucb_ix - 1] = (byte)(this.ucb_curLev + 2);
                }
            }
        }
        if ((sCond = this.impTab[newIS][12]) == 0) {
            if (this.ucb_condPos > -1) {
                i = this.ucb_condPos;
                while (i < this.ucb_ix) {
                    byte newLevel;
                    byte oldLevel = this.myBdx.propertyMap[i];
                    this.myBdx.propertyMap[i] = newLevel = (byte)(this.ucb_curLev + newIL);
                    if (this.ics_symmetric && BidiOrder.odd(oldLevel ^ newLevel)) {
                        int pos = this.impToImpPhase == 2 ? this.myBdx.dstToSrcMap[i] : i;
                        int n = pos;
                        this.specialTreatment[n] = (byte)(this.specialTreatment[n] ^ 8);
                    }
                    ++i;
                }
            }
            this.ucb_condPos = -1;
            if (this.ucb_lineSepPos >= 0) {
                this.myBdx.propertyMap[this.ucb_lineSepPos] = 0;
                this.ucb_lineSepPos = -1;
            }
        } else if (this.ucb_condPos == -1) {
            this.ucb_condPos = this.ucb_ix;
        }
        this.ucb_impLev = (byte)newIL;
        this.ucb_impSta = newIS;
        this.ucb_wTarget = (byte)(this.ucb_curLev + this.ucb_impLev);
    }

    private static byte getChType(char x, boolean wordBreak) {
        if (wordBreak && x == ' ') {
            return 1;
        }
        return BidiOrder.getChType(x);
    }

    private static byte getChType(char x) {
        if (x == '\n' || x == '\r' || x >= '\u001c' && x <= '\u001e' || x == '\u0085' || x == '\u2029') {
            return 0;
        }
        if (x == '\t' || x == '\u000b' || x == '\u001f') {
            return 1;
        }
        if (x > '@' && x <= 'Z' || x >= 'a' && x <= 'z' || x >= '\u00c0' && x <= '\u00d6' || x >= '\u00d8' && x <= '\u00f6' || x >= '\u00f8' && x <= '\u058f' || x >= '\u0900' && x <= '\u10ff' || x == '\u200e' || x >= '\u20d0' && x <= '\u20ff' || x >= '\u2160' && x <= '\u2182' || x >= '\u3040' && x <= '\u9fff' || x >= '\uf900' && x <= '\ufb17' || x == '\ufe60' || x == '\ufe6b' || x == '\uff06' || x >= '\uff20' && x <= '\uff3a' || x >= '\uff41' && x <= '\uff5a' || x >= '\uff60' && x <= '\uffdf') {
            return 2;
        }
        if (x >= '\u0591' && x <= '\u065f' || x >= '\u066e' && x <= '\u06ef' || x >= '\u06fa' && x <= '\u08ff' || x == '\u200f' || x >= '\ufb20' && x <= '\ufdff' || x >= '\ufe70' && x <= '\ufefc') {
            return 3;
        }
        if (x >= '0' && x <= '9' || x >= '\u00b2' && x <= '\u00b3' || x == '\u00b9' || x >= '\u06f0' && x <= '\u06f9' || x == '\u2070' || x >= '\u2074' && x <= '\u2079' || x >= '\u2080' && x <= '\u2089' || x >= '\u2460' && x <= '\u249b' || x == '\u24ea' || x >= '\uff10' && x <= '\uff19') {
            return 4;
        }
        if (x >= '\u0660' && x <= '\u0669' || x >= '\u066b' && x <= '\u066c') {
            return 5;
        }
        if (x >= '#' && x <= '%' || x == '+' || x == '-' || x >= '\u00a2' && x <= '\u00a5' || x >= '\u00b0' && x <= '\u00b1' || x == '\u066a' || x >= '\u09f2' && x <= '\u09f3' || x == '\u0af1' || x == '\u0bf9' || x == '\u0e3f' || x == '\u17db' || x >= '\u2030' && x <= '\u2034' || x >= '\u207a' && x <= '\u207b' || x >= '\u208a' && x <= '\u208b' || x >= '\u20a0' && x <= '\u20b1' || x == '\u212e' || x >= '\u2212' && x <= '\u2213' || x == '\ufb29' || x == '\ufe5f' || x >= '\ufe62' && x <= '\ufe63' || x >= '\ufe69' && x <= '\ufe6a' || x >= '\uff03' && x <= '\uff05' || x == '\uff0b' || x == '\uff0d' || x >= '\uffe0' && x <= '\uffe1' || x >= '\uffe5' && x <= '\uffe6') {
            return 6;
        }
        if (x == '/' || x == '\uff0f') {
            return 7;
        }
        if (x == ',' || x == '.' || x == ':' || x == '\u00a0' || x == '\u060c' || x == '\ufe50' || x == '\ufe52' || x == '\ufe55' || x == '\uff0c' || x == '\uff0e' || x == '\uff1a') {
            return 8;
        }
        if (x == '\f' || x == ' ' || x == '\u1680' || x == '\u180e' || x >= '\u2000' && x <= '\u200a' || x == '\u2028' || x == '\u202f' || x == '\u205f' || x == '\u3000') {
            return 9;
        }
        if (x >= '\u202a' && x <= '\u202e' || x >= '\u206c' && x <= '\u206f') {
            return 11;
        }
        return 10;
    }

    private static int firstStrong(BidiText src) {
        int lim = src.offset + src.count;
        int i = src.offset;
        while (i < lim) {
            byte type = BidiOrder.getChType(src.data[i]);
            if (type == 2 || type == 3) {
                return type;
            }
            ++i;
        }
        return 10;
    }

    private static int lastStrong(BidiText src) {
        int lim = src.offset + src.count;
        int i = lim - 1;
        while (i >= src.offset) {
            byte type = BidiOrder.getChType(src.data[i]);
            if (type == 2 || type == 3) {
                return type;
            }
            --i;
        }
        return 10;
    }

    private void BaseLvl() {
        this.visToVis = false;
        this.ucb_basLev = this.ics_orient_in == BidiFlag.ORIENTATION_RTL ? (byte)1 : 0;
        this.ucb_outLev = this.ics_orient_out == BidiFlag.ORIENTATION_RTL ? (byte)1 : 0;
        this.ucb_curLev = this.ucb_basLev;
        if (this.ucb_basLev == 0 && this.ucb_outLev == 1) {
            this.ucb_curLev = (byte)2;
        }
        if (this.ics_type_in == BidiFlag.TYPE_VISUAL && this.ics_type_out == BidiFlag.TYPE_VISUAL) {
            this.visToVis = true;
        }
        this.ucb_lineSepPos = -1;
        this.impTab = this.myBdx.roundTrip ? (this.ucb_basLev == 1 ? impTab_RTL_r : impTab_LTR_r) : (this.ucb_basLev == 1 ? impTab_RTL : impTab_LTR);
        this.ucb_impSta = 0;
        this.ucb_impLev = 0;
        this.ucb_condPos = -1;
    }

    private void pass1() {
        int treatmentFlag = 0;
        if (this.ucb_ix == 0) {
            this.ucb_pType = 0;
        }
        this.ucb_wTarget = 0;
        char cChar = this.ics_buffer_in[this.ucb_ix];
        int cType = BidiOrder.getChType(cChar, this.myBdx.wordBreak);
        switch (cType) {
            case 11: {
                switch (cChar) {
                    case '\u206c': {
                        this.ics_formShp = 0;
                        break;
                    }
                    case '\u206d': {
                        this.ics_formShp = 1;
                        break;
                    }
                    case '\u206e': {
                        this.ics_num_flag = BidiFlag.NUMERALS_NATIONAL;
                        break;
                    }
                    case '\u206f': {
                        this.ics_num_flag = BidiFlag.NUMERALS_NOMINAL;
                    }
                }
                break;
            }
            case 0: {
                this.ucb_xType = 0;
                this.implicitProcessing();
                this.ucb_wTarget = 0;
                this.BaseLvl();
                break;
            }
            case 1: {
                if (this.visToVis) {
                    cType = 10;
                    this.ucb_xType = 10;
                    this.ucb_wTarget = this.ucb_curLev;
                    break;
                }
                this.ucb_xType = 1;
                this.implicitProcessing();
                this.ucb_wTarget = this.ucb_basLev;
                break;
            }
            default: {
                if (cChar == '\u2028') {
                    this.ucb_lineSepPos = this.ucb_ix;
                    this.ucb_wTarget = 0;
                    break;
                }
                if (cType == 4 && this.ics_num_flag == BidiFlag.NUMERALS_NATIONAL) {
                    treatmentFlag = 1;
                }
                if (cType == 5 && this.ics_num_flag == BidiFlag.NUMERALS_NOMINAL) {
                    treatmentFlag = 2;
                }
                if (cType == 4 && this.ucb_araLet) {
                    cType = 5;
                    if (this.ics_num_flag == BidiFlag.NUMERALS_CONTEXTUAL) {
                        treatmentFlag = 5;
                    }
                }
                if (cType == 2) {
                    this.ucb_araLet = false;
                }
                if (cType == 3) {
                    if (cChar >= '\u0600' && cChar <= '\u06ef') {
                        this.ucb_araLet = true;
                        if (this.ics_txtShp_flag != BidiFlag.TEXT_NOMINAL) {
                            this.ucb_Shaping = 1;
                        }
                    }
                    if (cChar >= '\ufb50' && cChar <= '\ufefc') {
                        this.ucb_araLet = true;
                        if (this.ics_txtShp_flag != BidiFlag.TEXT_NOMINAL && this.ics_formShp == 1) {
                            this.ucb_Shaping = 1;
                        }
                    }
                }
                if (cType == 6) {
                    if (this.ucb_pType == 4) {
                        cType = 4;
                    } else {
                        int i2 = this.ucb_ix + 1;
                        while (i2 < this.ics_size) {
                            this.ucb_pType = BidiOrder.getChType(this.ics_buffer_in[i2]);
                            if (this.ucb_pType == 4) {
                                if (this.ucb_araLet) break;
                                cType = 4;
                                break;
                            }
                            if (this.ucb_pType != 6) break;
                            ++i2;
                        }
                    }
                    if (cType == 6) {
                        cType = 10;
                    }
                }
                if (cType == 7 || cType == 8) {
                    int n = this.ucb_xType = this.ucb_ix + 1 < this.ics_size ? (int)BidiOrder.getChType(this.ics_buffer_in[this.ucb_ix + 1]) : 0;
                    if (this.ucb_araLet && this.ucb_xType == 4) {
                        this.ucb_xType = 5;
                    }
                    cType = this.ucb_pType == 4 ? (this.ucb_xType == 4 ? 4 : 10) : (this.ucb_pType == 5 && cType == 8 ? (this.ucb_xType == 5 ? 5 : 10) : 10);
                }
                if (!BidiOrder.UCQSPAC(cChar) && cType == 10 && this.ucb_ix > 0) {
                    cType = this.ucb_pType;
                }
                this.ucb_xType = cType;
                if (this.visToVis) {
                    this.ucb_xType = 10;
                }
                this.implicitProcessing();
                if (cType != 10 || !this.ics_symmetric || !BidiOrder.odd(this.ucb_curLev + this.ucb_impLev)) break;
                treatmentFlag = 8;
            }
        }
        this.ucb_pType = cType;
        this.myBdx.propertyMap[this.ucb_ix] = this.ucb_wTarget;
        this.specialTreatment[this.ucb_ix] = treatmentFlag;
    }

    private void pass2() {
        byte current_level;
        byte lowest_level = 100;
        byte highest_level = 0;
        int flip_from = 0;
        int flip_to = this.ics_size - 1;
        int i = 0;
        while (i < this.ics_size) {
            if (this.impToImpPhase != 2) {
                this.myBdx.dstToSrcMap[i] = i;
            }
            if ((current_level = this.myBdx.propertyMap[i]) < lowest_level) {
                lowest_level = current_level;
            }
            if (current_level > highest_level) {
                highest_level = current_level;
            }
            ++i;
        }
        if (this.reqImpToImp && this.impToImpOrient == 0) {
            return;
        }
        if (lowest_level % 2 == 0) {
            lowest_level = (byte)(lowest_level + 1);
        }
        byte work_level = highest_level;
        while (work_level >= lowest_level) {
            i = 0;
            while (i < this.ics_size) {
                current_level = this.myBdx.propertyMap[i];
                if (current_level < work_level) {
                    ++i;
                    continue;
                }
                flip_from = i;
                while ((current_level = this.myBdx.propertyMap[i]) >= work_level) {
                    flip_to = i++;
                    if (i >= this.ics_size) break;
                }
                this.invertMap(this.myBdx.dstToSrcMap, flip_from, flip_to);
            }
            work_level = (byte)(work_level - 1);
        }
        if (this.ics_orient_out == BidiFlag.ORIENTATION_RTL) {
            this.invertMap(this.myBdx.dstToSrcMap, 0, this.ics_size - 1);
        }
    }

    private void pass3() {
        this.ucb_ix = 0;
        while (this.ucb_ix < this.ics_size) {
            int logPos = this.myBdx.dstToSrcMap[this.ucb_ix];
            byte xTran = this.specialTreatment[logPos];
            char xchar = this.ics_buffer_in[logPos];
            if ((xTran & 1) > 0) {
                if (xchar >= '0' && xchar <= '9') {
                    xchar = (char)(xchar + 1584);
                }
            } else if ((xTran & 2) > 0) {
                if (xchar >= '\u0660' && xchar <= '\u0669') {
                    xchar = (char)(xchar - 1584);
                }
            } else if ((xTran & 8) > 0) {
                xchar = BidiOrder.UCQSYMM(xchar);
            }
            this.ics_buffer_out[this.ucb_ix] = xchar;
            ++this.ucb_ix;
        }
    }

    synchronized void order(BidiText src, BidiText dst, BidiTransform bdx) {
        int type1;
        int i = 0;
        if (src.count < 1) {
            return;
        }
        this.myBdx = bdx;
        this.ics_orient_in = src.flags.getOrientation();
        this.ics_orient_out = dst.flags.getOrientation();
        if (this.ics_orient_in == BidiFlag.ORIENTATION_CONTEXT_LTR || this.ics_orient_in == BidiFlag.ORIENTATION_CONTEXT_RTL) {
            type1 = BidiOrder.firstStrong(src);
            switch (type1) {
                case 2: {
                    this.ics_orient_in = BidiFlag.ORIENTATION_LTR;
                    break;
                }
                case 3: {
                    this.ics_orient_in = BidiFlag.ORIENTATION_RTL;
                    break;
                }
                case 10: {
                    this.ics_orient_in = this.ics_orient_in == BidiFlag.ORIENTATION_CONTEXT_RTL ? BidiFlag.ORIENTATION_RTL : BidiFlag.ORIENTATION_LTR;
                }
            }
        }
        if (this.ics_orient_out == BidiFlag.ORIENTATION_CONTEXT_LTR || this.ics_orient_out == BidiFlag.ORIENTATION_CONTEXT_RTL) {
            type1 = BidiOrder.firstStrong(src);
            switch (type1) {
                case 2: {
                    type1 = BidiOrder.lastStrong(src);
                    if (type1 == 3) {
                        this.ics_orient_out = BidiFlag.ORIENTATION_RTL;
                        break;
                    }
                    this.ics_orient_out = BidiFlag.ORIENTATION_LTR;
                    break;
                }
                case 3: {
                    this.ics_orient_out = BidiFlag.ORIENTATION_RTL;
                    break;
                }
                case 10: {
                    this.ics_orient_out = this.ics_orient_out == BidiFlag.ORIENTATION_CONTEXT_RTL ? BidiFlag.ORIENTATION_RTL : BidiFlag.ORIENTATION_LTR;
                }
            }
        }
        this.ics_type_in = src.flags.getType();
        this.ics_type_out = dst.flags.getType();
        boolean bl = this.reqImpToImp = this.ics_type_in == BidiFlag.TYPE_IMPLICIT && this.ics_type_out == BidiFlag.TYPE_IMPLICIT;
        if (this.myBdx.impToImp && this.reqImpToImp && this.ics_orient_in != this.ics_orient_out) {
            this.impToImpOrient = this.ics_orient_in == BidiFlag.ORIENTATION_LTR ? 4 : 8;
            this.typeArray = new byte[src.count][2];
        } else {
            this.impToImpOrient = 0;
            this.typeArray = null;
        }
        this.ics_buffer_in = new char[src.count];
        if (this.ics_type_in == BidiFlag.TYPE_VISUAL && this.ics_type_out == BidiFlag.TYPE_IMPLICIT && this.ics_orient_in != this.ics_orient_out) {
            int ofs = src.offset + src.count - 1;
            int k = 0;
            while (k < src.count) {
                this.ics_buffer_in[k] = src.data[ofs - k];
                ++k;
            }
            this.ics_orient_in = this.ics_orient_out;
        } else {
            System.arraycopy(src.data, src.offset, this.ics_buffer_in, 0, src.count);
        }
        this.ics_size_out = 0;
        this.ics_size = src.count;
        this.ics_num_flag = dst.flags.getNumerals();
        this.ics_txtShp_flag = dst.flags.getText();
        this.ics_compc = false;
        this.ics_formShp = 0;
        this.ics_symmetric = this.reqImpToImp ? false : dst.flags.getSwap() != src.flags.getSwap();
        this.ics_buffer_out = new char[this.ics_buffer_in.length];
        if (this.myBdx.propertyMap == null || this.myBdx.propertyMap.length < src.count) {
            this.myBdx.propertyMap = new byte[src.count];
        }
        if (this.myBdx.dstToSrcMap == null || this.myBdx.dstToSrcMap.length < src.count) {
            this.myBdx.dstToSrcMap = new int[src.count];
        }
        this.specialTreatment = new byte[src.count];
        this.ucb_ix = 0;
        this.ucb_pType = 0;
        this.ucb_Shaping = 0;
        this.ucb_araLet = false;
        if (this.impToImpOrient > 0) {
            this.impToImpPhase = 1;
            BidiFlag orient_save = this.ics_orient_out;
            this.ics_orient_out = BidiFlag.ORIENTATION_LTR;
            this.ics_symmetric = src.flags.getSwap() == BidiFlag.SWAP_YES;
            this.BaseLvl();
            this.fillTypeArray();
            int pos = 0;
            while (pos < this.ics_size) {
                this.ucb_xType = this.typeArray[pos][1];
                this.ucb_ix = pos;
                this.implicitProcessing();
                this.myBdx.propertyMap[pos] = this.ucb_wTarget;
                this.specialTreatment[pos] = this.ucb_xType == 10 && this.ics_symmetric && BidiOrder.odd(this.ucb_wTarget) ? 8 : 0;
                ++pos;
            }
            this.ucb_ix = this.ics_size;
            this.ucb_xType = 0;
            this.implicitProcessing();
            this.pass2();
            this.ics_orient_out = orient_save;
            this.impToImpPhase = 2;
            orient_save = this.ics_orient_in;
            if (this.impToImpOrient == 4) {
                this.ics_orient_in = BidiFlag.ORIENTATION_RTL;
                this.invertMap(this.myBdx.dstToSrcMap, 0, this.ics_size - 1);
            } else {
                this.ics_orient_in = BidiFlag.ORIENTATION_LTR;
            }
            this.ics_symmetric = dst.flags.getSwap() == BidiFlag.SWAP_YES;
            this.BaseLvl();
            this.fillTypeArray2();
            pos = 0;
            while (pos < this.ics_size) {
                int ipos = this.myBdx.dstToSrcMap[pos];
                this.ucb_xType = this.typeArray[ipos][1];
                this.ucb_ix = pos;
                this.implicitProcessing();
                this.myBdx.propertyMap[pos] = this.ucb_wTarget;
                if (this.ucb_xType == 10 && this.ics_symmetric && BidiOrder.odd(this.ucb_wTarget)) {
                    int n = ipos;
                    this.specialTreatment[n] = (byte)(this.specialTreatment[n] ^ 8);
                }
                ++pos;
            }
            this.ucb_ix = this.ics_size;
            this.ucb_xType = 0;
            this.implicitProcessing();
            this.pass2();
            this.ics_orient_in = orient_save;
            this.ics_symmetric = true;
        } else {
            this.BaseLvl();
            while (this.ucb_ix < this.ics_size) {
                this.pass1();
                ++this.ucb_ix;
            }
            this.ucb_xType = 0;
            this.implicitProcessing();
            this.pass2();
        }
        this.pass3();
        if (this.myBdx.srcToDstMapRequired) {
            if (this.myBdx.srcToDstMap == null || this.myBdx.srcToDstMap.length < src.count) {
                this.myBdx.srcToDstMap = new int[src.count];
            }
            i = 0;
            while (i < this.ics_size) {
                this.myBdx.srcToDstMap[this.myBdx.dstToSrcMap[i]] = i;
                ++i;
            }
        }
        if (this.myBdx.propertyMapRequired && this.typeArray != null) {
            i = 0;
            while (i < src.count) {
                if (this.typeArray[i][0] != 13) {
                    int n = i;
                    bdx.propertyMap[n] = (byte)(bdx.propertyMap[n] | 0x80);
                }
                ++i;
            }
        }
        System.arraycopy(this.ics_buffer_out, 0, dst.data, dst.offset, src.count);
        dst.count = src.count;
    }
}

